/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml;

import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWDataField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorFieldPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorValue;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWXmlDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSchemaContextComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXmlField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXpathContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXpathSpec;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.SchemaChange;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWXmlClassIndicatorFieldPolicy
extends MWClassIndicatorFieldPolicy
implements MWXpathContext {
    private MWXmlField xmlField;
    private volatile boolean useXSIType;
    public static String USE_XSITYPE_PROPERTY = "useXSIType";

    private MWXmlClassIndicatorFieldPolicy() {
    }

    protected MWXmlClassIndicatorFieldPolicy(MWClassIndicatorPolicy.Parent parent) {
        this(parent, NullIterator.instance());
    }

    protected MWXmlClassIndicatorFieldPolicy(MWClassIndicatorPolicy.Parent parent, Iterator descriptorsAvailableForIndication) {
        super(parent);
        this.setDescriptorsAvailableForIndicatorDictionary(descriptorsAvailableForIndication);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.xmlField = new MWXmlField(this);
        this.useXSIType = false;
    }

    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.xmlField);
    }

    public MWXmlField getXmlField() {
        return this.xmlField;
    }

    public MWDataField getField() {
        return this.getXmlField();
    }

    public boolean isUseXSIType() {
        return this.useXSIType;
    }

    public void setUseXSIType(boolean newValue) {
        boolean oldValue = this.useXSIType;
        this.useXSIType = newValue;
        this.firePropertyChanged(USE_XSITYPE_PROPERTY, oldValue, newValue);
        if (newValue) {
            this.setClassNameIsIndicator(false);
            this.generateIndicatorValueValues();
        }
    }

    private void generateIndicatorValueValues() {
        Iterator indicatorValues = this.classIndicatorValues();
        while (indicatorValues.hasNext()) {
            MWClassIndicatorValue value = (MWClassIndicatorValue)indicatorValues.next();
            MWXmlDescriptor descriptor = (MWXmlDescriptor)value.getDescriptorValue();
            if (descriptor.getSchemaContext() == null) continue;
            String name = descriptor.getSchemaContext().contextTypeQname();
            value.setIndicatorValue(name);
        }
    }

    private void clearIndicatorValuesValues() {
        Iterator indicatorValues = this.classIndicatorValues();
        while (indicatorValues.hasNext()) {
            MWClassIndicatorValue value = (MWClassIndicatorValue)indicatorValues.next();
            value.setIndicatorValue(null);
        }
    }

    public MWSchemaContextComponent schemaContext(MWXmlField xmlField) {
        return this.xmlDescriptor().getSchemaContext();
    }

    public MWXpathSpec xpathSpec(MWXmlField xmlField) {
        return this.buildXpathSpec();
    }

    protected MWXpathSpec buildXpathSpec() {
        return new MWXpathSpec(){

            public boolean mayUseCollectionData() {
                return false;
            }

            public boolean mayUseComplexData() {
                return false;
            }

            public boolean mayUseSimpleData() {
                return true;
            }
        };
    }

    private MWClassIndicatorPolicy.Parent classIndicatorFieldPolicyParent() {
        return (MWClassIndicatorPolicy.Parent)this.getParent();
    }

    private MWXmlDescriptor xmlDescriptor() {
        return (MWXmlDescriptor)this.classIndicatorFieldPolicyParent().getContainingDescriptor();
    }

    protected void addProblemsTo(List newProblems) {
        super.addProblemsTo(newProblems);
        this.checkClassIndicatorField(newProblems);
    }

    protected boolean fieldSpecified() {
        if (!this.isUseXSIType()) {
            return this.getXmlField().isResolved();
        }
        return true;
    }

    public void resolveXpaths() {
        this.xmlField.resolveXpaths();
    }

    public void schemaChanged(SchemaChange change) {
        this.xmlField.schemaChanged(change);
    }

    public void adjustRuntimeInheritancePolicy(InheritancePolicy runtimeInheritancePolicy) {
        super.adjustRuntimeInheritancePolicy(runtimeInheritancePolicy);
        if (this.useXSIType) {
            runtimeInheritancePolicy.setClassIndicatorField((DatabaseField)new XMLField("@xsi:type"));
        } else {
            runtimeInheritancePolicy.setClassIndicatorFieldName(this.getXmlField().getXpath());
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWXmlClassIndicatorFieldPolicy.class);
        descriptor.getInheritancePolicy().setParentClass(MWClassIndicatorFieldPolicy.class);
        XMLDirectMapping useXSITypeMapping = (XMLDirectMapping)descriptor.addDirectMapping("useXSIType", "@use-xsitype");
        useXSITypeMapping.setNullValue((Object)Boolean.FALSE);
        XMLCompositeObjectMapping xmlFieldMapping = new XMLCompositeObjectMapping();
        xmlFieldMapping.setReferenceClass(MWXmlField.class);
        xmlFieldMapping.setAttributeName("xmlField");
        xmlFieldMapping.setGetMethodName("getXmlFieldForTopLink");
        xmlFieldMapping.setSetMethodName("setXmlFieldForTopLink");
        xmlFieldMapping.setXPath("xml-field");
        descriptor.addMapping((DatabaseMapping)xmlFieldMapping);
        return descriptor;
    }

    private MWXmlField getXmlFieldForTopLink() {
        return this.xmlField.isSpecified() ? this.xmlField : null;
    }

    private void setXmlFieldForTopLink(MWXmlField xmlField) {
        this.xmlField = xmlField == null ? new MWXmlField(this) : xmlField;
    }
}

