/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.server;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.server.ServerPlatformBase;
import org.eclipse.persistence.services.mbean.MBeanDevelopmentServices;
import org.eclipse.persistence.services.mbean.MBeanRuntimeServicesMBean;
import org.eclipse.persistence.sessions.DatabaseSession;

public abstract class JMXServerPlatformBase
extends ServerPlatformBase {
    public static final String JMX_REGISTRATION_PREFIX = "TopLink:Name=";
    public static final int JMX_MBEANSERVER_INDEX_DEFAULT_FOR_MULTIPLE_SERVERS = 0;
    protected static final String OVERRIDE_JMX_MODULENAME_PROPERTY = "eclipselink.jmx.moduleName";
    protected static final String OVERRIDE_JMX_APPLICATIONNAME_PROPERTY = "eclipselink.jmx.applicationName";
    protected static String APP_SERVER_CLASSLOADER_APPLICATION_PU_SEARCH_STRING_PREFIX = "annotation: ";
    protected static String APP_SERVER_CLASSLOADER_APPLICATION_PU_SEARCH_STRING_POSTFIX = "";
    protected static String APP_SERVER_CLASSLOADER_MODULE_EJB_SEARCH_STRING_PREFIX = ".jar/";
    protected static String APP_SERVER_CLASSLOADER_MODULE_WAR_SEARCH_STRING_PREFIX = ".war/";
    protected static String APP_SERVER_CLASSLOADER_MODULE_EJB_WAR_SEARCH_STRING_POSTFIX = "";
    protected MBeanServer mBeanServer = null;
    private MBeanRuntimeServicesMBean runtimeServicesMBean = null;
    private String moduleName = null;
    private String applicationName = null;

    public JMXServerPlatformBase(DatabaseSession newDatabaseSession) {
        super(newDatabaseSession);
    }

    protected AbstractSession getAbstractSession() {
        return (AbstractSession)((Object)this.getDatabaseSession());
    }

    public MBeanServer getMBeanServer() {
        if (null == this.mBeanServer) {
            try {
                ArrayList<MBeanServer> mBeanServerList = MBeanServerFactory.findMBeanServer(null);
                if (null == mBeanServerList || mBeanServerList.isEmpty()) {
                    this.getAbstractSession().log(6, "server", "failed_to_find_mbean_server", "null or empty List returned from MBeanServerFactory.findMBeanServer(null)");
                    this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
                    if (null == this.mBeanServer) {
                        this.getAbstractSession().log(6, "server", "failed_to_find_mbean_server", "null returned from ManagementFactory.getPlatformMBeanServer()");
                    } else {
                        this.getAbstractSession().log(2, "server", "jmx_mbean_runtime_services_registration_mbeanserver_print", new Object[]{this.mBeanServer, this.mBeanServer.getMBeanCount(), this.mBeanServer.getDefaultDomain(), 0});
                    }
                } else {
                    this.mBeanServer = (MBeanServer)mBeanServerList.get(0);
                    if (mBeanServerList.size() > 1) {
                        this.getAbstractSession().log(6, "server", "jmx_mbean_runtime_services_registration_encountered_multiple_mbeanserver_instances", mBeanServerList.size(), 0, this.mBeanServer);
                        int index = 0;
                        for (MBeanServer anMBeanServer : mBeanServerList) {
                            this.getAbstractSession().log(2, "server", "jmx_mbean_runtime_services_registration_mbeanserver_print", new Object[]{anMBeanServer, anMBeanServer.getMBeanCount(), anMBeanServer.getDefaultDomain(), index});
                            if (null != anMBeanServer.getDefaultDomain()) {
                                this.mBeanServer = anMBeanServer;
                                this.getAbstractSession().log(6, "server", "jmx_mbean_runtime_services_switching_to_alternate_mbeanserver", this.mBeanServer, index);
                            }
                            ++index;
                        }
                    } else {
                        this.getAbstractSession().log(2, "server", "jmx_mbean_runtime_services_registration_mbeanserver_print", new Object[]{this.mBeanServer, this.mBeanServer.getMBeanCount(), this.mBeanServer.getDefaultDomain(), 0});
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.mBeanServer;
    }

    public void serverSpecificRegisterMBean() {
        MBeanServer mBeanServerRuntime = this.getMBeanServer();
        ObjectName name = null;
        String sessionName = this.getMBeanSessionName();
        if (null != sessionName && (this.shouldRegisterDevelopmentBean || this.shouldRegisterRuntimeBean)) {
            if (null != mBeanServerRuntime && this.shouldRegisterDevelopmentBean) {
                try {
                    name = new ObjectName("TopLink:Name=Development-" + sessionName + ",Type=Configuration");
                }
                catch (MalformedObjectNameException mne) {
                    this.getAbstractSession().log(6, "server", "problem_registering_mbean", mne);
                }
                catch (Exception exception) {
                    this.getAbstractSession().log(6, "server", "problem_registering_mbean", exception);
                }
                MBeanDevelopmentServices developmentMBean = new MBeanDevelopmentServices(this.getDatabaseSession());
                ObjectInstance info = null;
                try {
                    info = mBeanServerRuntime.registerMBean(developmentMBean, name);
                }
                catch (InstanceAlreadyExistsException iaee) {
                    this.getAbstractSession().log(6, "server", "problem_registering_mbean", iaee);
                }
                catch (MBeanRegistrationException registrationProblem) {
                    this.getAbstractSession().log(6, "server", "problem_registering_mbean", registrationProblem);
                }
                catch (Exception e) {
                    this.getAbstractSession().log(6, "server", "problem_registering_mbean", e);
                }
                this.getAbstractSession().log(1, "server", "registered_mbean", info, mBeanServerRuntime);
            }
            if (null != mBeanServerRuntime && this.shouldRegisterRuntimeBean) {
                try {
                    name = new ObjectName("TopLink:Name=Session(" + sessionName + ")");
                }
                catch (MalformedObjectNameException mne) {
                    this.getAbstractSession().log(6, "server", "problem_registering_mbean", mne);
                }
                catch (Exception exception) {
                    this.getAbstractSession().log(6, "server", "problem_registering_mbean", exception);
                }
                ObjectInstance runtimeInstance = null;
                try {
                    runtimeInstance = mBeanServerRuntime.registerMBean(this.runtimeServicesMBean, name);
                    this.setRuntimeServicesMBean(this.runtimeServicesMBean);
                }
                catch (InstanceAlreadyExistsException iaee) {
                    this.getAbstractSession().log(6, "server", "problem_registering_mbean", iaee);
                }
                catch (MBeanRegistrationException registrationProblem) {
                    this.getAbstractSession().log(6, "server", "problem_registering_mbean", registrationProblem);
                }
                catch (Exception e) {
                    this.getAbstractSession().log(6, "server", "problem_registering_mbean", e);
                }
                this.getAbstractSession().log(1, "server", "registered_mbean", runtimeInstance, mBeanServerRuntime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serverSpecificUnregisterMBean() {
        block21: {
            MBeanServer mBeanServerRuntime = this.getMBeanServer();
            ObjectName name = null;
            String sessionName = this.getMBeanSessionName();
            if (null != sessionName && (this.shouldRegisterDevelopmentBean || this.shouldRegisterRuntimeBean)) {
                if (null == mBeanServerRuntime) {
                    this.getAbstractSession().log(6, "server", "jmx_unable_to_unregister_mbean", name);
                } else {
                    try {
                        if (this.shouldRegisterDevelopmentBean) {
                            try {
                                name = new ObjectName("TopLink:Name=Development-" + sessionName + ",Type=Configuration");
                            }
                            catch (MalformedObjectNameException mne) {
                                this.getAbstractSession().log(6, "server", "problem_unregistering_mbean", mne);
                            }
                            catch (Exception exception) {
                                this.getAbstractSession().log(6, "server", "problem_unregistering_mbean", exception);
                            }
                            this.getAbstractSession().log(1, "server", "unregistering_mbean", name, mBeanServerRuntime);
                            try {
                                mBeanServerRuntime.unregisterMBean(name);
                                this.getAbstractSession().log(1, "server", "jmx_unregistered_mbean", name, mBeanServerRuntime);
                            }
                            catch (InstanceNotFoundException inf) {
                                this.getAbstractSession().log(6, "server", "problem_unregistering_mbean", inf);
                            }
                            catch (MBeanRegistrationException mbre) {
                                this.getAbstractSession().log(6, "server", "problem_unregistering_mbean", mbre);
                            }
                        }
                        if (!this.shouldRegisterRuntimeBean) break block21;
                        try {
                            name = new ObjectName("TopLink:Name=Session(" + sessionName + ")");
                        }
                        catch (MalformedObjectNameException mne) {
                            this.getAbstractSession().log(6, "server", "problem_unregistering_mbean", mne);
                        }
                        catch (Exception exception) {
                            this.getAbstractSession().log(6, "server", "problem_unregistering_mbean", exception);
                        }
                        this.getAbstractSession().log(1, "server", "unregistering_mbean", name, mBeanServerRuntime);
                        try {
                            mBeanServerRuntime.unregisterMBean(name);
                            this.getAbstractSession().log(1, "server", "jmx_unregistered_mbean", name, mBeanServerRuntime);
                        }
                        catch (InstanceNotFoundException inf) {
                            this.getAbstractSession().log(6, "server", "problem_unregistering_mbean", inf);
                        }
                        catch (MBeanRegistrationException registrationProblem) {
                            this.getAbstractSession().log(6, "server", "problem_unregistering_mbean", registrationProblem);
                        }
                    }
                    catch (Exception exception) {
                        this.getAbstractSession().log(6, "server", "problem_unregistering_mbean", exception);
                    }
                    finally {
                        this.setRuntimeServicesMBean(null);
                    }
                }
            }
        }
    }

    protected String getMBeanSessionName() {
        if (null != this.getDatabaseSession() && null != this.getDatabaseSession().getName()) {
            return this.getDatabaseSession().getName().replaceAll("[=,:]", "_");
        }
        this.getAbstractSession().log(6, "server", "session_key_for_mbean_name_is_null");
        return null;
    }

    protected MBeanRuntimeServicesMBean getRuntimeServicesMBean() {
        return this.runtimeServicesMBean;
    }

    protected void setRuntimeServicesMBean(MBeanRuntimeServicesMBean runtimeServicesMBean) {
        this.runtimeServicesMBean = runtimeServicesMBean;
    }

    protected String getModuleName(boolean enableDefault) {
        if (null == this.moduleName) {
            this.moduleName = (String)this.getDatabaseSession().getProperty(OVERRIDE_JMX_MODULENAME_PROPERTY);
        }
        if (null == this.moduleName && enableDefault) {
            this.moduleName = DEFAULT_SERVER_NAME_AND_VERSION;
        }
        return this.moduleName;
    }

    public String getModuleName() {
        return this.getModuleName(true);
    }

    protected void setModuleName(String aName) {
        this.moduleName = aName;
    }

    protected String getApplicationName(boolean enableDefault) {
        if (null == this.applicationName) {
            this.applicationName = (String)this.getDatabaseSession().getProperty(OVERRIDE_JMX_APPLICATIONNAME_PROPERTY);
        }
        if (null == this.applicationName && enableDefault) {
            this.applicationName = DEFAULT_SERVER_NAME_AND_VERSION;
        }
        return this.applicationName;
    }

    public String getApplicationName() {
        return this.getApplicationName(true);
    }

    public void setApplicationName(String aName) {
        this.applicationName = aName;
    }

    protected void initializeApplicationNameAndModuleName() {
        String databaseSessionName = this.getDatabaseSession().getName();
        String classLoaderName = this.getDatabaseSession().getPlatform().getConversionManager().getLoader().toString();
        this.getAbstractSession().log(1, "server", "jmx_mbean_classloader_in_use", "Platform ConversionManager", classLoaderName);
        String jpaModuleName = this.getModuleName(false);
        String jpaApplicationName = this.getApplicationName(false);
        if (jpaModuleName == null) {
            String subString = databaseSessionName.substring(databaseSessionName.indexOf(APP_SERVER_CLASSLOADER_MODULE_EJB_SEARCH_STRING_PREFIX) + APP_SERVER_CLASSLOADER_MODULE_EJB_SEARCH_STRING_PREFIX.length());
            if (null != subString) {
                this.setModuleName(subString);
            } else {
                subString = databaseSessionName.substring(databaseSessionName.indexOf(APP_SERVER_CLASSLOADER_MODULE_WAR_SEARCH_STRING_PREFIX) + APP_SERVER_CLASSLOADER_MODULE_WAR_SEARCH_STRING_PREFIX.length());
                this.setModuleName(subString);
            }
            if (null != jpaModuleName && jpaModuleName.indexOf(APP_SERVER_CLASSLOADER_MODULE_EJB_WAR_SEARCH_STRING_POSTFIX) > -1) {
                jpaModuleName = jpaModuleName.substring(0, jpaModuleName.indexOf(APP_SERVER_CLASSLOADER_MODULE_EJB_WAR_SEARCH_STRING_POSTFIX));
            }
        }
        if (jpaApplicationName == null) {
            jpaApplicationName = classLoaderName.substring(classLoaderName.indexOf(APP_SERVER_CLASSLOADER_APPLICATION_PU_SEARCH_STRING_PREFIX) + APP_SERVER_CLASSLOADER_APPLICATION_PU_SEARCH_STRING_PREFIX.length());
            if (null != jpaApplicationName && jpaApplicationName.indexOf(APP_SERVER_CLASSLOADER_APPLICATION_PU_SEARCH_STRING_POSTFIX) > -1) {
                jpaApplicationName = jpaApplicationName.substring(0, jpaApplicationName.indexOf(APP_SERVER_CLASSLOADER_APPLICATION_PU_SEARCH_STRING_POSTFIX));
            }
            if (null != jpaApplicationName) {
                jpaApplicationName = jpaApplicationName.replaceAll("[=,:] ", "_");
            }
            this.setApplicationName(jpaApplicationName);
        }
        this.getAbstractSession().log(1, "server", "mbean_get_application_name", this.getDatabaseSession().getName(), this.getApplicationName());
        this.getAbstractSession().log(1, "server", "mbean_get_module_name", this.getDatabaseSession().getName(), this.getModuleName());
    }
}

