/*******************************************************************************
 * Copyright (c) 1998, 2010 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the 
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0 
 * which accompanies this distribution. 
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at 
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation from Oracle TopLink
 ******************************************************************************/  
package org.eclipse.persistence.testing.models.spatial.jgeometry;

import org.eclipse.persistence.sessions.*;
import org.eclipse.persistence.descriptors.*;
import org.eclipse.persistence.mappings.*;
import org.eclipse.persistence.queries.*;

/**
 * This class was generated by the TopLink project class generator.
 * It stores the meta-data (descriptors) that define the TopLink mappings.
 * ## Oracle TopLink - 11g Release 1 (11.1.1.0.0) (Build 061126) ##
 * @see org.eclipse.persistence.sessions.factories.ProjectClassGenerator
 */
public class JGeometryProject extends org.eclipse.persistence.sessions.Project {

    public JGeometryProject() {
        setName("simple-spatial");
        applyLogin();

        addDescriptor(buildSimpleSpatialDescriptor());
        addDescriptor(buildWrappedSpatialDescriptor());
    }

    public void applyLogin() {
        DatabaseLogin login = new DatabaseLogin();
        login.usePlatform(new org.eclipse.persistence.platform.database.oracle.Oracle10Platform());
        login.setDriverClassName("oracle.jdbc.OracleDriver");
        login.setConnectionString("jdbc:oracle:thin:@localhost:1521:ORCL");
        login.setUserName("scott");
        login.setEncryptedPassword("tiger");

        // Configuration Properties.

        setDatasourceLogin(login);
    }

    public ClassDescriptor buildSimpleSpatialDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(org.eclipse.persistence.testing.models.spatial.jgeometry.SimpleSpatial.class);
        descriptor.addTableName("SIMPLE_SPATIAL");
        descriptor.addPrimaryKeyFieldName("SIMPLE_SPATIAL.GID");

        // Descriptor Properties.
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteSoftCacheWeakIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setAlias("SimpleSpatial");


        // Query Manager.
        descriptor.getQueryManager().checkCacheForDoesExist();
        // Named Queries.
        // Named Query -- findAllSimpleSpatial
        ReadAllQuery namedQuery0 = new ReadAllQuery(org.eclipse.persistence.testing.models.spatial.jgeometry.SimpleSpatial.class);
        namedQuery0.setName("findAllSimpleSpatial");
        namedQuery0.setQueryTimeout(0);
        namedQuery0.setCacheUsage(ObjectLevelReadQuery.CheckCacheByPrimaryKey);
        namedQuery0.setLockMode(ObjectLevelReadQuery.NO_LOCK);
        descriptor.getQueryManager().addQuery("findAllSimpleSpatial", namedQuery0);

        // Event Manager.

        // Mappings.
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("SIMPLE_SPATIAL.GID");
        descriptor.addMapping(idMapping);

        DirectToFieldMapping geometryMapping = new DirectToFieldMapping();
        geometryMapping.setAttributeName("geometry");
        geometryMapping.setFieldName("SIMPLE_SPATIAL.GEOMETRY");
        geometryMapping.setFieldType(java.sql.Types.STRUCT);
        descriptor.addMapping(geometryMapping);

        return descriptor;
    }

    public ClassDescriptor buildWrappedSpatialDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(org.eclipse.persistence.testing.models.spatial.jgeometry.wrapped.WrappedSpatial.class);
        descriptor.addTableName("WRAPPED_SPATIAL");
        descriptor.addPrimaryKeyFieldName("WRAPPED_SPATIAL.GID");

        // Descriptor Properties.
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteSoftCacheWeakIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setAlias("WrappedSpatial");
        descriptor.setAmendmentClass(org.eclipse.persistence.testing.models.spatial.jgeometry.wrapped.TopLinkAfterLoad.class);
        descriptor.setAmendmentMethodName("afterLoadWrappedSpatial");


        // Query Manager.
        descriptor.getQueryManager().checkCacheForDoesExist();
        // Named Queries.
        // Named Query -- findAllWrappedSpatial
        ReadAllQuery namedQuery0 = new ReadAllQuery(org.eclipse.persistence.testing.models.spatial.jgeometry.wrapped.WrappedSpatial.class);
        namedQuery0.setName("findAllWrappedSpatial");
        namedQuery0.setQueryTimeout(0);
        namedQuery0.setCacheUsage(ObjectLevelReadQuery.CheckCacheByPrimaryKey);
        namedQuery0.setLockMode(ObjectLevelReadQuery.NO_LOCK);
        descriptor.getQueryManager().addQuery("findAllWrappedSpatial", namedQuery0);


        // Event Manager.

        // Query keys.
        descriptor.addDirectQueryKey("geometry.id", "WRAPPED_SPATIAL.GEOMETRY.ID");
        descriptor.addDirectQueryKey("geometry.geom", "WRAPPED_SPATIAL.GEOMETRY.GEOM");

        // Mappings.
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("WRAPPED_SPATIAL.GID");
        descriptor.addMapping(idMapping);

        DirectToFieldMapping geometryMapping = new DirectToFieldMapping();
        geometryMapping.setAttributeName("geometry");
        geometryMapping.setFieldName("WRAPPED_SPATIAL.GEOMETRY");
        geometryMapping.setFieldType(java.sql.Types.STRUCT);
        descriptor.addMapping(geometryMapping);

        descriptor.applyAmendmentMethod();
        return descriptor;
    }
}
