/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor;

import java.util.List;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWAbstractDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWClassHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWMethodHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWDescriptorAfterLoadingPolicy
extends MWAbstractDescriptorPolicy {
    private MWMethodHandle postLoadMethodHandle;
    public static final String POST_LOAD_METHOD_PROPERTY = "postLoadMethod";
    private MWClassHandle postLoadMethodClassHandle;
    public static final String POST_LOAD_METHOD_CLASS_PROPERTY = "postLoadMethodClass";

    private MWDescriptorAfterLoadingPolicy() {
    }

    MWDescriptorAfterLoadingPolicy(MWMappingDescriptor descriptor) {
        super(descriptor);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.postLoadMethodHandle = new MWMethodHandle(this, this.buildPostLoadMethodScrubber());
        this.postLoadMethodClassHandle = new MWClassHandle(this, this.buildPostLoadMethodClassScrubber());
    }

    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.postLoadMethodHandle);
        children.add(this.postLoadMethodClassHandle);
    }

    private MWHandle.NodeReferenceScrubber buildPostLoadMethodScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWDescriptorAfterLoadingPolicy.this.setPostLoadMethod(null);
            }

            public String toString() {
                return "MWDescriptorAfterLoadingPolicy.buildPostLoadMethodScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber buildPostLoadMethodClassScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWDescriptorAfterLoadingPolicy.this.setPostLoadMethodClass(null);
            }

            public String toString() {
                return "MWDescriptorAfterLoadingPolicy.buildPostLoadMethodClassScrubber()";
            }
        };
    }

    public MWMethod getPostLoadMethod() {
        return this.postLoadMethodHandle.getMethod();
    }

    public void setPostLoadMethod(MWMethod newMethod) {
        MWMethod oldMethod = this.postLoadMethodHandle.getMethod();
        this.postLoadMethodHandle.setMethod(newMethod);
        this.firePropertyChanged(POST_LOAD_METHOD_PROPERTY, oldMethod, newMethod);
    }

    public MWClass getPostLoadMethodClass() {
        return this.postLoadMethodClassHandle.getType();
    }

    public void setPostLoadMethodClass(MWClass newPostLoadMethodClass) {
        MWClass oldClass = this.postLoadMethodClassHandle.getType();
        this.postLoadMethodClassHandle.setType(newPostLoadMethodClass);
        this.firePropertyChanged(POST_LOAD_METHOD_CLASS_PROPERTY, oldClass, newPostLoadMethodClass);
    }

    public void adjustRuntimeDescriptor(ClassDescriptor runtimeDescriptor) {
        if (this.getPostLoadMethod() != null) {
            runtimeDescriptor.setAmendmentMethodName(this.getPostLoadMethod().getName());
        }
        if (this.getPostLoadMethodClass() != null) {
            runtimeDescriptor.setAmendmentClassName(this.getPostLoadMethodClass().getName());
        }
    }

    public MWDescriptorPolicy getPersistedPolicy() {
        return this;
    }

    public boolean isActive() {
        return true;
    }

    protected void addProblemsTo(List problems) {
        super.addProblemsTo(problems);
        this.checkAfterLoadClass(problems);
        this.checkAfterLoadMethod(problems);
    }

    private void checkAfterLoadClass(List problems) {
        if (this.getPostLoadMethodClass() == null) {
            problems.add(this.buildProblem("0322"));
        } else if (this.getPostLoadMethod() != null && !CollectionTools.contains(this.getPostLoadMethodClass().methods(), (Object)this.getPostLoadMethod())) {
            problems.add(this.buildProblem("0342"));
        }
    }

    private void checkAfterLoadMethod(List problems) {
        if (this.getPostLoadMethod() == null) {
            problems.add(this.buildProblem("0323"));
        } else if (!this.getPostLoadMethod().isCandidateDescriptorAfterLoadMethod()) {
            problems.add(this.buildProblem("0372"));
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWDescriptorAfterLoadingPolicy.class);
        XMLCompositeObjectMapping postLoadMethodClassHandleMapping = new XMLCompositeObjectMapping();
        postLoadMethodClassHandleMapping.setAttributeName("postLoadMethodClassHandle");
        postLoadMethodClassHandleMapping.setGetMethodName("getPostLoadMethodClassHandleForTopLink");
        postLoadMethodClassHandleMapping.setSetMethodName("setPostLoadMethodClassHandleForTopLink");
        postLoadMethodClassHandleMapping.setReferenceClass(MWClassHandle.class);
        postLoadMethodClassHandleMapping.setXPath("post-load-class-handle");
        descriptor.addMapping((DatabaseMapping)postLoadMethodClassHandleMapping);
        XMLCompositeObjectMapping postLoadMethodHandleMapping = new XMLCompositeObjectMapping();
        postLoadMethodHandleMapping.setAttributeName("postLoadMethodHandle");
        postLoadMethodHandleMapping.setGetMethodName("getPostLoadMethodHandleForTopLink");
        postLoadMethodHandleMapping.setSetMethodName("setPostLoadMethodHandleForTopLink");
        postLoadMethodHandleMapping.setReferenceClass(MWMethodHandle.class);
        postLoadMethodHandleMapping.setXPath("post-load-method-handle");
        descriptor.addMapping((DatabaseMapping)postLoadMethodHandleMapping);
        return descriptor;
    }

    private void setPostLoadMethodClassHandleForTopLink(MWClassHandle handle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildPostLoadMethodClassScrubber();
        this.postLoadMethodClassHandle = handle == null ? new MWClassHandle(this, scrubber) : handle.setScrubber(scrubber);
    }

    private MWClassHandle getPostLoadMethodClassHandleForTopLink() {
        return this.postLoadMethodClassHandle.getType() == null ? null : this.postLoadMethodClassHandle;
    }

    private void setPostLoadMethodHandleForTopLink(MWMethodHandle handle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildPostLoadMethodScrubber();
        this.postLoadMethodHandle = handle == null ? new MWMethodHandle(this, scrubber) : handle.setScrubber(scrubber);
    }

    private MWMethodHandle getPostLoadMethodHandleForTopLink() {
        return this.postLoadMethodHandle.getMethod() == null ? null : this.postLoadMethodHandle;
    }
}

