/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml;

import java.util.List;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.TimestampLockingPolicy;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWDataField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorLockingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWEisTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWRootEisDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSchemaContextComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXmlField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXmlNode;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXpathContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXpathSpec;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.SchemaChange;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWEisDescriptorLockingPolicy
extends MWDescriptorLockingPolicy
implements MWXmlNode,
MWXpathContext {
    private MWXmlField versionXmlField;

    private MWEisDescriptorLockingPolicy() {
    }

    MWEisDescriptorLockingPolicy(MWEisTransactionalPolicy descriptor) {
        super(descriptor);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.versionXmlField = new MWXmlField(this);
    }

    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.versionXmlField);
    }

    public MWDataField getVersionLockField() {
        return this.versionXmlField;
    }

    public void setVersionLockField(MWDataField newLockField) {
        throw new UnsupportedOperationException("the xml field itself should be modified");
    }

    public MWSchemaContextComponent schemaContext(MWXmlField xmlField) {
        return this.eisDescriptor().getSchemaContext();
    }

    public MWXpathSpec xpathSpec(MWXmlField xmlField) {
        return this.buildXpathSpec();
    }

    protected MWXpathSpec buildXpathSpec() {
        return new MWXpathSpec(){

            public boolean mayUseCollectionData() {
                return false;
            }

            public boolean mayUseComplexData() {
                return false;
            }

            public boolean mayUseSimpleData() {
                return true;
            }
        };
    }

    private MWRootEisDescriptor eisDescriptor() {
        return (MWRootEisDescriptor)((MWTransactionalPolicy)this.getParent()).getParent();
    }

    protected void checkLockFieldSpecifiedForLockingPolicy(List newProblems) {
        if (this.getLockingType() != "None" && this.getVersionLockField() == null) {
            newProblems.add(this.buildProblem("0308"));
        }
    }

    public void resolveXpaths() {
        this.versionXmlField.resolveXpaths();
    }

    public void schemaChanged(SchemaChange change) {
        this.versionXmlField.schemaChanged(change);
    }

    public void adjustRuntimeDescriptor(ClassDescriptor runtimeDescriptor) {
        super.adjustRuntimeDescriptor(runtimeDescriptor);
        if (this.getLockingType() == "Optimistic Locking") {
            VersionLockingPolicy lockingPolicy;
            if (this.getOptimisticVersionLockingType() == "Version Locking") {
                lockingPolicy = new VersionLockingPolicy();
            } else {
                lockingPolicy = new TimestampLockingPolicy();
                if (this.usesLocalTime()) {
                    ((TimestampLockingPolicy)lockingPolicy).useLocalTime();
                } else {
                    ((TimestampLockingPolicy)lockingPolicy).useServerTime();
                }
            }
            if (this.getVersionLockField() != null && this.getVersionLockField().runtimeField() != null) {
                lockingPolicy.setWriteLockFieldName(this.getVersionLockField().runtimeField().getQualifiedName());
            }
            lockingPolicy.setIsStoredInCache(this.shouldStoreVersionInCache());
            runtimeDescriptor.setOptimisticLockingPolicy((OptimisticLockingPolicy)lockingPolicy);
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWEisDescriptorLockingPolicy.class);
        descriptor.getInheritancePolicy().setParentClass(MWDescriptorLockingPolicy.class);
        XMLCompositeObjectMapping versionXmlFieldMapping = new XMLCompositeObjectMapping();
        versionXmlFieldMapping.setReferenceClass(MWXmlField.class);
        versionXmlFieldMapping.setAttributeName("versionXmlField");
        versionXmlFieldMapping.setGetMethodName("getVersionXmlFieldForTopLink");
        versionXmlFieldMapping.setSetMethodName("setVersionXmlFieldForTopLink");
        versionXmlFieldMapping.setXPath("version-xml-field");
        descriptor.addMapping((DatabaseMapping)versionXmlFieldMapping);
        return descriptor;
    }

    private MWXmlField getVersionXmlFieldForTopLink() {
        return this.versionXmlField.isSpecified() ? this.versionXmlField : null;
    }

    private void setVersionXmlFieldForTopLink(MWXmlField xmlField) {
        this.versionXmlField = xmlField == null ? new MWXmlField(this) : xmlField;
    }
}

