/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.internal.indirection.BasicIndirectionPolicy;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.internal.indirection.NoIndirectionPolicy;
import org.eclipse.persistence.internal.indirection.TransparentIndirectionPolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.TopLinkOptionSet;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.ColumnStringHolder;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumnPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWJoinFetchableMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWColumnHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWReferenceHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWTableHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWDirectContainerMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWIndirectableContainerMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWIndirectableMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTypeConversionConverter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.AggregateFieldDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.AggregateRuntimeFieldNameGenerator;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWAbstractTableReferenceMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWRelationalTypeConversionConverter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWTableReferenceMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.string.PartialStringComparator;
import org.eclipse.persistence.tools.workbench.utility.string.PartialStringMatcher;
import org.eclipse.persistence.tools.workbench.utility.string.SimplePartialStringMatcher;
import org.eclipse.persistence.tools.workbench.utility.string.StringHolder;

public abstract class MWRelationalDirectContainerMapping
extends MWDirectContainerMapping
implements MWTableReferenceMapping,
MWIndirectableContainerMapping,
MWJoinFetchableMapping {
    private MWTableHandle targetTableHandle;
    public static final String TARGET_TABLE_PROPERTY = "targetTable";
    private MWColumnHandle directValueColumnHandle;
    public static final String DIRECT_VALUE_COLUMN_PROPERTY = "directValueColumn";
    private volatile MWJoinFetchableMapping.JoinFetchOption joinFetchOption;
    private static TopLinkOptionSet joinFetchOptions;
    private MWReferenceHandle referenceHandle;
    private volatile String indirectionType;
    private volatile boolean batchReading;
    private static final PartialStringMatcher COLUMN_NAME_MATCHER;

    protected MWRelationalDirectContainerMapping() {
    }

    public MWRelationalDirectContainerMapping(MWMappingDescriptor parent, MWClassAttribute attribute, String name) {
        super(parent, attribute, name);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.directValueColumnHandle = new MWColumnHandle(this, this.buildDirectValueColumnScrubber());
        this.referenceHandle = new MWReferenceHandle(this, this.buildReferenceScrubber());
        this.targetTableHandle = new MWTableHandle(this, this.buildTargetTableScrubber());
        this.joinFetchOption = (MWJoinFetchableMapping.JoinFetchOption)MWJoinFetchableMapping.JoinFetchOptionSet.joinFetchOptions().topLinkOptionForMWModelOption("NONE");
    }

    protected void initialize(MWClassAttribute attribute, String name) {
        super.initialize(attribute, name);
        if (attribute.isEjb20Attribute() || !attribute.isValueHolder()) {
            this.setUseTransparentIndirection();
        } else {
            this.setUseValueHolderIndirection();
        }
    }

    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.directValueColumnHandle);
        children.add(this.referenceHandle);
        children.add(this.targetTableHandle);
    }

    private MWHandle.NodeReferenceScrubber buildDirectValueColumnScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWRelationalDirectContainerMapping.this.setDirectValueColumn(null);
            }

            public String toString() {
                return "MWRelationalDirectContainerMapping.buildDirectValueColumnScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber buildReferenceScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWRelationalDirectContainerMapping.this.setReference(null);
            }

            public String toString() {
                return "MWRelationalDirectContainerMapping.buildReferenceScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber buildTargetTableScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWRelationalDirectContainerMapping.this.setTargetTable(null);
            }

            public String toString() {
                return "MWRelationalDirectContainerMapping.buildTargetTableScrubber()";
            }
        };
    }

    public void initializeFromMWRelationalDirectContainerMapping(MWRelationalDirectContainerMapping oldMapping) {
        super.initializeFromMWRelationalDirectContainerMapping(oldMapping);
        this.setTargetTable(oldMapping.getTargetTable());
        this.setDirectValueColumn(oldMapping.getDirectValueColumn());
        this.setReference(oldMapping.getReference());
        this.setTargetTable(oldMapping.getTargetTable());
        this.setUsesBatchReading(oldMapping.usesBatchReading());
    }

    public void initializeFromMWAbstractTableReferenceMapping(MWAbstractTableReferenceMapping oldMapping) {
        super.initializeFromMWAbstractTableReferenceMapping(oldMapping);
        this.setReference(oldMapping.getReference());
        this.setUsesBatchReading(oldMapping.usesBatchReading());
    }

    protected void initializeFromMWIndirectableMapping(MWIndirectableMapping oldMapping) {
        super.initializeFromMWIndirectableMapping(oldMapping);
        if (oldMapping.usesValueHolderIndirection()) {
            this.setUseValueHolderIndirection();
        } else if (oldMapping.usesNoIndirection()) {
            this.setUseNoIndirection();
        }
    }

    protected void initializeFromMWIndirectableContainerMapping(MWIndirectableContainerMapping oldMapping) {
        super.initializeFromMWIndirectableContainerMapping(oldMapping);
        if (oldMapping.usesTransparentIndirection()) {
            this.setUseTransparentIndirection();
        }
    }

    protected MWTypeConversionConverter buildTypeConversionConverter() {
        return new MWRelationalTypeConversionConverter(this);
    }

    public boolean parentDescriptorIsAggregate() {
        return ((MWRelationalDescriptor)((Object)this.getParentDescriptor())).isAggregateDescriptor();
    }

    public MWRelationalDescriptor getParentRelationalDescriptor() {
        return (MWRelationalDescriptor)((Object)this.getParentDescriptor());
    }

    public MWTable getTargetTable() {
        return this.targetTableHandle.getTable();
    }

    public void setTargetTable(MWTable newValue) {
        MWTable oldValue = this.targetTableHandle.getTable();
        this.targetTableHandle.setTable(newValue);
        this.firePropertyChanged(TARGET_TABLE_PROPERTY, oldValue, newValue);
        if (oldValue != newValue) {
            this.setDirectFieldsNull();
        }
    }

    protected void setDirectFieldsNull() {
        this.setDirectValueColumn(null);
    }

    public MWColumn getDirectValueColumn() {
        return this.directValueColumnHandle.getColumn();
    }

    public void setDirectValueColumn(MWColumn newValue) {
        this.checkColumn(newValue);
        MWColumn oldValue = this.directValueColumnHandle.getColumn();
        this.directValueColumnHandle.setColumn(newValue);
        this.firePropertyChanged(DIRECT_VALUE_COLUMN_PROPERTY, oldValue, newValue);
    }

    protected void checkColumn(MWColumn field) {
        if (field == null) {
            return;
        }
        if (this.getTargetTable() == null) {
            throw new IllegalStateException("The target table must be set first");
        }
        if (this.getTargetTable().columnNamed(field.getName()) == null) {
            throw new IllegalArgumentException("The field must be in the target table");
        }
    }

    public MWJoinFetchableMapping.JoinFetchOption getJoinFetchOption() {
        if (this.joinFetchOption == null) {
            this.joinFetchOption = (MWJoinFetchableMapping.JoinFetchOption)MWJoinFetchableMapping.JoinFetchOptionSet.joinFetchOptions().topLinkOptionForMWModelOption("NONE");
        }
        return this.joinFetchOption;
    }

    public void setJoinFetchOption(MWJoinFetchableMapping.JoinFetchOption newJoinFetchOption) {
        MWJoinFetchableMapping.JoinFetchOption old = this.joinFetchOption;
        this.joinFetchOption = newJoinFetchOption;
        this.firePropertyChanged("joinFetchOption", old, this.joinFetchOption);
    }

    public void setJoinFetchOption(String joinFetchOptions) {
        this.setJoinFetchOption((MWJoinFetchableMapping.JoinFetchOption)MWJoinFetchableMapping.JoinFetchOptionSet.joinFetchOptions().topLinkOptionForMWModelOption(joinFetchOptions));
    }

    public MWReference getReference() {
        return this.referenceHandle.getReference();
    }

    public void setReference(MWReference newValue) {
        MWReference oldValue = this.getReference();
        this.referenceHandle.setReference(newValue);
        this.firePropertyChanged("reference", oldValue, newValue);
        this.getProject().recalculateAggregatePathsToColumn(this.getParentDescriptor());
    }

    public boolean usesNoIndirection() {
        return this.indirectionType == "no-indirection";
    }

    public boolean usesValueHolderIndirection() {
        return this.indirectionType == "value-holder-indirection";
    }

    public boolean usesTransparentIndirection() {
        return this.indirectionType == "transparentIndirection";
    }

    public void setUseNoIndirection() {
        this.setIndirectionType("no-indirection");
    }

    public void setUseValueHolderIndirection() {
        this.setIndirectionType("value-holder-indirection");
    }

    public void setUseTransparentIndirection() {
        this.setIndirectionType("transparentIndirection");
    }

    private void setIndirectionType(String indirectionType) {
        String oldValue = this.indirectionType;
        this.indirectionType = indirectionType;
        this.firePropertyChanged("indirection", oldValue, indirectionType);
    }

    public boolean usesBatchReading() {
        return this.batchReading;
    }

    public void setUsesBatchReading(boolean newValue) {
        boolean oldValue = this.batchReading;
        this.batchReading = newValue;
        this.firePropertyChanged("usesBatchReading", oldValue, newValue);
    }

    public boolean allowsChildren() {
        return false;
    }

    public boolean allowsOuterJoin() {
        return this.allowsChildren();
    }

    public boolean isLeaf(Filter queryableFilter) {
        return true;
    }

    public boolean usesAnyOf() {
        return true;
    }

    public boolean isValidForReadAllQueryOrderable() {
        return false;
    }

    public boolean isTraversableForBatchReadAttribute() {
        return true;
    }

    public boolean isValidForBatchReadAttribute() {
        return true;
    }

    public boolean isTraversableForJoinedAttribute() {
        return true;
    }

    public boolean isValidForJoinedAttribute() {
        return true;
    }

    public boolean isTraversableForQueryExpression() {
        return true;
    }

    public boolean isValidForQueryExpression() {
        return true;
    }

    public boolean referenceIsCandidate(MWReference reference) {
        return this.getTargetTable() != null && reference.getSourceTable() == this.getTargetTable() && CollectionTools.contains(this.getParentRelationalDescriptor().candidateTables(), (Object)reference.getTargetTable());
    }

    public Iterator candidateReferences() {
        return this.buildCandidateReferences().iterator();
    }

    public Collection buildCandidateReferences() {
        HashSet references = new HashSet();
        boolean inClassDescriptor = !this.parentDescriptorIsAggregate();
        MWColumn column = this.getDirectValueColumn();
        if (column != null && inClassDescriptor) {
            MWTable sourceTable = column.getTable();
            MWTable targetTable = ((MWTableDescriptor)this.getParentDescriptor()).getPrimaryTable();
            if (targetTable != null) {
                CollectionTools.addAll(references, sourceTable.referencesBetween(targetTable));
            }
        } else {
            Iterator stream1 = this.getDatabase().tables();
            while (stream1.hasNext()) {
                MWTable table1 = (MWTable)stream1.next();
                if (inClassDescriptor) {
                    MWTableDescriptor descriptor = (MWTableDescriptor)this.getParentDescriptor();
                    Iterator stream2 = descriptor.candidateTables();
                    while (stream2.hasNext()) {
                        MWTable table2 = (MWTable)stream2.next();
                        CollectionTools.addAll(references, table1.referencesTo(table2));
                    }
                    continue;
                }
                CollectionTools.addAll(references, table1.references());
            }
        }
        return references;
    }

    protected DatabaseMapping buildRuntimeMapping() {
        return new DirectCollectionMapping();
    }

    public void addWrittenFieldsTo(Collection writtenFields) {
    }

    public void automap() {
        super.automap();
        this.automapIndirection();
        this.automapReference();
        this.automapDirectValueColumn();
    }

    public void automapIndirection() {
        if (this.getInstanceVariable().isValueHolder()) {
            this.setUseValueHolderIndirection();
        }
    }

    private void automapReference() {
        if (this.getReference() != null || this.parentDescriptorIsAggregate()) {
            return;
        }
        Collection references = this.buildCandidateReferences();
        if (references.isEmpty()) {
            return;
        }
        MWReference reference = this.findReasonableReference(references);
        this.setTargetTable(reference.getSourceTable());
        this.setReference(reference);
    }

    private MWReference findReasonableReference(Collection references) {
        MWReference result = null;
        for (MWReference reference : references) {
            if (result == null) {
                result = reference;
            }
            MWTable sourceTable = reference.getSourceTable();
            int refColumnPairsSize = reference.columnPairsSize();
            if (sourceTable.columnsSize() - refColumnPairsSize != this.automapNonPrimaryKeyColumnsSize()) continue;
            result = reference;
            break;
        }
        return result;
    }

    protected abstract int automapNonPrimaryKeyColumnsSize();

    private void automapDirectValueColumn() {
        if (this.getDirectValueColumn() != null || this.getReference() == null) {
            return;
        }
        StringHolder[] columnStringHolders = ColumnStringHolder.buildHolders(this.candidateDirectValueColumns());
        PartialStringMatcher.StringHolderScore shs = COLUMN_NAME_MATCHER.match(this.getName().toLowerCase(), columnStringHolders);
        if (shs.getScore() > 0.5) {
            this.setDirectValueColumn(((ColumnStringHolder)shs.getStringHolder()).getColumn());
        }
    }

    private Iterator candidateDirectValueColumns() {
        return this.getReference().getSourceTable().columns();
    }

    protected Collection buildAggregateFieldNameGenerators() {
        Collection generators = super.buildAggregateFieldNameGenerators();
        if (this.getReference() != null) {
            Iterator stream = this.getReference().columnPairs();
            while (stream.hasNext()) {
                generators.add(new ColumnPairAggregateRuntimeFieldNameGenerator(this, (MWColumnPair)stream.next()));
            }
        }
        return generators;
    }

    protected void addProblemsTo(List newProblems) {
        super.addProblemsTo(newProblems);
        this.checkDirectValueColumn(newProblems);
        this.checkReference(newProblems);
        this.checkValueHolderInstanceVariable(newProblems);
        this.checkNonValueHolderInstanceVariable(newProblems);
        this.checkTransparentIndirection(newProblems);
    }

    private void checkDirectValueColumn(List newProblems) {
        if (this.parentDescriptorIsAggregate()) {
            return;
        }
        if (this.getDirectValueColumn() == null) {
            newProblems.add(this.buildProblem("0410"));
        }
    }

    private void checkReference(List newProblems) {
        if (this.getReference() == null) {
            newProblems.add(this.buildProblem("0460"));
        } else if (!this.referenceIsCandidate(this.getReference())) {
            newProblems.add(this.buildProblem("0461"));
        }
    }

    private void checkValueHolderInstanceVariable(List newProblems) {
        if (this.getInstanceVariable().isValueHolder() && !this.usesValueHolderIndirection()) {
            newProblems.add(this.buildProblem("0550"));
        }
    }

    private void checkNonValueHolderInstanceVariable(List newProblems) {
        if (!this.getProject().usesWeaving() && !this.getInstanceVariable().isValueHolder() && this.usesValueHolderIndirection()) {
            newProblems.add(this.buildProblem("0551"));
        }
    }

    private void checkTransparentIndirection(List newProblems) {
        MWClass collectionType;
        if (this.usesTransparentIndirection() && (collectionType = this.conatinerPolicyClass()) != null && !collectionType.mightBeAssignableToIndirectContainer()) {
            newProblems.add(this.buildProblem("0560"));
        }
    }

    protected abstract MWClass conatinerPolicyClass();

    public DatabaseMapping runtimeMapping() {
        DirectCollectionMapping directCollectionMapping = (DirectCollectionMapping)super.runtimeMapping();
        if (this.getDirectValueColumn() != null) {
            directCollectionMapping.setDirectFieldName(this.getDirectValueColumn().qualifiedName());
        }
        directCollectionMapping.setValueConverter(this.getConverter().runtimeConverter((DatabaseMapping)directCollectionMapping));
        if (this.usesValueHolderIndirection()) {
            directCollectionMapping.setIndirectionPolicy((IndirectionPolicy)new BasicIndirectionPolicy());
        } else if (this.usesTransparentIndirection()) {
            directCollectionMapping.setIndirectionPolicy((IndirectionPolicy)new TransparentIndirectionPolicy());
        } else {
            directCollectionMapping.setIndirectionPolicy((IndirectionPolicy)new NoIndirectionPolicy());
        }
        this.joinFetchOption.setMWOptionOnTopLinkObject(directCollectionMapping);
        directCollectionMapping.setUsesBatchReading(this.usesBatchReading());
        MWReference ref = this.getReference();
        if (ref != null) {
            directCollectionMapping.setReferenceTableName(ref.getSourceTable().getName());
            Iterator stream = ref.columnPairs();
            while (stream.hasNext()) {
                MWColumnPair pair = (MWColumnPair)stream.next();
                if (pair.getSourceColumn() == null || pair.getTargetColumn() == null) continue;
                if (!this.parentDescriptorIsAggregate()) {
                    directCollectionMapping.addReferenceKeyFieldName(pair.getSourceColumn().qualifiedName(), pair.getTargetColumn().qualifiedName());
                    continue;
                }
                directCollectionMapping.addReferenceKeyFieldName(pair.getSourceColumn().qualifiedName(), this.getName() + "->" + pair.getTargetColumn().getName() + "_IN_REFERENCE_" + this.getReference().getName());
            }
        }
        return directCollectionMapping;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWRelationalDirectContainerMapping.class);
        descriptor.getInheritancePolicy().setParentClass(MWDirectContainerMapping.class);
        XMLCompositeObjectMapping targetTableHandleMapping = new XMLCompositeObjectMapping();
        targetTableHandleMapping.setAttributeName("targetTableHandle");
        targetTableHandleMapping.setGetMethodName("getTargetTableHandleForTopLink");
        targetTableHandleMapping.setSetMethodName("setTargetTableHandleForTopLink");
        targetTableHandleMapping.setReferenceClass(MWTableHandle.class);
        targetTableHandleMapping.setXPath("target-table-handle");
        descriptor.addMapping((DatabaseMapping)targetTableHandleMapping);
        XMLCompositeObjectMapping directValueColumnHandleMapping = new XMLCompositeObjectMapping();
        directValueColumnHandleMapping.setAttributeName("directValueColumnHandle");
        directValueColumnHandleMapping.setGetMethodName("getDirectValueColumnHandleForTopLink");
        directValueColumnHandleMapping.setSetMethodName("setDirectValueColumnHandleForTopLink");
        directValueColumnHandleMapping.setReferenceClass(MWColumnHandle.class);
        directValueColumnHandleMapping.setXPath("direct-value-column-handle");
        descriptor.addMapping((DatabaseMapping)directValueColumnHandleMapping);
        XMLCompositeObjectMapping referenceHandleMapping = new XMLCompositeObjectMapping();
        referenceHandleMapping.setAttributeName("referenceHandle");
        referenceHandleMapping.setGetMethodName("getReferenceHandleForTopLink");
        referenceHandleMapping.setSetMethodName("setReferenceHandleForTopLink");
        referenceHandleMapping.setReferenceClass(MWReferenceHandle.class);
        referenceHandleMapping.setXPath("reference-handle");
        descriptor.addMapping((DatabaseMapping)referenceHandleMapping);
        ObjectTypeConverter joinFetchingConverter = new ObjectTypeConverter();
        MWJoinFetchableMapping.JoinFetchOptionSet.joinFetchOptions().addConversionValuesForTopLinkTo(joinFetchingConverter);
        XMLDirectMapping joinFetchingMapping = new XMLDirectMapping();
        joinFetchingMapping.setAttributeName("joinFetchOption");
        joinFetchingMapping.setXPath("join-fetch-option/text()");
        joinFetchingMapping.setNullValue((Object)MWJoinFetchableMapping.JoinFetchOptionSet.joinFetchOptions().topLinkOptionForMWModelOption("NONE"));
        joinFetchingMapping.setConverter((Converter)joinFetchingConverter);
        descriptor.addMapping((DatabaseMapping)joinFetchingMapping);
        ObjectTypeConverter indirectionTypeConverter = new ObjectTypeConverter();
        indirectionTypeConverter.addConversionValue((Object)"no-indirection", (Object)"no-indirection");
        indirectionTypeConverter.addConversionValue((Object)"value-holder-indirection", (Object)"value-holder-indirection");
        indirectionTypeConverter.addConversionValue((Object)"transparentIndirection", (Object)"transparentIndirection");
        XMLDirectMapping indirectionTypeMapping = new XMLDirectMapping();
        indirectionTypeMapping.setAttributeName("indirectionType");
        indirectionTypeMapping.setXPath("indirection-type/text()");
        indirectionTypeMapping.setNullValue((Object)"no-indirection");
        indirectionTypeMapping.setConverter((Converter)indirectionTypeConverter);
        descriptor.addMapping((DatabaseMapping)indirectionTypeMapping);
        XMLDirectMapping batchReadingMapping = (XMLDirectMapping)descriptor.addDirectMapping("batchReading", "uses-batch-reading/text()");
        batchReadingMapping.setNullValue((Object)Boolean.FALSE);
        return descriptor;
    }

    public static XMLDescriptor legacy60BuildDescriptor() {
        XMLDescriptor descriptor = MWModel.legacy60BuildStandardDescriptor();
        descriptor.setJavaClass(MWRelationalDirectContainerMapping.class);
        descriptor.getInheritancePolicy().setParentClass(MWDirectContainerMapping.class);
        XMLCompositeObjectMapping targetTableHandleMapping = new XMLCompositeObjectMapping();
        targetTableHandleMapping.setAttributeName("targetTableHandle");
        targetTableHandleMapping.setGetMethodName("getTargetTableHandleForTopLink");
        targetTableHandleMapping.setSetMethodName("setTargetTableHandleForTopLink");
        targetTableHandleMapping.setReferenceClass(MWTableHandle.class);
        targetTableHandleMapping.setXPath("target-table-handle");
        descriptor.addMapping((DatabaseMapping)targetTableHandleMapping);
        XMLCompositeObjectMapping directValueColumnHandleMapping = new XMLCompositeObjectMapping();
        directValueColumnHandleMapping.setAttributeName("directValueColumnHandle");
        directValueColumnHandleMapping.setGetMethodName("getDirectValueColumnHandleForTopLink");
        directValueColumnHandleMapping.setSetMethodName("setDirectValueColumnHandleForTopLink");
        directValueColumnHandleMapping.setReferenceClass(MWColumnHandle.class);
        directValueColumnHandleMapping.setXPath("direct-value-column-handle");
        descriptor.addMapping((DatabaseMapping)directValueColumnHandleMapping);
        XMLCompositeObjectMapping referenceHandleMapping = new XMLCompositeObjectMapping();
        referenceHandleMapping.setAttributeName("referenceHandle");
        referenceHandleMapping.setGetMethodName("getReferenceHandleForTopLink");
        referenceHandleMapping.setSetMethodName("setReferenceHandleForTopLink");
        referenceHandleMapping.setReferenceClass(MWReferenceHandle.class);
        referenceHandleMapping.setXPath("reference-handle");
        descriptor.addMapping((DatabaseMapping)referenceHandleMapping);
        ObjectTypeConverter indirectionTypeConverter = new ObjectTypeConverter();
        indirectionTypeConverter.addConversionValue((Object)"no-indirection", (Object)"no-indirection");
        indirectionTypeConverter.addConversionValue((Object)"value-holder-indirection", (Object)"value-holder-indirection");
        indirectionTypeConverter.addConversionValue((Object)"transparentIndirection", (Object)"transparentIndirection");
        XMLDirectMapping indirectionTypeMapping = new XMLDirectMapping();
        indirectionTypeMapping.setAttributeName("indirectionType");
        indirectionTypeMapping.setXPath("indirection-type/text()");
        indirectionTypeMapping.setNullValue((Object)"no-indirection");
        indirectionTypeMapping.setConverter((Converter)indirectionTypeConverter);
        descriptor.addMapping((DatabaseMapping)indirectionTypeMapping);
        XMLDirectMapping batchReadingMapping = (XMLDirectMapping)descriptor.addDirectMapping("batchReading", "uses-batch-reading/text()");
        batchReadingMapping.setNullValue((Object)Boolean.FALSE);
        return descriptor;
    }

    protected void legacy60PostBuild(DescriptorEvent event) {
        super.legacy60PostBuild(event);
        this.joinFetchOption = (MWJoinFetchableMapping.JoinFetchOption)MWJoinFetchableMapping.JoinFetchOptionSet.joinFetchOptions().topLinkOptionForMWModelOption("NONE");
    }

    private MWTableHandle getTargetTableHandleForTopLink() {
        return this.targetTableHandle.getTable() == null ? null : this.targetTableHandle;
    }

    private void setTargetTableHandleForTopLink(MWTableHandle handle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildTargetTableScrubber();
        this.targetTableHandle = handle == null ? new MWTableHandle(this, scrubber) : handle.setScrubber(scrubber);
    }

    private MWColumnHandle getDirectValueColumnHandleForTopLink() {
        return this.directValueColumnHandle.getColumn() == null ? null : this.directValueColumnHandle;
    }

    private void setDirectValueColumnHandleForTopLink(MWColumnHandle handle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildDirectValueColumnScrubber();
        this.directValueColumnHandle = handle == null ? new MWColumnHandle(this, scrubber) : handle.setScrubber(scrubber);
    }

    private MWReferenceHandle getReferenceHandleForTopLink() {
        return this.referenceHandle.getReference() == null ? null : this.referenceHandle;
    }

    private void setReferenceHandleForTopLink(MWReferenceHandle handle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildReferenceScrubber();
        this.referenceHandle = handle == null ? new MWReferenceHandle(this, scrubber) : handle.setScrubber(scrubber);
    }

    public TopLinkOptionSet joinFetchOptions() {
        if (joinFetchOptions == null) {
            joinFetchOptions = MWJoinFetchableMapping.JoinFetchOptionSet.joinFetchOptions();
        }
        return joinFetchOptions;
    }

    static {
        COLUMN_NAME_MATCHER = new SimplePartialStringMatcher(PartialStringComparator.DEFAULT_COMPARATOR);
    }

    private static class ColumnPairAggregateRuntimeFieldNameGenerator
    implements AggregateRuntimeFieldNameGenerator {
        MWRelationalDirectContainerMapping mapping;
        private MWColumnPair columnPair;

        ColumnPairAggregateRuntimeFieldNameGenerator(MWRelationalDirectContainerMapping mapping, MWColumnPair columnPair) {
            this.mapping = mapping;
            this.columnPair = columnPair;
        }

        public boolean fieldIsWritten() {
            return false;
        }

        public String fieldNameForRuntime() {
            return this.columnPair.getTargetColumn().getName() + "_IN_REFERENCE_" + this.mapping.getReference().getName();
        }

        public AggregateFieldDescription fullFieldDescription() {
            final MWColumn column = this.columnPair.getTargetColumn();
            return new AggregateFieldDescription(){

                public String getMessageKey() {
                    return "AGGREGATE_FIELD_DESCRIPTION_FOR_REFERENCE";
                }

                public Object[] getMessageArguments() {
                    return new Object[]{column.getName(), ColumnPairAggregateRuntimeFieldNameGenerator.this.mapping.getReference().getName()};
                }
            };
        }

        public MWDescriptor owningDescriptor() {
            throw new UnsupportedOperationException();
        }
    }
}

