/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Map;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.expressions.BaseExpression;
import org.eclipse.persistence.internal.expressions.ExpressionIterator;
import org.eclipse.persistence.internal.expressions.ExpressionNormalizer;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.LogicalExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.expressions.RelationExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.queries.ExpressionQueryMechanism;
import org.eclipse.persistence.internal.queries.StatementQueryMechanism;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.SQLCall;

public class SubSelectExpression
extends BaseExpression {
    protected ReportQuery subQuery;

    public SubSelectExpression() {
    }

    public SubSelectExpression(ReportQuery query, Expression baseExpression) {
        super(baseExpression);
        this.subQuery = query;
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public String descriptionOfNodeType() {
        return "SubSelect";
    }

    public ReportQuery getSubQuery() {
        return this.subQuery;
    }

    public void iterateOn(ExpressionIterator iterator) {
        super.iterateOn(iterator);
        if (this.baseExpression != null) {
            this.baseExpression.iterateOn(iterator);
        }
        if (iterator.shouldIterateOverSubSelects()) {
            if (this.getSubQuery().getSelectionCriteria() != null) {
                this.getSubQuery().getSelectionCriteria().iterateOn(iterator);
            } else {
                this.getSubQuery().getExpressionBuilder().iterateOn(iterator);
            }
        }
    }

    public Expression normalize(ExpressionNormalizer normalizer) {
        this.validateNode();
        normalizer.addSubSelectExpression(this);
        normalizer.getStatement().setRequiresAliases(true);
        return this;
    }

    public Expression normalizeSubSelect(ExpressionNormalizer normalizer, Map clonedExpressions) {
        if (!this.getSubQuery().isCallQuery() && this.getSubQuery().getReferenceClass() == null) {
            Expression rightChild;
            ReportQuery subQuery = this.getSubQuery();
            Expression criteria = subQuery.getSelectionCriteria();
            if (criteria instanceof LogicalExpression) {
                criteria = ((LogicalExpression)criteria).getFirstChild();
            }
            if (criteria instanceof RelationExpression && (rightChild = ((RelationExpression)criteria).getSecondChild()) instanceof QueryKeyExpression) {
                subQuery.setReferenceClass(((QueryKeyExpression)rightChild).getDescriptor().getJavaClass());
            }
        }
        this.validateNode();
        this.getSubQuery().prepareSubSelect(normalizer.getSession(), null, clonedExpressions);
        if (!this.getSubQuery().isCallQuery()) {
            SQLSelectStatement statement = (SQLSelectStatement)((StatementQueryMechanism)this.getSubQuery().getQueryMechanism()).getSQLStatement();
            statement.setRequiresAliases(true);
            statement.setParentStatement(normalizer.getStatement());
            statement.normalize(normalizer.getSession(), this.getSubQuery().getDescriptor(), clonedExpressions);
        }
        return this;
    }

    protected void postCopyIn(Map alreadyDone) {
        super.postCopyIn(alreadyDone);
        ReportQuery clonedQuery = (ReportQuery)this.getSubQuery().clone();
        if (!clonedQuery.isCallQuery()) {
            if (clonedQuery.getSelectionCriteria() != null) {
                clonedQuery.setSelectionCriteria(this.getSubQuery().getSelectionCriteria().copiedVersionFrom(alreadyDone));
                if (clonedQuery.getExpressionBuilder() != null) {
                    clonedQuery.setExpressionBuilder((ExpressionBuilder)clonedQuery.getExpressionBuilder().copiedVersionFrom(alreadyDone));
                }
            } else if (clonedQuery.getExpressionBuilder() != null) {
                clonedQuery.setExpressionBuilder((ExpressionBuilder)clonedQuery.getExpressionBuilder().copiedVersionFrom(alreadyDone));
            }
            clonedQuery.copyReportItems(alreadyDone);
        }
        this.setSubQuery(clonedQuery);
    }

    protected void printCustomSQL(ExpressionSQLPrinter printer) {
        SQLCall call = (SQLCall)this.getSubQuery().getCall();
        call.translateCustomQuery();
        printer.getCall().getParameters().addAll(call.getParameters());
        printer.getCall().getParameterTypes().addAll(call.getParameterTypes());
        printer.printString(call.getCallString());
    }

    public void printSQL(ExpressionSQLPrinter printer) {
        ReportQuery query = this.getSubQuery();
        printer.printString("(");
        if (query.isCallQuery()) {
            this.printCustomSQL(printer);
        } else {
            SQLSelectStatement statement = (SQLSelectStatement)((ExpressionQueryMechanism)query.getQueryMechanism()).getSQLStatement();
            boolean isFirstElementPrinted = printer.isFirstElementPrinted();
            printer.setIsFirstElementPrinted(false);
            boolean requiresDistinct = printer.requiresDistinct();
            statement.printSQL(printer);
            printer.setIsFirstElementPrinted(isFirstElementPrinted);
            printer.setRequiresDistinct(requiresDistinct);
        }
        printer.printString(")");
    }

    public Expression rebuildOn(Expression newBase) {
        return this;
    }

    public void resetPlaceHolderBuilder(ExpressionBuilder queryBuilder) {
        if (this.baseExpression.isExpressionBuilder() && ((ExpressionBuilder)this.baseExpression).wasQueryClassSetInternally()) {
            this.baseExpression = queryBuilder;
            if (this.builder != null) {
                this.builder = queryBuilder;
            }
        } else {
            this.baseExpression.resetPlaceHolderBuilder(queryBuilder);
        }
    }

    public void setSubQuery(ReportQuery subQuery) {
        this.subQuery = subQuery;
    }

    public void writeDescriptionOn(BufferedWriter writer) throws IOException {
        writer.write(String.valueOf(this.getSubQuery()));
    }

    public void writeSubexpressionsTo(BufferedWriter writer, int indent) throws IOException {
        if (this.getSubQuery().getSelectionCriteria() != null) {
            this.getSubQuery().getSelectionCriteria().toString(writer, indent);
        }
    }
}

