/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.inheritance;

import javax.persistence.InheritanceType;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.descriptors.TablePerClassPolicy;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.MappedSuperclassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;

public class InheritanceMetadata
extends ORMetadata {
    private String m_strategy;

    public InheritanceMetadata() {
        super("<inheritance>");
    }

    public InheritanceMetadata(MetadataAnnotation inheritance, MetadataAccessibleObject accessibleObject) {
        super(inheritance, accessibleObject);
        if (inheritance != null) {
            this.m_strategy = (String)inheritance.getAttribute("strategy");
        }
    }

    protected void addClassExtractor(MetadataDescriptor descriptor, EntityAccessor accessor) {
        descriptor.getClassDescriptor().getInheritancePolicy().setClassExtractorName(accessor.processClassExtractor());
    }

    protected void addClassIndicator(MetadataDescriptor descriptor, EntityAccessor accessor) {
        if (descriptor.isInheritanceSubclass()) {
            this.addClassIndicator(descriptor.getInheritanceRootDescriptor(), accessor);
        } else {
            String discriminatorValue = accessor.processDiscriminatorValue();
            if (discriminatorValue != null) {
                if (descriptor.getClassDescriptor().getInheritancePolicy().getClassIndicatorField().getType() == Integer.class) {
                    try {
                        descriptor.getClassDescriptor().getInheritancePolicy().addClassNameIndicator(accessor.getJavaClassName(), Integer.valueOf(discriminatorValue));
                    }
                    catch (NumberFormatException exc) {
                        accessor.getLogger().logWarningMessage("metadata_warning_integer_discriminator_could_not_be_built", accessor.getJavaClassName(), discriminatorValue);
                    }
                } else {
                    descriptor.getClassDescriptor().getInheritancePolicy().addClassNameIndicator(accessor.getJavaClassName(), discriminatorValue);
                }
            }
        }
    }

    protected void addClassIndicatorField(MetadataDescriptor descriptor, EntityAccessor accessor) {
        descriptor.getClassDescriptor().getInheritancePolicy().setClassIndicatorField(accessor.processDiscriminatorColumn());
    }

    public void addTablePerClassParentMappings(MetadataDescriptor startingDescriptor, MetadataDescriptor realDescriptor) {
        EntityAccessor reloadedParentEntity = null;
        MetadataDescriptor realParentDescriptor = null;
        if (realDescriptor.isInheritanceSubclass() && realDescriptor.getInheritanceRootDescriptor().usesTablePerClassInheritanceStrategy()) {
            realParentDescriptor = realDescriptor.getInheritanceParentDescriptor();
            reloadedParentEntity = this.reloadEntity((EntityAccessor)realParentDescriptor.getClassAccessor(), startingDescriptor);
            this.addTablePerClassParentMappings(startingDescriptor, realParentDescriptor);
        }
        if (reloadedParentEntity != null) {
            EntityAccessor realParentEntityAccessor = (EntityAccessor)realParentDescriptor.getClassAccessor();
            for (MappedSuperclassAccessor mappedSuperclass : realParentEntityAccessor.getMappedSuperclasses()) {
                this.reloadMappedSuperclass(mappedSuperclass, startingDescriptor).addAccessors();
            }
            reloadedParentEntity.addAccessors();
        }
    }

    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof InheritanceMetadata) {
            return this.valuesMatch(this.m_strategy, ((InheritanceMetadata)objectToCompare).getStrategy());
        }
        return false;
    }

    public String getStrategy() {
        return this.m_strategy;
    }

    public void process(MetadataDescriptor descriptor) {
        EntityAccessor accessor = (EntityAccessor)descriptor.getClassAccessor();
        if (this.m_strategy != null && this.m_strategy.equals(InheritanceType.TABLE_PER_CLASS.name())) {
            this.setTablePerClassInheritancePolicy(descriptor);
        } else {
            this.setInheritancePolicy(descriptor);
        }
        if (descriptor.isInheritanceSubclass()) {
            MetadataDescriptor rootDescriptor = descriptor.getInheritanceRootDescriptor();
            EntityAccessor rootAccessor = (EntityAccessor)rootDescriptor.getClassAccessor();
            if (rootDescriptor.usesTablePerClassInheritanceStrategy()) {
                MetadataDescriptor parentDescriptor = descriptor.getInheritanceParentDescriptor();
                descriptor.getClassDescriptor().getTablePerClassPolicy().addParentDescriptor(parentDescriptor.getClassDescriptor());
                parentDescriptor.getClassDescriptor().getTablePerClassPolicy().addChildDescriptor(descriptor.getClassDescriptor());
            } else {
                descriptor.getClassDescriptor().getInheritancePolicy().setParentClassName(descriptor.getInheritanceParentDescriptor().getJavaClassName());
            }
            if (accessor.hasInheritance() && !this.equals(rootAccessor.getInheritance())) {
                this.processInheritanceRoot(descriptor, accessor);
            } else {
                this.processInheritanceSubclass(descriptor, accessor, rootAccessor);
            }
            if (rootDescriptor.hasCompositePrimaryKey()) {
                descriptor.setPKClass(rootDescriptor.getPKClass());
            }
        } else {
            this.processInheritanceRoot(descriptor, accessor);
        }
    }

    protected void processInheritanceRoot(MetadataDescriptor descriptor, EntityAccessor accessor) {
        if (descriptor.isInheritanceSubclass()) {
            if (descriptor.getInheritanceRootDescriptor().usesTablePerClassInheritanceStrategy()) {
                this.addTablePerClassParentMappings(descriptor, descriptor);
            } else {
                accessor.processInheritancePrimaryKeyJoinColumns();
            }
        }
        if (!this.usesTablePerClassStrategy()) {
            if (accessor.hasClassExtractor()) {
                this.addClassExtractor(descriptor, accessor);
            } else {
                this.addClassIndicatorField(descriptor, accessor);
                this.addClassIndicator(descriptor, accessor);
            }
        }
    }

    protected void processInheritanceSubclass(MetadataDescriptor descriptor, EntityAccessor accessor, EntityAccessor rootAccessor) {
        if (this.usesTablePerClassStrategy()) {
            this.addTablePerClassParentMappings(descriptor, descriptor);
        } else {
            if (!rootAccessor.hasClassExtractor()) {
                this.addClassIndicator(rootAccessor.getDescriptor(), accessor);
            }
            if (rootAccessor.getInheritance().usesJoinedStrategy()) {
                accessor.processInheritancePrimaryKeyJoinColumns();
            }
        }
    }

    protected void setInheritancePolicy(MetadataDescriptor descriptor) {
        if (this.m_strategy != null || !descriptor.isInheritanceSubclass()) {
            // empty if block
        }
        descriptor.getClassDescriptor().setInheritancePolicy(new InheritancePolicy(descriptor.getClassDescriptor()));
    }

    public void setStrategy(String strategy) {
        this.m_strategy = strategy;
    }

    protected void setTablePerClassInheritancePolicy(MetadataDescriptor descriptor) {
        descriptor.getClassDescriptor().setTablePerClassPolicy(new TablePerClassPolicy(descriptor.getClassDescriptor()));
    }

    public boolean usesJoinedStrategy() {
        return this.m_strategy != null && this.m_strategy.equals(InheritanceType.JOINED.name());
    }

    public boolean usesSingleTableStrategy() {
        return this.m_strategy == null || this.m_strategy.equals(InheritanceType.SINGLE_TABLE.name());
    }

    public boolean usesTablePerClassStrategy() {
        return this.m_strategy != null && this.m_strategy.equals(InheritanceType.TABLE_PER_CLASS.name());
    }
}

