/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.querydef;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.persistence.Tuple;
import javax.persistence.criteria.CompoundSelection;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.Type;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionMath;
import org.eclipse.persistence.internal.expressions.ArgumentListFunctionExpression;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.expressions.SubSelectExpression;
import org.eclipse.persistence.internal.helper.BasicTypeHelperImpl;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jpa.metamodel.MetamodelImpl;
import org.eclipse.persistence.internal.jpa.metamodel.TypeImpl;
import org.eclipse.persistence.internal.jpa.querydef.AbstractQueryImpl;
import org.eclipse.persistence.internal.jpa.querydef.CompoundExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.CompoundSelectionImpl;
import org.eclipse.persistence.internal.jpa.querydef.ConstructorSelectionImpl;
import org.eclipse.persistence.internal.jpa.querydef.CriteriaQueryImpl;
import org.eclipse.persistence.internal.jpa.querydef.ExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.FromImpl;
import org.eclipse.persistence.internal.jpa.querydef.FunctionExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.InImpl;
import org.eclipse.persistence.internal.jpa.querydef.InternalExpression;
import org.eclipse.persistence.internal.jpa.querydef.InternalSelection;
import org.eclipse.persistence.internal.jpa.querydef.OrderImpl;
import org.eclipse.persistence.internal.jpa.querydef.ParameterExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.PredicateImpl;
import org.eclipse.persistence.internal.jpa.querydef.SubQueryImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.queries.ReportQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CriteriaBuilderImpl
implements CriteriaBuilder,
Serializable {
    public static final String CONCAT = "concat";
    public static final String SIZE = "size";
    protected Metamodel metamodel;

    public CriteriaBuilderImpl(Metamodel metamodel) {
        this.metamodel = metamodel;
    }

    @Override
    public CriteriaQuery<Object> createQuery() {
        return new CriteriaQueryImpl<Object>(this.metamodel, AbstractQueryImpl.ResultType.UNKNOWN, ClassConstants.OBJECT, this);
    }

    @Override
    public <T> CriteriaQuery<T> createQuery(Class<T> resultClass) {
        if (resultClass == null) {
            return this.createQuery();
        }
        if (resultClass.equals(Tuple.class)) {
            return new CriteriaQueryImpl(this.metamodel, AbstractQueryImpl.ResultType.TUPLE, resultClass, this);
        }
        if (resultClass.equals(ClassConstants.AOBJECT)) {
            return new CriteriaQueryImpl(this.metamodel, AbstractQueryImpl.ResultType.OBJECT_ARRAY, resultClass, this);
        }
        if (resultClass.isArray()) {
            return new CriteriaQueryImpl(this.metamodel, AbstractQueryImpl.ResultType.OBJECT_ARRAY, resultClass, this);
        }
        if (resultClass.equals(ClassConstants.OBJECT)) {
            return this.createQuery();
        }
        if (resultClass.isPrimitive() || resultClass.equals(ClassConstants.STRING) || BasicTypeHelperImpl.getInstance().isWrapperClass(resultClass) || BasicTypeHelperImpl.getInstance().isDateClass(resultClass)) {
            return new CriteriaQueryImpl(this.metamodel, AbstractQueryImpl.ResultType.OTHER, resultClass, this);
        }
        TypeImpl<T> type = ((MetamodelImpl)this.metamodel).getType(resultClass);
        if (type != null && type.getPersistenceType().equals((Object)Type.PersistenceType.ENTITY)) {
            return new CriteriaQueryImpl(this.metamodel, AbstractQueryImpl.ResultType.ENTITY, resultClass, this);
        }
        return new CriteriaQueryImpl(this.metamodel, AbstractQueryImpl.ResultType.CONSTRUCTOR, resultClass, this);
    }

    @Override
    public CriteriaQuery<Tuple> createTupleQuery() {
        return new CriteriaQueryImpl<Tuple>(this.metamodel, AbstractQueryImpl.ResultType.TUPLE, Tuple.class, this);
    }

    @Override
    public <Y> CompoundSelection<Y> construct(Class<Y> result, Selection<?> ... selections) {
        return new ConstructorSelectionImpl(result, selections);
    }

    @Override
    public CompoundSelection<Tuple> tuple(Selection<?> ... selections) {
        return new CompoundSelectionImpl(Tuple.class, selections);
    }

    @Override
    public CompoundSelection<Object[]> array(Selection<?> ... selections) {
        return new CompoundSelectionImpl(ClassConstants.AOBJECT, selections);
    }

    @Override
    public Order asc(javax.persistence.criteria.Expression<?> x) {
        if (((InternalSelection)((Object)x)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new OrderImpl(x);
    }

    @Override
    public Order desc(javax.persistence.criteria.Expression<?> x) {
        if (((InternalSelection)((Object)x)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        OrderImpl order = new OrderImpl(x, false);
        return order;
    }

    @Override
    public <N extends Number> javax.persistence.criteria.Expression<Double> avg(javax.persistence.criteria.Expression<N> x) {
        return new FunctionExpressionImpl<Double>(this.metamodel, ClassConstants.DOUBLE, ((InternalSelection)((Object)x)).getCurrentNode().average(), this.buildList(x), "AVG");
    }

    @Override
    public <N extends Number> javax.persistence.criteria.Expression<N> sum(javax.persistence.criteria.Expression<N> x) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ((InternalSelection)((Object)x)).getCurrentNode().sum(), this.buildList(x), "SUM");
    }

    @Override
    public <N extends Number> javax.persistence.criteria.Expression<N> max(javax.persistence.criteria.Expression<N> x) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ((InternalSelection)((Object)x)).getCurrentNode().maximum(), this.buildList(x), "MAX");
    }

    @Override
    public <N extends Number> javax.persistence.criteria.Expression<N> min(javax.persistence.criteria.Expression<N> x) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ((InternalSelection)((Object)x)).getCurrentNode().minimum(), this.buildList(x), "MIN");
    }

    @Override
    public <X extends Comparable<? super X>> javax.persistence.criteria.Expression<X> greatest(javax.persistence.criteria.Expression<X> x) {
        if (((InternalSelection)((Object)x)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new ExpressionImpl(this.metamodel, x.getJavaType(), ((InternalSelection)((Object)x)).getCurrentNode().maximum());
    }

    @Override
    public <X extends Comparable<? super X>> javax.persistence.criteria.Expression<X> least(javax.persistence.criteria.Expression<X> x) {
        if (((InternalSelection)((Object)x)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new ExpressionImpl(this.metamodel, x.getJavaType(), ((InternalSelection)((Object)x)).getCurrentNode().minimum());
    }

    @Override
    public javax.persistence.criteria.Expression<Long> count(javax.persistence.criteria.Expression<?> x) {
        if (((InternalSelection)((Object)x)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new FunctionExpressionImpl<Long>(this.metamodel, ClassConstants.LONG, ((InternalSelection)((Object)x)).getCurrentNode().count(), this.buildList(x), "COUNT");
    }

    @Override
    public javax.persistence.criteria.Expression<Long> countDistinct(javax.persistence.criteria.Expression<?> x) {
        if (((InternalSelection)((Object)x)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new FunctionExpressionImpl<Long>(this.metamodel, ClassConstants.LONG, ((InternalSelection)((Object)x)).getCurrentNode().distinct().count(), this.buildList(x), "COUNT");
    }

    @Override
    public Predicate exists(Subquery<?> subquery) {
        return new CompoundExpressionImpl(this.metamodel, new ExpressionBuilder().exists(((SubQueryImpl)subquery).subQuery), this.buildList(subquery), "exists");
    }

    @Override
    public <Y> javax.persistence.criteria.Expression<Y> all(Subquery<Y> subquery) {
        return new FunctionExpressionImpl(this.metamodel, subquery.getJavaType(), new ExpressionBuilder().all(((InternalSelection)((Object)subquery)).getCurrentNode()), this.buildList(subquery), "all");
    }

    @Override
    public <Y> javax.persistence.criteria.Expression<Y> some(Subquery<Y> subquery) {
        return new FunctionExpressionImpl(this.metamodel, subquery.getJavaType(), new ExpressionBuilder().some(((InternalSelection)((Object)subquery)).getCurrentNode()), this.buildList(subquery), "some");
    }

    @Override
    public <Y> javax.persistence.criteria.Expression<Y> any(Subquery<Y> subquery) {
        return new FunctionExpressionImpl(this.metamodel, subquery.getJavaType(), new ExpressionBuilder().any(((InternalSelection)((Object)subquery)).getCurrentNode()), this.buildList(subquery), "any");
    }

    @Override
    public Predicate and(javax.persistence.criteria.Expression<Boolean> x, javax.persistence.criteria.Expression<Boolean> y) {
        CompoundExpressionImpl xp = null;
        CompoundExpressionImpl yp = null;
        xp = ((InternalExpression)((Object)x)).isExpression() ? (CompoundExpressionImpl)this.isTrue(x) : (CompoundExpressionImpl)x;
        yp = ((InternalExpression)((Object)y)).isExpression() ? (CompoundExpressionImpl)this.isTrue(y) : (CompoundExpressionImpl)y;
        if (yp.isPredicate() && yp.expressions.isEmpty()) {
            if (yp.isNegated()) {
                return yp;
            }
            return xp;
        }
        if (xp.isPredicate() && xp.expressions.isEmpty()) {
            if (xp.isNegated()) {
                return xp;
            }
            return yp;
        }
        Expression currentNode = xp.getCurrentNode().and(yp.getCurrentNode());
        xp.setParentNode(currentNode);
        yp.setParentNode(currentNode);
        return new PredicateImpl(this.metamodel, currentNode, this.buildList(xp, yp), Predicate.BooleanOperator.AND);
    }

    @Override
    public Predicate or(javax.persistence.criteria.Expression<Boolean> x, javax.persistence.criteria.Expression<Boolean> y) {
        CompoundExpressionImpl xp = null;
        CompoundExpressionImpl yp = null;
        xp = ((InternalExpression)((Object)x)).isExpression() ? (CompoundExpressionImpl)this.isTrue(x) : (CompoundExpressionImpl)x;
        yp = ((InternalExpression)((Object)y)).isExpression() ? (CompoundExpressionImpl)this.isTrue(y) : (CompoundExpressionImpl)y;
        if (yp.isPredicate() && yp.expressions.isEmpty() && yp.isNegated()) {
            return xp;
        }
        if (xp.isPredicate() && xp.expressions.isEmpty() && xp.isNegated()) {
            return yp;
        }
        Expression parentNode = xp.getCurrentNode().or(yp.getCurrentNode());
        xp.setParentNode(parentNode);
        yp.setParentNode(parentNode);
        return new PredicateImpl(this.metamodel, parentNode, this.buildList(xp, yp), Predicate.BooleanOperator.OR);
    }

    @Override
    public Predicate and(Predicate ... restrictions) {
        int max = restrictions.length;
        if (max == 0) {
            return this.conjunction();
        }
        Predicate a = restrictions[0];
        for (int i = 1; i < max; ++i) {
            a = this.and((javax.persistence.criteria.Expression<Boolean>)a, (javax.persistence.criteria.Expression<Boolean>)restrictions[i]);
        }
        return a;
    }

    @Override
    public Predicate or(Predicate ... restrictions) {
        int max = restrictions.length;
        if (max == 0) {
            return this.disjunction();
        }
        Predicate a = restrictions[0];
        for (int i = 1; i < max; ++i) {
            a = this.or((javax.persistence.criteria.Expression<Boolean>)a, (javax.persistence.criteria.Expression<Boolean>)restrictions[i]);
        }
        return a;
    }

    @Override
    public Predicate not(javax.persistence.criteria.Expression<Boolean> restriction) {
        if (((InternalExpression)((Object)restriction)).isPredicate()) {
            return ((PredicateImpl)restriction).not();
        }
        Expression parentNode = null;
        String name = "not";
        if (((InternalExpression)((Object)restriction)).isCompoundExpression() && ((CompoundExpressionImpl)restriction).getOperation().equals("exists")) {
            FunctionExpression exp = (FunctionExpression)((InternalSelection)((Object)restriction)).getCurrentNode();
            SubSelectExpression sub = (SubSelectExpression)exp.getChildren().get(0);
            parentNode = new ExpressionBuilder().notExists(sub.getSubQuery());
            name = "notExists";
        } else {
            parentNode = ((InternalSelection)((Object)restriction)).getCurrentNode().not();
        }
        if (((InternalExpression)((Object)restriction)).isCompoundExpression()) {
            ((CompoundExpressionImpl)restriction).setParentNode(parentNode);
        }
        return new CompoundExpressionImpl(this.metamodel, parentNode, this.buildList(restriction), name);
    }

    @Override
    public Predicate conjunction() {
        return new PredicateImpl(this.metamodel, null, null, Predicate.BooleanOperator.AND);
    }

    @Override
    public Predicate disjunction() {
        return new PredicateImpl(this.metamodel, null, null, Predicate.BooleanOperator.OR);
    }

    @Override
    public Predicate isTrue(javax.persistence.criteria.Expression<Boolean> x) {
        if (((InternalExpression)((Object)x)).isPredicate()) {
            if (((InternalSelection)((Object)x)).getCurrentNode() == null) {
                return (Predicate)x;
            }
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("PREDICATE_PASSED_TO_EVALUATION"));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().equal(true), list, "equals");
    }

    @Override
    public Predicate isFalse(javax.persistence.criteria.Expression<Boolean> x) {
        if (((InternalExpression)((Object)x)).isPredicate()) {
            if (((InternalSelection)((Object)x)).getCurrentNode() == null) {
                if (((Predicate)x).getOperator() == Predicate.BooleanOperator.AND) {
                    return (Predicate)x;
                }
                return this.conjunction();
            }
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("PREDICATE_PASSED_TO_EVALUATION"));
        }
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().equal(false), this.buildList(x), "equals");
    }

    @Override
    public Predicate isNull(javax.persistence.criteria.Expression<?> x) {
        if (((InternalSelection)((Object)x)).isFrom()) {
            ((FromImpl)x).isLeaf = false;
        }
        return new PredicateImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().isNull(), new ArrayList(), Predicate.BooleanOperator.AND);
    }

    @Override
    public Predicate isNotNull(javax.persistence.criteria.Expression<?> x) {
        if (((InternalSelection)((Object)x)).isFrom()) {
            ((FromImpl)x).isLeaf = false;
        }
        return new PredicateImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().notNull(), new ArrayList(), Predicate.BooleanOperator.AND);
    }

    @Override
    public Predicate equal(javax.persistence.criteria.Expression<?> x, javax.persistence.criteria.Expression<?> y) {
        if (((InternalSelection)((Object)x)).isFrom()) {
            ((FromImpl)x).isLeaf = false;
        }
        if (((InternalSelection)((Object)y)).isFrom()) {
            ((FromImpl)y).isLeaf = false;
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(y);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().equal(((InternalSelection)((Object)y)).getCurrentNode()), list, "equals");
    }

    @Override
    public Predicate notEqual(javax.persistence.criteria.Expression<?> x, javax.persistence.criteria.Expression<?> y) {
        if (((InternalSelection)((Object)x)).getCurrentNode() == null || ((InternalSelection)((Object)y)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(y);
        if (((InternalSelection)((Object)x)).isFrom()) {
            ((FromImpl)x).isLeaf = false;
        }
        if (((InternalSelection)((Object)y)).isFrom()) {
            ((FromImpl)y).isLeaf = false;
        }
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().notEqual(((InternalSelection)((Object)y)).getCurrentNode()), list, "not equal");
    }

    @Override
    public Predicate equal(javax.persistence.criteria.Expression<?> x, Object y) {
        if (((InternalSelection)((Object)x)).isFrom()) {
            ((FromImpl)x).isLeaf = false;
        }
        if (((InternalSelection)((Object)x)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        if (y instanceof javax.persistence.criteria.ParameterExpression) {
            return this.equal(x, (javax.persistence.criteria.Expression<?>)((javax.persistence.criteria.ParameterExpression)y));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(this.literal(y));
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().equal(y), list, "equal");
    }

    @Override
    public Predicate notEqual(javax.persistence.criteria.Expression<?> x, Object y) {
        if (((InternalSelection)((Object)x)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        if (y instanceof javax.persistence.criteria.ParameterExpression) {
            return this.notEqual(x, (javax.persistence.criteria.Expression<?>)((javax.persistence.criteria.ParameterExpression)y));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(this.literal(y));
        if (((InternalSelection)((Object)x)).isFrom()) {
            ((FromImpl)x).isLeaf = false;
        }
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().notEqual(y), list, "not equal");
    }

    @Override
    public <Y extends Comparable<? super Y>> Predicate greaterThan(javax.persistence.criteria.Expression<? extends Y> x, javax.persistence.criteria.Expression<? extends Y> y) {
        if (((InternalSelection)((Object)x)).getCurrentNode() == null || ((InternalSelection)((Object)y)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(y);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().greaterThan(((InternalSelection)((Object)y)).getCurrentNode()), list, "greaterThan");
    }

    @Override
    public <Y extends Comparable<? super Y>> Predicate lessThan(javax.persistence.criteria.Expression<? extends Y> x, javax.persistence.criteria.Expression<? extends Y> y) {
        if (((InternalSelection)((Object)x)).getCurrentNode() == null || ((InternalSelection)((Object)y)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().lessThan(((InternalSelection)((Object)y)).getCurrentNode()), this.buildList(x, y), "lessThan");
    }

    @Override
    public <Y extends Comparable<? super Y>> Predicate greaterThanOrEqualTo(javax.persistence.criteria.Expression<? extends Y> x, javax.persistence.criteria.Expression<? extends Y> y) {
        if (((ExpressionImpl)x).getCurrentNode() == null || ((ExpressionImpl)y).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(y);
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)x).getCurrentNode().greaterThanEqual(((ExpressionImpl)y).getCurrentNode()), list, "greaterThanEqual");
    }

    @Override
    public <Y extends Comparable<? super Y>> Predicate lessThanOrEqualTo(javax.persistence.criteria.Expression<? extends Y> x, javax.persistence.criteria.Expression<? extends Y> y) {
        if (((ExpressionImpl)x).getCurrentNode() == null || ((ExpressionImpl)y).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(y);
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)x).getCurrentNode().lessThanEqual(((ExpressionImpl)y).getCurrentNode()), list, "lessThanEqual");
    }

    @Override
    public <Y extends Comparable<? super Y>> Predicate between(javax.persistence.criteria.Expression<? extends Y> v, javax.persistence.criteria.Expression<? extends Y> x, javax.persistence.criteria.Expression<? extends Y> y) {
        ArrayList list = new ArrayList();
        list.add(v);
        list.add(x);
        list.add(y);
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)v).getCurrentNode().between(((ExpressionImpl)x).getCurrentNode(), ((ExpressionImpl)y).getCurrentNode()), list, "between");
    }

    @Override
    public <Y extends Comparable<? super Y>> Predicate greaterThan(javax.persistence.criteria.Expression<? extends Y> x, Y y) {
        javax.persistence.criteria.Expression<Y> expressionY = this.literal(y);
        if (((ExpressionImpl)x).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(this.literal(y));
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)x).getCurrentNode().greaterThan(((ExpressionImpl)expressionY).getCurrentNode()), list, "greaterThan");
    }

    @Override
    public <Y extends Comparable<? super Y>> Predicate lessThan(javax.persistence.criteria.Expression<? extends Y> x, Y y) {
        javax.persistence.criteria.Expression<Y> expressionY = this.literal(y);
        if (((ExpressionImpl)x).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(this.literal(y));
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)x).getCurrentNode().lessThan(((ExpressionImpl)expressionY).getCurrentNode()), list, "lessThan");
    }

    @Override
    public <Y extends Comparable<? super Y>> Predicate greaterThanOrEqualTo(javax.persistence.criteria.Expression<? extends Y> x, Y y) {
        javax.persistence.criteria.Expression<Y> expressionY = this.literal(y);
        if (((ExpressionImpl)x).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(this.literal(y));
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)x).getCurrentNode().greaterThanEqual(((ExpressionImpl)expressionY).getCurrentNode()), list, "greaterThanEqual");
    }

    @Override
    public <Y extends Comparable<? super Y>> Predicate lessThanOrEqualTo(javax.persistence.criteria.Expression<? extends Y> x, Y y) {
        javax.persistence.criteria.Expression<Y> expressionY = this.literal(y);
        if (((ExpressionImpl)x).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(this.literal(y));
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)x).getCurrentNode().lessThanEqual(((ExpressionImpl)expressionY).getCurrentNode()), list, "lessThanEqual");
    }

    @Override
    public <Y extends Comparable<? super Y>> Predicate between(javax.persistence.criteria.Expression<? extends Y> v, Y x, Y y) {
        ArrayList list = new ArrayList();
        list.add(v);
        list.add(this.literal(x));
        list.add(this.literal(y));
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)v).getCurrentNode().between(x, y), list, "between");
    }

    protected List<javax.persistence.criteria.Expression<?>> buildList(javax.persistence.criteria.Expression<?> ... expressions) {
        ArrayList list = new ArrayList();
        for (javax.persistence.criteria.Expression<?> exp : expressions) {
            list.add(exp);
        }
        return list;
    }

    @Override
    public Predicate gt(javax.persistence.criteria.Expression<? extends Number> x, javax.persistence.criteria.Expression<? extends Number> y) {
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(y);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().greaterThan(((InternalSelection)((Object)y)).getCurrentNode()), list, "gt");
    }

    @Override
    public Predicate lt(javax.persistence.criteria.Expression<? extends Number> x, javax.persistence.criteria.Expression<? extends Number> y) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().lessThan(((InternalSelection)((Object)y)).getCurrentNode()), this.buildList(x, y), "lessThan");
    }

    @Override
    public Predicate ge(javax.persistence.criteria.Expression<? extends Number> x, javax.persistence.criteria.Expression<? extends Number> y) {
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(y);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().greaterThanEqual(((InternalSelection)((Object)y)).getCurrentNode()), list, "ge");
    }

    @Override
    public Predicate le(javax.persistence.criteria.Expression<? extends Number> x, javax.persistence.criteria.Expression<? extends Number> y) {
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(y);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().lessThanEqual(((InternalSelection)((Object)y)).getCurrentNode()), list, "le");
    }

    @Override
    public Predicate gt(javax.persistence.criteria.Expression<? extends Number> x, Number y) {
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(this.literal(y));
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().greaterThan(y), list, "gt");
    }

    @Override
    public Predicate lt(javax.persistence.criteria.Expression<? extends Number> x, Number y) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().lessThan(y), this.buildList(x, this.literal(y)), "lt");
    }

    @Override
    public Predicate ge(javax.persistence.criteria.Expression<? extends Number> x, Number y) {
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(this.literal(y));
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().greaterThanEqual(y), list, "ge");
    }

    @Override
    public Predicate le(javax.persistence.criteria.Expression<? extends Number> x, Number y) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().lessThanEqual(y), this.buildList(x, this.literal(y)), "le");
    }

    @Override
    public <N extends Number> javax.persistence.criteria.Expression<N> neg(javax.persistence.criteria.Expression<N> x) {
        return new FunctionExpressionImpl(this.metamodel, ClassConstants.INTEGER, ExpressionMath.negate(((InternalSelection)((Object)x)).getCurrentNode()), this.buildList(x), "neg");
    }

    @Override
    public <N extends Number> javax.persistence.criteria.Expression<N> abs(javax.persistence.criteria.Expression<N> x) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ExpressionMath.abs(((InternalSelection)((Object)x)).getCurrentNode()), this.buildList(x), "ABS");
    }

    @Override
    public <N extends Number> javax.persistence.criteria.Expression<N> sum(javax.persistence.criteria.Expression<? extends N> x, javax.persistence.criteria.Expression<? extends N> y) {
        return new FunctionExpressionImpl(this.metamodel, (Class)BasicTypeHelperImpl.getInstance().extendedBinaryNumericPromotion(x.getJavaType(), y.getJavaType()), ExpressionMath.add(((InternalSelection)((Object)x)).getCurrentNode(), ((InternalSelection)((Object)y)).getCurrentNode()), this.buildList(x, y), "sum");
    }

    @Override
    public javax.persistence.criteria.Expression<Long> sumAsLong(javax.persistence.criteria.Expression<Integer> x) {
        return new FunctionExpressionImpl<Long>(this.metamodel, ClassConstants.LONG, ((InternalSelection)((Object)x)).getCurrentNode().sum(), this.buildList(x), "SUM");
    }

    @Override
    public javax.persistence.criteria.Expression<Double> sumAsDouble(javax.persistence.criteria.Expression<Float> x) {
        return new FunctionExpressionImpl<Double>(this.metamodel, ClassConstants.DOUBLE, ((InternalSelection)((Object)x)).getCurrentNode().sum(), this.buildList(x), "SUM");
    }

    @Override
    public <N extends Number> javax.persistence.criteria.Expression<N> prod(javax.persistence.criteria.Expression<? extends N> x, javax.persistence.criteria.Expression<? extends N> y) {
        return new FunctionExpressionImpl(this.metamodel, (Class)BasicTypeHelperImpl.getInstance().extendedBinaryNumericPromotion(x.getJavaType(), y.getJavaType()), ExpressionMath.multiply(((InternalSelection)((Object)x)).getCurrentNode(), ((InternalSelection)((Object)y)).getCurrentNode()), this.buildList(x, y), "prod");
    }

    @Override
    public <N extends Number> javax.persistence.criteria.Expression<N> diff(javax.persistence.criteria.Expression<? extends N> x, javax.persistence.criteria.Expression<? extends N> y) {
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(y);
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ExpressionMath.subtract(((InternalSelection)((Object)x)).getCurrentNode(), ((InternalSelection)((Object)y)).getCurrentNode()), list, "diff");
    }

    @Override
    public <N extends Number> javax.persistence.criteria.Expression<N> sum(javax.persistence.criteria.Expression<? extends N> x, N y) {
        return new FunctionExpressionImpl(this.metamodel, (Class)BasicTypeHelperImpl.getInstance().extendedBinaryNumericPromotion(x.getJavaType(), y.getClass()), ExpressionMath.add(((InternalSelection)((Object)x)).getCurrentNode(), y), this.buildList(x, this.literal(y)), "sum");
    }

    @Override
    public <N extends Number> javax.persistence.criteria.Expression<N> prod(javax.persistence.criteria.Expression<? extends N> x, N y) {
        return new FunctionExpressionImpl(this.metamodel, (Class)BasicTypeHelperImpl.getInstance().extendedBinaryNumericPromotion(x.getJavaType(), y.getClass()), ExpressionMath.multiply(((InternalSelection)((Object)x)).getCurrentNode(), y), this.buildList(x, this.literal(y)), "prod");
    }

    @Override
    public <N extends Number> javax.persistence.criteria.Expression<N> diff(javax.persistence.criteria.Expression<? extends N> x, N y) {
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(this.literal(y));
        return new FunctionExpressionImpl(this.metamodel, y.getClass(), ExpressionMath.subtract(((InternalSelection)((Object)x)).getCurrentNode(), y), list, "diff");
    }

    @Override
    public <N extends Number> javax.persistence.criteria.Expression<N> sum(N x, javax.persistence.criteria.Expression<? extends N> y) {
        return new FunctionExpressionImpl(this.metamodel, (Class)BasicTypeHelperImpl.getInstance().extendedBinaryNumericPromotion(x.getClass(), y.getJavaType()), ExpressionMath.add((Expression)new ConstantExpression(x, ((InternalSelection)((Object)y)).getCurrentNode()), ((InternalSelection)((Object)y)).getCurrentNode()), this.buildList(this.literal(x), y), "sum");
    }

    @Override
    public <N extends Number> javax.persistence.criteria.Expression<N> prod(N x, javax.persistence.criteria.Expression<? extends N> y) {
        return new FunctionExpressionImpl(this.metamodel, (Class)BasicTypeHelperImpl.getInstance().extendedBinaryNumericPromotion(x.getClass(), y.getJavaType()), ExpressionMath.multiply((Expression)new ConstantExpression(x, ((InternalSelection)((Object)y)).getCurrentNode()), ((InternalSelection)((Object)y)).getCurrentNode()), this.buildList(this.literal(x), y), "prod");
    }

    @Override
    public <N extends Number> javax.persistence.criteria.Expression<N> diff(N x, javax.persistence.criteria.Expression<? extends N> y) {
        ArrayList list = new ArrayList();
        ExpressionImpl literal = (ExpressionImpl)this.literal(x);
        list.add(literal);
        list.add(y);
        return new FunctionExpressionImpl(this.metamodel, literal.getJavaType(), ExpressionMath.subtract(literal.getCurrentNode(), ((InternalSelection)((Object)y)).getCurrentNode()), list, "diff");
    }

    @Override
    public javax.persistence.criteria.Expression<Number> quot(javax.persistence.criteria.Expression<? extends Number> x, javax.persistence.criteria.Expression<? extends Number> y) {
        return new FunctionExpressionImpl<Number>(this.metamodel, (Class)BasicTypeHelperImpl.getInstance().extendedBinaryNumericPromotion(x.getJavaType(), y.getClass()), ExpressionMath.divide(((InternalSelection)((Object)x)).getCurrentNode(), ((InternalSelection)((Object)y)).getCurrentNode()), this.buildList(x, y), "quot");
    }

    @Override
    public javax.persistence.criteria.Expression<Number> quot(javax.persistence.criteria.Expression<? extends Number> x, Number y) {
        return new FunctionExpressionImpl<Number>(this.metamodel, (Class)BasicTypeHelperImpl.getInstance().extendedBinaryNumericPromotion(x.getJavaType(), y.getClass()), ExpressionMath.divide(((InternalSelection)((Object)x)).getCurrentNode(), y), this.buildList(x, this.literal(y)), "quot");
    }

    @Override
    public javax.persistence.criteria.Expression<Number> quot(Number x, javax.persistence.criteria.Expression<? extends Number> y) {
        return new FunctionExpressionImpl<Number>(this.metamodel, ClassConstants.NUMBER, ExpressionMath.divide((Expression)new ConstantExpression(x, ((InternalSelection)((Object)y)).getCurrentNode()), ((InternalSelection)((Object)y)).getCurrentNode()), this.buildList(this.literal(x), y), "quot");
    }

    @Override
    public javax.persistence.criteria.Expression<Integer> mod(javax.persistence.criteria.Expression<Integer> x, javax.persistence.criteria.Expression<Integer> y) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ExpressionMath.mod(((InternalSelection)((Object)x)).getCurrentNode(), ((InternalSelection)((Object)y)).getCurrentNode()), this.buildList(x, y), "mod");
    }

    @Override
    public javax.persistence.criteria.Expression<Integer> mod(javax.persistence.criteria.Expression<Integer> x, Integer y) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ExpressionMath.mod(((InternalSelection)((Object)x)).getCurrentNode(), y), this.buildList(x, this.literal(y)), "mod");
    }

    @Override
    public javax.persistence.criteria.Expression<Integer> mod(Integer x, javax.persistence.criteria.Expression<Integer> y) {
        javax.persistence.criteria.Expression<Integer> xExp = this.literal(x);
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ExpressionMath.mod(((InternalSelection)((Object)xExp)).getCurrentNode(), ((InternalSelection)((Object)y)).getCurrentNode()), this.buildList(xExp, y), "mod");
    }

    @Override
    public javax.persistence.criteria.Expression<Double> sqrt(javax.persistence.criteria.Expression<? extends Number> x) {
        return new FunctionExpressionImpl<Double>(this.metamodel, ClassConstants.DOUBLE, ExpressionMath.sqrt(((InternalSelection)((Object)x)).getCurrentNode()), this.buildList(x), "sqrt");
    }

    @Override
    public javax.persistence.criteria.Expression<Long> toLong(javax.persistence.criteria.Expression<? extends Number> number) {
        return number;
    }

    @Override
    public javax.persistence.criteria.Expression<Integer> toInteger(javax.persistence.criteria.Expression<? extends Number> number) {
        return number;
    }

    @Override
    public javax.persistence.criteria.Expression<Float> toFloat(javax.persistence.criteria.Expression<? extends Number> number) {
        return number;
    }

    @Override
    public javax.persistence.criteria.Expression<Double> toDouble(javax.persistence.criteria.Expression<? extends Number> number) {
        return number;
    }

    @Override
    public javax.persistence.criteria.Expression<BigDecimal> toBigDecimal(javax.persistence.criteria.Expression<? extends Number> number) {
        return number;
    }

    @Override
    public javax.persistence.criteria.Expression<BigInteger> toBigInteger(javax.persistence.criteria.Expression<? extends Number> number) {
        return number;
    }

    @Override
    public javax.persistence.criteria.Expression<String> toString(javax.persistence.criteria.Expression<Character> character) {
        ExpressionImpl impl = (ExpressionImpl)character;
        return impl;
    }

    @Override
    public <T> javax.persistence.criteria.Expression<T> literal(T value) {
        return new ExpressionImpl(this.metamodel, value == null ? null : value.getClass(), new ConstantExpression(value, new ExpressionBuilder()), value);
    }

    @Override
    public <T> javax.persistence.criteria.Expression<T> nullLiteral(Class<T> resultClass) {
        return new ExpressionImpl<T>(this.metamodel, resultClass, new ConstantExpression(null, new ExpressionBuilder()), null);
    }

    @Override
    public <T> javax.persistence.criteria.ParameterExpression<T> parameter(Class<T> paramClass) {
        return new ParameterExpressionImpl<T>(this.metamodel, paramClass);
    }

    @Override
    public <T> javax.persistence.criteria.ParameterExpression<T> parameter(Class<T> paramClass, String name) {
        return new ParameterExpressionImpl<T>(this.metamodel, paramClass, name);
    }

    @Override
    public <C extends Collection<?>> Predicate isEmpty(javax.persistence.criteria.Expression<C> collection) {
        if (((InternalExpression)((Object)collection)).isLiteral()) {
            if (((Collection)((ConstantExpression)((InternalSelection)((Object)collection)).getCurrentNode()).getValue()).isEmpty()) {
                return this.conjunction();
            }
            return this.disjunction();
        }
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)collection)).getCurrentNode().size(ClassConstants.INTEGER).equal(0), this.buildList(collection), "isEmpty");
    }

    @Override
    public <C extends Collection<?>> Predicate isNotEmpty(javax.persistence.criteria.Expression<C> collection) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)collection)).getCurrentNode().size(ClassConstants.INTEGER).equal(0).not(), this.buildList(collection), "isNotEmpty");
    }

    @Override
    public <C extends Collection<?>> javax.persistence.criteria.Expression<Integer> size(C collection) {
        return this.literal(collection.size());
    }

    @Override
    public <C extends Collection<?>> javax.persistence.criteria.Expression<Integer> size(javax.persistence.criteria.Expression<C> collection) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ((InternalSelection)((Object)collection)).getCurrentNode().size(ClassConstants.INTEGER), this.buildList(collection), SIZE);
    }

    @Override
    public <E, C extends Collection<E>> Predicate isMember(E elem, javax.persistence.criteria.Expression<C> collection) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)collection)).getCurrentNode().equal(elem), this.buildList(collection, this.literal(elem)), "isMember");
    }

    @Override
    public <E, C extends Collection<E>> Predicate isNotMember(E elem, javax.persistence.criteria.Expression<C> collection) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)collection)).getCurrentNode().notEqual(elem), this.buildList(collection, this.literal(elem)), "isMember");
    }

    @Override
    public <E, C extends Collection<E>> Predicate isMember(javax.persistence.criteria.Expression<E> elem, javax.persistence.criteria.Expression<C> collection) {
        if (((InternalSelection)((Object)elem)).isFrom()) {
            ((FromImpl)elem).isLeaf = false;
        }
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)collection)).getCurrentNode().equal(((InternalSelection)((Object)elem)).getCurrentNode()), this.buildList(collection, elem), "isMember");
    }

    @Override
    public <E, C extends Collection<E>> Predicate isNotMember(javax.persistence.criteria.Expression<E> elem, javax.persistence.criteria.Expression<C> collection) {
        if (((InternalSelection)((Object)elem)).isFrom()) {
            ((FromImpl)elem).isLeaf = false;
        }
        ReportQuery subQuery = new ReportQuery();
        subQuery.setReferenceClass(((ExpressionImpl)elem).getJavaType());
        ExpressionBuilder elemBuilder = new ExpressionBuilder();
        Expression collectionExp = ((InternalSelection)((Object)collection)).getCurrentNode();
        Expression elemExp = ((InternalSelection)((Object)elem)).getCurrentNode();
        subQuery.setExpressionBuilder(elemBuilder);
        subQuery.setShouldRetrieveFirstPrimaryKey(true);
        subQuery.setSelectionCriteria(elemBuilder.equal(collectionExp).and(collectionExp.equal(elemExp)));
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)elem)).getCurrentNode().notExists(subQuery), this.buildList(elem, collection), "isNotMemeber");
    }

    @Override
    public <V, M extends Map<?, V>> javax.persistence.criteria.Expression<Collection<V>> values(M map) {
        return this.literal(map.values());
    }

    @Override
    public <K, M extends Map<K, ?>> javax.persistence.criteria.Expression<Set<K>> keys(M map) {
        return this.literal(map.keySet());
    }

    @Override
    public Predicate like(javax.persistence.criteria.Expression<String> x, javax.persistence.criteria.Expression<String> pattern) {
        List<javax.persistence.criteria.Expression<?>> list = this.buildList(x, pattern);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().like(((InternalSelection)((Object)pattern)).getCurrentNode()), list, "like");
    }

    @Override
    public Predicate like(javax.persistence.criteria.Expression<String> x, javax.persistence.criteria.Expression<String> pattern, javax.persistence.criteria.Expression<Character> escapeChar) {
        List<javax.persistence.criteria.Expression<?>> list = this.buildList(x, pattern, escapeChar);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().like(((InternalSelection)((Object)pattern)).getCurrentNode(), ((InternalSelection)((Object)escapeChar)).getCurrentNode()), list, "like");
    }

    @Override
    public Predicate like(javax.persistence.criteria.Expression<String> x, javax.persistence.criteria.Expression<String> pattern, char escapeChar) {
        return this.like(x, pattern, this.literal(Character.valueOf(escapeChar)));
    }

    @Override
    public Predicate like(javax.persistence.criteria.Expression<String> x, String pattern) {
        List<javax.persistence.criteria.Expression<?>> list = this.buildList(x, this.literal(pattern));
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().like(pattern), list, "like");
    }

    @Override
    public Predicate like(javax.persistence.criteria.Expression<String> x, String pattern, javax.persistence.criteria.Expression<Character> escapeChar) {
        return this.like(x, this.literal(pattern), escapeChar);
    }

    @Override
    public Predicate like(javax.persistence.criteria.Expression<String> x, String pattern, char escapeChar) {
        List<javax.persistence.criteria.Expression<?>> list = this.buildList(x, this.literal(pattern), this.literal(Character.valueOf(escapeChar)));
        String escapeString = String.valueOf(escapeChar);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().like(pattern, escapeString), list, "like");
    }

    @Override
    public Predicate notLike(javax.persistence.criteria.Expression<String> x, javax.persistence.criteria.Expression<String> pattern) {
        List<javax.persistence.criteria.Expression<?>> list = this.buildList(x, pattern);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().notLike(((InternalSelection)((Object)pattern)).getCurrentNode()), list, "notLike");
    }

    @Override
    public Predicate notLike(javax.persistence.criteria.Expression<String> x, javax.persistence.criteria.Expression<String> pattern, javax.persistence.criteria.Expression<Character> escapeChar) {
        List<javax.persistence.criteria.Expression<?>> list = this.buildList(x, pattern, escapeChar);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().notLike(((InternalSelection)((Object)pattern)).getCurrentNode(), ((InternalSelection)((Object)escapeChar)).getCurrentNode()), list, "like");
    }

    @Override
    public Predicate notLike(javax.persistence.criteria.Expression<String> x, javax.persistence.criteria.Expression<String> pattern, char escapeChar) {
        return this.notLike(x, pattern, this.literal(Character.valueOf(escapeChar)));
    }

    @Override
    public Predicate notLike(javax.persistence.criteria.Expression<String> x, String pattern) {
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(this.literal(pattern));
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().notLike(pattern), list, "notLike");
    }

    @Override
    public Predicate notLike(javax.persistence.criteria.Expression<String> x, String pattern, javax.persistence.criteria.Expression<Character> escapeChar) {
        return this.notLike(x, this.literal(pattern), escapeChar);
    }

    @Override
    public Predicate notLike(javax.persistence.criteria.Expression<String> x, String pattern, char escapeChar) {
        return this.notLike(x, this.literal(pattern), this.literal(Character.valueOf(escapeChar)));
    }

    @Override
    public javax.persistence.criteria.Expression<String> concat(javax.persistence.criteria.Expression<String> x, javax.persistence.criteria.Expression<String> y) {
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(y);
        Expression xNode = ((InternalSelection)((Object)x)).getCurrentNode();
        Expression yNode = ((InternalSelection)((Object)y)).getCurrentNode();
        if (xNode.isParameterExpression() && yNode.isParameterExpression()) {
            ((ParameterExpression)xNode).setType(ClassConstants.STRING);
        }
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, xNode.concat(yNode), list, CONCAT);
    }

    @Override
    public javax.persistence.criteria.Expression<String> concat(javax.persistence.criteria.Expression<String> x, String y) {
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(this.literal(y));
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x)).getCurrentNode().concat(y), list, CONCAT);
    }

    @Override
    public javax.persistence.criteria.Expression<String> concat(String x, javax.persistence.criteria.Expression<String> y) {
        ArrayList list = new ArrayList();
        ExpressionImpl literal = (ExpressionImpl)this.literal(x);
        list.add(literal);
        list.add(y);
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, literal.getCurrentNode().concat(((InternalSelection)((Object)y)).getCurrentNode()), list, CONCAT);
    }

    @Override
    public javax.persistence.criteria.Expression<String> substring(javax.persistence.criteria.Expression<String> x, javax.persistence.criteria.Expression<Integer> from) {
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x)).getCurrentNode().substring(((InternalSelection)((Object)from)).getCurrentNode()), this.buildList(x, from), "subString");
    }

    @Override
    public javax.persistence.criteria.Expression<String> substring(javax.persistence.criteria.Expression<String> x, int from) {
        return this.substring(x, this.literal(from));
    }

    @Override
    public javax.persistence.criteria.Expression<String> substring(javax.persistence.criteria.Expression<String> x, javax.persistence.criteria.Expression<Integer> from, javax.persistence.criteria.Expression<Integer> len) {
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x)).getCurrentNode().substring(((InternalSelection)((Object)from)).getCurrentNode(), ((InternalSelection)((Object)len)).getCurrentNode()), this.buildList(x, from, len), "subString");
    }

    @Override
    public javax.persistence.criteria.Expression<String> substring(javax.persistence.criteria.Expression<String> x, int from, int len) {
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x)).getCurrentNode().substring(from, len), this.buildList(x, this.literal(from), this.literal(len)), "subString");
    }

    @Override
    public javax.persistence.criteria.Expression<String> trim(javax.persistence.criteria.Expression<String> x) {
        List<javax.persistence.criteria.Expression<?>> list = this.buildList(x);
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x)).getCurrentNode().trim(), list, "trim");
    }

    @Override
    public javax.persistence.criteria.Expression<String> trim(CriteriaBuilder.Trimspec ts, javax.persistence.criteria.Expression<String> x) {
        List<javax.persistence.criteria.Expression<?>> list = this.buildList(x);
        if (ts == CriteriaBuilder.Trimspec.LEADING) {
            return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x)).getCurrentNode().leftTrim(), list, "leftTrim");
        }
        if (ts == CriteriaBuilder.Trimspec.TRAILING) {
            return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x)).getCurrentNode().rightTrim(), list, "rightTrim");
        }
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x)).getCurrentNode().rightTrim().leftTrim(), list, "bothTrim");
    }

    @Override
    public javax.persistence.criteria.Expression<String> trim(javax.persistence.criteria.Expression<Character> t, javax.persistence.criteria.Expression<String> x) {
        List<javax.persistence.criteria.Expression<?>> list = this.buildList(x, t);
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x)).getCurrentNode().trim(((InternalSelection)((Object)t)).getCurrentNode()), list, "trim");
    }

    @Override
    public javax.persistence.criteria.Expression<String> trim(CriteriaBuilder.Trimspec ts, javax.persistence.criteria.Expression<Character> t, javax.persistence.criteria.Expression<String> x) {
        List<javax.persistence.criteria.Expression<?>> list = this.buildList(x, t);
        if (ts == CriteriaBuilder.Trimspec.LEADING) {
            return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x)).getCurrentNode().leftTrim(((InternalSelection)((Object)t)).getCurrentNode()), list, "leftTrim");
        }
        if (ts == CriteriaBuilder.Trimspec.TRAILING) {
            return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x)).getCurrentNode().rightTrim(((InternalSelection)((Object)t)).getCurrentNode()), list, "rightTrim");
        }
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x)).getCurrentNode().rightTrim(((InternalSelection)((Object)t)).getCurrentNode()).leftTrim(((InternalSelection)((Object)t)).getCurrentNode()), list, "bothTrim");
    }

    @Override
    public javax.persistence.criteria.Expression<String> trim(char t, javax.persistence.criteria.Expression<String> x) {
        return this.trim(this.literal(Character.valueOf(t)), x);
    }

    @Override
    public javax.persistence.criteria.Expression<String> trim(CriteriaBuilder.Trimspec ts, char t, javax.persistence.criteria.Expression<String> x) {
        return this.trim(ts, this.literal(Character.valueOf(t)), x);
    }

    @Override
    public javax.persistence.criteria.Expression<String> lower(javax.persistence.criteria.Expression<String> x) {
        List<javax.persistence.criteria.Expression<?>> list = this.buildList(x);
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x)).getCurrentNode().toLowerCase(), list, "lower");
    }

    @Override
    public javax.persistence.criteria.Expression<String> upper(javax.persistence.criteria.Expression<String> x) {
        List<javax.persistence.criteria.Expression<?>> list = this.buildList(x);
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x)).getCurrentNode().toUpperCase(), list, "upper");
    }

    @Override
    public javax.persistence.criteria.Expression<Integer> length(javax.persistence.criteria.Expression<String> x) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ((InternalSelection)((Object)x)).getCurrentNode().length(), this.buildList(x), "length");
    }

    @Override
    public javax.persistence.criteria.Expression<Integer> locate(javax.persistence.criteria.Expression<String> x, javax.persistence.criteria.Expression<String> pattern) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ((InternalSelection)((Object)x)).getCurrentNode().locate(((InternalSelection)((Object)pattern)).getCurrentNode()), this.buildList(x, pattern), "locate");
    }

    @Override
    public javax.persistence.criteria.Expression<Integer> locate(javax.persistence.criteria.Expression<String> x, javax.persistence.criteria.Expression<String> pattern, javax.persistence.criteria.Expression<Integer> from) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ((InternalSelection)((Object)x)).getCurrentNode().locate(((InternalSelection)((Object)pattern)).getCurrentNode(), ((InternalSelection)((Object)from)).getCurrentNode()), this.buildList(x, pattern, from), "locate");
    }

    @Override
    public javax.persistence.criteria.Expression<Integer> locate(javax.persistence.criteria.Expression<String> x, String pattern) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ((InternalSelection)((Object)x)).getCurrentNode().locate(pattern), this.buildList(x, this.literal(pattern)), "locate");
    }

    @Override
    public javax.persistence.criteria.Expression<Integer> locate(javax.persistence.criteria.Expression<String> x, String pattern, int from) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ((InternalSelection)((Object)x)).getCurrentNode().locate(pattern, from), this.buildList(x, this.literal(pattern), this.literal(from)), "locate");
    }

    @Override
    public javax.persistence.criteria.Expression<Date> currentDate() {
        return new ExpressionImpl<Date>(this.metamodel, ClassConstants.SQLDATE, new ExpressionBuilder().currentDateDate());
    }

    @Override
    public javax.persistence.criteria.Expression<Timestamp> currentTimestamp() {
        return new ExpressionImpl<Timestamp>(this.metamodel, ClassConstants.TIMESTAMP, new ExpressionBuilder().currentTimeStamp());
    }

    @Override
    public javax.persistence.criteria.Expression<Time> currentTime() {
        return new ExpressionImpl<Time>(this.metamodel, ClassConstants.TIME, new ExpressionBuilder().currentTime());
    }

    @Override
    public <T> CriteriaBuilder.In<T> in(javax.persistence.criteria.Expression<? extends T> expression) {
        if (((InternalSelection)((Object)expression)).isFrom()) {
            ((FromImpl)expression).isLeaf = false;
        }
        return new InImpl(this.metamodel, expression, this.buildList(expression));
    }

    @Override
    public <Y> javax.persistence.criteria.Expression<Y> coalesce(javax.persistence.criteria.Expression<? extends Y> x, javax.persistence.criteria.Expression<? extends Y> y) {
        ArgumentListFunctionExpression coalesce = ((InternalSelection)((Object)x)).getCurrentNode().coalesce();
        coalesce.addChild(((InternalSelection)((Object)x)).getCurrentNode());
        coalesce.addChild(((InternalSelection)((Object)y)).getCurrentNode());
        return new CoalesceImpl(this.metamodel, x.getJavaType(), coalesce, this.buildList(x, y), "coalesce");
    }

    @Override
    public <Y> javax.persistence.criteria.Expression<Y> coalesce(javax.persistence.criteria.Expression<? extends Y> x, Y y) {
        ArgumentListFunctionExpression coalesce = ((InternalSelection)((Object)x)).getCurrentNode().coalesce();
        coalesce.addChild(((InternalSelection)((Object)x)).getCurrentNode());
        coalesce.addChild(((InternalSelection)y).getCurrentNode());
        return new CoalesceImpl(this.metamodel, x.getJavaType(), coalesce, this.buildList(x, this.literal(y)), "coalesce");
    }

    @Override
    public <Y> javax.persistence.criteria.Expression<Y> nullif(javax.persistence.criteria.Expression<Y> x, javax.persistence.criteria.Expression<?> y) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ((InternalSelection)((Object)x)).getCurrentNode().nullIf(((InternalSelection)((Object)y)).getCurrentNode()), this.buildList(x, y), "nullIf");
    }

    @Override
    public <Y> javax.persistence.criteria.Expression<Y> nullif(javax.persistence.criteria.Expression<Y> x, Y y) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ((InternalSelection)((Object)x)).getCurrentNode().nullIf(y), this.buildList(x, this.literal(y)), "nullIf");
    }

    @Override
    public <T> CriteriaBuilder.Coalesce<T> coalesce() {
        ArgumentListFunctionExpression coalesce = new ExpressionBuilder().coalesce();
        return new CoalesceImpl<Object>(this.metamodel, Object.class, (Expression)coalesce, new ArrayList());
    }

    @Override
    public <C, R> CriteriaBuilder.SimpleCase<C, R> selectCase(javax.persistence.criteria.Expression<? extends C> expression) {
        ArgumentListFunctionExpression caseStatement = new ExpressionBuilder().caseStatement();
        return new SimpleCaseImpl<C, Object>(this.metamodel, Object.class, caseStatement, new ArrayList(), expression);
    }

    @Override
    public <R> CriteriaBuilder.Case<R> selectCase() {
        ArgumentListFunctionExpression caseStatement = new ExpressionBuilder().caseConditionStatement();
        return new CaseImpl<Object>(this.metamodel, Object.class, (Expression)caseStatement, (List<javax.persistence.criteria.Expression<?>>)new ArrayList());
    }

    @Override
    public <T> javax.persistence.criteria.Expression<T> function(String name, Class<T> type, javax.persistence.criteria.Expression<?> ... args) {
        if (args != null && args.length > 0) {
            Vector<Expression> params = new Vector<Expression>();
            for (int index = 1; index < args.length; ++index) {
                javax.persistence.criteria.Expression<?> x = args[index];
                if (((InternalSelection)((Object)x)).isFrom()) {
                    ((FromImpl)x).isLeaf = false;
                }
                params.add(((InternalSelection)((Object)x)).getCurrentNode());
            }
            return new FunctionExpressionImpl<T>(this.metamodel, type, ((InternalSelection)((Object)args[0])).getCurrentNode().getFunctionWithArguments(name, params), this.buildList(args), name);
        }
        return new FunctionExpressionImpl<T>(this.metamodel, type, new ExpressionBuilder().getFunction(name), new ArrayList(0), name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SimpleCaseImpl<C, R>
    extends FunctionExpressionImpl<R>
    implements CriteriaBuilder.SimpleCase<C, R> {
        private javax.persistence.criteria.Expression<C> expression;

        protected <T> SimpleCaseImpl(Metamodel metamodel, Class<R> resultClass, FunctionExpression expressionNode, List<javax.persistence.criteria.Expression<?>> compoundExpressions, javax.persistence.criteria.Expression<C> expression) {
            super(metamodel, resultClass, (Expression)expressionNode, compoundExpressions);
            this.expression = expression;
            expressionNode.addChild(((InternalSelection)((Object)expression)).getCurrentNode());
        }

        protected <T> SimpleCaseImpl(Metamodel metamodel, Class<R> resultClass, FunctionExpression expressionNode, List<javax.persistence.criteria.Expression<?>> compoundExpressions, String operator, javax.persistence.criteria.Expression<C> expression) {
            super(metamodel, resultClass, expressionNode, compoundExpressions, operator);
            this.expression = expression;
            expressionNode.addChild(((InternalSelection)((Object)expression)).getCurrentNode());
        }

        @Override
        public javax.persistence.criteria.Expression<C> getExpression() {
            return this.expression;
        }

        @Override
        public CriteriaBuilder.SimpleCase<C, R> when(C condition, R result) {
            Expression conditionExp = Expression.from(condition, new ExpressionBuilder());
            ((FunctionExpression)this.currentNode).addChild(conditionExp);
            Expression resultExp = Expression.from(result, new ExpressionBuilder());
            ((FunctionExpression)this.currentNode).addChild(resultExp);
            return this;
        }

        @Override
        public CriteriaBuilder.SimpleCase<C, R> when(C condition, javax.persistence.criteria.Expression<? extends R> result) {
            Expression conditionExp = Expression.from(condition, new ExpressionBuilder());
            ((FunctionExpression)this.currentNode).addChild(conditionExp);
            Expression resultExp = ((InternalSelection)((Object)result)).getCurrentNode();
            resultExp = Expression.from(resultExp, this.currentNode);
            ((FunctionExpression)this.currentNode).addChild(resultExp);
            return this;
        }

        @Override
        public javax.persistence.criteria.Expression<R> otherwise(R result) {
            Expression resultExp = Expression.from(result, new ExpressionBuilder());
            ((ArgumentListFunctionExpression)this.currentNode).addRightMostChild(resultExp);
            return this;
        }

        @Override
        public javax.persistence.criteria.Expression<R> otherwise(javax.persistence.criteria.Expression<? extends R> result) {
            Expression resultExp = ((InternalSelection)((Object)result)).getCurrentNode();
            resultExp = Expression.from(resultExp, this.currentNode);
            ((ArgumentListFunctionExpression)this.currentNode).addRightMostChild(resultExp);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CaseImpl<R>
    extends FunctionExpressionImpl<R>
    implements CriteriaBuilder.Case<R> {
        protected <T> CaseImpl(Metamodel metamodel, Class<R> resultClass, Expression expressionNode, List<javax.persistence.criteria.Expression<?>> compoundExpressions) {
            super(metamodel, resultClass, expressionNode, compoundExpressions);
        }

        protected <T> CaseImpl(Metamodel metamodel, Class<R> resultClass, Expression expressionNode, List<javax.persistence.criteria.Expression<?>> compoundExpressions, String operator) {
            super(metamodel, resultClass, expressionNode, compoundExpressions, operator);
        }

        @Override
        public CriteriaBuilder.Case<R> when(javax.persistence.criteria.Expression<Boolean> condition, R result) {
            Expression conditionExp = ((InternalSelection)((Object)condition)).getCurrentNode();
            conditionExp = Expression.from(conditionExp, this.currentNode);
            ((FunctionExpression)this.currentNode).addChild(conditionExp);
            Expression resultExp = Expression.from(result, new ExpressionBuilder());
            ((FunctionExpression)this.currentNode).addChild(resultExp);
            return this;
        }

        @Override
        public CriteriaBuilder.Case<R> when(javax.persistence.criteria.Expression<Boolean> condition, javax.persistence.criteria.Expression<? extends R> result) {
            Expression conditionExp = ((InternalSelection)((Object)condition)).getCurrentNode();
            conditionExp = Expression.from(conditionExp, this.currentNode);
            ((FunctionExpression)this.currentNode).addChild(conditionExp);
            Expression resultExp = ((InternalSelection)((Object)condition)).getCurrentNode();
            resultExp = Expression.from(resultExp, this.currentNode);
            ((FunctionExpression)this.currentNode).addChild(resultExp);
            return this;
        }

        @Override
        public javax.persistence.criteria.Expression<R> otherwise(R result) {
            Expression resultExp = Expression.from(result, new ExpressionBuilder());
            ((ArgumentListFunctionExpression)this.currentNode).addRightMostChild(resultExp);
            return this;
        }

        @Override
        public javax.persistence.criteria.Expression<R> otherwise(javax.persistence.criteria.Expression<? extends R> result) {
            Expression resultExp = ((InternalSelection)((Object)result)).getCurrentNode();
            resultExp = Expression.from(resultExp, this.currentNode);
            ((ArgumentListFunctionExpression)this.currentNode).addRightMostChild(resultExp);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CoalesceImpl<X>
    extends FunctionExpressionImpl<X>
    implements CriteriaBuilder.Coalesce<X> {
        protected <T> CoalesceImpl(Metamodel metamodel, Class<X> resultClass, Expression expressionNode, List<javax.persistence.criteria.Expression<?>> compoundExpressions) {
            super(metamodel, resultClass, expressionNode, compoundExpressions);
        }

        protected <T> CoalesceImpl(Metamodel metamodel, Class<X> resultClass, Expression expressionNode, List<javax.persistence.criteria.Expression<?>> compoundExpressions, String operator) {
            super(metamodel, resultClass, expressionNode, compoundExpressions, operator);
        }

        @Override
        public CriteriaBuilder.Coalesce<X> value(X value) {
            Expression exp = Expression.from(value, new ExpressionBuilder());
            ((FunctionExpression)this.currentNode).addChild(exp);
            return this;
        }

        @Override
        public CriteriaBuilder.Coalesce<X> value(javax.persistence.criteria.Expression<? extends X> value) {
            Expression exp = ((InternalSelection)((Object)value)).getCurrentNode();
            exp = Expression.from(exp, this.currentNode);
            ((FunctionExpression)this.currentNode).addChild(exp);
            return this;
        }
    }
}

