/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.documentpreservation;

import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.oxm.WeakObjectWrapper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.documentpreservation.AppendNewElementsOrderingPolicy;
import org.eclipse.persistence.oxm.documentpreservation.DocumentPreservationPolicy;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DescriptorLevelDocumentPreservationPolicy
extends DocumentPreservationPolicy {
    private XMLContext context;

    public DescriptorLevelDocumentPreservationPolicy() {
        this.setNodeOrderingPolicy(new AppendNewElementsOrderingPolicy());
    }

    public void initialize(XMLContext ctx) {
        this.context = ctx;
    }

    public void addObjectToCache(Object obj, Node node) {
        this.addObjectToCache(obj, node, null);
    }

    public void addObjectToCache(Object obj, Node node, XMLMapping selfRecordMapping) {
        if (node.getNodeType() != 1) {
            return;
        }
        AbstractSession session = this.context.getSession(obj);
        XMLDescriptor xmlDescriptor = (XMLDescriptor)session.getDescriptor(obj);
        DOMRecord row = new DOMRecord((Element)node);
        row.setSession(session);
        Object pk = xmlDescriptor.getObjectBuilder().extractPrimaryKeyFromRow(row, session);
        if (xmlDescriptor.shouldPreserveDocument() || xmlDescriptor.getPrimaryKeyFieldNames().size() > 0) {
            if (pk == null || ((CacheId)pk).getPrimaryKey().length == 0) {
                pk = new CacheId(new Object[]{new WeakObjectWrapper(obj)});
            }
            CacheKey key = session.getIdentityMapAccessorInstance().acquireDeferredLock(pk, xmlDescriptor.getJavaClass(), xmlDescriptor);
            if (xmlDescriptor.shouldPreserveDocument()) {
                key.setRecord(row);
            }
            key.setObject(obj);
            key.releaseDeferredLock();
        }
    }

    public Node getNodeForObject(Object obj) {
        AbstractSession session = this.context.getSession(obj);
        XMLDescriptor xmlDescriptor = (XMLDescriptor)session.getDescriptor(obj);
        if (xmlDescriptor.shouldPreserveDocument()) {
            CacheKey cacheKey;
            Object pk = xmlDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(obj, session);
            if (pk == null || pk instanceof CacheId && ((CacheId)pk).getPrimaryKey().length == 0) {
                pk = new CacheId(new Object[]{new WeakObjectWrapper(obj)});
            }
            if ((cacheKey = session.getIdentityMapAccessorInstance().getCacheKeyForObject(pk, xmlDescriptor.getJavaClass(), xmlDescriptor)) != null && cacheKey.getRecord() != null) {
                return ((DOMRecord)cacheKey.getRecord()).getDOM();
            }
        }
        return null;
    }

    public Object getObjectForNode(Node node) {
        return this.getObjectForNode(node, null);
    }

    public Object getObjectForNode(Node node, XMLMapping selfRecordMapping) {
        return null;
    }

    public boolean shouldPreserveDocument() {
        return true;
    }
}

