/*******************************************************************************
 * Copyright (c) 1998, 2010 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the 
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0 
 * which accompanies this distribution. 
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at 
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation from Oracle TopLink
 ******************************************************************************/  
package org.eclipse.persistence.testing.tests.queries.report;

import org.eclipse.persistence.sessions.*;
import org.eclipse.persistence.descriptors.*;
import org.eclipse.persistence.mappings.*;
import org.eclipse.persistence.indirection.*;

/**
 * This class was generated by the TopLink project class generator.
 * It stores the meta-data (descriptors) that define the TopLink mappings.
 * ## TopLink - 4.6.0 (Build 417) ##
 * @see com.webgain.integrator.tools.workbench.ProjectClassGenerator
 */
public class BarBeerProject extends Project {
    public BarBeerProject() {
        setName("barBeer_project");
        applyLogin();

        addDescriptor(buildBarDescriptor());
        addDescriptor(buildBeerDescriptor());
        addDescriptor(buildBrewerDescriptor());
        addDescriptor(buildPersonDescriptor());
    }

    public void applyLogin() {
        DatabaseLogin login = new DatabaseLogin();
        setLogin(login);
    }

    public RelationalDescriptor buildBarDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Bar.class);
        descriptor.addTableName("BAR");
        descriptor.addPrimaryKeyFieldName("BAR.KEY_BAR");

        // RelationalDescriptor properties.
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.setAlias("Bar");

        // Query manager.
        descriptor.getQueryManager().checkCacheForDoesExist();

        //Named Queries
        // Event manager.
        // Mappings.
        DirectToFieldMapping keyMapping = new DirectToFieldMapping();
        keyMapping.setAttributeName("key");
        keyMapping.setFieldName("BAR.KEY_BAR");
        descriptor.addMapping(keyMapping);

        DirectToFieldMapping nameMapping = new DirectToFieldMapping();
        nameMapping.setAttributeName("name");
        nameMapping.setFieldName("BAR.TXT_NAME");
        descriptor.addMapping(nameMapping);

        ManyToManyMapping beerCollectionMapping = new ManyToManyMapping();
        beerCollectionMapping.setAttributeName("beerCollection");
        beerCollectionMapping.setGetMethodName("getBeerCollection");
        beerCollectionMapping.setSetMethodName("setBeerCollection");
        beerCollectionMapping.setReferenceClass(Beer.class);
        beerCollectionMapping.setRelationshipPartnerAttributeName("barCollection");
        beerCollectionMapping.useTransparentCollection();
        beerCollectionMapping.useCollectionClass(IndirectList.class);
        beerCollectionMapping.setRelationTableName("BAR_BEER");
        beerCollectionMapping.addSourceRelationKeyFieldName("BAR_BEER.KEY_BAR", "BAR.KEY_BAR");
        beerCollectionMapping.addTargetRelationKeyFieldName("BAR_BEER.KEY_BEER", "BEER.KEY_BEER");
        descriptor.addMapping(beerCollectionMapping);

        OneToOneMapping brewerMapping = new OneToOneMapping();
        brewerMapping.setAttributeName("brewer");
        brewerMapping.setReferenceClass(Person.class);
        brewerMapping.dontUseIndirection();
        brewerMapping.addForeignKeyFieldName("BAR.KEY_PERSON", "PERSON.KEY_PERSON");
        descriptor.addMapping(brewerMapping);

        return descriptor;
    }

    public RelationalDescriptor buildBeerDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Beer.class);
        descriptor.addTableName("BEER");
        descriptor.addPrimaryKeyFieldName("BEER.KEY_BEER");

        // RelationalDescriptor properties.
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.setAlias("Beer");

        // Query manager.
        descriptor.getQueryManager().checkCacheForDoesExist();

        //Named Queries
        // Event manager.
        // Mappings.
        DirectToFieldMapping brandMapping = new DirectToFieldMapping();
        brandMapping.setAttributeName("brand");
        brandMapping.setFieldName("BEER.TXT_BRAND");
        descriptor.addMapping(brandMapping);

        DirectToFieldMapping keyMapping = new DirectToFieldMapping();
        keyMapping.setAttributeName("key");
        keyMapping.setFieldName("BEER.KEY_BEER");
        descriptor.addMapping(keyMapping);

        ManyToManyMapping barCollectionMapping = new ManyToManyMapping();
        barCollectionMapping.setAttributeName("barCollection");
        barCollectionMapping.setGetMethodName("getBarCollection");
        barCollectionMapping.setSetMethodName("setBarCollection");
        barCollectionMapping.setReferenceClass(Bar.class);
        barCollectionMapping.setRelationshipPartnerAttributeName("beerCollection");
        barCollectionMapping.useTransparentCollection();
        barCollectionMapping.useCollectionClass(IndirectList.class);
        barCollectionMapping.readOnly();
        barCollectionMapping.setRelationTableName("BAR_BEER");
        barCollectionMapping.addSourceRelationKeyFieldName("BAR_BEER.KEY_BEER", "BEER.KEY_BEER");
        barCollectionMapping.addTargetRelationKeyFieldName("BAR_BEER.KEY_BAR", "BAR.KEY_BAR");
        descriptor.addMapping(barCollectionMapping);

        OneToOneMapping brewerMapping = new OneToOneMapping();
        brewerMapping.setAttributeName("brewer");
        brewerMapping.setReferenceClass(Brewer.class);
        brewerMapping.dontUseIndirection();
        brewerMapping.addForeignKeyFieldName("BEER.KEY_BREWER", "BREWER.KEY_BREWER");
        descriptor.addMapping(brewerMapping);

        return descriptor;
    }

    public RelationalDescriptor buildBrewerDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Brewer.class);
        descriptor.addTableName("BREWER");
        descriptor.addPrimaryKeyFieldName("BREWER.KEY_BREWER");

        // RelationalDescriptor properties.
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.setAlias("Brewer");

        // Query manager.
        descriptor.getQueryManager().checkCacheForDoesExist();

        //Named Queries
        // Event manager.
        // Mappings.
        DirectToFieldMapping keyMapping = new DirectToFieldMapping();
        keyMapping.setAttributeName("key");
        keyMapping.setFieldName("BREWER.KEY_BREWER");
        descriptor.addMapping(keyMapping);

        DirectToFieldMapping nameMapping = new DirectToFieldMapping();
        nameMapping.setAttributeName("name");
        nameMapping.setFieldName("BREWER.TXT_NAME");
        descriptor.addMapping(nameMapping);

        return descriptor;
    }

    public RelationalDescriptor buildPersonDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Person.class);
        descriptor.addTableName("PERSON");
        descriptor.addPrimaryKeyFieldName("PERSON.KEY_PERSON");

        // RelationalDescriptor properties.
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.setAlias("Person");

        // Query manager.
        descriptor.getQueryManager().checkCacheForDoesExist();

        //Named Queries
        // Event manager.
        // Mappings.
        DirectToFieldMapping brandMapping = new DirectToFieldMapping();
        brandMapping.setAttributeName("name");
        brandMapping.setFieldName("PERSON.TXT_NAME");
        descriptor.addMapping(brandMapping);

        DirectToFieldMapping keyMapping = new DirectToFieldMapping();
        keyMapping.setAttributeName("key");
        keyMapping.setFieldName("PERSON.KEY_PERSON");
        descriptor.addMapping(keyMapping);

        OneToOneMapping brewerMapping = new OneToOneMapping();
        brewerMapping.setAttributeName("faviouriteBeer");
        brewerMapping.setReferenceClass(Beer.class);
        brewerMapping.dontUseIndirection();
        brewerMapping.addForeignKeyFieldName("PERSON.KEY_BEER", "BEER.KEY_BEER");
        descriptor.addMapping(brewerMapping);

        return descriptor;
    }
}
