/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws.oracle;

import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.XMLNullRepresentationType;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.oxm.schema.XMLSchemaURLReference;
import org.eclipse.persistence.platform.database.oracle.publisher.visit.PublisherDefaultListener;

public class PLSQLOXDescriptorBuilder
extends PublisherDefaultListener {
    public static final String ITEMS_MAPPING_ATTRIBUTE_NAME = "items";
    protected String targetNamespace;
    protected Stack<PublisherDefaultListener.ListenerHelper> stac = new Stack();
    protected Map<String, XMLDescriptor> descriptorMap = new HashMap<String, XMLDescriptor>();
    protected String packageName = null;

    public PLSQLOXDescriptorBuilder(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public List<XMLDescriptor> getDescriptors() {
        if (this.descriptorMap.isEmpty()) {
            return null;
        }
        ArrayList<XMLDescriptor> al = new ArrayList<XMLDescriptor>();
        al.addAll(this.descriptorMap.values());
        return al;
    }

    @Override
    public void beginPackage(String packageName) {
        int dotIdx = packageName.indexOf(46);
        if (dotIdx > -1) {
            this.packageName = packageName.substring(dotIdx + 1);
        }
    }

    @Override
    public void beginPlsqlTable(String tableName, String targetTypeName) {
        PublisherDefaultListener.TableHelper tableHelper = new PublisherDefaultListener.TableHelper(tableName, targetTypeName.toLowerCase(), targetTypeName);
        this.stac.push(tableHelper);
    }

    @Override
    public void endPlsqlTable(String tableName, String typeDDL, String typeDropDDL) {
        XMLCompositeCollectionMapping itemsMapping;
        boolean itemsMappingFound;
        PublisherDefaultListener.ListenerHelper top = this.stac.pop();
        PublisherDefaultListener.ListenerHelper next = this.stac.peek();
        PublisherDefaultListener.TableHelper tableHelper = null;
        if (next.isTable()) {
            tableHelper = (PublisherDefaultListener.TableHelper)next;
            next = top;
        } else if (top.isTable()) {
            tableHelper = (PublisherDefaultListener.TableHelper)top;
        }
        String tableAlias = tableHelper.targetTypeName().toLowerCase();
        XMLDescriptor xdesc = this.descriptorMap.get(tableAlias);
        if (xdesc == null) {
            xdesc = new XMLDescriptor();
            xdesc.setAlias(tableHelper.tableAlias());
            xdesc.setJavaClassName(tableName.toLowerCase() + "_CollectionWrapper");
            xdesc.getQueryManager();
            XMLSchemaURLReference schemaReference = new XMLSchemaURLReference("");
            schemaReference.setSchemaContext("/" + tableHelper.targetTypeName());
            schemaReference.setType(1);
            xdesc.setSchemaReference((XMLSchemaReference)schemaReference);
            NamespaceResolver nr = new NamespaceResolver();
            nr.setDefaultNamespaceURI(this.targetNamespace);
            xdesc.setNamespaceResolver(nr);
        }
        boolean bl = itemsMappingFound = xdesc.getMappingForAttributeName(ITEMS_MAPPING_ATTRIBUTE_NAME) != null;
        if (next.isRecord()) {
            if (!itemsMappingFound) {
                itemsMapping = new XMLCompositeCollectionMapping();
                itemsMapping.setAttributeName(ITEMS_MAPPING_ATTRIBUTE_NAME);
                itemsMapping.setXPath("item");
                XMLField xField = (XMLField)itemsMapping.getField();
                xField.setRequired(true);
                itemsMapping.useCollectionClassName("java.util.ArrayList");
                itemsMapping.setReferenceClassName(((PublisherDefaultListener.RecordHelper)next).recordName().toLowerCase());
                xdesc.addMapping((DatabaseMapping)itemsMapping);
            }
            tableHelper.nestedIsComplex();
        } else {
            if (!itemsMappingFound) {
                if (!next.isComplex()) {
                    itemsMapping = new XMLCompositeDirectCollectionMapping();
                    itemsMapping.setAttributeElementClass(PLSQLOXDescriptorBuilder.attributeClassFromDatabaseType((PublisherDefaultListener.DefaultListenerHelper)next));
                    itemsMapping.setAttributeName(ITEMS_MAPPING_ATTRIBUTE_NAME);
                    itemsMapping.setUsesSingleNode(true);
                    itemsMapping.setXPath("item/text()");
                    XMLField xField = (XMLField)itemsMapping.getField();
                    xField.setRequired(true);
                    itemsMapping.useCollectionClassName("java.util.ArrayList");
                    AbstractNullPolicy nullPolicy = itemsMapping.getNullPolicy();
                    nullPolicy.setNullRepresentedByEmptyNode(false);
                    nullPolicy.setMarshalNullRepresentation(XMLNullRepresentationType.XSI_NIL);
                    nullPolicy.setNullRepresentedByXsiNil(true);
                    itemsMapping.setNullPolicy(nullPolicy);
                    xdesc.getNamespaceResolver().put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                    xdesc.addMapping((DatabaseMapping)itemsMapping);
                } else {
                    itemsMapping = new XMLCompositeCollectionMapping();
                    itemsMapping.setAttributeName(ITEMS_MAPPING_ATTRIBUTE_NAME);
                    itemsMapping.setXPath("item");
                    XMLField xField = (XMLField)itemsMapping.getField();
                    xField.setRequired(true);
                    itemsMapping.useCollectionClassName("java.util.ArrayList");
                    itemsMapping.setReferenceClassName(((PublisherDefaultListener.TableHelper)next).tableName().toLowerCase() + "_CollectionWrapper");
                    xdesc.addMapping((DatabaseMapping)itemsMapping);
                }
            }
            if (next.isTable()) {
                ((PublisherDefaultListener.TableHelper)next).nestedIsComplex();
            }
        }
        if (!itemsMappingFound) {
            this.descriptorMap.put(tableAlias, xdesc);
        }
    }

    @Override
    public void beginPlsqlRecord(String plsqlRecordName, String targetTypeName, int numFields) {
        PublisherDefaultListener.RecordHelper recordHelper = new PublisherDefaultListener.RecordHelper(plsqlRecordName, targetTypeName, numFields);
        this.stac.push(recordHelper);
        String recordAlias = targetTypeName.toLowerCase();
        XMLDescriptor xdesc = this.descriptorMap.get(recordAlias);
        if (xdesc == null) {
            xdesc = new XMLDescriptor();
            xdesc.setAlias(recordAlias);
            xdesc.setJavaClassName(plsqlRecordName.toLowerCase());
            xdesc.getQueryManager();
            XMLSchemaURLReference schemaReference = new XMLSchemaURLReference();
            schemaReference.setSchemaContext("/" + targetTypeName);
            schemaReference.setType(1);
            xdesc.setSchemaReference((XMLSchemaReference)schemaReference);
            NamespaceResolver nr = new NamespaceResolver();
            nr.setDefaultNamespaceURI(this.targetNamespace);
            xdesc.setNamespaceResolver(nr);
            this.descriptorMap.put(recordAlias, xdesc);
        }
    }

    @Override
    public void endPlsqlRecordField(String fieldName, int idx) {
        PublisherDefaultListener.ListenerHelper top = this.stac.pop();
        PublisherDefaultListener.ListenerHelper listenerHelper = this.stac.peek();
        if (listenerHelper.isRecord()) {
            String lfieldName;
            PublisherDefaultListener.RecordHelper recordHelper = (PublisherDefaultListener.RecordHelper)this.stac.peek();
            XMLDescriptor xdesc = this.descriptorMap.get(recordHelper.targetTypeName().toLowerCase());
            if (xdesc.getMappingForAttributeName(lfieldName = fieldName.toLowerCase()) == null) {
                if (top.isComplex()) {
                    if (top.isTable()) {
                        PublisherDefaultListener.TableHelper tblHelper = (PublisherDefaultListener.TableHelper)top;
                        if (tblHelper.isNestedComplex()) {
                            XMLCompositeObjectMapping fieldMapping = new XMLCompositeObjectMapping();
                            fieldMapping.setAttributeName(lfieldName);
                            fieldMapping.setXPath(lfieldName);
                            XMLField xField = (XMLField)fieldMapping.getField();
                            xField.setRequired(true);
                            fieldMapping.setReferenceClassName(tblHelper.tableName().toLowerCase());
                            xdesc.addMapping((DatabaseMapping)fieldMapping);
                        } else {
                            XMLCompositeDirectCollectionMapping fieldMapping = new XMLCompositeDirectCollectionMapping();
                            String foo = tblHelper.targetTypeName().toLowerCase();
                            XMLDescriptor xdesc2 = this.descriptorMap.get(foo);
                            if (xdesc2 != null) {
                                XMLCompositeDirectCollectionMapping itemsMapping = (XMLCompositeDirectCollectionMapping)xdesc2.getMappingForAttributeName(ITEMS_MAPPING_ATTRIBUTE_NAME);
                                Class attributeElementClass = itemsMapping.getAttributeElementClass();
                                fieldMapping.setAttributeElementClass(attributeElementClass);
                            } else {
                                fieldMapping.setAttributeElementClass(String.class);
                            }
                            fieldMapping.setAttributeName(lfieldName);
                            fieldMapping.setUsesSingleNode(true);
                            fieldMapping.setXPath(lfieldName + "/item/text()");
                            XMLField xField = (XMLField)fieldMapping.getField();
                            xField.setRequired(true);
                            fieldMapping.useCollectionClassName("java.util.ArrayList");
                            AbstractNullPolicy nullPolicy = fieldMapping.getNullPolicy();
                            nullPolicy.setNullRepresentedByEmptyNode(false);
                            nullPolicy.setMarshalNullRepresentation(XMLNullRepresentationType.XSI_NIL);
                            nullPolicy.setNullRepresentedByXsiNil(true);
                            fieldMapping.setNullPolicy(nullPolicy);
                            xdesc.getNamespaceResolver().put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                            xdesc.addMapping((DatabaseMapping)fieldMapping);
                        }
                    } else if (top.isRecord()) {
                        XMLCompositeObjectMapping fieldMapping = new XMLCompositeObjectMapping();
                        fieldMapping.setAttributeName(lfieldName);
                        fieldMapping.setXPath(lfieldName);
                        XMLField xField = (XMLField)fieldMapping.getField();
                        xField.setRequired(true);
                        fieldMapping.setReferenceClassName(((PublisherDefaultListener.RecordHelper)top).recordName().toLowerCase());
                        xdesc.addMapping((DatabaseMapping)fieldMapping);
                    }
                } else {
                    XMLDirectMapping fieldMapping = new XMLDirectMapping();
                    fieldMapping.setAttributeName(lfieldName);
                    XMLField xField = new XMLField(lfieldName + "/text()");
                    xField.setRequired(true);
                    QName qnameFromDatabaseType = PLSQLOXDescriptorBuilder.qnameFromDatabaseType(top);
                    xField.setSchemaType(qnameFromDatabaseType);
                    if (qnameFromDatabaseType == XMLConstants.DATE_QNAME) {
                        fieldMapping.setAttributeClassification(Date.class);
                        xField.addXMLConversion(XMLConstants.DATE_QNAME, Date.class);
                        xField.addJavaConversion(Date.class, XMLConstants.DATE_QNAME);
                        xdesc.getNamespaceResolver().put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                        xdesc.getNamespaceResolver().put("xsd", "http://www.w3.org/2001/XMLSchema");
                    } else {
                        Class attributeClass = (Class)XMLConversionManager.getDefaultXMLTypes().get(qnameFromDatabaseType);
                        if (attributeClass == null) {
                            attributeClass = ClassConstants.Object_Class;
                        }
                        fieldMapping.setAttributeClassification(attributeClass);
                    }
                    fieldMapping.setField((DatabaseField)xField);
                    AbstractNullPolicy nullPolicy = fieldMapping.getNullPolicy();
                    nullPolicy.setNullRepresentedByEmptyNode(false);
                    nullPolicy.setMarshalNullRepresentation(XMLNullRepresentationType.XSI_NIL);
                    nullPolicy.setNullRepresentedByXsiNil(true);
                    fieldMapping.setNullPolicy(nullPolicy);
                    xdesc.getNamespaceResolver().put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                    xdesc.addMapping((DatabaseMapping)fieldMapping);
                }
            }
        } else {
            System.identityHashCode(listenerHelper);
        }
    }

    @Override
    public void endMethodArg(String argName) {
        this.stac.pop();
    }

    @Override
    public void handleSqlType(String sqlTypeName, int typecode, String targetType) {
        this.stac.push(new PublisherDefaultListener.SqltypeHelper(sqlTypeName));
    }

    @Override
    public void handleObjectType(String objectTypename, String targetTypeName, int numAttributes) {
        this.stac.push(new PublisherDefaultListener.ObjectTypeHelper(objectTypename, targetTypeName, numAttributes));
    }

    public static Class<?> attributeClassFromDatabaseType(PublisherDefaultListener.DefaultListenerHelper helper) {
        if (!helper.isComplex()) {
            String typeName = helper.targetTypeName();
            if (typeName == null) {
                if (helper instanceof PublisherDefaultListener.SqltypeHelper) {
                    typeName = ((PublisherDefaultListener.SqltypeHelper)helper).sqlTypeName();
                } else if (helper instanceof PublisherDefaultListener.ObjectTypeHelper) {
                    typeName = ((PublisherDefaultListener.ObjectTypeHelper)helper).objectTypename();
                } else if (helper instanceof PublisherDefaultListener.SqlArrayTypeHelper) {
                    typeName = ((PublisherDefaultListener.SqlArrayTypeHelper)helper).arrayTypename();
                }
            }
            if ("NUMBER".equals(typeName)) {
                return ClassConstants.BIGDECIMAL;
            }
            if ("INTEGER".equals(typeName)) {
                return ClassConstants.INTEGER;
            }
            if ("BOOLEAN".equals(typeName)) {
                return ClassConstants.BOOLEAN;
            }
            if ("DATE".equals(typeName)) {
                return ClassConstants.JavaSqlDate_Class;
            }
        }
        return ClassConstants.STRING;
    }

    public static <T extends PublisherDefaultListener.ListenerHelper> QName qnameFromDatabaseType(T helper) {
        if (!helper.isComplex()) {
            String typeName = helper.targetTypeName();
            if (typeName == null) {
                if (helper instanceof PublisherDefaultListener.SqltypeHelper) {
                    typeName = ((PublisherDefaultListener.SqltypeHelper)helper).sqlTypeName();
                }
                if (typeName == null && helper instanceof PublisherDefaultListener.ObjectTypeHelper) {
                    typeName = ((PublisherDefaultListener.ObjectTypeHelper)helper).objectTypename();
                }
            }
            if ("VARCHAR2".equals(typeName) || "VARCHAR".equals(typeName)) {
                return XMLConstants.STRING_QNAME;
            }
            if ("NUMBER".equals(typeName)) {
                return XMLConstants.DECIMAL_QNAME;
            }
            if ("INTEGER".equals(typeName)) {
                return XMLConstants.INTEGER_QNAME;
            }
            if ("BOOLEAN".equals(typeName)) {
                return XMLConstants.BOOLEAN_QNAME;
            }
            if ("DATE".equals(typeName)) {
                return XMLConstants.DATE_QNAME;
            }
        }
        return XMLConstants.ANY_SIMPLE_TYPE_QNAME;
    }
}

