/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalDatabase;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalTableDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.jdbc.JDBCExternalTableDescription;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.ResultSetIterator;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

final class JDBCExternalDatabase
implements ExternalDatabase {
    private final Connection connection;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    JDBCExternalDatabase(Connection connection) {
        this.connection = connection;
    }

    public String[] getCatalogNames() {
        ResultSet resultSet;
        try {
            resultSet = this.metaData().getCatalogs();
        }
        catch (SQLException ex) {
            return EMPTY_STRING_ARRAY;
        }
        return this.buildStringArray(resultSet);
    }

    public String[] getSchemaNames() {
        ResultSet resultSet;
        try {
            resultSet = this.metaData().getSchemas();
        }
        catch (SQLException ex) {
            return EMPTY_STRING_ARRAY;
        }
        return this.buildStringArray(resultSet);
    }

    public String[] getTableTypeNames() {
        ResultSet resultSet;
        try {
            resultSet = this.metaData().getTableTypes();
        }
        catch (SQLException ex) {
            return EMPTY_STRING_ARRAY;
        }
        return this.buildStringArray(resultSet);
    }

    public ExternalTableDescription[] getTableDescriptions(String catalogName, String schemaNamePattern, String tableNamePattern, String[] tableTypeNames) {
        ResultSet resultSet;
        if (catalogName != null) {
            try {
                this.getConnection().setCatalog(catalogName);
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        }
        try {
            resultSet = this.metaData().getTables(catalogName, schemaNamePattern, tableNamePattern, tableTypeNames);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        List tableDescriptions = CollectionTools.list(new ResultSetIterator(resultSet, new ExternalTableDescriptionResultSetAdapter()));
        return tableDescriptions.toArray(new ExternalTableDescription[tableDescriptions.size()]);
    }

    public ExternalTableDescription[] getTableDescriptions() {
        return this.getTableDescriptions(null, null, "%", null);
    }

    private Connection getConnection() {
        if (this.connection == null) {
            throw new IllegalStateException("not connected");
        }
        return this.connection;
    }

    DatabaseMetaData metaData() {
        try {
            return this.getConnection().getMetaData();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String toString() {
        return StringTools.buildToStringFor(this);
    }

    private String[] buildStringArray(ResultSet resultSet) {
        List strings = CollectionTools.list(new ResultSetIterator(resultSet, new StringResultSetAdapter()));
        return strings.toArray(new String[strings.size()]);
    }

    private class ExternalTableDescriptionResultSetAdapter
    implements ResultSetIterator.Adapter {
        private ExternalTableDescriptionResultSetAdapter() {
        }

        public Object buildNext(ResultSet rs) throws SQLException {
            return new JDBCExternalTableDescription(rs, JDBCExternalDatabase.this);
        }
    }

    private static class StringResultSetAdapter
    implements ResultSetIterator.Adapter {
        private StringResultSetAdapter() {
        }

        public Object buildNext(ResultSet rs) throws SQLException {
            String string = rs.getString(1);
            return string == null ? null : string.trim();
        }
    }
}

