/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.impl.HelperProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.internal.descriptors.InstantiationPolicy;
import org.eclipse.persistence.internal.descriptors.Namespace;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLAnyAttributeMapping;
import org.eclipse.persistence.oxm.mappings.XMLAnyCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.schema.XMLSchemaClassPathReference;
import org.eclipse.persistence.sdo.SDOConstants;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.helper.SDOClassLoader;
import org.eclipse.persistence.sdo.helper.SDOTypeHelper;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;
import org.eclipse.persistence.sdo.helper.SDOXSDHelper;
import org.eclipse.persistence.sdo.helper.extension.SDOUtil;

public class SDOType
implements Type,
Serializable {
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private QName qName;
    private boolean open;
    private boolean isAbstract;
    protected boolean isDataType;
    private List baseTypes;
    private List declaredProperties;
    private transient Map declaredPropertiesMap;
    private List aliasNames;
    private boolean xsd;
    private boolean xsdList;
    private String xsdLocalName;
    private QName xsdType;
    protected transient XMLDescriptor xmlDescriptor;
    private Map propertyValues;
    private SDOProperty changeSummaryProperty;
    private List allProperties;
    private SDOProperty[] allPropertiesArr;
    private List subTypes;
    private boolean finalized;
    private Class javaClass;
    private String javaClassName;
    private String javaImplClassName;
    protected Class javaImplClass;
    private List<SDOProperty> nonFinalizedReferencingProps;
    private List nonFinalizedMappingURIs;
    private Object pseudoDefault;
    protected HelperContext aHelperContext;
    private List appInfoElements;
    private Map appInfoMap;
    private static final String ANY_MAPPING_ATTRIBUTE_NAME = "openContentProperties";
    private static final String ANY_MAPPING_GET_METHOD_NAME = "_getOpenContentPropertiesWithXMLRoots";
    private static final String ANY_MAPPING_SET_METHOD_NAME = "_setOpenContentPropertiesWithXMLRoots";
    private static final String SDO_REF_MAPPING_ATTRIBUTE_NAME = "sdoRef";

    public SDOType(HelperContext helperContext) {
        this((SDOTypeHelper)helperContext.getTypeHelper());
    }

    public SDOType(SDOTypeHelper sdoTypeHelper) {
        this(sdoTypeHelper, new XMLDescriptor());
        this.xmlDescriptor.setLazilyInitialized(true);
    }

    protected SDOType(SDOTypeHelper sdoTypeHelper, XMLDescriptor xmlDescriptor) {
        this.xmlDescriptor = xmlDescriptor;
        if (null != sdoTypeHelper) {
            this.aHelperContext = sdoTypeHelper.getHelperContext();
            if (null != xmlDescriptor) {
                this.xmlDescriptor.setNamespaceResolver(sdoTypeHelper.getNamespaceResolver());
            }
        }
    }

    public SDOType(String uri, String type_name) {
        this(uri, type_name, (SDOTypeHelper)HelperProvider.getDefaultContext().getTypeHelper());
    }

    public SDOType(String uri, String name, SDOTypeHelper sdoTypeHelper) {
        this(sdoTypeHelper);
        if (null != uri) {
            uri = uri.intern();
        }
        if (null != name) {
            name = name.intern();
        }
        this.qName = new QName(uri, name);
    }

    protected SDOType(String uri, String name, SDOTypeHelper sdoTypeHelper, XMLDescriptor xmlDescriptor) {
        this(sdoTypeHelper, xmlDescriptor);
        if (null != uri) {
            uri = uri.intern();
        }
        if (null != name) {
            name = name.intern();
        }
        this.qName = new QName(uri, name);
    }

    public QName getQName() {
        return this.qName;
    }

    public void setQName(QName qName) {
        this.qName = qName;
    }

    public String getName() {
        return this.qName.getLocalPart();
    }

    public String getURI() {
        String uri = this.qName.getNamespaceURI();
        if ("".equals(uri)) {
            return null;
        }
        return uri;
    }

    public Class getInstanceClass() {
        if (this.javaClass == null && this.javaClassName != null) {
            try {
                SDOClassLoader loader = ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).getLoader();
                Class<?> clazz = loader.getParent().loadClass(this.javaClassName);
                this.javaClass = this.isValidInstanceClass(clazz) ? clazz : this.getClass();
            }
            catch (ClassNotFoundException e) {
                this.javaClass = this.getClass();
            }
            catch (SecurityException e) {
                throw SDOException.classNotFound(e, this.getURI(), this.getName());
            }
        }
        if (this.javaClass == this.getClass()) {
            return null;
        }
        return this.javaClass;
    }

    private boolean isValidInstanceClass(Class clazz) {
        if (this.isDataType) {
            return true;
        }
        if (!clazz.isInterface()) {
            return false;
        }
        for (Object object : this.getDeclaredProperties()) {
            SDOProperty sdoProperty = (SDOProperty)object;
            SDOType sdoPropertyType = sdoProperty.getType();
            if (sdoPropertyType.isChangeSummaryType()) continue;
            String javaType = SDOUtil.getJavaTypeForProperty(sdoProperty);
            try {
                String getMethodName = SDOUtil.getMethodName(sdoProperty.getName(), javaType);
                PrivilegedAccessHelper.getPublicMethod(clazz, getMethodName, EMPTY_CLASS_ARRAY, false);
            }
            catch (NoSuchMethodException e) {
                if (sdoPropertyType == SDOConstants.SDO_BOOLEAN || sdoPropertyType == SDOConstants.SDO_BOOLEANOBJECT) {
                    try {
                        String booleanGetterMethodName = SDOUtil.getBooleanGetMethodName(sdoProperty.getName(), javaType);
                        PrivilegedAccessHelper.getPublicMethod(clazz, booleanGetterMethodName, EMPTY_CLASS_ARRAY, false);
                        continue;
                    }
                    catch (NoSuchMethodException e2) {
                        return false;
                    }
                }
                return false;
            }
        }
        return true;
    }

    public boolean isInstance(Object object) {
        Type doType;
        if (!this.isDataType() && object instanceof DataObject && (doType = ((DataObject)object).getType()) != null) {
            return doType.equals(this);
        }
        Class instanceClass = this.getInstanceClass();
        if (instanceClass != null) {
            return instanceClass.isInstance(object);
        }
        return false;
    }

    public List getProperties() {
        if (this.allProperties == null) {
            this.allProperties = new ArrayList();
        }
        return this.allProperties;
    }

    public SDOProperty getProperty(String propertyName) {
        SDOProperty queriedProperty = (SDOProperty)this.getDeclaredPropertiesMap().get(propertyName);
        if (null == queriedProperty && this.isSubType()) {
            for (int i = 0; i < this.getBaseTypes().size() && (queriedProperty = ((SDOType)this.getBaseTypes().get(i)).getProperty(propertyName)) == null; ++i) {
            }
        }
        return queriedProperty;
    }

    public boolean isDataType() {
        return this.isDataType;
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isSequenced() {
        return this.xmlDescriptor.isSequencedObject();
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public List getBaseTypes() {
        if (this.baseTypes == null) {
            this.baseTypes = new ArrayList();
        }
        return this.baseTypes;
    }

    public boolean isSubType() {
        return null != this.baseTypes && !this.baseTypes.isEmpty();
    }

    public List getDeclaredProperties() {
        if (this.declaredProperties == null) {
            this.declaredProperties = new ArrayList();
        }
        return this.declaredProperties;
    }

    public List getAliasNames() {
        if (this.aliasNames == null) {
            this.aliasNames = new ArrayList();
        }
        return this.aliasNames;
    }

    public void addAliasName(String name) {
        this.getAliasNames().add(name);
        QName qname = new QName(this.getURI(), name);
        ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getTypesHashMap().put(qname, this);
    }

    public void setAliasNames(List names) {
        for (int i = 0; i < names.size(); ++i) {
            this.addAliasName((String)names.get(i));
        }
    }

    public void setOpen(boolean bOpen) {
        if (this.isDataType() && bOpen) {
            throw SDOException.typeCannotBeOpenAndDataType(this.getURI(), this.getName());
        }
        if (this.open != bOpen) {
            this.open = bOpen;
            if (this.open) {
                if (this.isSubType()) {
                    Type baseType = (Type)this.getBaseTypes().get(0);
                    if (!baseType.isOpen()) {
                        this.addOpenMappings();
                    }
                } else {
                    this.addOpenMappings();
                }
                if (this.isBaseType()) {
                    for (int i = 0; i < this.getSubTypes().size(); ++i) {
                        SDOType nextSubType = (SDOType)this.getSubTypes().get(i);
                        nextSubType.setOpen(bOpen);
                    }
                }
            }
        }
    }

    private void addOpenMappings() {
        XMLAnyCollectionMapping anyMapping = new XMLAnyCollectionMapping();
        anyMapping.setAttributeName(ANY_MAPPING_ATTRIBUTE_NAME);
        anyMapping.setGetMethodName(ANY_MAPPING_GET_METHOD_NAME);
        anyMapping.setSetMethodName(ANY_MAPPING_SET_METHOD_NAME);
        anyMapping.setUseXMLRoot(true);
        this.getXmlDescriptor().addMapping(anyMapping);
        XMLAnyAttributeMapping anyAttrMapping = new XMLAnyAttributeMapping();
        anyAttrMapping.setAttributeName("openContentPropertiesAttributes");
        anyAttrMapping.setGetMethodName("_getOpenContentPropertiesAttributesMap");
        anyAttrMapping.setSetMethodName("_setOpenContentPropertiesAttributesMap");
        this.getXmlDescriptor().addMapping(anyAttrMapping);
    }

    public void setAbstract(boolean makeAbstract) {
        this.isAbstract = makeAbstract;
    }

    public void setSequenced(boolean sequenced) {
        this.xmlDescriptor.setSequencedObject(sequenced);
    }

    public void setMixed(boolean isMixed) {
        String textAttribute = "text";
        XMLDirectMapping textMapping = (XMLDirectMapping)this.xmlDescriptor.getMappingForAttributeName(textAttribute);
        if (isMixed) {
            if (null == textMapping) {
                textMapping = new XMLDirectMapping();
                textMapping.setAttributeName(textAttribute);
                textMapping.setXPath("text()");
                this.xmlDescriptor.addMapping(textMapping);
            }
        } else {
            this.xmlDescriptor.removeMappingForAttributeName(textAttribute);
        }
    }

    public void setDataType(boolean datatype) {
        if (datatype && this.isOpen()) {
            throw SDOException.typeCannotBeOpenAndDataType(this.getURI(), this.getName());
        }
        this.isDataType = datatype;
        if (datatype) {
            this.setFinalized(true);
        }
    }

    public void setBaseTypes(List bTypes) {
        if (bTypes != null) {
            for (int i = 0; i < bTypes.size(); ++i) {
                this.addBaseType((SDOType)bTypes.get(i));
            }
        } else {
            this.baseTypes = null;
        }
    }

    public void addBaseType(SDOType type) {
        if (!this.getBaseTypes().contains(type)) {
            this.getBaseTypes().add(type);
            this.updateSubtypes(type);
            type.getSubTypes().add(this);
            if (type.isOpen() && this.isOpen()) {
                DatabaseMapping anyCollectionMapping = this.getXmlDescriptor().getMappingForAttributeName(ANY_MAPPING_ATTRIBUTE_NAME);
                this.getXmlDescriptor().getMappings().remove(anyCollectionMapping);
                DatabaseMapping anyAttrMapping = this.getXmlDescriptor().getMappingForAttributeName("openContentPropertiesAttributes");
                this.getXmlDescriptor().getMappings().remove(anyAttrMapping);
            }
        }
    }

    private void updateSubtypes(Type baseType) {
        this.getProperties().addAll(0, baseType.getProperties());
        if (this.isBaseType()) {
            for (int i = 0; i < this.getSubTypes().size(); ++i) {
                SDOType nextSubType = (SDOType)this.getSubTypes().get(i);
                nextSubType.updateSubtypes(baseType);
            }
        }
    }

    public void setInstanceClass(Class aClass) {
        this.javaClass = aClass;
        if (this.javaClass != null) {
            this.javaClassName = this.javaClass.getName();
        }
    }

    public void setXsd(boolean bXsd) {
        this.xsd = bXsd;
    }

    public boolean isXsd() {
        return this.xsd;
    }

    public void setXsdLocalName(String xsdLocalNameString) {
        this.xsdLocalName = xsdLocalNameString;
    }

    public String getXsdLocalName() {
        return this.xsdLocalName;
    }

    public void addDeclaredProperty(Property property) {
        this.addDeclaredProperty((SDOProperty)property);
    }

    public void addDeclaredProperty(SDOProperty property) {
        int end = this.getDeclaredProperties().size();
        this.addDeclaredProperty(property, end);
    }

    public void addDeclaredProperty(Property property, int index) {
        this.addDeclaredProperty((SDOProperty)property, index);
    }

    public void addDeclaredProperty(SDOProperty property, int index) {
        if (!this.getDeclaredPropertiesMap().containsKey(property.getName())) {
            int currentSize = this.getDeclaredProperties().size();
            int allSize = this.getProperties().size();
            int insertPlace = allSize - currentSize + index;
            if (this.isBaseType()) {
                for (int i = 0; i < this.getSubTypes().size(); ++i) {
                    SDOType nextSubType = (SDOType)this.getSubTypes().get(i);
                    nextSubType.updateIndices(insertPlace, property);
                }
            }
            this.getDeclaredProperties().add(index, property);
            this.getProperties().add(insertPlace, property);
            property.setContainingType(this);
            this.getDeclaredPropertiesMap().put(property.getName(), property);
            if (property.hasAliasNames()) {
                for (int j = 0; j < property.getAliasNames().size(); ++j) {
                    this.getDeclaredPropertiesMap().put(property.getAliasNames().get(j), property);
                }
            }
            if (property.getType() != null && property.getType().isChangeSummaryType()) {
                this.changeSummaryProperty = property;
            }
        }
    }

    public void removeDeclaredProperties(Property p) {
        this.getDeclaredProperties().remove(p);
        this.getDeclaredPropertiesMap().remove(p.getName());
        this.getProperties().remove(p);
    }

    public Map getDeclaredPropertiesMap() {
        if (null == this.declaredPropertiesMap) {
            this.declaredPropertiesMap = new HashMap();
        }
        return this.declaredPropertiesMap;
    }

    public void setInstanceClassName(String instanceClassName) {
        this.javaClassName = instanceClassName;
        this.javaClass = null;
    }

    public String getInstanceClassName() {
        if (this.javaClassName == null && this.javaClass != null) {
            this.javaClassName = this.javaClass.getName();
        }
        return this.javaClassName;
    }

    public void setXsdList(boolean anXsdList) {
        this.xsdList = anXsdList;
    }

    public boolean isXsdList() {
        return this.xsdList;
    }

    public void setXmlDescriptor(XMLDescriptor anXMLDescriptor) {
        this.xmlDescriptor = anXMLDescriptor;
    }

    public XMLDescriptor getXmlDescriptor() {
        return this.xmlDescriptor;
    }

    public void initializeNamespaces(List namespaceResolvers) {
        if (!this.isDataType()) {
            NamespaceResolver nr = new NamespaceResolver();
            if (namespaceResolvers != null) {
                for (int i = 0; i < namespaceResolvers.size(); ++i) {
                    NamespaceResolver nextNR = (NamespaceResolver)namespaceResolvers.get(i);
                    if (nextNR == null) continue;
                    int size = nextNR.getNamespaces().size();
                    for (int j = 0; j < size; ++j) {
                        Namespace nextNamespace = (Namespace)nextNR.getNamespaces().get(j);
                        if (nextNamespace.getPrefix().equals("xmlns") || nextNamespace.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") || nextNamespace.getNamespaceURI().equals("commonj.sdo/java") || nextNamespace.getNamespaceURI().equals("commonj.sdo/xml") || nextNamespace.getNamespaceURI().equals("commonj.sdo")) continue;
                        String newPrefix = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).addNamespace(nextNamespace.getPrefix(), nextNamespace.getNamespaceURI());
                        nr.put(newPrefix, nextNamespace.getNamespaceURI());
                    }
                }
            }
            this.xmlDescriptor.setNamespaceResolver(nr);
            if (this.getURI() != null) {
                String prefix = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getPrefix(this.getURI());
                this.xmlDescriptor.getNamespaceResolver().put(prefix, this.getURI());
            }
            this.xmlDescriptor.getNamespaceResolver().put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        }
    }

    private void addClassIndicator(XMLDescriptor xdesc, Class pCls, boolean isInheritanceRoot) {
        XMLField field = (XMLField)this.getXmlDescriptor().buildField("@xsi:type");
        xdesc.getInheritancePolicy().setClassIndicatorField(field);
        String parentIndicator = this.getName();
        String parentPrefix = xdesc.getNamespaceResolver().resolveNamespaceURI(this.getURI());
        if (parentPrefix != null) {
            parentIndicator = parentPrefix + ":" + parentIndicator;
        }
        xdesc.getInheritancePolicy().addClassIndicator(pCls, parentIndicator);
        if (xdesc.getMappingForAttributeName(SDO_REF_MAPPING_ATTRIBUTE_NAME) == null) {
            String sdoPrefix = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getPrefix("commonj.sdo");
            XMLDirectMapping sdoRefMapping = new XMLDirectMapping();
            sdoRefMapping.setAttributeName(SDO_REF_MAPPING_ATTRIBUTE_NAME);
            XMLField xmlField = new XMLField("@" + sdoPrefix + ":" + "ref");
            xmlField.getXPathFragment().setNamespaceURI("commonj.sdo");
            xmlField.getLastXPathFragment().setNamespaceURI("commonj.sdo");
            sdoRefMapping.setField(xmlField);
            xdesc.addMapping(sdoRefMapping);
        }
    }

    public void setupInheritance(SDOType parentType) {
        if (parentType == null) {
            this.addClassIndicator(this.getXmlDescriptor(), this.getImplClass(), true);
        } else if (parentType.getURI() != null && !parentType.getURI().equals("commonj.sdo")) {
            XMLDescriptor parentDescriptor;
            NamespaceResolver parentNR;
            if (!parentType.getXmlDescriptor().hasInheritance()) {
                this.addClassIndicator(parentType.getXmlDescriptor(), parentType.getImplClass(), false);
            }
            if ((parentNR = (parentDescriptor = (XMLDescriptor)parentType.getXmlDescriptor().getInheritancePolicy().getRootParentDescriptor()).getNonNullNamespaceResolver()) != null) {
                for (int i = 0; i < parentNR.getNamespaces().size(); ++i) {
                    Namespace nextNamespace = (Namespace)parentNR.getNamespaces().get(i);
                    if (nextNamespace.getPrefix().equals("xmlns") || nextNamespace.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") || nextNamespace.getNamespaceURI().equals("commonj.sdo/java") || nextNamespace.getNamespaceURI().equals("commonj.sdo/xml") || nextNamespace.getNamespaceURI().equals("commonj.sdo")) continue;
                    this.getXmlDescriptor().getNonNullNamespaceResolver().put(nextNamespace.getPrefix(), nextNamespace.getNamespaceURI());
                }
            }
            if (this.getInstanceClassName() != null) {
                String indicator = this.getName();
                String prefix = parentDescriptor.getNamespaceResolver().resolveNamespaceURI(this.getURI());
                if (prefix == null && (prefix = this.getXmlDescriptor().getNamespaceResolver().resolveNamespaceURI(this.getURI())) != null) {
                    parentDescriptor.getNamespaceResolver().put(prefix, this.getURI());
                }
                if (prefix != null) {
                    indicator = prefix + ":" + indicator;
                }
                Class implClass = this.getImplClass();
                parentDescriptor.getInheritancePolicy().addClassIndicator(implClass, indicator);
                parentDescriptor.getInheritancePolicy().setShouldReadSubclasses(true);
                Class parentClass = parentType.getImplClass();
                this.getXmlDescriptor().getInheritancePolicy().setParentClass(parentClass);
                this.getXmlDescriptor().getInheritancePolicy().setParentDescriptor(parentType.getXmlDescriptor());
                parentType.getXmlDescriptor().getNamespaceResolver().put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                this.getXmlDescriptor().getNamespaceResolver().put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            }
        }
        if (this.isBaseType()) {
            for (int i = 0; i < this.subTypes.size(); ++i) {
                SDOType nextSubType = (SDOType)this.subTypes.get(i);
                if (nextSubType.isDataType() || !nextSubType.isSubType()) continue;
                nextSubType.setupInheritance(this);
            }
        }
    }

    public void preInitialize(String packageName, List namespaceResolvers) {
        String prefix;
        String instanceClassName = this.getInstanceClassName();
        if (null == instanceClassName) {
            if (null == packageName) {
                String uri = this.getURI();
                packageName = null == uri ? SDOUtil.getDefaultPackageName() + "." : SDOUtil.getPackageNameFromURI(uri) + ".";
            }
            String mangledClassName = SDOUtil.className(this.getName(), true);
            StringBuffer fullClassName = new StringBuffer(packageName);
            fullClassName.append(mangledClassName);
            this.setInstanceClassName(fullClassName.toString());
        }
        AbstractSessionLog.getLog().log(2, "sdo_type_generation_processing_type", new Object[]{Helper.getShortClassName(this.getClass()), this.getInstanceClassName()});
        this.initializeNamespaces(namespaceResolvers);
        this.getXmlDescriptor().setJavaClassName(this.getImplClassName());
        String schemaContext = this.getName();
        if (this.getXmlDescriptor().getNamespaceResolver() != null && (prefix = this.getXmlDescriptor().getNamespaceResolver().resolveNamespaceURI(this.getURI())) != null && !prefix.equals("")) {
            schemaContext = prefix + ":" + schemaContext;
        }
        String schemaContextWithSlash = "/" + schemaContext;
        XMLSchemaClassPathReference schemaRef = new XMLSchemaClassPathReference();
        schemaRef.setSchemaContext(schemaContextWithSlash);
        schemaRef.setType(1);
        this.getXmlDescriptor().setSchemaReference(schemaRef);
    }

    public void postInitialize() {
        SDOProperty idProp;
        String idPropName = (String)this.get(SDOConstants.ID_PROPERTY);
        if (idPropName != null && (idProp = this.getProperty(idPropName)) != null) {
            String targetxpath = idProp.getQualifiedXPath(this.getURI(), true);
            this.getXmlDescriptor().addPrimaryKeyFieldName(targetxpath);
        }
        this.setFinalized(true);
        if (null != this.nonFinalizedReferencingProps) {
            for (int i = 0; i < this.nonFinalizedReferencingProps.size(); ++i) {
                SDOProperty nextProp = this.nonFinalizedReferencingProps.get(i);
                String nextURI = (String)this.getNonFinalizedMappingURIs().get(i);
                nextProp.buildMapping(nextURI, nextProp.getIndexInType());
            }
            this.nonFinalizedReferencingProps = null;
            this.nonFinalizedMappingURIs = null;
        }
        if (!(this.isDataType() || this.isSubType() || this.isBaseType())) {
            String sdoPrefix = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getPrefix("commonj.sdo");
            XMLDirectMapping sdoRefMapping = new XMLDirectMapping();
            sdoRefMapping.setAttributeName(SDO_REF_MAPPING_ATTRIBUTE_NAME);
            XMLField xmlField = new XMLField("@" + sdoPrefix + ":" + "ref");
            xmlField.getXPathFragment().setNamespaceURI("commonj.sdo");
            xmlField.getLastXPathFragment().setNamespaceURI("commonj.sdo");
            sdoRefMapping.setField(xmlField);
            this.xmlDescriptor.addMapping(sdoRefMapping);
        }
        if (!this.isDataType()) {
            this.getImplClass();
            if (!this.isAbstract() && !this.isWrapperType()) {
                TypeInstantiationPolicy tip = new TypeInstantiationPolicy(this);
                this.xmlDescriptor.setInstantiationPolicy(tip);
            }
        }
    }

    public void setImplClassName(String implClassName) {
        this.javaImplClassName = implClassName;
        this.javaImplClass = null;
    }

    public String getImplClassName() {
        if (this.javaImplClassName == null && this.javaClassName != null) {
            this.javaImplClassName = this.javaClassName + "Impl";
        }
        return this.javaImplClassName;
    }

    public Class getImplClass() {
        if (this.javaImplClass == null && this.getImplClassName() != null) {
            try {
                SDOClassLoader loader = ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).getLoader();
                this.javaImplClass = loader.loadClass(this.getImplClassName(), this);
                this.xmlDescriptor.setJavaClass(this.javaImplClass);
            }
            catch (ClassNotFoundException e) {
                throw SDOException.classNotFound(e, this.getURI(), this.getName());
            }
            catch (SecurityException e) {
                throw SDOException.classNotFound(e, this.getURI(), this.getName());
            }
        }
        return this.javaImplClass;
    }

    public Object get(Property property) {
        if (null == this.propertyValues) {
            return null;
        }
        return this.propertyValues.get(property);
    }

    public List getInstanceProperties() {
        if (null == this.propertyValues) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList(this.getPropertyValues().keySet());
    }

    public void setPropertyValues(Map properties) {
        this.propertyValues = properties;
    }

    public Map getPropertyValues() {
        if (this.propertyValues == null) {
            this.propertyValues = new HashMap();
        }
        return this.propertyValues;
    }

    public void setInstanceProperty(Property property, Object value) {
        if (property.equals(SDOConstants.JAVA_CLASS_PROPERTY) && value instanceof String) {
            this.setInstanceClassName((String)value);
        }
        this.getPropertyValues().put(property, value);
    }

    public SDOProperty getChangeSummaryProperty() {
        return this.changeSummaryProperty;
    }

    public SDOProperty[] getPropertiesArray() {
        if (this.allPropertiesArr == null || this.allPropertiesArr.length != this.getProperties().size()) {
            List l = this.getProperties();
            int s = l == null ? 0 : l.size();
            this.allPropertiesArr = s > 0 ? l.toArray(new SDOProperty[s]) : new SDOProperty[0];
        }
        return this.allPropertiesArr;
    }

    public void setSubTypes(List subTypesList) {
        this.subTypes = subTypesList;
    }

    public List getSubTypes() {
        if (this.subTypes == null) {
            this.subTypes = new ArrayList();
        }
        return this.subTypes;
    }

    public boolean isBaseType() {
        return null != this.subTypes && !this.subTypes.isEmpty();
    }

    private void updateIndices(int insertPosition, Property property) {
        int declaredSize = this.getDeclaredProperties().size();
        SDOProperty nextProp = null;
        for (int i = 0; i < declaredSize; ++i) {
            nextProp = (SDOProperty)this.getDeclaredProperties().get(i);
            nextProp.setIndexInType(nextProp.getIndexInType() + 1);
        }
        this.getProperties().add(insertPosition, property);
        if (this.isBaseType()) {
            int subTypesSize = this.getSubTypes().size();
            SDOType nextSubType = null;
            for (int i = 0; i < subTypesSize; ++i) {
                nextSubType = (SDOType)this.getSubTypes().get(i);
                nextSubType.updateIndices(insertPosition, property);
            }
        }
    }

    public void setXsdType(QName xsdTypeQName) {
        this.xsdType = xsdTypeQName;
    }

    public QName getXsdType() {
        return this.xsdType;
    }

    public void setFinalized(boolean bFinalized) {
        this.finalized = bFinalized;
    }

    public boolean isFinalized() {
        return this.finalized;
    }

    public void setNonFinalizedReferencingProps(List nonFinalizedReferencingProps) {
        this.nonFinalizedReferencingProps = nonFinalizedReferencingProps;
    }

    public List getNonFinalizedReferencingProps() {
        if (this.nonFinalizedReferencingProps == null) {
            this.nonFinalizedReferencingProps = new ArrayList<SDOProperty>();
        }
        return this.nonFinalizedReferencingProps;
    }

    public void setNonFinalizedMappingURIs(List nonFinalizedMappingURIsList) {
        this.nonFinalizedMappingURIs = nonFinalizedMappingURIsList;
    }

    public List getNonFinalizedMappingURIs() {
        if (this.nonFinalizedMappingURIs == null) {
            this.nonFinalizedMappingURIs = new ArrayList();
        }
        return this.nonFinalizedMappingURIs;
    }

    public void setAppInfoElements(List appInfoElementsList) {
        this.appInfoElements = appInfoElementsList;
    }

    public List getAppInfoElements() {
        return this.appInfoElements;
    }

    public Map getAppInfoMap() {
        if (this.appInfoMap == null) {
            this.appInfoMap = ((SDOXSDHelper)this.aHelperContext.getXSDHelper()).buildAppInfoMap(this.appInfoElements);
        }
        return this.appInfoMap;
    }

    public Object getPseudoDefault() {
        return this.pseudoDefault;
    }

    public void setPseudoDefault(Object anObject) {
        this.pseudoDefault = anObject;
    }

    public HelperContext getHelperContext() {
        return this.aHelperContext;
    }

    public boolean isChangeSummaryType() {
        return false;
    }

    public boolean isDataObjectType() {
        return false;
    }

    public boolean isTypeType() {
        return false;
    }

    public boolean isOpenSequencedType() {
        return false;
    }

    public boolean isWrapperType() {
        return false;
    }

    public static class TypeInstantiationPolicy
    extends InstantiationPolicy {
        SDOType sdoType;

        public TypeInstantiationPolicy(SDOType type) {
            this.sdoType = type;
        }

        public Object buildNewInstance() throws DescriptorException {
            return this.sdoType.getHelperContext().getDataFactory().create((Type)this.sdoType);
        }
    }
}

