/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.io.File;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.validation.Schema;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jaxb.WrappedValue;
import org.eclipse.persistence.internal.jaxb.many.ManyValue;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.JAXBErrorHandler;
import org.eclipse.persistence.jaxb.JAXBIntrospector;
import org.eclipse.persistence.jaxb.JAXBMarshalListener;
import org.eclipse.persistence.jaxb.JAXBTypeElement;
import org.eclipse.persistence.jaxb.TypeMappingInfo;
import org.eclipse.persistence.jaxb.attachment.AttachmentMarshallerAdapter;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.record.XMLEventWriterRecord;
import org.eclipse.persistence.oxm.record.XMLStreamWriterRecord;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBMarshaller
implements Marshaller {
    private ValidationEventHandler validationEventHandler = new DefaultValidationEventHandler();
    private XMLMarshaller xmlMarshaller;
    private JAXBContext jaxbContext;
    public static final String XML_JAVATYPE_ADAPTERS = "xml-javatype-adapters";
    private static final String XML_DECLARATION = "com.sun.xml.bind.xmlDeclaration";

    public JAXBMarshaller(XMLMarshaller newXMLMarshaller, JAXBIntrospector newIntrospector) {
        this.xmlMarshaller = newXMLMarshaller;
        this.xmlMarshaller.setEncoding("UTF-8");
        this.xmlMarshaller.setFormattedOutput(false);
        JAXBMarshalListener listener = new JAXBMarshalListener(this);
        this.xmlMarshaller.setMarshalListener(listener);
    }

    private XMLRoot createXMLRootFromJAXBElement(JAXBElement elt) {
        Type objectType;
        Class theClass;
        XMLRoot xmlroot = new XMLRoot();
        Object objectValue = elt.getValue();
        xmlroot.setObject(objectValue);
        QName qname = elt.getName();
        xmlroot.setLocalName(qname.getLocalPart());
        xmlroot.setNamespaceURI(qname.getNamespaceURI());
        xmlroot.setDeclaredType(elt.getDeclaredType());
        xmlroot.setNil(elt.isNil());
        if (elt.getDeclaredType() == ClassConstants.ABYTE || elt.getDeclaredType() == ClassConstants.APBYTE || elt.getDeclaredType().getCanonicalName().equals("javax.activation.DataHandler") || elt.getDeclaredType().isEnum()) {
            Class generatedClass = this.getClassToGeneratedClasses().get(elt.getDeclaredType().getCanonicalName());
            if (!elt.getDeclaredType().isEnum()) {
                xmlroot.setSchemaType(XMLConstants.BASE_64_BINARY_QNAME);
            }
            if (generatedClass != null && WrappedValue.class.isAssignableFrom(generatedClass)) {
                ClassDescriptor desc = this.xmlMarshaller.getXMLContext().getSession(generatedClass).getDescriptor(generatedClass);
                Object newObject = desc.getInstantiationPolicy().buildNewInstance();
                ((WrappedValue)((Object)newObject)).setValue(objectValue);
                xmlroot.setObject(newObject);
                return xmlroot;
            }
        } else {
            xmlroot.setSchemaType((QName)XMLConversionManager.getDefaultJavaTypes().get(elt.getDeclaredType()));
        }
        if (elt instanceof WrappedValue) {
            xmlroot.setObject(elt);
            return xmlroot;
        }
        Map<QName, Class> qNameToGeneratedClasses = this.jaxbContext.getQNameToGeneratedClasses();
        if (qNameToGeneratedClasses != null && (theClass = qNameToGeneratedClasses.get(qname)) != null && WrappedValue.class.isAssignableFrom(theClass)) {
            ClassDescriptor desc = this.xmlMarshaller.getXMLContext().getSession(theClass).getDescriptor(theClass);
            Object newObject = desc.getInstantiationPolicy().buildNewInstance();
            ((WrappedValue)((Object)newObject)).setValue(objectValue);
            xmlroot.setObject(newObject);
            return xmlroot;
        }
        Class generatedClass = null;
        if (this.jaxbContext.getTypeMappingInfoToGeneratedType() != null) {
            if (this.jaxbContext.getTypeToTypeMappingInfo() != null) {
                if (elt.getDeclaredType() != null && elt.getDeclaredType().isArray()) {
                    TypeMappingInfo tmi = this.jaxbContext.getTypeToTypeMappingInfo().get(elt.getDeclaredType());
                    generatedClass = this.jaxbContext.getTypeMappingInfoToGeneratedType().get(tmi);
                } else if (elt instanceof JAXBTypeElement) {
                    objectType = ((JAXBTypeElement)elt).getType();
                    TypeMappingInfo tmi = this.jaxbContext.getTypeToTypeMappingInfo().get(objectType);
                    generatedClass = this.jaxbContext.getTypeMappingInfoToGeneratedType().get(tmi);
                }
            }
        } else if (elt.getDeclaredType() != null && elt.getDeclaredType().isArray()) {
            if (this.jaxbContext.getArrayClassesToGeneratedClasses() != null) {
                generatedClass = this.jaxbContext.getArrayClassesToGeneratedClasses().get(elt.getDeclaredType().getCanonicalName());
            }
        } else if (elt instanceof JAXBTypeElement) {
            objectType = ((JAXBTypeElement)elt).getType();
            generatedClass = this.jaxbContext.getCollectionClassesToGeneratedClasses().get(objectType);
        }
        if (generatedClass != null) {
            ClassDescriptor desc = this.xmlMarshaller.getXMLContext().getSession(generatedClass).getDescriptor(generatedClass);
            Object newObject = desc.getInstantiationPolicy().buildNewInstance();
            ((ManyValue)newObject).setItem(objectValue);
            xmlroot.setObject(newObject);
        }
        return xmlroot;
    }

    public XmlAdapter getAdapter(Class javaClass) {
        HashMap result = (HashMap)this.xmlMarshaller.getProperty(XML_JAVATYPE_ADAPTERS);
        if (result == null) {
            return null;
        }
        return (XmlAdapter)result.get(javaClass);
    }

    public AttachmentMarshaller getAttachmentMarshaller() {
        if (this.xmlMarshaller.getAttachmentMarshaller() == null) {
            return null;
        }
        return ((AttachmentMarshallerAdapter)this.xmlMarshaller.getAttachmentMarshaller()).getAttachmentMarshaller();
    }

    public ValidationEventHandler getEventHandler() throws JAXBException {
        return this.validationEventHandler;
    }

    public Marshaller.Listener getListener() {
        return ((JAXBMarshalListener)this.xmlMarshaller.getMarshalListener()).getListener();
    }

    public Node getNode(Object object) throws JAXBException {
        throw new UnsupportedOperationException();
    }

    public Object getProperty(String key) throws PropertyException {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if ("jaxb.formatted.output".equals(key)) {
            return this.xmlMarshaller.isFormattedOutput();
        }
        if ("jaxb.encoding".equals(key)) {
            return this.xmlMarshaller.getEncoding();
        }
        if ("jaxb.schemaLocation".equals(key)) {
            return this.xmlMarshaller.getSchemaLocation();
        }
        if ("jaxb.noNamespaceSchemaLocation".equals(key)) {
            return this.xmlMarshaller.getNoNamespaceSchemaLocation();
        }
        if ("jaxb.fragment".equals(key)) {
            return this.xmlMarshaller.isFragment();
        }
        throw new PropertyException(key);
    }

    public Schema getSchema() {
        return this.xmlMarshaller.getSchema();
    }

    public void marshal(Object object, ContentHandler contentHandler) throws JAXBException {
        if (object == null || contentHandler == null) {
            throw new IllegalArgumentException();
        }
        if (object instanceof JAXBElement) {
            object = this.createXMLRootFromJAXBElement((JAXBElement)object);
        }
        try {
            this.xmlMarshaller.marshal(object, contentHandler);
        }
        catch (Exception e) {
            throw new MarshalException((Throwable)e);
        }
    }

    public void marshal(Object object, XMLEventWriter eventWriter) throws JAXBException {
        if (object == null || eventWriter == null) {
            throw new IllegalArgumentException();
        }
        if (object instanceof JAXBElement) {
            object = this.createXMLRootFromJAXBElement((JAXBElement)object);
        }
        try {
            XMLEventWriterRecord record = new XMLEventWriterRecord(eventWriter);
            record.setMarshaller(this.xmlMarshaller);
            this.xmlMarshaller.marshal(object, record);
        }
        catch (Exception ex) {
            throw new MarshalException((Throwable)ex);
        }
    }

    public void marshal(Object object, XMLEventWriter eventWriter, TypeMappingInfo type) throws JAXBException {
        if (this.jaxbContext.getTypeMappingInfoToGeneratedType() == null) {
            this.marshal(object, eventWriter);
        } else {
            JAXBContext.RootLevelXmlAdapter adapter;
            JAXBElement element = null;
            Object value = object;
            if (object instanceof JAXBElement) {
                element = (JAXBElement)object;
                value = element.getValue();
            }
            if ((adapter = this.jaxbContext.getTypeMappingInfoToJavaTypeAdapters().get(type)) != null) {
                try {
                    value = adapter.getXmlAdapter().marshal(value);
                }
                catch (Exception ex) {
                    throw new JAXBException((Throwable)XMLMarshalException.marshalException(ex));
                }
            }
            value = this.wrapObject(value, element, type);
            this.marshal(value, eventWriter);
        }
    }

    public void marshal(Object object, Node node) throws JAXBException {
        if (object == null || node == null) {
            throw new IllegalArgumentException();
        }
        if (object instanceof JAXBElement) {
            object = this.createXMLRootFromJAXBElement((JAXBElement)object);
        }
        try {
            this.xmlMarshaller.marshal(object, node);
        }
        catch (Exception e) {
            throw new MarshalException((Throwable)e);
        }
    }

    public void marshal(Object object, OutputStream outputStream) throws JAXBException {
        if (object == null || outputStream == null) {
            throw new IllegalArgumentException();
        }
        if (object instanceof JAXBElement) {
            object = this.createXMLRootFromJAXBElement((JAXBElement)object);
        }
        try {
            this.xmlMarshaller.marshal(object, outputStream);
        }
        catch (Exception e) {
            throw new MarshalException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Object object, File file) throws JAXBException {
        try {
            FileWriter writer = new FileWriter(file);
            try {
                this.marshal(object, writer);
            }
            finally {
                writer.close();
            }
        }
        catch (Exception ex) {
            throw new MarshalException((Throwable)ex);
        }
    }

    public void marshal(Object object, Result result) throws JAXBException {
        if (object == null || result == null) {
            throw new IllegalArgumentException();
        }
        if (object instanceof JAXBElement) {
            object = this.createXMLRootFromJAXBElement((JAXBElement)object);
        }
        try {
            this.xmlMarshaller.marshal(object, result);
        }
        catch (Exception e) {
            throw new MarshalException((Throwable)e);
        }
    }

    public void marshal(Object object, Result result, TypeMappingInfo type) throws JAXBException {
        if (this.jaxbContext.getTypeMappingInfoToGeneratedType() == null) {
            this.marshal(object, result);
        } else {
            JAXBContext.RootLevelXmlAdapter adapter;
            JAXBElement element = null;
            Object value = object;
            if (object instanceof JAXBElement) {
                element = (JAXBElement)object;
                value = element.getValue();
            }
            if ((adapter = this.jaxbContext.getTypeMappingInfoToJavaTypeAdapters().get(type)) != null) {
                try {
                    value = adapter.getXmlAdapter().marshal(value);
                }
                catch (Exception ex) {
                    throw new JAXBException((Throwable)XMLMarshalException.marshalException(ex));
                }
            }
            value = this.wrapObject(value, element, type);
            this.marshal(value, result);
        }
    }

    public void marshal(Object object, XMLStreamWriter streamWriter) throws JAXBException {
        if (object == null || streamWriter == null) {
            throw new IllegalArgumentException();
        }
        if (object instanceof JAXBElement) {
            object = this.createXMLRootFromJAXBElement((JAXBElement)object);
        }
        try {
            XMLStreamWriterRecord record = new XMLStreamWriterRecord(streamWriter);
            record.setMarshaller(this.xmlMarshaller);
            this.xmlMarshaller.marshal(object, record);
        }
        catch (Exception ex) {
            throw new MarshalException((Throwable)ex);
        }
    }

    public void marshal(Object object, XMLStreamWriter streamWriter, TypeMappingInfo type) throws JAXBException {
        if (this.jaxbContext.getTypeMappingInfoToGeneratedType() == null) {
            this.marshal(object, streamWriter);
        } else {
            JAXBContext.RootLevelXmlAdapter adapter;
            JAXBElement element = null;
            Object value = object;
            if (object instanceof JAXBElement) {
                element = (JAXBElement)object;
                value = element.getValue();
            }
            if ((adapter = this.jaxbContext.getTypeMappingInfoToJavaTypeAdapters().get(type)) != null) {
                try {
                    value = adapter.getXmlAdapter().marshal(value);
                }
                catch (Exception ex) {
                    throw new JAXBException((Throwable)XMLMarshalException.marshalException(ex));
                }
            }
            value = this.wrapObject(value, element, type);
            this.marshal(value, streamWriter);
        }
    }

    private Object wrapObject(Object object, JAXBElement wrapperElement, TypeMappingInfo typeMappingInfo) {
        Object newObject;
        ClassDescriptor desc;
        Class generatedClass = this.jaxbContext.getTypeMappingInfoToGeneratedType().get(typeMappingInfo);
        if (generatedClass != null && object == null && wrapperElement != null) {
            return this.wrapObjectInXMLRoot(wrapperElement, object);
        }
        if (generatedClass != null && WrappedValue.class.isAssignableFrom(generatedClass)) {
            desc = this.xmlMarshaller.getXMLContext().getSession(generatedClass).getDescriptor(generatedClass);
            newObject = desc.getInstantiationPolicy().buildNewInstance();
            ((WrappedValue)((Object)newObject)).setValue(object);
            object = newObject;
        } else if (generatedClass != null) {
            desc = this.xmlMarshaller.getXMLContext().getSession(generatedClass).getDescriptor(generatedClass);
            newObject = desc.getInstantiationPolicy().buildNewInstance();
            ((ManyValue)newObject).setItem(object);
            object = newObject;
        }
        if (null == wrapperElement) {
            XMLRoot xmlRoot = new XMLRoot();
            QName xmlTagName = typeMappingInfo.getXmlTagName();
            if (null == xmlTagName) {
                return object;
            }
            xmlRoot.setNamespaceURI(typeMappingInfo.getXmlTagName().getNamespaceURI());
            xmlRoot.setLocalName(typeMappingInfo.getXmlTagName().getLocalPart());
            xmlRoot.setObject(object);
            return xmlRoot;
        }
        return this.wrapObjectInXMLRoot(wrapperElement, object);
    }

    private XMLRoot wrapObjectInXMLRoot(JAXBElement wrapperElement, Object value) {
        XMLRoot xmlroot = new XMLRoot();
        Object objectValue = value;
        xmlroot.setObject(objectValue);
        QName qname = wrapperElement.getName();
        xmlroot.setLocalName(qname.getLocalPart());
        xmlroot.setNamespaceURI(qname.getNamespaceURI());
        xmlroot.setDeclaredType(wrapperElement.getDeclaredType());
        if (value != null && (value.getClass() == ClassConstants.ABYTE || value.getClass() == ClassConstants.APBYTE || value.getClass().getCanonicalName().equals("javax.activation.DataHandler"))) {
            xmlroot.setSchemaType(XMLConstants.BASE_64_BINARY_QNAME);
        }
        return xmlroot;
    }

    public void marshal(Object object, Writer writer) throws JAXBException {
        if (object == null || writer == null) {
            throw new IllegalArgumentException();
        }
        if (object instanceof JAXBElement) {
            object = this.createXMLRootFromJAXBElement((JAXBElement)object);
        }
        try {
            this.xmlMarshaller.marshal(object, writer);
        }
        catch (Exception e) {
            throw new MarshalException((Throwable)e);
        }
    }

    public void marshal(Object object, MarshalRecord record) throws JAXBException {
        if (object == null || record == null) {
            throw new IllegalArgumentException();
        }
        if (object instanceof JAXBElement) {
            object = this.createXMLRootFromJAXBElement((JAXBElement)object);
        }
        try {
            record.setMarshaller(this.xmlMarshaller);
            this.xmlMarshaller.marshal(object, record);
        }
        catch (Exception e) {
            throw new MarshalException((Throwable)e);
        }
    }

    public void marshal(Object object, MarshalRecord record, TypeMappingInfo type) throws JAXBException {
        if (this.jaxbContext.getTypeMappingInfoToGeneratedType() == null) {
            this.marshal(object, record);
        } else {
            JAXBContext.RootLevelXmlAdapter adapter;
            JAXBElement element = null;
            Object value = object;
            if (object instanceof JAXBElement) {
                element = (JAXBElement)object;
                value = element.getValue();
            }
            if ((adapter = this.jaxbContext.getTypeMappingInfoToJavaTypeAdapters().get(type)) != null) {
                try {
                    value = adapter.getXmlAdapter().marshal(value);
                }
                catch (Exception ex) {
                    throw new JAXBException((Throwable)XMLMarshalException.marshalException(ex));
                }
            }
            value = this.wrapObject(value, element, type);
            this.marshal(value, record);
        }
    }

    public void setAdapter(Class javaClass, XmlAdapter adapter) {
        HashMap<Class, XmlAdapter> result = (HashMap<Class, XmlAdapter>)this.xmlMarshaller.getProperty(XML_JAVATYPE_ADAPTERS);
        if (result == null) {
            result = new HashMap<Class, XmlAdapter>();
            this.xmlMarshaller.getProperties().put(XML_JAVATYPE_ADAPTERS, result);
        }
        result.put(javaClass, adapter);
    }

    public void setAdapter(XmlAdapter adapter) {
        this.setAdapter(adapter.getClass(), adapter);
    }

    public void setAttachmentMarshaller(AttachmentMarshaller attachmentMarshaller) {
        if (attachmentMarshaller == null) {
            this.xmlMarshaller.setAttachmentMarshaller(null);
        } else {
            this.xmlMarshaller.setAttachmentMarshaller(new AttachmentMarshallerAdapter(attachmentMarshaller));
        }
    }

    public void setEventHandler(ValidationEventHandler newValidationEventHandler) throws JAXBException {
        this.validationEventHandler = null == newValidationEventHandler ? new DefaultValidationEventHandler() : newValidationEventHandler;
        this.xmlMarshaller.setErrorHandler(new JAXBErrorHandler(this.validationEventHandler));
    }

    public void setListener(Marshaller.Listener listener) {
        ((JAXBMarshalListener)this.xmlMarshaller.getMarshalListener()).setListener(listener);
    }

    public void setMarshalCallbacks(HashMap callbacks) {
        ((JAXBMarshalListener)this.xmlMarshaller.getMarshalListener()).setClassBasedMarshalEvents(callbacks);
    }

    public void setProperty(String key, Object value) throws PropertyException {
        block9: {
            try {
                if (key == null) {
                    throw new IllegalArgumentException();
                }
                if ("jaxb.formatted.output".equals(key)) {
                    Boolean formattedOutput = (Boolean)value;
                    this.xmlMarshaller.setFormattedOutput(formattedOutput);
                    break block9;
                }
                if ("jaxb.encoding".equals(key)) {
                    this.xmlMarshaller.setEncoding((String)value);
                    break block9;
                }
                if ("jaxb.schemaLocation".equals(key)) {
                    this.xmlMarshaller.setSchemaLocation((String)value);
                    break block9;
                }
                if ("jaxb.noNamespaceSchemaLocation".equals(key)) {
                    this.xmlMarshaller.setNoNamespaceSchemaLocation((String)value);
                    break block9;
                }
                if ("jaxb.fragment".equals(key)) {
                    Boolean fragment = (Boolean)value;
                    this.xmlMarshaller.setFragment(fragment);
                    break block9;
                }
                if (XML_DECLARATION.equals(key)) {
                    Boolean fragment = (Boolean)value == false;
                    this.xmlMarshaller.setFragment(fragment);
                    break block9;
                }
                throw new PropertyException(key, value);
            }
            catch (ClassCastException exception) {
                throw new PropertyException(key, (Throwable)exception);
            }
        }
    }

    public void setSchema(Schema schema) {
        this.xmlMarshaller.setSchema(schema);
    }

    private HashMap<String, Class> getClassToGeneratedClasses() {
        return this.jaxbContext.getClassToGeneratedClasses();
    }

    public JAXBContext getJaxbContext() {
        return this.jaxbContext;
    }

    public void setJaxbContext(JAXBContext jaxbContext) {
        this.jaxbContext = jaxbContext;
    }

    public XMLMarshaller getXMLMarshaller() {
        return this.xmlMarshaller;
    }
}

