/*******************************************************************************
 * Copyright (c) 1998, 2011 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the 
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0 
 * which accompanies this distribution. 
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at 
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation from Oracle TopLink
 ******************************************************************************/  
package org.eclipse.persistence.testing.tests.remote;

import org.eclipse.persistence.tools.schemaframework.*;

/**
 * This class was generated by the TopLink table creator generator.
 * It stores the meta-data (tables) that define the database schema.
 * @see org.eclipse.persistence.sessions.factories.TableCreatorClassGenerator
 */
public class MasterSlaveTableCreator extends TableCreator {

    public MasterSlaveTableCreator() {
        setName("MasterSlave");

        addTableDefinition(buildMASTERTable());
        addTableDefinition(buildSLAVETable());
    }

    public TableDefinition buildMASTERTable() {
        TableDefinition table = new TableDefinition();
        table.setName("MASTER");

        FieldDefinition fieldid = new FieldDefinition();
        fieldid.setName("id");
        fieldid.setTypeName("NUMBER");
        fieldid.setSize(18);
        fieldid.setSubSize(0);
        fieldid.setIsPrimaryKey(true);
        fieldid.setIsIdentity(false);
        fieldid.setUnique(false);
        fieldid.setShouldAllowNull(false);
        table.addField(fieldid);

        return table;
    }

    public TableDefinition buildSLAVETable() {
        TableDefinition table = new TableDefinition();
        table.setName("SLAVE");

        FieldDefinition fieldid = new FieldDefinition();
        fieldid.setName("id");
        fieldid.setTypeName("NUMBER");
        fieldid.setSize(18);
        fieldid.setSubSize(0);
        fieldid.setIsPrimaryKey(true);
        fieldid.setIsIdentity(false);
        fieldid.setUnique(false);
        fieldid.setShouldAllowNull(false);
        table.addField(fieldid);

        FieldDefinition fieldmid = new FieldDefinition();
        fieldmid.setName("mid");
        fieldmid.setTypeName("NUMBER");
        fieldmid.setSize(18);
        fieldmid.setSubSize(0);
        fieldmid.setIsPrimaryKey(false);
        fieldmid.setIsIdentity(false);
        fieldmid.setUnique(false);
        fieldmid.setShouldAllowNull(true);
        table.addField(fieldmid);

        return table;
    }

}

