/*******************************************************************************
 * Copyright (c) 2011 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Praba Vijayaratnam - 2.3 - initial implementation
 ******************************************************************************/
package org.eclipse.persistence.testing.jaxb.javadoc.xmlelementwrapper;

import java.util.ArrayList;
import java.util.List;
import java.io.IOException;

import org.eclipse.persistence.testing.jaxb.JAXBTestCases;

public class XmlElementWrapperTest extends JAXBTestCases{

	private final static String XML_RESOURCE = "org/eclipse/persistence/testing/jaxb/javadoc/xmlelementwrapper/xmlelementwrapper.xml";
	
	public XmlElementWrapperTest(String name) throws Exception {
		super(name);
		setControlDocument(XML_RESOURCE);
		Class[] classes = new Class[1];
		classes[0] = Hockey.class;
		setClasses(classes);
	}

	protected Object getControlObject() {

		Hockey example = new Hockey();
		List<String> clubs = new ArrayList();
		clubs.add("Habs");
		clubs.add("Leafs");
		clubs.add("Sens");
		clubs.add("Flames");
		clubs.add("Oilers");
		clubs.add("Canucks");
		example.team = clubs;
        return example;
	}


}
