/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.LoadState;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.ProviderUtil;
import org.eclipse.persistence.exceptions.PersistenceUnitLoadingException;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryProvider;
import org.eclipse.persistence.internal.jpa.EntityManagerSetupImpl;
import org.eclipse.persistence.internal.jpa.deployment.JPAInitializer;
import org.eclipse.persistence.internal.jpa.deployment.JavaSECMPInitializer;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;

public class PersistenceProvider
implements javax.persistence.spi.PersistenceProvider,
ProviderUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityManagerFactory createEntityManagerFactory(String emName, Map properties) {
        Object object;
        String sessionName;
        String uniqueName;
        boolean isNew;
        EntityManagerSetupImpl emSetupImpl;
        Map nonNullProperties;
        block23: {
            nonNullProperties = properties == null ? new HashMap() : properties;
            String name = emName;
            if (name == null) {
                name = "";
            }
            emSetupImpl = null;
            isNew = false;
            uniqueName = null;
            sessionName = null;
            JPAInitializer initializer = this.getInitializer(emName, nonNullProperties);
            try {
                SEPersistenceUnitInfo puInfo = initializer.findPersistenceUnitInfo(name, nonNullProperties);
                if (puInfo == null) {
                    return null;
                }
                if (EntityManagerSetupImpl.mustBeCompositeMember(puInfo)) {
                    emSetupImpl = new EntityManagerSetupImpl(name, name);
                    emSetupImpl.predeploy(puInfo, nonNullProperties);
                    isNew = true;
                    break block23;
                }
                uniqueName = initializer.isPersistenceUnitUniquelyDefinedByName() ? name : initializer.createUniquePersistenceUnitName(puInfo);
                sessionName = EntityManagerSetupImpl.getOrBuildSessionName(nonNullProperties, puInfo, uniqueName);
                object = EntityManagerFactoryProvider.emSetupImpls;
                synchronized (object) {
                    emSetupImpl = EntityManagerFactoryProvider.getEntityManagerSetupImpl(sessionName);
                    if (emSetupImpl == null) {
                        emSetupImpl = initializer.extractInitialEmSetupImpl(name);
                        if (emSetupImpl != null) {
                            emSetupImpl.changeSessionName(sessionName);
                        } else {
                            emSetupImpl = initializer.callPredeploy(puInfo, nonNullProperties, uniqueName, sessionName);
                        }
                        emSetupImpl.predeploy(emSetupImpl.getPersistenceUnitInfo(), nonNullProperties);
                        EntityManagerFactoryProvider.addEntityManagerSetupImpl(sessionName, emSetupImpl);
                        isNew = true;
                    }
                }
            }
            catch (Exception e) {
                throw PersistenceUnitLoadingException.exceptionSearchingForPersistenceResources((ClassLoader)initializer.getInitializationClassLoader(), (Exception)e);
            }
        }
        if (!isNew) {
            if (!uniqueName.equals(emSetupImpl.getPersistenceUnitUniqueName())) {
                throw PersistenceUnitLoadingException.sessionNameAlreadyInUse((String)sessionName, (String)uniqueName, (String)emSetupImpl.getPersistenceUnitUniqueName());
            }
            boolean undeployed = false;
            object = emSetupImpl;
            synchronized (object) {
                if (emSetupImpl.isUndeployed()) {
                    undeployed = true;
                }
                emSetupImpl.predeploy(emSetupImpl.getPersistenceUnitInfo(), nonNullProperties);
            }
            if (undeployed) {
                return this.createEntityManagerFactory(emName, properties);
            }
        }
        EntityManagerFactoryImpl factory = null;
        try {
            factory = new EntityManagerFactoryImpl(emSetupImpl, nonNullProperties);
            if (emSetupImpl.shouldGetSessionOnCreateFactory(nonNullProperties)) {
                factory.getDatabaseSession();
            }
            return factory;
        }
        catch (RuntimeException ex) {
            if (factory != null) {
                factory.close();
            } else {
                emSetupImpl.undeploy();
            }
            throw ex;
        }
    }

    public JPAInitializer getInitializer(String emName, Map m) {
        ClassLoader classLoader = this.getClassLoader(emName, m);
        return JavaSECMPInitializer.getJavaSECMPInitializer(classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo info, Map properties) {
        JavaSECMPInitializer.setIsInContainer(true);
        Map nonNullProperties = properties == null ? new HashMap() : properties;
        EntityManagerSetupImpl emSetupImpl = null;
        if (EntityManagerSetupImpl.mustBeCompositeMember(info)) {
            emSetupImpl = new EntityManagerSetupImpl(info.getPersistenceUnitName(), info.getPersistenceUnitName());
            emSetupImpl.predeploy(info, nonNullProperties);
        } else {
            boolean isNew = false;
            ClassTransformer transformer = null;
            String uniqueName = PersistenceUnitProcessor.buildPersistenceUnitName(info.getPersistenceUnitRootUrl(), info.getPersistenceUnitName());
            String sessionName = EntityManagerSetupImpl.getOrBuildSessionName(nonNullProperties, info, uniqueName);
            HashMap<String, EntityManagerSetupImpl> hashMap = EntityManagerFactoryProvider.emSetupImpls;
            synchronized (hashMap) {
                emSetupImpl = EntityManagerFactoryProvider.getEntityManagerSetupImpl(sessionName);
                if (emSetupImpl == null) {
                    emSetupImpl = new EntityManagerSetupImpl(uniqueName, sessionName);
                    isNew = true;
                    emSetupImpl.setIsInContainerMode(true);
                    transformer = emSetupImpl.predeploy(info, nonNullProperties);
                    EntityManagerFactoryProvider.addEntityManagerSetupImpl(sessionName, emSetupImpl);
                }
            }
            if (!isNew) {
                if (!uniqueName.equals(emSetupImpl.getPersistenceUnitUniqueName())) {
                    throw PersistenceUnitLoadingException.sessionNameAlreadyInUse((String)sessionName, (String)uniqueName, (String)emSetupImpl.getPersistenceUnitUniqueName());
                }
                boolean undeployed = false;
                EntityManagerSetupImpl entityManagerSetupImpl = emSetupImpl;
                synchronized (entityManagerSetupImpl) {
                    if (emSetupImpl.isUndeployed()) {
                        undeployed = true;
                    }
                    transformer = emSetupImpl.predeploy(emSetupImpl.getPersistenceUnitInfo(), nonNullProperties);
                }
                if (undeployed) {
                    return this.createContainerEntityManagerFactory(info, properties);
                }
            }
            if (transformer != null) {
                info.addTransformer(transformer);
            }
        }
        EntityManagerFactoryImpl factory = null;
        try {
            factory = new EntityManagerFactoryImpl(emSetupImpl, nonNullProperties);
            if (emSetupImpl.shouldGetSessionOnCreateFactory(nonNullProperties)) {
                factory.getDatabaseSession();
            }
            return factory;
        }
        catch (RuntimeException ex) {
            if (factory != null) {
                factory.close();
            } else {
                emSetupImpl.undeploy();
            }
            throw ex;
        }
    }

    public ProviderUtil getProviderUtil() {
        return this;
    }

    public LoadState isLoadedWithoutReference(Object entity, String attributeName) {
        if (entity instanceof PersistenceWeaved) {
            return this.isLoadedWithReference(entity, attributeName);
        }
        return LoadState.UNKNOWN;
    }

    public LoadState isLoadedWithReference(Object entity, String attributeName) {
        for (EntityManagerSetupImpl setup : EntityManagerFactoryProvider.getEmSetupImpls().values()) {
            Boolean isLoaded;
            if (!setup.isDeployed() || (isLoaded = EntityManagerFactoryImpl.isLoaded(entity, (AbstractSession)setup.getSession())) == null) continue;
            if (isLoaded.booleanValue() && attributeName != null) {
                isLoaded = EntityManagerFactoryImpl.isLoaded(entity, attributeName, (AbstractSession)setup.getSession());
            }
            if (isLoaded == null) continue;
            return isLoaded != false ? LoadState.LOADED : LoadState.NOT_LOADED;
        }
        return LoadState.UNKNOWN;
    }

    public LoadState isLoaded(Object entity) {
        if (entity instanceof PersistenceWeaved) {
            return this.isLoadedWithReference(entity, null);
        }
        return LoadState.UNKNOWN;
    }

    public ClassLoader getClassLoader(String emName, Map properties) {
        ClassLoader classloader = null;
        if (properties != null) {
            classloader = (ClassLoader)properties.get("eclipselink.classloader");
        }
        if (classloader == null) {
            classloader = Thread.currentThread().getContextClassLoader();
        }
        return classloader;
    }
}

