/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.resources;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.tools.workbench.framework.resources.IconResourceFileNameMap;
import org.eclipse.persistence.tools.workbench.framework.resources.MissingIconException;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public abstract class AbstractIconResourceFileNameMap
implements IconResourceFileNameMap {
    private final Map resourceFileNames = this.buildResourceFileNames();

    protected AbstractIconResourceFileNameMap() {
    }

    protected Map buildResourceFileNames() {
        String[][] entries = this.getEntries();
        HashMap<String, String> result = new HashMap<String, String>(entries.length);
        for (int i = 0; i < entries.length; ++i) {
            String[] entry = entries[i];
            String key = entry[0];
            String value = entry[1];
            String previous = result.put(key, value);
            if (previous == null) continue;
            throw new IllegalStateException("An icon resource file name is already associated with the key \"" + key + "\" (previous: \"" + previous + "\"; duplicate: \"" + value + "\"). Duplicates are not allowed.");
        }
        return result;
    }

    protected abstract String[][] getEntries();

    public boolean hasResourceFileName(String key) {
        return this.resourceFileNames.containsKey(key);
    }

    public String getResourceFileName(String key) {
        String resourceFileName = (String)this.resourceFileNames.get(key);
        if (resourceFileName == null) {
            throw new MissingIconException("There is no icon resource file name associated with the key \"" + key + "\".", key);
        }
        return resourceFileName;
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)(String.valueOf(this.resourceFileNames.size()) + " icons"));
    }
}

