/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping;

import javax.swing.Icon;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWClassBasedTransformer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMethodBasedTransformer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTransformer;
import org.eclipse.persistence.tools.workbench.uitools.cell.AbstractCellRendererAdapter;

public class TransformerCellRendererAdapter
extends AbstractCellRendererAdapter {
    private final ResourceRepository resourceRepository;

    public TransformerCellRendererAdapter(ResourceRepository resourceRepository) {
        this.resourceRepository = resourceRepository;
    }

    public Icon buildIcon(Object value) {
        MWTransformer transformer = (MWTransformer)value;
        String text = this.buildText(transformer);
        if (text == null) {
            return null;
        }
        if (transformer instanceof MWMethodBasedTransformer) {
            return this.resourceRepository.getIcon("method.public");
        }
        if (transformer instanceof MWClassBasedTransformer) {
            return this.resourceRepository.getIcon("class.public");
        }
        throw new IllegalArgumentException("unknown transformer: " + transformer);
    }

    public String buildText(Object value) {
        return ((MWTransformer)value).transformerDisplayString();
    }

    public String buildToolTipText(Object value) {
        MWTransformer transformer = (MWTransformer)value;
        String text = this.buildText(transformer);
        if (text == null) {
            return null;
        }
        if (transformer instanceof MWMethodBasedTransformer) {
            return this.resourceRepository.getString("TRANSFORMER_METHOD_TOOLTIP", text);
        }
        if (transformer instanceof MWClassBasedTransformer) {
            return this.resourceRepository.getString("TRANSFORMER_CLASS_TOOLTIP", text);
        }
        throw new IllegalArgumentException("unknown transformer: " + transformer);
    }
}

