/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWComplexTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWElementDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWModelGroupDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWNamedSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWNamespace;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSchemaContextComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchema;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml.SchemaContextComponentDisplayer;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml.SchemaRepositoryValue;
import org.eclipse.persistence.tools.workbench.uitools.Displayable;
import org.eclipse.persistence.tools.workbench.uitools.app.AbstractTreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimpleListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TreeModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.DisplayableTreeCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

final class SchemaContextChooserDialog
extends AbstractDialog {
    private SchemaRepositoryValue schemaRepositoryValue;
    private PropertyValueModel schemaComponentHolder;
    private PropertyValueModel selectedSchemaComponentHolder;
    private TreeSelectionModel schemaContextTreeSelectionModel;

    SchemaContextChooserDialog(WorkbenchContext context, SchemaRepositoryValue schemaRepository, PropertyValueModel schemaComponentHolder) {
        super(context);
        this.initialize(schemaRepository, schemaComponentHolder);
    }

    protected void initialize() {
        super.initialize();
        this.setTitle(this.resourceRepository().getString("SCHEMA_CONTEXT_CHOOSER_DIALOG.TITLE"));
    }

    private void initialize(SchemaRepositoryValue schemaRepository, PropertyValueModel schemaComponentHolder) {
        this.schemaRepositoryValue = schemaRepository;
        this.schemaComponentHolder = schemaComponentHolder;
        this.selectedSchemaComponentHolder = this.buildSelectedSchemaComponentHolder();
        this.schemaContextTreeSelectionModel = this.buildSchemaContextTreeSelectionModel();
    }

    private PropertyValueModel buildSelectedSchemaComponentHolder() {
        return new SimplePropertyValueModel(null);
    }

    private TreeSelectionModel buildSchemaContextTreeSelectionModel() {
        DefaultTreeSelectionModel treeSelectionModel = new DefaultTreeSelectionModel();
        treeSelectionModel.setSelectionMode(1);
        treeSelectionModel.addTreeSelectionListener(this.buildTreeSelectionListener());
        return treeSelectionModel;
    }

    private TreeSelectionListener buildTreeSelectionListener() {
        return new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent tse) {
                SchemaContextChooserDialog.this.schemaContextTreeSelectionChanged();
            }
        };
    }

    protected Component buildMainPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.setPreferredSize(new Dimension(400, 400));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.anchor = 19;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)this.buildSchemaContextTreePane(), constraints);
        JLabel schemaContextPreviewLabel = this.buildSchemaContextPreviewLabel();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(5, 0, 0, 5);
        panel.add((Component)schemaContextPreviewLabel, constraints);
        JTextField schemaContextPreviewTextField = this.buildSchemaContextPreviewTextField();
        schemaContextPreviewLabel.setLabelFor(schemaContextPreviewTextField);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.anchor = 10;
        constraints.fill = 2;
        constraints.insets = new Insets(5, 0, 0, 0);
        panel.add((Component)schemaContextPreviewTextField, constraints);
        return panel;
    }

    private JScrollPane buildSchemaContextTreePane() {
        return new JScrollPane(this.buildSchemaContextTree());
    }

    private JTree buildSchemaContextTree() {
        JTree tree = SwingComponentFactory.buildTree(this.buildSchemaContextTreeModel());
        tree.setSelectionModel(this.schemaContextTreeSelectionModel);
        tree.setCellRenderer(this.buildTreeCellRenderer());
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.setRowHeight(20);
        tree.setDoubleBuffered(true);
        tree.expandRow(0);
        return tree;
    }

    private TreeModelAdapter buildSchemaContextTreeModel() {
        return new TreeModelAdapter(this.buildSchemaContextTreeRoot());
    }

    private SchemaRepositoryNode buildSchemaContextTreeRoot() {
        return new SchemaRepositoryNode(this.schemaRepositoryValue);
    }

    private TreeCellRenderer buildTreeCellRenderer() {
        return new DisplayableTreeCellRenderer();
    }

    private JLabel buildSchemaContextPreviewLabel() {
        JLabel schemaContextPreviewLabel = new JLabel(this.resourceRepository().getString("SCHEMA_CONTEXT_CHOOSER_DIALOG.PREVIEW_TEXT_FIELD"));
        schemaContextPreviewLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("SCHEMA_CONTEXT_CHOOSER_DIALOG.PREVIEW_TEXT_FIELD"));
        return schemaContextPreviewLabel;
    }

    private JTextField buildSchemaContextPreviewTextField() {
        JTextField textField = new JTextField();
        textField.setEditable(false);
        textField.setEnabled(true);
        textField.setDocument(this.buildSchemaContextPreviewDocument());
        return textField;
    }

    private DocumentAdapter buildSchemaContextPreviewDocument() {
        return new DocumentAdapter(this.buildSelectedSchemaContextStringHolder());
    }

    private PropertyValueModel buildSelectedSchemaContextStringHolder() {
        return new TransformationPropertyValueModel(this.selectedSchemaComponentHolder){

            protected Object transform(Object value) {
                return SchemaContextComponentDisplayer.displayString(SchemaContextChooserDialog.this.resourceRepository(), (MWSchemaContextComponent)value);
            }
        };
    }

    private void schemaContextTreeSelectionChanged() {
        TreePath selectedPath = this.schemaContextTreeSelectionModel.getSelectionPath();
        Object newComponent = null;
        if (selectedPath != null && selectedPath.getLastPathComponent() instanceof SchemaContextComponentNode) {
            newComponent = ((SchemaContextComponentNode)this.schemaContextTreeSelectionModel.getSelectionPath().getLastPathComponent()).getValue();
        }
        this.selectedSchemaComponentHolder.setValue(newComponent);
    }

    public MWNamedSchemaComponent selectedSchemaComponent() {
        return (MWNamedSchemaComponent)this.selectedSchemaComponentHolder.getValue();
    }

    protected void okConfirmed() {
        this.schemaComponentHolder.setValue(this.selectedSchemaComponentHolder.getValue());
        super.okConfirmed();
    }

    protected String helpTopicId() {
        return "dialog.schemaContextChooser";
    }

    public void show() {
        if (!this.schemaRepositoryValue.schemas().hasNext()) {
            this.showErrorDialog();
        } else {
            super.show();
        }
    }

    private void showErrorDialog() {
        Window currentWindow = this.currentWindow();
        ResourceRepository repo = this.resourceRepository();
        String errorTitle = repo.getString("SCHEMA_CONTEXT_CHOOSER_DIALOG.NO_SCHEMAS_LOADED_TITLE");
        String errorMessage = repo.getString("SCHEMA_CONTEXT_CHOOSER_DIALOG.NO_SCHEMAS_LOADED_MESSAGE");
        JOptionPane.showMessageDialog(currentWindow, errorMessage, errorTitle, 2);
    }

    private static final class SchemaContextComponentNode
    extends AbstractTreeNodeValueModel
    implements Displayable {
        private AbstractTreeNodeValueModel parent;
        private MWNamedSchemaComponent component;
        private ListValueModel childrenModel;

        SchemaContextComponentNode(AbstractTreeNodeValueModel parent, MWNamedSchemaComponent component) {
            this.initialize(parent, component);
        }

        private void initialize(AbstractTreeNodeValueModel parent, MWNamedSchemaComponent component) {
            this.parent = parent;
            this.component = component;
            this.childrenModel = this.buildChildrenModel();
        }

        protected ListValueModel buildChildrenModel() {
            return new TransformationListValueModelAdapter(this.buildContextComponentsAdapter()){

                protected Object transformItem(Object item) {
                    return SchemaContextComponentNode.this.buildContextComponentNode((MWNamedSchemaComponent)item);
                }
            };
        }

        protected ListValueModel buildContextComponentsAdapter() {
            return new SimpleListValueModel(CollectionTools.list((Iterator)this.component.descriptorContextComponents()));
        }

        protected SchemaContextComponentNode buildContextComponentNode(MWNamedSchemaComponent component) {
            return new SchemaContextComponentNode(this, component);
        }

        public Object getValue() {
            return this.component;
        }

        public TreeNodeValueModel getParent() {
            return this.parent;
        }

        public ListValueModel getChildrenModel() {
            return this.childrenModel;
        }

        protected void engageValue() {
        }

        protected void disengageValue() {
        }

        public int compareTo(Object o) {
            return SchemaContextComponentNodeComparator.compare(this, o);
        }

        public String displayString() {
            return this.component.componentTypeName() + "::" + this.component.qName();
        }

        public Icon icon() {
            return null;
        }

        private static class SchemaContextComponentNodeComparator {
            private SchemaContextComponentNodeComparator() {
            }

            public static int compare(Object o1, Object o2) {
                SchemaContextComponentNode node1 = (SchemaContextComponentNode)o1;
                SchemaContextComponentNode node2 = (SchemaContextComponentNode)o2;
                MWNamedSchemaComponent comp1 = node1.component;
                MWNamedSchemaComponent comp2 = node2.component;
                int comparison = SchemaContextComponentNodeComparator.compare(comp1.getTargetNamespace(), comp2.getTargetNamespace());
                if (comparison == 0) {
                    comparison = SchemaContextComponentNodeComparator.compareComponentType(comp1, comp2);
                }
                if (comparison == 0) {
                    comparison = comp1.qName().compareTo(comp2.qName());
                }
                return comparison;
            }

            private static int compare(MWNamespace thisNamespace, MWNamespace otherNamespace) {
                if (thisNamespace.isTargetNamespace() && !otherNamespace.isTargetNamespace()) {
                    return -1;
                }
                if (!thisNamespace.isTargetNamespace() && otherNamespace.isTargetNamespace()) {
                    return 1;
                }
                if (thisNamespace.getNamespacePrefix() != otherNamespace.getNamespacePrefix()) {
                    return thisNamespace.getNamespacePrefix().compareToIgnoreCase(otherNamespace.getNamespacePrefix());
                }
                return 0;
            }

            private static int compareComponentType(MWNamedSchemaComponent comp1, MWNamedSchemaComponent comp2) {
                int rank2 = 0;
                int rank1 = comp1 instanceof MWElementDeclaration ? 1 : (comp1 instanceof MWModelGroupDefinition ? 2 : (comp1 instanceof MWComplexTypeDefinition ? 3 : 4));
                rank2 = comp2 instanceof MWElementDeclaration ? 1 : (comp2 instanceof MWModelGroupDefinition ? 2 : (comp2 instanceof MWComplexTypeDefinition ? 3 : 4));
                return rank1 - rank2;
            }
        }
    }

    private static final class SchemaNode
    extends AbstractTreeNodeValueModel
    implements Displayable {
        private SchemaRepositoryNode parent;
        private MWXmlSchema schema;
        private ListValueModel childrenModel;

        SchemaNode(SchemaRepositoryNode parent, MWXmlSchema schema) {
            this.initialize(parent, schema);
        }

        private void initialize(SchemaRepositoryNode parent, MWXmlSchema schema) {
            this.parent = parent;
            this.schema = schema;
            this.childrenModel = this.buildChildrenModel();
        }

        private ListValueModel buildChildrenModel() {
            return new SortedListValueModelAdapter(this.buildContextComponentNodesAdapter());
        }

        private ListValueModel buildContextComponentNodesAdapter() {
            return new TransformationListValueModelAdapter(this.buildContextComponentsAdapter()){

                protected Object transformItem(Object item) {
                    return SchemaNode.this.buildContextComponentNode((MWNamedSchemaComponent)item);
                }
            };
        }

        private ListValueModel buildContextComponentsAdapter() {
            return new SimpleListValueModel(CollectionTools.list((Iterator)this.schema.contextComponents()));
        }

        private SchemaContextComponentNode buildContextComponentNode(MWNamedSchemaComponent component) {
            return new SchemaContextComponentNode(this, component);
        }

        public Object getValue() {
            return this.schema;
        }

        public TreeNodeValueModel getParent() {
            return this.parent;
        }

        public ListValueModel getChildrenModel() {
            return this.childrenModel;
        }

        protected void engageValue() {
        }

        protected void disengageValue() {
        }

        public int compareTo(Object o) {
            return DEFAULT_COMPARATOR.compare(this, o);
        }

        public String displayString() {
            return "schema::" + this.schema.getName();
        }

        public Icon icon() {
            return null;
        }
    }

    private static final class SchemaRepositoryNode
    extends AbstractTreeNodeValueModel
    implements Displayable {
        private SchemaRepositoryValue schemaRepository;
        private ListValueModel childrenModel;

        public SchemaRepositoryNode(SchemaRepositoryValue schemaRepository) {
            this.initialize(schemaRepository);
        }

        private void initialize(SchemaRepositoryValue schemaRepository) {
            this.schemaRepository = schemaRepository;
            this.childrenModel = this.buildChildrenModel();
        }

        protected ListValueModel buildChildrenModel() {
            return new SortedListValueModelAdapter(this.buildSchemaNodesAdapter());
        }

        protected ListValueModel buildSchemaNodesAdapter() {
            return new TransformationListValueModelAdapter(this.buildSchemasAdapter()){

                protected Object transformItem(Object item) {
                    return SchemaRepositoryNode.this.buildSchemaNode((MWXmlSchema)item);
                }
            };
        }

        protected ListValueModel buildSchemasAdapter() {
            return new SimpleListValueModel(CollectionTools.list((Iterator)this.schemaRepository.schemas()));
        }

        protected SchemaNode buildSchemaNode(MWXmlSchema schema) {
            return new SchemaNode(this, schema);
        }

        public Object getValue() {
            return this.schemaRepository;
        }

        public TreeNodeValueModel getParent() {
            return null;
        }

        public ListValueModel getChildrenModel() {
            return this.childrenModel;
        }

        protected void engageValue() {
        }

        protected void disengageValue() {
        }

        public int compareTo(Object o) {
            return DEFAULT_COMPARATOR.compare(this, o);
        }

        public String displayString() {
            return null;
        }

        public Icon icon() {
            return null;
        }
    }
}

