/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.queries.ValueReadQuery;

public class InformixPlatform
extends DatabasePlatform {
    protected void appendDate(Date date, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("'");
            writer.write(Helper.printDate(date));
            writer.write("'");
        } else {
            super.appendDate(date, writer);
        }
    }

    protected void appendInformixTimestamp(Timestamp timestamp, Writer writer) throws IOException {
        writer.write("'");
        writer.write(Helper.printTimestampWithoutNanos(timestamp));
        writer.write(46);
        String nanoString = Integer.toString(timestamp.getNanos());
        int numberOfZeros = 0;
        int num = Math.min(9 - nanoString.length(), 3);
        while (num > 0) {
            writer.write(48);
            ++numberOfZeros;
            --num;
        }
        if (nanoString.length() + numberOfZeros > 3) {
            nanoString = nanoString.substring(0, 3 - numberOfZeros);
        }
        writer.write(nanoString);
        writer.write("'");
    }

    protected void appendCalendar(Calendar calendar, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            this.appendInformixCalendar(calendar, writer);
        } else {
            super.appendCalendar(calendar, writer);
        }
    }

    protected void appendInformixCalendar(Calendar calendar, Writer writer) throws IOException {
        writer.write("'");
        writer.write(Helper.printCalendar(calendar));
        writer.write("'");
    }

    protected void appendTime(Time time, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("'");
            writer.write(Helper.printTime(time));
            writer.write("'");
        } else {
            super.appendTime(time, writer);
        }
    }

    protected void appendTimestamp(Timestamp timestamp, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            this.appendInformixTimestamp(timestamp, writer);
        } else {
            super.appendTimestamp(timestamp, writer);
        }
    }

    protected Hashtable buildFieldTypes() {
        Hashtable<Class<Timestamp>, FieldTypeDefinition> fieldTypeMapping = new Hashtable<Class<Timestamp>, FieldTypeDefinition>();
        fieldTypeMapping.put(Boolean.class, new FieldTypeDefinition("SMALLINT default 0", false));
        fieldTypeMapping.put(Integer.class, new FieldTypeDefinition("INTEGER", false));
        fieldTypeMapping.put(Long.class, new FieldTypeDefinition("NUMERIC", 19));
        fieldTypeMapping.put(Float.class, new FieldTypeDefinition("FLOAT(16)", false));
        fieldTypeMapping.put(Double.class, new FieldTypeDefinition("DECIMAL(32)", false));
        fieldTypeMapping.put(Short.class, new FieldTypeDefinition("SMALLINT", false));
        fieldTypeMapping.put(Byte.class, new FieldTypeDefinition("SMALLINT", false));
        fieldTypeMapping.put(BigInteger.class, new FieldTypeDefinition("DECIMAL", 32));
        fieldTypeMapping.put(BigDecimal.class, new FieldTypeDefinition("DECIMAL", 32).setLimits(32, -19, 19));
        fieldTypeMapping.put(Number.class, new FieldTypeDefinition("DECIMAL", 32).setLimits(32, -19, 19));
        fieldTypeMapping.put(String.class, new FieldTypeDefinition("VARCHAR", 255));
        fieldTypeMapping.put(Character.class, new FieldTypeDefinition("CHAR", 1));
        fieldTypeMapping.put(Byte[].class, new FieldTypeDefinition("BYTE", false));
        fieldTypeMapping.put(Character[].class, new FieldTypeDefinition("TEXT", false));
        fieldTypeMapping.put(byte[].class, new FieldTypeDefinition("BYTE", false));
        fieldTypeMapping.put(char[].class, new FieldTypeDefinition("TEXT", false));
        fieldTypeMapping.put(Blob.class, new FieldTypeDefinition("BYTE", false));
        fieldTypeMapping.put(Clob.class, new FieldTypeDefinition("TEXT", false));
        fieldTypeMapping.put(Date.class, new FieldTypeDefinition("DATE", false));
        fieldTypeMapping.put(Time.class, new FieldTypeDefinition("DATETIME HOUR TO SECOND", false));
        fieldTypeMapping.put(Timestamp.class, new FieldTypeDefinition("DATETIME YEAR TO FRACTION(5)", false));
        return fieldTypeMapping;
    }

    public ValueReadQuery buildSelectQueryForIdentity() {
        ValueReadQuery selectQuery = new ValueReadQuery();
        StringWriter writer = new StringWriter();
        writer.write("SELECT DISTINCT(DBINFO('sqlca.sqlerrd1')) FROM systables");
        selectQuery.setSQLString(writer.toString());
        return selectQuery;
    }

    public int getMaxFieldNameSize() {
        return 18;
    }

    public String getSelectForUpdateString() {
        return " FOR UPDATE";
    }

    public boolean isInformix() {
        return true;
    }

    public boolean isInformixOuterJoin() {
        return true;
    }

    public boolean shouldSelectIncludeOrderBy() {
        return true;
    }

    public Hashtable maximumNumericValues() {
        Hashtable<Class, Number> values = new Hashtable<Class, Number>();
        values.put(Integer.class, Integer.MAX_VALUE);
        values.put(Long.class, Long.MAX_VALUE);
        values.put(Double.class, 3.4028234663852886E38);
        values.put(Short.class, (short)Short.MAX_VALUE);
        values.put(Byte.class, (byte)127);
        values.put(Float.class, Float.valueOf(Float.MAX_VALUE));
        values.put(BigInteger.class, new BigInteger("99999999999999999999999999999999999999"));
        values.put(BigDecimal.class, new BigDecimal("9999999999999999999.9999999999999999999"));
        return values;
    }

    public Hashtable minimumNumericValues() {
        Hashtable<Class, Number> values = new Hashtable<Class, Number>();
        values.put(Integer.class, Integer.MIN_VALUE);
        values.put(Long.class, Long.MIN_VALUE);
        values.put(Double.class, 1.401298464324715E-44);
        values.put(Short.class, (short)Short.MIN_VALUE);
        values.put(Byte.class, (byte)-128);
        values.put(Float.class, Float.valueOf(Float.MIN_VALUE));
        values.put(BigInteger.class, new BigInteger("-99999999999999999999999999999999999999"));
        values.put(BigDecimal.class, new BigDecimal("-9999999999999999999.9999999999999999999"));
        return values;
    }

    public void printFieldIdentityClause(Writer writer) throws ValidationException {
        try {
            writer.write(" SERIAL");
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    public boolean requiresProcedureCallBrackets() {
        return false;
    }

    public boolean shouldPrintConstraintNameAfter() {
        return true;
    }

    public boolean supportsIdentity() {
        return true;
    }

    public boolean supportsSequenceObjects() {
        return true;
    }

    public ValueReadQuery buildSelectQueryForSequenceObject(String qualifiedSeqName, Integer size) {
        return new ValueReadQuery("select " + qualifiedSeqName + ".nextval from systables where tabid = 1");
    }

    public boolean isAlterSequenceObjectSupported() {
        return true;
    }
}

