/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.model.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.model.IListChangeListener;
import org.eclipse.persistence.jpa.jpql.model.query.AbstractStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.ListHolderStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.util.iterator.CloneListIterator;
import org.eclipse.persistence.jpa.jpql.util.iterator.IterableListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractListHolderStateObject<T extends StateObject>
extends AbstractStateObject
implements ListHolderStateObject<T> {
    private List<T> items;

    protected AbstractListHolderStateObject(StateObject parent) {
        super(parent);
    }

    protected AbstractListHolderStateObject(StateObject parent, List<? extends T> items) {
        super(parent);
        this.items.addAll(items);
        this.parent(items);
    }

    protected AbstractListHolderStateObject(StateObject parent, T ... items) {
        super(parent);
        Collections.addAll(this.items, this.parent(items));
    }

    @Override
    protected void addChildren(List<StateObject> children) {
        super.addChildren(children);
        children.addAll(this.items);
    }

    @Override
    public <S extends T> S addItem(S item) {
        this.getChangeSupport().addItem(this, this.items, this.listName(), this.parent(item));
        return item;
    }

    @Override
    public void addItems(List<? extends T> items) {
        this.getChangeSupport().addItems(this, this.items, this.listName(), this.parent(items));
    }

    @Override
    public void addListChangeListener(String listName, IListChangeListener<T> listener) {
        this.getChangeSupport().addListChangeListener(listName, listener);
    }

    @Override
    public boolean canMoveDown(T stateObject) {
        return this.getChangeSupport().canMoveDown(this.items, stateObject);
    }

    @Override
    public boolean canMoveUp(T stateObject) {
        return this.getChangeSupport().canMoveUp(this.items, stateObject);
    }

    @Override
    public T getItem(int index) {
        return (T)((StateObject)this.items.get(index));
    }

    @Override
    public boolean hasItems() {
        return !this.items.isEmpty();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.items = new ArrayList<T>();
    }

    @Override
    public IterableListIterator<? extends T> items() {
        return new CloneListIterator<T>(this.items);
    }

    @Override
    public int itemsSize() {
        return this.items.size();
    }

    protected abstract String listName();

    @Override
    public T moveDown(T item) {
        this.getChangeSupport().moveDown(this, this.items, this.listName(), item);
        return item;
    }

    @Override
    public T moveUp(T item) {
        this.getChangeSupport().moveUp(this, this.items, this.listName(), item);
        return item;
    }

    @Override
    public void removeItem(T stateObject) {
        this.getChangeSupport().removeItem(this, this.items, this.listName(), stateObject);
    }

    @Override
    public void removeItems(Collection<T> items) {
        this.getChangeSupport().removeItems(this, this.items, this.listName(), items);
    }

    @Override
    public void removeListChangeListener(String listName, IListChangeListener<T> listener) {
        this.getChangeSupport().removeListChangeListener(listName, listener);
    }

    protected void toStringItems(Appendable writer, boolean useComma) throws IOException {
        this.toStringItems(writer, this.items, useComma);
    }
}

