/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.diff;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.Counter;
import org.eclipse.persistence.tools.workbench.utility.diff.CollectionAdapter;
import org.eclipse.persistence.tools.workbench.utility.diff.ContainerDiff;
import org.eclipse.persistence.tools.workbench.utility.diff.Diff;
import org.eclipse.persistence.tools.workbench.utility.diff.Differentiator;
import org.eclipse.persistence.tools.workbench.utility.diff.EqualityDifferentiator;
import org.eclipse.persistence.tools.workbench.utility.diff.MapAdapter;
import org.eclipse.persistence.tools.workbench.utility.diff.MapEntryDifferentiator;
import org.eclipse.persistence.tools.workbench.utility.diff.NullDiff;
import org.eclipse.persistence.tools.workbench.utility.diff.SimpleDiff;
import org.eclipse.persistence.tools.workbench.utility.diff.UnorderedArrayAdapter;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class ContainerDifferentiator
implements Differentiator {
    private Adapter adapter;
    private Differentiator elementDifferentiator;

    public static ContainerDifferentiator forCollections() {
        return new ContainerDifferentiator(CollectionAdapter.instance());
    }

    public static ContainerDifferentiator forCollections(Differentiator elementDifferentiator) {
        return new ContainerDifferentiator(CollectionAdapter.instance(), elementDifferentiator);
    }

    public static ContainerDifferentiator forArrays() {
        return new ContainerDifferentiator(UnorderedArrayAdapter.instance());
    }

    public static ContainerDifferentiator forArrays(Differentiator elementDifferentiator) {
        return new ContainerDifferentiator(UnorderedArrayAdapter.instance(), elementDifferentiator);
    }

    public static ContainerDifferentiator forMaps() {
        return new ContainerDifferentiator(MapAdapter.instance(), new MapEntryDifferentiator());
    }

    public static ContainerDifferentiator forMaps(Differentiator keyDifferentiator, Differentiator valueDifferentiator) {
        return new ContainerDifferentiator(MapAdapter.instance(), new MapEntryDifferentiator(keyDifferentiator, valueDifferentiator));
    }

    public static ContainerDifferentiator forMaps(Differentiator entryDifferentiator) {
        return new ContainerDifferentiator(MapAdapter.instance(), entryDifferentiator);
    }

    public ContainerDifferentiator() {
        this(Adapter.INVALID_INSTANCE);
    }

    public ContainerDifferentiator(Differentiator elementDifferentiator) {
        this(Adapter.INVALID_INSTANCE, elementDifferentiator);
    }

    public ContainerDifferentiator(Adapter adapter) {
        this(adapter, EqualityDifferentiator.instance());
    }

    public ContainerDifferentiator(Adapter adapter, Differentiator elementDifferentiator) {
        this.adapter = adapter;
        this.elementDifferentiator = elementDifferentiator;
    }

    public Diff diff(Object object1, Object object2) {
        return this.diff(object1, object2, true);
    }

    public Diff keyDiff(Object object1, Object object2) {
        return this.diff(object1, object2, false);
    }

    private Diff diff(Object object1, Object object2, boolean fullDiff) {
        if (object1 == object2) {
            return new NullDiff(object1, object2, this);
        }
        if (this.diffIsFatal(object1, object2)) {
            return new SimpleDiff(object1, object2, this.fatalDescriptionTitle(), this);
        }
        Map counters1 = this.buildCounters(object1);
        Map counters2 = this.buildCounters(object2);
        ArrayList removedElements = new ArrayList();
        ArrayList<Diff> keyMatchedDiffs = new ArrayList<Diff>();
        for (Map.Entry entry1 : counters1.entrySet()) {
            Object element1 = entry1.getKey();
            Counter counter1 = (Counter)entry1.getValue();
            int i = counter1.count();
            while (i-- > 0) {
                boolean keyMatchFound = false;
                Iterator stream2 = counters2.entrySet().iterator();
                while (stream2.hasNext()) {
                    Map.Entry entry2 = stream2.next();
                    Object element2 = entry2.getKey();
                    Diff keyDiff = this.elementDifferentiator.keyDiff(element1, element2);
                    if (!keyDiff.identical()) continue;
                    keyMatchFound = true;
                    Counter counter2 = (Counter)entry2.getValue();
                    counter2.decrement();
                    if (counter2.count() == 0) {
                        stream2.remove();
                    }
                    if (fullDiff) {
                        keyMatchedDiffs.add(this.elementDifferentiator.diff(element1, element2));
                        break;
                    }
                    keyMatchedDiffs.add(keyDiff);
                    break;
                }
                if (keyMatchFound) continue;
                removedElements.add(element1);
            }
        }
        ArrayList addedElements = new ArrayList();
        for (Map.Entry entry2 : counters2.entrySet()) {
            Object element2 = entry2.getKey();
            Counter counter2 = (Counter)entry2.getValue();
            int i = counter2.count();
            while (i-- > 0) {
                addedElements.add(element2);
            }
        }
        return new ContainerDiff(this.containerClass(), object1, object2, keyMatchedDiffs.toArray(new Diff[keyMatchedDiffs.size()]), removedElements.toArray(), addedElements.toArray(), this);
    }

    private Map buildCounters(Object container) {
        IdentityHashMap counters = new IdentityHashMap(this.size(container));
        Iterator stream = this.iterator(container);
        while (stream.hasNext()) {
            Object element = stream.next();
            Counter counter = (Counter)counters.get(element);
            if (counter == null) {
                counter = new Counter();
                counters.put(element, counter);
            }
            counter.increment();
        }
        return counters;
    }

    private String fatalDescriptionTitle() {
        return "The two " + ClassTools.shortNameFor(this.containerClass()) + "s cannot be compared";
    }

    public boolean comparesValueObjects() {
        return false;
    }

    public Differentiator getElementDifferentiator() {
        return this.elementDifferentiator;
    }

    public void setElementDifferentiator(Differentiator elementDifferentiator) {
        this.elementDifferentiator = elementDifferentiator;
    }

    protected boolean diffIsFatal(Object object1, Object object2) {
        return this.adapter.diffIsFatal(object1, object2);
    }

    protected Class containerClass() {
        return this.adapter.containerClass();
    }

    protected int size(Object container) {
        return this.adapter.size(container);
    }

    protected Iterator iterator(Object container) {
        return this.adapter.iterator(container);
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.elementDifferentiator);
    }

    public static interface Adapter {
        public static final Adapter INVALID_INSTANCE = new Adapter(){

            public boolean diffIsFatal(Object object1, Object object2) {
                throw new UnsupportedOperationException();
            }

            public Class containerClass() {
                throw new UnsupportedOperationException();
            }

            public int size(Object container) {
                throw new UnsupportedOperationException();
            }

            public Iterator iterator(Object container) {
                throw new UnsupportedOperationException();
            }

            public String toString() {
                return "InvalidAdapter";
            }
        };

        public boolean diffIsFatal(Object var1, Object var2);

        public Class containerClass();

        public int size(Object var1);

        public Iterator iterator(Object var1);
    }
}

