/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryParameter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.QueryParametersPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.utility.TriStateBoolean;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;

public final class QueryGeneralPanel
extends AbstractPanel {
    private PropertyValueModel queryHolder;
    private QueryParametersPanel queryParametersPanel;

    public QueryGeneralPanel(PropertyValueModel queryHolder, ObjectListSelectionModel querySelectionModel, WorkbenchContextHolder contextHolder) {
        super(contextHolder);
        this.queryHolder = queryHolder;
        this.initializeLayout(querySelectionModel);
    }

    private MWQuery getQuery() {
        return (MWQuery)this.queryHolder.getValue();
    }

    public String helpTopicId() {
        return "descriptor.queries.general";
    }

    private void initializeLayout(ObjectListSelectionModel querySelectionModel) {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.initializeQueryTypePanel(querySelectionModel);
        this.initializeParametersPanel();
        this.addHelpTopicId(this, this.helpTopicId());
    }

    private void initializeParametersPanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        this.queryParametersPanel = new QueryParametersPanel(this.queryHolder, this.getWorkbenchContextHolder());
        this.queryParametersPanel.setBorder(this.buildTitledBorder("QUERY_PARAMETERS_TABLE_TITLE"));
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.queryParametersPanel, constraints);
    }

    private void initializeQueryTypePanel(ObjectListSelectionModel querySelectionModel) {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel queryTypePanel = new JPanel(new GridBagLayout());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)queryTypePanel, constraints);
        JLabel typeLabel = this.buildQueryTypeLabel();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        queryTypePanel.add((Component)typeLabel, constraints);
        JComboBox queryTypeComboBox = this.buildQueryTypeComboBox(querySelectionModel);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 0, 0);
        queryTypePanel.add((Component)queryTypeComboBox, constraints);
        typeLabel.setLabelFor(queryTypeComboBox);
        this.addHelpTopicId(queryTypePanel, this.helpTopicId() + ".type");
    }

    private JLabel buildQueryTypeLabel() {
        JLabel label = this.buildLabel("QUERY_TYPE_COMBO_BOX_LABEL");
        this.queryHolder.addPropertyChangeListener("value", this.buildQueryTypeLabelListener(label));
        return label;
    }

    private PropertyChangeListener buildQueryTypeLabelListener(final JLabel label) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                label.setEnabled(QueryGeneralPanel.this.getQuery() != null);
            }
        };
    }

    private JComboBox buildQueryTypeComboBox(ObjectListSelectionModel querySelectionModel) {
        JComboBox comboBox = new JComboBox(new ComboBoxModelAdapter(this.buildQueryTypeValueModel(), this.buildQueryTypePropertyAdapter(querySelectionModel)));
        comboBox.setEnabled(false);
        comboBox.setEditable(false);
        this.queryHolder.addPropertyChangeListener(this.buildQueryTypeChooserListener(comboBox));
        return comboBox;
    }

    private CollectionValueModel buildQueryTypeValueModel() {
        return new CollectionAspectAdapter(this.queryHolder){

            protected Iterator getValueFromSubject() {
                return new TransformationIterator(((MWQuery)this.subject).queryTypes()){

                    protected Object transform(Object next) {
                        return QueryGeneralPanel.this.resourceRepository().getString((String)next);
                    }
                };
            }
        };
    }

    private boolean queryTypeCanChange() {
        boolean changeQueryType;
        String promptValue = TriStateBoolean.UNDEFINED.toString();
        String value = this.preferences().get("query change query type", promptValue);
        if (value.equals(promptValue)) {
            changeQueryType = this.promptToChangeQueryType();
        } else {
            changeQueryType = TriStateBoolean.TRUE.toString().equals(value);
            if (!changeQueryType) {
                JOptionPane.showMessageDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString("QUERY_TYPE_CHANGE_DISSALLOWED"));
            }
        }
        return changeQueryType;
    }

    private boolean promptToChangeQueryType() {
        if (this.preferences().getBoolean("query change query type", false)) {
            return true;
        }
        String title = this.resourceRepository().getString("QUERY_CHANGE_QUERY_TYPE_TITLE");
        String message = this.resourceRepository().getString("QUERY_CHANGE_QUERY_TYPE_MESSAGE");
        SimplePropertyValueModel dontAskAgainHolder = new SimplePropertyValueModel(new Boolean(false));
        JComponent dontAskAgainPanel = SwingComponentFactory.buildDoNotAskAgainPanel(message, dontAskAgainHolder, this.resourceRepository());
        JOptionPane queryChangePane = new JOptionPane(dontAskAgainPanel, 2, 0);
        JDialog queryChangeDialog = queryChangePane.createDialog(this.getWorkbenchContext().getCurrentWindow(), title);
        queryChangeDialog.setSize(400, 150);
        queryChangeDialog.setResizable(false);
        queryChangeDialog.show();
        queryChangeDialog.dispose();
        int response = -1;
        Object value = queryChangePane.getValue();
        if (value != null && value instanceof Integer) {
            response = (Integer)value;
        }
        if (dontAskAgainHolder.getValue().equals(Boolean.TRUE)) {
            if (response == 0) {
                this.preferences().putBoolean("query change query type", true);
            } else if (response == 1) {
                this.preferences().putBoolean("query change query type", false);
            }
        }
        return response == 0;
    }

    private PropertyValueModel buildQueryTypePropertyAdapter(final ObjectListSelectionModel querySelectionModel) {
        return new PropertyAspectAdapter(this.queryHolder){

            protected Object getValueFromSubject() {
                return QueryGeneralPanel.this.resourceRepository().getString(((MWQuery)this.subject).queryType());
            }

            protected void setValueOnSubject(Object value) {
                if (!QueryGeneralPanel.this.queryTypeCanChange()) {
                    return;
                }
                Object newQuery = value == QueryGeneralPanel.this.resourceRepository().getString("REPORT_QUERY") ? QueryGeneralPanel.this.getQuery().asReportQuery() : (value == QueryGeneralPanel.this.resourceRepository().getString("READ_ALL_QUERY") ? QueryGeneralPanel.this.getQuery().asReadAllQuery() : QueryGeneralPanel.this.getQuery().asReadObjectQuery());
                querySelectionModel.setSelectedValue(newQuery);
            }
        };
    }

    private PropertyChangeListener buildQueryTypeChooserListener(final JComboBox comboBox) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (QueryGeneralPanel.this.getQuery() == null) {
                    comboBox.setEnabled(false);
                } else {
                    comboBox.setEnabled(true);
                }
            }
        };
    }

    protected void selectParameter(MWQueryParameter parameter) {
        this.queryParametersPanel.selectParameter(parameter);
    }
}

