/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis;

import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.eis.EISPlatform;
import org.eclipse.persistence.eis.mappings.EISCompositeCollectionMapping;
import org.eclipse.persistence.eis.mappings.EISCompositeDirectCollectionMapping;
import org.eclipse.persistence.eis.mappings.EISCompositeObjectMapping;
import org.eclipse.persistence.eis.mappings.EISDirectMapping;
import org.eclipse.persistence.eis.mappings.EISOneToManyMapping;
import org.eclipse.persistence.eis.mappings.EISOneToOneMapping;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.expressions.SQLStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.oxm.QNameInheritancePolicy;
import org.eclipse.persistence.internal.oxm.XMLObjectBuilder;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.AggregateMapping;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.queries.DatabaseQuery;

public class EISDescriptor
extends ClassDescriptor {
    protected String dataFormat;
    public static final String MAPPED = "mapped";
    public static final String INDEXED = "indexed";
    public static final String XML = "xml";
    protected NamespaceResolver namespaceResolver;

    public EISDescriptor() {
        this.shouldOrderMappings = false;
        this.dataFormat = XML;
    }

    protected void validateMappingType(DatabaseMapping mapping) {
        if (!mapping.isEISMapping()) {
            throw DescriptorException.invalidMappingType(mapping);
        }
    }

    public void setDataTypeName(String dataTypeName) throws DescriptorException {
        this.setTableName(dataTypeName);
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceResolver;
    }

    public InheritancePolicy getInheritancePolicy() {
        if (this.inheritancePolicy == null) {
            if (this.isXMLFormat()) {
                this.setInheritancePolicy(new QNameInheritancePolicy(this));
            } else {
                this.setInheritancePolicy(new InheritancePolicy(this));
            }
        }
        return this.inheritancePolicy;
    }

    public void setNamespaceResolver(NamespaceResolver namespaceResolver) {
        this.namespaceResolver = namespaceResolver;
    }

    public void setQueryManager(DescriptorQueryManager queryManager) {
        this.queryManager = queryManager;
        if (queryManager != null) {
            queryManager.setDescriptor(this);
        }
    }

    public void preInitialize(AbstractSession session) {
        if (this.isInitialized(1)) {
            return;
        }
        if (this.isXMLFormat()) {
            this.setObjectBuilder(new XMLObjectBuilder(this));
            if (this.hasInheritance()) {
                ((QNameInheritancePolicy)this.getInheritancePolicy()).setNamespaceResolver(this.namespaceResolver);
            }
        }
        super.preInitialize(session);
    }

    public void initialize(DescriptorQueryManager queryManager, AbstractSession session) {
        ((DatasourcePlatform)session.getDatasourcePlatform()).initializeDefaultQueries(queryManager, session);
        super.initialize(queryManager, session);
    }

    public boolean isXMLFormat() {
        return this.dataFormat.equals(XML);
    }

    public boolean isMappedFormat() {
        return this.dataFormat.equals(MAPPED);
    }

    public boolean isIndexedFormat() {
        return this.dataFormat.equals(INDEXED);
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public String getDataTypeName() throws DescriptorException {
        return this.getTableName();
    }

    public void setDataFormat(String dataFormat) {
        this.dataFormat = dataFormat;
    }

    public void useMappedRecordFormat() {
        this.setDataFormat(MAPPED);
    }

    public void useIndexedRecordFormat() {
        this.setDataFormat(INDEXED);
    }

    public void useXMLRecordFormat() {
        this.setDataFormat(XML);
    }

    public AbstractRecord buildNestedRowFromFieldValue(Object fieldValue) {
        if (fieldValue instanceof AbstractRecord) {
            return (AbstractRecord)fieldValue;
        }
        if (!(fieldValue instanceof List)) {
            return this.getObjectBuilder().createRecord(0, null);
        }
        List nestedRows = (List)fieldValue;
        if (nestedRows.isEmpty()) {
            return this.getObjectBuilder().createRecord(0, null);
        }
        if (!(nestedRows.get(0) instanceof AbstractRecord)) {
            return this.getObjectBuilder().createRecord(0, null);
        }
        return (AbstractRecord)nestedRows.get(0);
    }

    public Vector buildNestedRowsFromFieldValue(Object fieldValue, AbstractSession session) {
        if (!this.isXMLFormat()) {
            if (!(fieldValue instanceof List)) {
                return new Vector();
            }
            return new Vector((List)fieldValue);
        }
        if (!(fieldValue instanceof Vector)) {
            return new Vector(0);
        }
        return (Vector)fieldValue;
    }

    public Vector buildDirectValuesFromFieldValue(Object fieldValue) {
        if (!(fieldValue instanceof Vector)) {
            Vector<Object> fieldValues = new Vector<Object>(1);
            fieldValues.add(fieldValue);
            return fieldValues;
        }
        return (Vector)fieldValue;
    }

    public Object buildFieldValueFromDirectValues(Vector directValues, String elementDataTypeName, AbstractSession session) {
        return directValues;
    }

    public Object buildFieldValueFromNestedRow(AbstractRecord nestedRow, AbstractSession session) throws DatabaseException {
        Vector<AbstractRecord> nestedRows = new Vector<AbstractRecord>(1);
        nestedRows.add(nestedRow);
        return this.buildFieldValueFromNestedRows(nestedRows, "", session);
    }

    public Object buildFieldValueFromNestedRows(Vector nestedRows, String structureName, AbstractSession session) throws DatabaseException {
        return nestedRows;
    }

    public DatabaseField buildField(String fieldName) {
        if (this.isXMLFormat()) {
            XMLField xmlField = new XMLField(fieldName);
            xmlField.setNamespaceResolver(this.getNamespaceResolver());
            xmlField.initialize();
            return xmlField;
        }
        return super.buildField(fieldName);
    }

    public DatabaseField buildField(DatabaseField field) {
        if (this.isXMLFormat()) {
            if (!(field instanceof XMLField)) {
                String xPath = field.getName();
                if (xPath.indexOf(64) == -1 && xPath.indexOf("/text()") == -1) {
                    xPath = String.valueOf(xPath) + "/text()";
                }
                field = new XMLField(xPath);
            }
            ((XMLField)field).setNamespaceResolver(this.getNamespaceResolver());
            ((XMLField)field).initialize();
        }
        return super.buildField(field);
    }

    public AbstractDirectMapping newDirectMapping() {
        return new EISDirectMapping();
    }

    public AggregateMapping newAggregateMapping() {
        return new EISCompositeObjectMapping();
    }

    public DatabaseMapping newAggregateCollectionMapping() {
        return new EISCompositeCollectionMapping();
    }

    public DatabaseMapping newDirectCollectionMapping() {
        return new EISCompositeDirectCollectionMapping();
    }

    public ObjectReferenceMapping newOneToOneMapping() {
        return new EISOneToOneMapping();
    }

    public ObjectReferenceMapping newManyToOneMapping() {
        return new EISOneToOneMapping();
    }

    public CollectionMapping newOneToManyMapping() {
        return new EISOneToManyMapping();
    }

    public CollectionMapping newManyToManyMapping() {
        return new EISOneToManyMapping();
    }

    public DatabaseMapping addDirectMapping(String attributeName, String fieldName) {
        EISDirectMapping mapping = new EISDirectMapping();
        mapping.setAttributeName(attributeName);
        if (this.isXMLFormat()) {
            mapping.setXPath(fieldName);
        } else {
            mapping.setFieldName(fieldName);
        }
        return this.addMapping(mapping);
    }

    public DatabaseMapping addDirectMapping(String attributeName, String getMethodName, String setMethodName, String fieldName) {
        EISDirectMapping mapping = new EISDirectMapping();
        mapping.setAttributeName(attributeName);
        mapping.setSetMethodName(setMethodName);
        mapping.setGetMethodName(getMethodName);
        if (this.isXMLFormat()) {
            mapping.setXPath(fieldName);
        } else {
            mapping.setFieldName(fieldName);
        }
        return this.addMapping(mapping);
    }

    public void addPrimaryKeyFieldName(String fieldName) {
        if (this.isXMLFormat()) {
            this.addPrimaryKeyField(new XMLField(fieldName));
        } else {
            super.addPrimaryKeyFieldName(fieldName);
        }
    }

    public void setSequenceNumberFieldName(String fieldName) {
        super.setSequenceNumberFieldName(fieldName);
    }

    public DatasourceCall buildCallFromStatement(SQLStatement statement, DatabaseQuery query, AbstractSession session) {
        return ((EISPlatform)session.getDatasourcePlatform()).buildCallFromStatement(statement, query, session);
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        if (this.isXMLFormat()) {
            int x = 0;
            int primaryKeyFieldsSize = this.primaryKeyFields.size();
            while (x < primaryKeyFieldsSize) {
                XMLField pkField = (XMLField)this.primaryKeyFields.get(x);
                pkField.setNamespaceResolver(this.namespaceResolver);
                pkField.initialize();
                ++x;
            }
        }
        super.initialize(session);
    }

    public void initializeAggregateInheritancePolicy(AbstractSession session) {
    }

    public boolean requiresInitialization() {
        return !this.isDescriptorForInterface();
    }

    protected DatabaseTable extractDefaultTable() {
        if (this.isAggregateDescriptor()) {
            return new DatabaseTable();
        }
        return super.extractDefaultTable();
    }

    public boolean isReturnTypeRequiredForReturningPolicy() {
        return false;
    }

    public boolean isEISDescriptor() {
        return true;
    }

    public boolean shouldUseFullChangeSetsForNewObjects() {
        return true;
    }
}

