/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.persistence.CascadeType;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import org.eclipse.persistence.annotations.BatchFetch;
import org.eclipse.persistence.annotations.CascadeOnDelete;
import org.eclipse.persistence.annotations.JoinFetch;
import org.eclipse.persistence.annotations.JoinField;
import org.eclipse.persistence.annotations.JoinFields;
import org.eclipse.persistence.annotations.Noncacheable;
import org.eclipse.persistence.annotations.PrivateOwned;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProcessor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.mappings.CascadeMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.JoinTableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.RelationTableMechanism;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RelationshipAccessor
extends MappingAccessor {
    private Boolean m_orphanRemoval;
    private Boolean m_cascadeOnDelete;
    private Boolean m_nonCacheable;
    private Boolean m_privateOwned;
    private CascadeMetadata m_cascade;
    protected MetadataClass m_referenceClass;
    private MetadataClass m_targetEntity;
    private String m_fetch;
    private String m_mappedBy;
    private String m_joinFetch;
    private String m_batchFetch;
    private String m_targetEntityName;
    private Integer m_batchFetchSize;
    private JoinTableMetadata m_joinTable;
    private List<JoinColumnMetadata> m_joinColumns = new ArrayList<JoinColumnMetadata>();
    private List<JoinColumnMetadata> m_joinFields = new ArrayList<JoinColumnMetadata>();

    protected RelationshipAccessor(String xmlElement) {
        super(xmlElement);
    }

    protected RelationshipAccessor(MetadataAnnotation annotation, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(annotation, accessibleObject, classAccessor);
        Object joinColumn;
        int n;
        int n2;
        Object[] objectArray;
        this.m_fetch = annotation == null ? this.getDefaultFetchType() : (String)annotation.getAttribute("fetch");
        this.m_targetEntity = this.getMetadataClass(annotation == null ? "void" : (String)annotation.getAttributeString("targetEntity"));
        CascadeMetadata cascadeMetadata = this.m_cascade = annotation == null ? null : new CascadeMetadata((Object[])annotation.getAttributeArray("cascade"), (MetadataAccessor)this);
        if (this.isAnnotationPresent(JoinFetch.class)) {
            this.m_joinFetch = (String)this.getAnnotation(JoinFetch.class).getAttributeString("value");
        }
        if (this.isAnnotationPresent(BatchFetch.class)) {
            this.m_batchFetch = (String)this.getAnnotation(BatchFetch.class).getAttributeString("value");
            this.m_batchFetchSize = (Integer)this.getAnnotation(BatchFetch.class).getAttribute("size");
        }
        if (this.isAnnotationPresent(JoinColumns.class)) {
            objectArray = (Object[])this.getAnnotation(JoinColumns.class).getAttributeArray("value");
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                joinColumn = objectArray[n];
                this.m_joinColumns.add(new JoinColumnMetadata((MetadataAnnotation)joinColumn, this));
                ++n;
            }
        }
        if (this.isAnnotationPresent(JoinColumn.class)) {
            this.m_joinColumns.add(new JoinColumnMetadata(this.getAnnotation(JoinColumn.class), this));
        }
        if (this.isAnnotationPresent(JoinFields.class)) {
            objectArray = (Object[])this.getAnnotation(JoinFields.class).getAttributeArray("value");
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                joinColumn = objectArray[n];
                this.m_joinColumns.add(new JoinColumnMetadata((MetadataAnnotation)joinColumn, this));
                ++n;
            }
        }
        if (this.isAnnotationPresent(JoinField.class)) {
            this.m_joinColumns.add(new JoinColumnMetadata(this.getAnnotation(JoinField.class), this));
        }
        if (this.isAnnotationPresent(JoinTable.class)) {
            this.m_joinTable = new JoinTableMetadata(this.getAnnotation(JoinTable.class), this);
        }
        this.m_privateOwned = this.isAnnotationPresent(PrivateOwned.class);
        this.m_cascadeOnDelete = this.isAnnotationPresent(CascadeOnDelete.class);
        this.m_nonCacheable = this.isAnnotationPresent(Noncacheable.class);
    }

    protected void addJoinTableRelationKeyFields(List<JoinColumnMetadata> joinColumns, RelationTableMechanism mechanism, String defaultFieldName, MetadataDescriptor descriptor, boolean isSource) {
        String FK_CTX;
        String PK_CTX;
        if (isSource) {
            PK_CTX = "metadata_default_source_pk_column";
            FK_CTX = "metadata_default_source_fk_column";
        } else {
            PK_CTX = "metadata_default_target_pk_column";
            FK_CTX = "metadata_default_target_fk_column";
        }
        for (JoinColumnMetadata joinColumn : joinColumns) {
            DatabaseField pkField = this.getReferencedField(joinColumn.getReferencedColumnName(), descriptor, PK_CTX);
            DatabaseField fkField = joinColumn.getForeignKeyField(pkField);
            String defaultFKFieldName = String.valueOf(defaultFieldName) + "_" + descriptor.getPrimaryKeyFieldName();
            this.setFieldName(fkField, defaultFKFieldName, FK_CTX);
            fkField.setTable(mechanism.getRelationTable());
            if (isSource) {
                mechanism.addSourceRelationKeyField(fkField, pkField);
                continue;
            }
            mechanism.addTargetRelationKeyField(fkField, pkField);
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof RelationshipAccessor) {
            RelationshipAccessor relationshipAccessor = (RelationshipAccessor)objectToCompare;
            if (!this.valuesMatch(this.m_orphanRemoval, relationshipAccessor.getOrphanRemoval())) {
                return false;
            }
            if (!this.valuesMatch(this.m_privateOwned, relationshipAccessor.getPrivateOwned())) {
                return false;
            }
            if (!this.valuesMatch(this.m_nonCacheable, relationshipAccessor.getNonCacheable())) {
                return false;
            }
            if (!this.valuesMatch(this.m_cascade, relationshipAccessor.getCascade())) {
                return false;
            }
            if (!this.valuesMatch(this.m_mappedBy, relationshipAccessor.getMappedBy())) {
                return false;
            }
            if (!this.valuesMatch(this.m_fetch, relationshipAccessor.getFetch())) {
                return false;
            }
            if (!this.valuesMatch(this.m_joinFetch, relationshipAccessor.getJoinFetch())) {
                return false;
            }
            if (!this.valuesMatch(this.m_batchFetch, relationshipAccessor.getBatchFetch())) {
                return false;
            }
            if (!this.valuesMatch(this.m_batchFetchSize, relationshipAccessor.getBatchFetchSize())) {
                return false;
            }
            if (!this.valuesMatch(this.m_joinTable, relationshipAccessor.getJoinTable())) {
                return false;
            }
            if (!this.valuesMatch(this.m_joinColumns, relationshipAccessor.getJoinColumns())) {
                return false;
            }
            return this.valuesMatch(this.m_targetEntityName, relationshipAccessor.getTargetEntityName());
        }
        return false;
    }

    public String getBatchFetch() {
        return this.m_batchFetch;
    }

    public Boolean getCascadeOnDelete() {
        return this.m_cascadeOnDelete;
    }

    public Integer getBatchFetchSize() {
        return this.m_batchFetchSize;
    }

    public CascadeMetadata getCascade() {
        return this.m_cascade;
    }

    @Override
    public abstract String getDefaultFetchType();

    @Override
    protected DatabaseTable getDefaultTableForEntityMapKey() {
        if (this.getJoinTable() != null) {
            return this.getJoinTable().getDatabaseTable();
        }
        return super.getDefaultTableForEntityMapKey();
    }

    public String getFetch() {
        return this.m_fetch;
    }

    public List<JoinColumnMetadata> getJoinColumns() {
        return this.m_joinColumns;
    }

    public List<JoinColumnMetadata> getJoinFields() {
        return this.m_joinFields;
    }

    public String getJoinFetch() {
        return this.m_joinFetch;
    }

    public JoinTableMetadata getJoinTable() {
        return this.m_joinTable;
    }

    protected JoinTableMetadata getJoinTableMetadata() {
        if (this.getDescriptor().hasAssociationOverrideFor(this.getAttributeName())) {
            this.m_joinTable = this.getDescriptor().getAssociationOverrideFor(this.getAttributeName()).getJoinTable();
        } else if (this.m_joinTable == null) {
            this.m_joinTable = new JoinTableMetadata(this.getClassAccessor());
        }
        return this.m_joinTable;
    }

    protected abstract String getLoggingContext();

    public String getMappedBy() {
        return this.m_mappedBy;
    }

    public Boolean getNonCacheable() {
        return this.m_nonCacheable;
    }

    public Boolean getOrphanRemoval() {
        return this.m_orphanRemoval;
    }

    protected DatabaseMapping getOwningMappingAccessor() {
        RelationshipAccessor relationshipAccessor;
        String mappedBy;
        MetadataDescriptor ownerDescriptor = this.getReferenceDescriptor();
        MappingAccessor mappingAccessor = ownerDescriptor.getMappingAccessor(this.getMappedBy());
        if (mappingAccessor == null) {
            throw ValidationException.noMappedByAttributeFound(ownerDescriptor.getJavaClass(), this.getMappedBy(), this.getJavaClass(), this.getAttributeName());
        }
        if (mappingAccessor.isRelationship() && (mappedBy = (relationshipAccessor = (RelationshipAccessor)mappingAccessor).getMappedBy()) != null && mappedBy.equals(this.getAttributeName())) {
            throw ValidationException.circularMappedByReferences(this.getJavaClass(), this.getAttributeName(), this.getJavaClass(), this.getMappedBy());
        }
        return mappingAccessor.getMapping();
    }

    public Boolean getPrivateOwned() {
        return this.m_privateOwned;
    }

    @Override
    public MetadataDescriptor getReferenceDescriptor() {
        MetadataDescriptor referenceDescriptor;
        block4: {
            MetadataProcessor compositeProcessor;
            block3: {
                if ((!this.getDescriptor().isMappedSuperclass() || !this.getReferenceClassName().equals("java.lang.String")) && !this.getReferenceClass().isVoid()) break block3;
                MappingAccessor childMappingAccessor = this.getDescriptor().getMetamodelMappedSuperclassChildDescriptor().getMappingAccessor(this.getAttributeName());
                referenceDescriptor = childMappingAccessor.getReferenceDescriptor();
                if (!referenceDescriptor.isInheritanceSubclass()) break block4;
                referenceDescriptor = referenceDescriptor.getInheritanceRootDescriptor();
                break block4;
            }
            ClassAccessor accessor = this.getProject().getAccessor(this.getReferenceClassName());
            MetadataDescriptor metadataDescriptor = referenceDescriptor = accessor != null ? accessor.getDescriptor() : null;
            if (referenceDescriptor == null && (compositeProcessor = this.getProject().getCompositeProcessor()) != null) {
                for (MetadataProject pearProject : compositeProcessor.getPearProjects(this.getProject())) {
                    accessor = pearProject.getAccessor(this.getReferenceClassName());
                    if (accessor == null) continue;
                    referenceDescriptor = accessor.getDescriptor();
                    break;
                }
            }
        }
        if (referenceDescriptor == null || referenceDescriptor.isEmbeddable() || referenceDescriptor.isEmbeddableCollection()) {
            throw ValidationException.nonEntityTargetInRelationship(this.getJavaClass(), this.getReferenceClass(), this.getAnnotatedElement());
        }
        return referenceDescriptor;
    }

    public MetadataClass getTargetEntity() {
        return this.m_targetEntity;
    }

    public String getTargetEntityName() {
        return this.m_targetEntityName;
    }

    protected boolean hasJoinTable() {
        return this.m_joinTable != null;
    }

    public boolean hasMappedBy() {
        return this.getMappedBy() != null && !this.getMappedBy().equals("");
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        if (this.m_joinFields != null) {
            this.m_joinColumns.addAll(this.m_joinFields);
        }
        this.initXMLObjects(this.m_joinColumns, accessibleObject);
        this.initXMLObject(this.m_joinTable, accessibleObject);
        this.initXMLObject(this.m_cascade, accessibleObject);
        this.m_targetEntity = this.initXMLClassName(this.m_targetEntityName);
    }

    public boolean isCascadeOnDelete() {
        return this.m_cascadeOnDelete != null && this.m_cascadeOnDelete != false;
    }

    public boolean isLazy() {
        String fetchType = this.getFetch();
        if (fetchType == null) {
            fetchType = this.getDefaultFetchType();
        }
        return fetchType.equals(FetchType.LAZY.name());
    }

    public boolean isNonCacheable() {
        return this.m_nonCacheable != null && this.m_nonCacheable != false;
    }

    protected boolean isOrphanRemoval() {
        return this.m_orphanRemoval != null && this.m_orphanRemoval != false;
    }

    public boolean isPrivateOwned() {
        return this.m_privateOwned != null && this.m_privateOwned != false;
    }

    public boolean isValueHolderInterface() {
        return this.getTargetEntity().getName().equals(ValueHolderInterface.class.getName()) || this.getTargetEntity().getName().equals(Void.TYPE.getName()) && this.getReferenceClass().getName().equals(ValueHolderInterface.class.getName());
    }

    @Override
    public void process() {
        if (!this.isProcessed()) {
            if (this.hasColumn()) {
                throw ValidationException.invalidColumnAnnotationOnRelationship(this.getJavaClass(), this.getAttributeName());
            }
            if (this.hasConvert(false)) {
                throw ValidationException.invalidMappingForConverter(this.getJavaClass(), this.getAttributeName());
            }
        }
    }

    protected void processCascadeTypes(ForeignReferenceMapping mapping) {
        if (this.m_cascade != null) {
            for (String cascadeType : this.m_cascade.getTypes()) {
                this.setCascadeType(cascadeType, mapping);
            }
        }
        if (this.getDescriptor().isCascadePersist() && !mapping.isCascadePersist()) {
            this.setCascadeType(CascadeType.PERSIST.name(), mapping);
        }
    }

    protected void processJoinTable(ForeignReferenceMapping mapping, RelationTableMechanism mechanism, JoinTableMetadata joinTable) {
        String defaultName = String.valueOf(this.getOwningDescriptor().getPrimaryTableName()) + "_" + this.getReferenceDescriptor().getPrimaryTableName();
        this.processTable(joinTable, defaultName);
        mechanism.setRelationTable(joinTable.getDatabaseTable());
        String defaultSourceFieldName = this.getReferenceDescriptor().hasBiDirectionalManyToManyAccessorFor(this.getJavaClassName(), this.getAttributeName()) ? this.getReferenceDescriptor().getBiDirectionalManyToManyAccessor(this.getJavaClassName(), this.getAttributeName()).getAttributeName() : this.getOwningDescriptor().getAlias();
        this.addJoinTableRelationKeyFields(this.getJoinColumnsAndValidate(joinTable.getJoinColumns(), this.getOwningDescriptor()), mechanism, defaultSourceFieldName, this.getOwningDescriptor(), true);
        String defaultTargetFieldName = this.getAttributeName();
        this.addJoinTableRelationKeyFields(this.getJoinColumnsAndValidate(joinTable.getInverseJoinColumns(), this.getReferenceDescriptor()), mechanism, defaultTargetFieldName, this.getReferenceDescriptor(), false);
        mapping.setShouldExtendPessimisticLockScope(true);
    }

    protected void processMappedByRelationTable(RelationTableMechanism ownerMechanism, RelationTableMechanism mechanism) {
        mechanism.setRelationTable(ownerMechanism.getRelationTable());
        if (this.getDescriptor().usesTablePerClassInheritanceStrategy()) {
            Vector<DatabaseField> targetKeyFields = new Vector<DatabaseField>();
            for (DatabaseField targetKeyField : ownerMechanism.getTargetKeyFields()) {
                DatabaseField newTargetKeyField = targetKeyField.clone();
                newTargetKeyField.setTable(this.getDescriptor().getPrimaryTable());
                targetKeyFields.add(newTargetKeyField);
            }
            mechanism.setSourceKeyFields(targetKeyFields);
        } else {
            mechanism.setSourceKeyFields(ownerMechanism.getTargetKeyFields());
        }
        mechanism.setSourceRelationKeyFields(ownerMechanism.getTargetRelationKeyFields());
        mechanism.setTargetKeyFields(ownerMechanism.getSourceKeyFields());
        mechanism.setTargetRelationKeyFields(ownerMechanism.getSourceRelationKeyFields());
    }

    protected void processOrphanRemoval(ForeignReferenceMapping mapping) {
        if (this.isOrphanRemoval()) {
            mapping.setIsPrivateOwned(true);
            mapping.setCascadeRemove(true);
        } else {
            mapping.setIsPrivateOwned(this.isPrivateOwned());
        }
    }

    protected void processRelationshipMapping(ForeignReferenceMapping mapping) {
        this.setMapping(mapping);
        mapping.setIsLazy(this.isLazy());
        mapping.setAttributeName(this.getAttributeName());
        mapping.setReferenceClassName(this.getReferenceClassName());
        mapping.setIsCascadeOnDeleteSetOnDatabase(this.isCascadeOnDelete());
        this.processJoinFetch(this.getJoinFetch(), mapping);
        this.processBatchFetch(this.getBatchFetch(), mapping);
        this.processOrphanRemoval(mapping);
        this.setAccessorMethods(mapping);
        this.processCascadeTypes(mapping);
        this.processPartitioning();
        mapping.setIsCacheable(!this.isNonCacheable());
    }

    @Override
    protected void setAccessorMethods(DatabaseMapping mapping) {
        super.setAccessorMethods(mapping);
        ((ForeignReferenceMapping)mapping).setRequiresTransientWeavedFields(this.usesPropertyAccess() && !this.getClassAccessor().usesPropertyAccess());
    }

    public void setBatchFetch(String batchFetch) {
        this.m_batchFetch = batchFetch;
    }

    public void setBatchFetchSize(Integer batchFetchSize) {
        this.m_batchFetchSize = batchFetchSize;
    }

    protected void setCascadeType(String type, ForeignReferenceMapping mapping) {
        if (type.equals(CascadeType.ALL.name())) {
            mapping.setCascadeAll(true);
        } else if (type.equals(CascadeType.MERGE.name())) {
            mapping.setCascadeMerge(true);
        } else if (type.equals(CascadeType.PERSIST.name())) {
            mapping.setCascadePersist(true);
        } else if (type.equals(CascadeType.REFRESH.name())) {
            mapping.setCascadeRefresh(true);
        } else if (type.equals(CascadeType.REMOVE.name())) {
            mapping.setCascadeRemove(true);
        } else if (type.equals(CascadeType.DETACH.name())) {
            mapping.setCascadeDetach(true);
        }
    }

    public void setCascade(CascadeMetadata cascade) {
        this.m_cascade = cascade;
    }

    public void setCascadeOnDelete(Boolean cascadeOnDelete) {
        this.m_cascadeOnDelete = cascadeOnDelete;
    }

    public void setFetch(String fetch) {
        this.m_fetch = fetch;
    }

    public void setJoinColumns(List<JoinColumnMetadata> joinColumns) {
        this.m_joinColumns = joinColumns;
    }

    public void setJoinFields(List<JoinColumnMetadata> joinFields) {
        this.m_joinFields = joinFields;
    }

    public void setJoinFetch(String joinFetch) {
        this.m_joinFetch = joinFetch;
    }

    public void setJoinTable(JoinTableMetadata joinTable) {
        this.m_joinTable = joinTable;
    }

    public void setMappedBy(String mappedBy) {
        this.m_mappedBy = mappedBy;
    }

    public void setNonCacheable(Boolean noncacheable) {
        this.m_nonCacheable = noncacheable;
    }

    public void setOrphanRemoval(Boolean orphanRemoval) {
        this.m_orphanRemoval = orphanRemoval;
    }

    public void setPrivateOwned(Boolean privateOwned) {
        this.m_privateOwned = privateOwned;
    }

    public void setTargetEntity(MetadataClass targetEntity) {
        this.m_targetEntity = targetEntity;
    }

    public void setTargetEntityName(String targetEntityName) {
        this.m_targetEntityName = targetEntityName;
    }

    @Override
    protected boolean usesIndirection() {
        if (this.getProject().isWeavingEagerEnabled()) {
            return true;
        }
        return this.isLazy();
    }
}

