/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.queries.FieldResultMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.queries.EntityResult;
import org.eclipse.persistence.queries.SQLResultSetMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityResultMetadata
extends ORMetadata {
    private MetadataClass m_entityClass;
    private List<FieldResultMetadata> m_fieldResults = new ArrayList<FieldResultMetadata>();
    private String m_discriminatorColumn;
    private String m_entityClassName;

    public EntityResultMetadata() {
        super("<entity-result>");
    }

    public EntityResultMetadata(MetadataAnnotation entityResult, MetadataAccessor accessor) {
        super(entityResult, accessor);
        this.m_entityClass = this.getMetadataClass((String)entityResult.getAttribute("entityClass"));
        this.m_discriminatorColumn = (String)entityResult.getAttribute("discriminatorColumn");
        Object[] objectArray = (Object[])entityResult.getAttributeArray("fields");
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object fieldResult = objectArray[n2];
            this.m_fieldResults.add(new FieldResultMetadata((MetadataAnnotation)fieldResult, accessor));
            ++n2;
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof EntityResultMetadata) {
            EntityResultMetadata entityResult = (EntityResultMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_entityClass, entityResult.getEntityClass())) {
                return false;
            }
            if (!this.valuesMatch(this.m_fieldResults, entityResult.getFieldResults())) {
                return false;
            }
            return this.valuesMatch(this.m_discriminatorColumn, entityResult.getDiscriminatorColumn());
        }
        return false;
    }

    public String getDiscriminatorColumn() {
        return this.m_discriminatorColumn;
    }

    public MetadataClass getEntityClass() {
        return this.m_entityClass;
    }

    public String getEntityClassName() {
        return this.m_entityClassName;
    }

    public List<FieldResultMetadata> getFieldResults() {
        return this.m_fieldResults;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObjects(this.m_fieldResults, accessibleObject);
        this.m_entityClass = this.initXMLClassName(this.m_entityClassName);
    }

    public void process(SQLResultSetMapping mapping, ClassLoader loader) {
        EntityResult entityResult = new EntityResult(MetadataHelper.getClassForName(this.getEntityClass().getName(), loader));
        for (FieldResultMetadata fieldResult : this.getFieldResults()) {
            fieldResult.process(entityResult);
        }
        if (this.getDiscriminatorColumn() != null) {
            DatabaseField discriminatorField = new DatabaseField();
            this.setFieldName(discriminatorField, this.getDiscriminatorColumn());
            entityResult.setDiscriminatorColumn(discriminatorField);
        }
        mapping.addResult(entityResult);
    }

    public void setDiscriminatorColumn(String discriminatorColumn) {
        this.m_discriminatorColumn = discriminatorColumn;
    }

    public void setEntityClass(MetadataClass entityClass) {
        this.m_entityClass = entityClass;
    }

    public void setEntityClassName(String entityClassName) {
        this.m_entityClassName = entityClassName;
    }

    public void setFieldResults(List<FieldResultMetadata> fieldResults) {
        this.m_fieldResults = fieldResults;
    }
}

