/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.awt.Image;
import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessorOrder;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttachmentRef;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlInlineBinaryData;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlMimeType;
import javax.xml.bind.annotation.XmlMixed;
import javax.xml.bind.annotation.XmlNs;
import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.bind.annotation.XmlRegistry;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSchemaTypes;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapters;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.eclipse.persistence.exceptions.JAXBException;
import org.eclipse.persistence.internal.descriptors.Namespace;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.jaxb.JaxbClassLoader;
import org.eclipse.persistence.internal.libraries.asm.AnnotationVisitor;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;
import org.eclipse.persistence.internal.libraries.asm.FieldVisitor;
import org.eclipse.persistence.internal.libraries.asm.Label;
import org.eclipse.persistence.internal.libraries.asm.MethodVisitor;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.TypeMappingInfo;
import org.eclipse.persistence.jaxb.compiler.CompilerHelper;
import org.eclipse.persistence.jaxb.compiler.ElementDeclaration;
import org.eclipse.persistence.jaxb.compiler.EnumTypeInfo;
import org.eclipse.persistence.jaxb.compiler.JAXBMetadataLogger;
import org.eclipse.persistence.jaxb.compiler.MarshalCallback;
import org.eclipse.persistence.jaxb.compiler.NamespaceInfo;
import org.eclipse.persistence.jaxb.compiler.PackageInfo;
import org.eclipse.persistence.jaxb.compiler.Property;
import org.eclipse.persistence.jaxb.compiler.SchemaTypeInfo;
import org.eclipse.persistence.jaxb.compiler.TypeInfo;
import org.eclipse.persistence.jaxb.compiler.UnmarshalCallback;
import org.eclipse.persistence.jaxb.compiler.XMLProcessor;
import org.eclipse.persistence.jaxb.javamodel.AnnotationProxy;
import org.eclipse.persistence.jaxb.javamodel.Helper;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaConstructor;
import org.eclipse.persistence.jaxb.javamodel.JavaField;
import org.eclipse.persistence.jaxb.javamodel.JavaHasAnnotations;
import org.eclipse.persistence.jaxb.javamodel.JavaMethod;
import org.eclipse.persistence.jaxb.javamodel.JavaPackage;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaFieldImpl;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAccessOrder;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAccessType;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElement;
import org.eclipse.persistence.jaxb.xmlmodel.XmlIsSetNullPolicy;
import org.eclipse.persistence.jaxb.xmlmodel.XmlJavaTypeAdapter;
import org.eclipse.persistence.jaxb.xmlmodel.XmlJoinNodes;
import org.eclipse.persistence.jaxb.xmlmodel.XmlMarshalNullRepresentation;
import org.eclipse.persistence.jaxb.xmlmodel.XmlRegistry;
import org.eclipse.persistence.jaxb.xmlmodel.XmlTransformation;
import org.eclipse.persistence.jaxb.xmlmodel.XmlVirtualAccessMethodsSchema;
import org.eclipse.persistence.mappings.transformers.AttributeTransformer;
import org.eclipse.persistence.mappings.transformers.FieldTransformer;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLNameTransformer;
import org.eclipse.persistence.oxm.annotations.XmlAccessMethods;
import org.eclipse.persistence.oxm.annotations.XmlCDATA;
import org.eclipse.persistence.oxm.annotations.XmlClassExtractor;
import org.eclipse.persistence.oxm.annotations.XmlContainerProperty;
import org.eclipse.persistence.oxm.annotations.XmlCustomizer;
import org.eclipse.persistence.oxm.annotations.XmlDiscriminatorNode;
import org.eclipse.persistence.oxm.annotations.XmlDiscriminatorValue;
import org.eclipse.persistence.oxm.annotations.XmlElementsJoinNodes;
import org.eclipse.persistence.oxm.annotations.XmlInverseReference;
import org.eclipse.persistence.oxm.annotations.XmlIsSetNullPolicy;
import org.eclipse.persistence.oxm.annotations.XmlJoinNode;
import org.eclipse.persistence.oxm.annotations.XmlJoinNodes;
import org.eclipse.persistence.oxm.annotations.XmlKey;
import org.eclipse.persistence.oxm.annotations.XmlLocation;
import org.eclipse.persistence.oxm.annotations.XmlNameTransformer;
import org.eclipse.persistence.oxm.annotations.XmlNullPolicy;
import org.eclipse.persistence.oxm.annotations.XmlParameter;
import org.eclipse.persistence.oxm.annotations.XmlPath;
import org.eclipse.persistence.oxm.annotations.XmlPaths;
import org.eclipse.persistence.oxm.annotations.XmlProperties;
import org.eclipse.persistence.oxm.annotations.XmlProperty;
import org.eclipse.persistence.oxm.annotations.XmlReadOnly;
import org.eclipse.persistence.oxm.annotations.XmlReadTransformer;
import org.eclipse.persistence.oxm.annotations.XmlVirtualAccessMethods;
import org.eclipse.persistence.oxm.annotations.XmlWriteOnly;
import org.eclipse.persistence.oxm.annotations.XmlWriteTransformer;
import org.eclipse.persistence.oxm.annotations.XmlWriteTransformers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsProcessor {
    static final String JAVAX_ACTIVATION_DATAHANDLER = "javax.activation.DataHandler";
    static final String JAVAX_MAIL_INTERNET_MIMEMULTIPART = "javax.mail.internet.MimeMultipart";
    private static final String JAVAX_XML_BIND_JAXBELEMENT = "javax.xml.bind.JAXBElement";
    private static final String TYPE_METHOD_NAME = "type";
    private static final String VALUE_METHOD_NAME = "value";
    private static final String ARRAY_PACKAGE_NAME = "jaxb.dev.java.net.array";
    private static final String ARRAY_NAMESPACE = "http://jaxb.dev.java.net/array";
    private static final String ARRAY_CLASS_NAME_SUFFIX = "Array";
    private static final String JAXB_DEV = "jaxb.dev.java.net";
    private static final String ORG_W3C_DOM = "org.w3c.dom";
    private static final String CREATE = "create";
    private static final String ELEMENT_DECL_GLOBAL = "javax.xml.bind.annotation.XmlElementDecl.GLOBAL";
    private static final String ELEMENT_DECL_DEFAULT = "\u0000";
    private static final String EMPTY_STRING = "";
    private static final String JAVA_UTIL_LIST = "java.util.List";
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private static final String SLASH = "/";
    private static final String SEMI_COLON = ";";
    private static final String L = "L";
    private static final String ITEM = "item";
    private static final String IS_STR = "is";
    private static final String GET_STR = "get";
    private static final String SET_STR = "set";
    private static final Character DOT_CHR = Character.valueOf('.');
    private static final Character DOLLAR_SIGN_CHR = Character.valueOf('$');
    private static final Character SLASH_CHR = Character.valueOf('/');
    private ArrayList<JavaClass> typeInfoClasses;
    private HashMap<String, PackageInfo> packageToPackageInfoMappings;
    private HashMap<String, MarshalCallback> marshalCallbacks;
    private HashMap<String, QName> userDefinedSchemaTypes;
    private HashMap<String, TypeInfo> typeInfo;
    private ArrayList<QName> typeQNames;
    private HashMap<String, UnmarshalCallback> unmarshalCallbacks;
    private HashMap<String, HashMap<QName, ElementDeclaration>> elementDeclarations;
    private HashMap<String, ElementDeclaration> xmlRootElements;
    private List<ElementDeclaration> localElements;
    private HashMap<String, JavaMethod> factoryMethods;
    private Map<String, org.eclipse.persistence.jaxb.xmlmodel.XmlRegistry> xmlRegistries;
    private List<String> objectFactoryClassNames;
    private List<JavaClass> classesToProcessPropertyTypes;
    private Map<String, Class> arrayClassesToGeneratedClasses;
    private Map<Class, JavaClass> generatedClassesToArrayClasses;
    private Map<Type, Class> collectionClassesToGeneratedClasses;
    private Map<Class, Type> generatedClassesToCollectionClasses;
    private Map<JavaClass, TypeMappingInfo> javaClassToTypeMappingInfos;
    private Map<TypeMappingInfo, Class> typeMappingInfoToGeneratedClasses;
    private Map<TypeMappingInfo, Class> typeMappingInfoToAdapterClasses;
    private Map<TypeMappingInfo, QName> typeMappingInfoToSchemaType;
    private NamespaceResolver namespaceResolver;
    private Helper helper;
    private String defaultTargetNamespace;
    private JAXBMetadataLogger logger;
    private boolean isDefaultNamespaceAllowed;
    private boolean hasSwaRef;
    private List<String> referencedByTransformer;

    public AnnotationsProcessor(Helper helper) {
        this.helper = helper;
        this.isDefaultNamespaceAllowed = true;
        this.hasSwaRef = false;
    }

    void postInitialize() {
        this.typeInfoClasses = null;
        this.packageToPackageInfoMappings = null;
        this.typeInfo = null;
        this.typeQNames = null;
        this.elementDeclarations = null;
        this.xmlRootElements = null;
        this.localElements = null;
        this.factoryMethods = null;
        this.xmlRegistries = null;
        this.objectFactoryClassNames = null;
        this.classesToProcessPropertyTypes = null;
        this.javaClassToTypeMappingInfos = null;
        this.typeMappingInfoToGeneratedClasses = null;
        this.typeMappingInfoToAdapterClasses = null;
        this.namespaceResolver = null;
        this.helper = null;
        this.logger = null;
        this.referencedByTransformer = null;
    }

    void processClassesAndProperties(JavaClass[] classes, TypeMappingInfo[] typeMappingInfos) {
        this.init(classes, typeMappingInfos);
        this.preBuildTypeInfo(classes);
        classes = this.postBuildTypeInfo(classes);
        this.processPropertyTypes(this.typeInfoClasses.toArray(new JavaClass[this.typeInfoClasses.size()]));
        this.finalizeProperties();
        this.createElementsForTypeMappingInfo();
        this.processJavaClasses(null);
    }

    public void createElementsForTypeMappingInfo() {
        if (this.javaClassToTypeMappingInfos != null && !this.javaClassToTypeMappingInfos.isEmpty()) {
            Set<JavaClass> classes = this.javaClassToTypeMappingInfos.keySet();
            for (JavaClass nextClass : classes) {
                Class generatedClass;
                TypeInfo nextTypeInfo;
                Class generatedClass2;
                TypeMappingInfo nextInfo = this.javaClassToTypeMappingInfos.get(nextClass);
                if (nextInfo == null) continue;
                boolean xmlAttachmentRef = false;
                String xmlMimeType = null;
                Annotation[] annotations = this.getAnnotations(nextInfo);
                Class adapterClass = this.typeMappingInfoToAdapterClasses.get(nextInfo);
                Class declJavaType = null;
                if (adapterClass != null) {
                    declJavaType = CompilerHelper.getTypeFromAdapterClass(adapterClass);
                }
                if (annotations != null) {
                    int j = 0;
                    while (j < annotations.length) {
                        Annotation nextAnnotation = annotations[j];
                        if (nextAnnotation != null) {
                            if (nextAnnotation instanceof XmlMimeType) {
                                XmlMimeType javaAnnotation = (XmlMimeType)nextAnnotation;
                                xmlMimeType = javaAnnotation.value();
                            } else if (nextAnnotation instanceof XmlAttachmentRef) {
                                xmlAttachmentRef = true;
                                if (!this.hasSwaRef) {
                                    this.hasSwaRef = true;
                                }
                            }
                        }
                        ++j;
                    }
                }
                QName qname = null;
                String nextClassName = nextClass.getQualifiedName();
                if (declJavaType != null) {
                    nextClassName = declJavaType.getCanonicalName();
                }
                if (this.typeMappingInfoToGeneratedClasses != null && (generatedClass2 = this.typeMappingInfoToGeneratedClasses.get(nextInfo)) != null) {
                    nextClassName = generatedClass2.getCanonicalName();
                }
                if ((nextTypeInfo = this.typeInfo.get(nextClassName)) != null) {
                    qname = new QName(nextTypeInfo.getClassNamespace(), nextTypeInfo.getSchemaTypeName());
                } else {
                    qname = this.getUserDefinedSchemaTypes().get(nextClassName);
                    if (qname == null) {
                        if (nextClassName.equals(ClassConstants.APBYTE.getName()) || nextClassName.equals(Image.class.getName()) || nextClassName.equals(Source.class.getName()) || nextClassName.equals(JAVAX_ACTIVATION_DATAHANDLER)) {
                            qname = xmlAttachmentRef ? XMLConstants.SWA_REF_QNAME : XMLConstants.BASE_64_BINARY_QNAME;
                        } else if (nextClassName.equals(ClassConstants.OBJECT.getName())) {
                            qname = XMLConstants.ANY_TYPE_QNAME;
                        } else if (nextClassName.equals(ClassConstants.XML_GREGORIAN_CALENDAR.getName())) {
                            qname = XMLConstants.ANY_SIMPLE_TYPE_QNAME;
                        } else {
                            Class theClass = this.helper.getClassForJavaClass(nextClass);
                            qname = (QName)XMLConversionManager.getDefaultJavaTypes().get(theClass);
                        }
                    }
                }
                if (qname != null) {
                    this.typeMappingInfoToSchemaType.put(nextInfo, qname);
                }
                if (nextInfo.getXmlTagName() == null) continue;
                ElementDeclaration element = new ElementDeclaration(nextInfo.getXmlTagName(), nextClass, nextClass.getQualifiedName(), false);
                element.setTypeMappingInfo(nextInfo);
                element.setXmlMimeType(xmlMimeType);
                element.setXmlAttachmentRef(xmlAttachmentRef);
                element.setNillable(nextInfo.isNillable());
                if (declJavaType != null) {
                    element.setJavaType(this.helper.getJavaClass(declJavaType));
                }
                if ((generatedClass = this.typeMappingInfoToGeneratedClasses.get(nextInfo)) != null) {
                    element.setJavaType(this.helper.getJavaClass(generatedClass));
                }
                if (nextInfo.getElementScope() == TypeMappingInfo.ElementScope.Global) {
                    ElementDeclaration currentElement = this.getGlobalElements().get(element.getElementName());
                    if (currentElement == null) {
                        this.addGlobalElement(element.getElementName(), element);
                    } else {
                        this.localElements.add(element);
                    }
                } else {
                    this.localElements.add(element);
                }
                String rootNamespace = element.getElementName().getNamespaceURI();
                if (rootNamespace == null) {
                    rootNamespace = EMPTY_STRING;
                }
                if (!rootNamespace.equals(EMPTY_STRING)) continue;
                this.isDefaultNamespaceAllowed = false;
            }
        }
    }

    private Annotation[] getAnnotations(TypeMappingInfo tmInfo) {
        if (tmInfo.getXmlElement() != null) {
            ClassLoader loader = this.helper.getClassLoader();
            ConversionManager cMgr = new ConversionManager();
            cMgr.setLoader(loader);
            XmlElement xElt = CompilerHelper.getXmlElement(tmInfo.getXmlElement(), loader);
            ArrayList<Object> annotations = new ArrayList<Object>();
            HashMap<String, Object> components = null;
            if (!xElt.getType().equals("javax.xml.bind.annotation.XmlElement.DEFAULT")) {
                components = new HashMap<String, Object>();
                components.put(TYPE_METHOD_NAME, xElt.getType());
                annotations.add(AnnotationProxy.getProxy(components, javax.xml.bind.annotation.XmlElement.class, loader, cMgr));
            }
            if (xElt.isXmlList()) {
                annotations.add(AnnotationProxy.getProxy(components, XmlList.class, loader, cMgr));
            }
            if (xElt.isXmlAttachmentRef()) {
                annotations.add(AnnotationProxy.getProxy(components, XmlAttachmentRef.class, loader, cMgr));
            }
            if (xElt.getXmlMimeType() != null) {
                components = new HashMap();
                components.put(VALUE_METHOD_NAME, xElt.getXmlMimeType());
                annotations.add(AnnotationProxy.getProxy(components, XmlMimeType.class, loader, cMgr));
            }
            if (xElt.getXmlJavaTypeAdapter() != null) {
                components = new HashMap();
                components.put(TYPE_METHOD_NAME, xElt.getXmlJavaTypeAdapter().getType());
                components.put(VALUE_METHOD_NAME, xElt.getXmlJavaTypeAdapter().getValue());
                annotations.add(AnnotationProxy.getProxy(components, javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter.class, loader, cMgr));
            }
            return annotations.toArray(new Annotation[annotations.size()]);
        }
        return tmInfo.getAnnotations();
    }

    void init(JavaClass[] classes, TypeMappingInfo[] typeMappingInfos) {
        this.typeInfoClasses = new ArrayList();
        this.referencedByTransformer = new ArrayList<String>();
        this.typeInfo = new HashMap();
        this.typeQNames = new ArrayList();
        this.classesToProcessPropertyTypes = new ArrayList<JavaClass>();
        this.objectFactoryClassNames = new ArrayList<String>();
        this.userDefinedSchemaTypes = new HashMap();
        if (this.packageToPackageInfoMappings == null) {
            this.packageToPackageInfoMappings = new HashMap();
        }
        this.factoryMethods = new HashMap();
        this.xmlRegistries = new HashMap<String, org.eclipse.persistence.jaxb.xmlmodel.XmlRegistry>();
        this.namespaceResolver = new NamespaceResolver();
        this.xmlRootElements = new HashMap();
        this.arrayClassesToGeneratedClasses = new HashMap<String, Class>();
        this.collectionClassesToGeneratedClasses = new HashMap<Type, Class>();
        this.generatedClassesToArrayClasses = new HashMap<Class, JavaClass>();
        this.generatedClassesToCollectionClasses = new HashMap<Class, Type>();
        this.typeMappingInfoToGeneratedClasses = new HashMap<TypeMappingInfo, Class>();
        this.typeMappingInfoToSchemaType = new HashMap<TypeMappingInfo, QName>();
        this.elementDeclarations = new HashMap();
        HashMap globalElements = new HashMap();
        this.elementDeclarations.put(XmlElementDecl.GLOBAL.class.getName(), globalElements);
        this.localElements = new ArrayList<ElementDeclaration>();
        this.javaClassToTypeMappingInfos = new HashMap<JavaClass, TypeMappingInfo>();
        if (typeMappingInfos != null) {
            int i = 0;
            while (i < typeMappingInfos.length) {
                this.javaClassToTypeMappingInfos.put(classes[i], typeMappingInfos[i]);
                ++i;
            }
        }
        this.typeMappingInfoToAdapterClasses = new HashMap<TypeMappingInfo, Class>();
        if (typeMappingInfos != null) {
            TypeMappingInfo[] typeMappingInfoArray = typeMappingInfos;
            int n = typeMappingInfos.length;
            int n2 = 0;
            while (n2 < n) {
                TypeMappingInfo next = typeMappingInfoArray[n2];
                Annotation[] annotations = this.getAnnotations(next);
                if (annotations != null) {
                    Annotation[] annotationArray = annotations;
                    int n3 = annotations.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Annotation nextAnnotation = annotationArray[n4];
                        if (nextAnnotation instanceof javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter) {
                            this.typeMappingInfoToAdapterClasses.put(next, ((javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter)nextAnnotation).value());
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    public Map<String, TypeInfo> preBuildTypeInfo(JavaClass[] javaClasses) {
        JavaClass[] javaClassArray = javaClasses;
        int n = javaClasses.length;
        int n2 = 0;
        while (n2 < n) {
            TypeInfo info;
            JavaClass javaClass = javaClassArray[n2];
            if (!(javaClass == null || !this.shouldGenerateTypeInfo(javaClass) || this.isXmlRegistry(javaClass) || javaClass.isArray() || (info = this.typeInfo.get(javaClass.getQualifiedName())) != null && info.isPreBuilt())) {
                Map<Object, Object> propertiesMap;
                info = javaClass.isEnum() ? new EnumTypeInfo(this.helper) : new TypeInfo(this.helper);
                info.setJavaClassName(javaClass.getQualifiedName());
                info.setPreBuilt(true);
                if (this.helper.isAnnotationPresent(javaClass, XmlTransient.class)) {
                    info.setXmlTransient(true);
                }
                this.processXmlExtensible(javaClass, info);
                if (this.helper.isAnnotationPresent(javaClass, XmlInlineBinaryData.class)) {
                    info.setInlineBinaryData(true);
                }
                this.processXmlRootElement(javaClass, info);
                this.processXmlSeeAlso(javaClass, info);
                PackageInfo packageInfo = this.getPackageInfoForPackage(javaClass);
                if (packageInfo != null && packageInfo.getPackageLevelAdaptersByClass().size() > 0) {
                    for (String adapterClass : packageInfo.getPackageLevelAdaptersByClass().keySet()) {
                        JavaClass boundType = packageInfo.getPackageLevelAdaptersByClass().get(adapterClass);
                        info.getPackageLevelAdaptersByClass().put(adapterClass, boundType);
                    }
                }
                this.preProcessXmlType(javaClass, info, packageInfo.getNamespaceInfo());
                this.preProcessXmlAccessorType(javaClass, info, packageInfo.getNamespaceInfo());
                this.preProcessXmlAccessorOrder(javaClass, info, packageInfo.getNamespaceInfo());
                this.processPackageLevelAdapters(javaClass, info);
                this.processClassLevelAdapters(javaClass, info);
                this.preProcessCustomizer(javaClass, info);
                this.processSchemaTypes(javaClass, info);
                if (this.helper.isAnnotationPresent(javaClass, XmlClassExtractor.class)) {
                    XmlClassExtractor classExtractor = (XmlClassExtractor)this.helper.getAnnotation(javaClass, XmlClassExtractor.class);
                    info.setClassExtractorName(classExtractor.value().getName());
                }
                if (this.helper.isAnnotationPresent(javaClass, XmlProperties.class)) {
                    XmlProperties xmlProperties = (XmlProperties)this.helper.getAnnotation(javaClass, XmlProperties.class);
                    propertiesMap = this.createUserPropertiesMap(xmlProperties.value());
                    info.setUserProperties(propertiesMap);
                } else if (this.helper.isAnnotationPresent(javaClass, XmlProperty.class)) {
                    XmlProperty xmlProperty = (XmlProperty)this.helper.getAnnotation(javaClass, XmlProperty.class);
                    propertiesMap = this.createUserPropertiesMap(new XmlProperty[]{xmlProperty});
                    info.setUserProperties(propertiesMap);
                }
                if (this.helper.isAnnotationPresent(javaClass, XmlDiscriminatorNode.class)) {
                    XmlDiscriminatorNode xmlDiscriminatorNode = (XmlDiscriminatorNode)this.helper.getAnnotation(javaClass, XmlDiscriminatorNode.class);
                    info.setXmlDiscriminatorNode(xmlDiscriminatorNode.value());
                }
                if (this.helper.isAnnotationPresent(javaClass, XmlDiscriminatorValue.class)) {
                    XmlDiscriminatorValue xmlDiscriminatorValue = (XmlDiscriminatorValue)this.helper.getAnnotation(javaClass, XmlDiscriminatorValue.class);
                    info.setXmlDiscriminatorValue(xmlDiscriminatorValue.value());
                }
                this.typeInfoClasses.add(javaClass);
                this.typeInfo.put(info.getJavaClassName(), info);
            }
            ++n2;
        }
        return this.typeInfo;
    }

    public JavaClass[] postBuildTypeInfo(JavaClass[] javaClasses) {
        if (javaClasses.length == 0) {
            return javaClasses;
        }
        javaClasses = this.processAdditionalClasses(javaClasses);
        this.preBuildTypeInfo(javaClasses);
        this.buildTypeInfo(javaClasses);
        this.updateGlobalElements(javaClasses);
        return javaClasses;
    }

    private Map<String, TypeInfo> buildTypeInfo(JavaClass[] allClasses) {
        JavaClass[] javaClassArray = allClasses;
        int n = allClasses.length;
        int n2 = 0;
        while (n2 < n) {
            TypeInfo info;
            JavaClass javaClass = javaClassArray[n2];
            if (javaClass != null && (info = this.typeInfo.get(javaClass.getQualifiedName())) != null && !info.isPostBuilt()) {
                info.setPostBuilt(true);
                this.processFactoryMethods(javaClass, info);
                PackageInfo packageInfo = this.getPackageInfoForPackage(javaClass);
                XMLNameTransformer transformer = info.getXmlNameTransformer();
                if (transformer == TypeInfo.DEFAULT_NAME_TRANSFORMER) {
                    XMLNameTransformer nsInfoXmlNameTransformer = packageInfo.getXmlNameTransformer();
                    if (nsInfoXmlNameTransformer != null) {
                        info.setXmlNameTransformer(nsInfoXmlNameTransformer);
                    } else {
                        Class<? extends XMLNameTransformer> nameTransformerClass;
                        XmlNameTransformer nameTranformer;
                        if (this.helper.isAnnotationPresent(javaClass, XmlNameTransformer.class)) {
                            nameTranformer = (XmlNameTransformer)this.helper.getAnnotation(javaClass, XmlNameTransformer.class);
                            nameTransformerClass = nameTranformer.value();
                            try {
                                info.setXmlNameTransformer(nameTransformerClass.newInstance());
                            }
                            catch (InstantiationException ex) {
                                throw JAXBException.exceptionWithNameTransformerClass(nameTransformerClass.getName(), ex);
                            }
                            catch (IllegalAccessException ex) {
                                throw JAXBException.exceptionWithNameTransformerClass(nameTransformerClass.getName(), ex);
                            }
                        }
                        if (this.helper.isAnnotationPresent(javaClass.getPackage(), XmlNameTransformer.class)) {
                            nameTranformer = (XmlNameTransformer)this.helper.getAnnotation(javaClass.getPackage(), XmlNameTransformer.class);
                            nameTransformerClass = nameTranformer.value();
                            try {
                                info.setXmlNameTransformer(nameTransformerClass.newInstance());
                            }
                            catch (InstantiationException ex) {
                                throw JAXBException.exceptionWithNameTransformerClass(nameTransformerClass.getName(), ex);
                            }
                            catch (IllegalAccessException ex) {
                                throw JAXBException.exceptionWithNameTransformerClass(nameTransformerClass.getName(), ex);
                            }
                        }
                    }
                }
                this.postProcessXmlAccessorType(info, packageInfo);
                this.postProcessXmlType(javaClass, info, packageInfo);
                if (info.isEnumerationType()) {
                    this.addEnumTypeInfo(javaClass, (EnumTypeInfo)info);
                } else {
                    this.processTypeQName(javaClass, info, packageInfo.getNamespaceInfo());
                    JavaClass superClass = javaClass.getSuperclass();
                    if (this.shouldGenerateTypeInfo(superClass)) {
                        JavaClass[] jClassArray = new JavaClass[]{superClass};
                        this.buildNewTypeInfo(jClassArray);
                    }
                    this.processPropertiesSuperClass(javaClass, info);
                    info.setProperties(this.getPropertiesForClass(javaClass, info));
                    this.processTypeInfoProperties(javaClass, info);
                    this.postProcessXmlAccessorOrder(info, packageInfo);
                    this.validatePropOrderForInfo(info);
                }
            }
            ++n2;
        }
        return this.typeInfo;
    }

    private void processPropertiesSuperClass(JavaClass cls, TypeInfo info) {
        JavaClass superClass = cls.getSuperclass();
        if (superClass == null) {
            return;
        }
        TypeInfo superClassInfo = this.typeInfo.get(superClass.getQualifiedName());
        if (superClassInfo != null) {
            this.processPropertiesSuperClass(superClass, superClassInfo);
            this.classesToProcessPropertyTypes.add(superClass);
            if (superClassInfo.getXmlVirtualAccessMethods() != null && info.getXmlVirtualAccessMethods() == null) {
                info.setXmlVirtualAccessMethods(superClassInfo.getXmlVirtualAccessMethods());
            }
            if (superClassInfo.isIDSet()) {
                info.setIDProperty(superClassInfo.getIDProperty());
            }
        }
    }

    public void finalizeProperties() {
        ArrayList<JavaClass> jClasses = this.getTypeInfoClasses();
        for (JavaClass jClass : jClasses) {
            JavaConstructor zeroArgConstructor;
            TypeInfo tInfo = this.getTypeInfo().get(jClass.getQualifiedName());
            if (tInfo.isTransient()) continue;
            if (!(jClass.isInterface() || tInfo.isEnumerationType() || jClass.isAbstract() || tInfo.getFactoryMethodName() != null || tInfo.getObjectFactoryClassName() != null || (zeroArgConstructor = jClass.getDeclaredConstructor(new JavaClass[0])) != null)) {
                if (tInfo.isSetXmlJavaTypeAdapter()) {
                    tInfo.setTransient(true);
                } else if (!this.referencedByTransformer.contains(jClass.getName())) {
                    throw JAXBException.factoryMethodOrConstructorRequired(jClass.getName());
                }
            }
            if (tInfo.getXmlValueProperty() != null) {
                this.validateXmlValueFieldOrProperty(jClass, tInfo.getXmlValueProperty());
            }
            for (Property property : tInfo.getPropertyList()) {
                JavaClass typeClass = property.getActualType();
                TypeInfo targetInfo = this.typeInfo.get(typeClass.getQualifiedName());
                if (targetInfo != null && targetInfo.isTransient()) {
                    throw JAXBException.invalidReferenceToTransientClass(jClass.getQualifiedName(), property.getPropertyName(), typeClass.getQualifiedName());
                }
                if (tInfo.isSetXmlValueProperty()) {
                    if (property.isXmlValue() && !tInfo.getXmlValueProperty().getPropertyName().equals(property.getPropertyName())) {
                        throw JAXBException.xmlValueAlreadySet(property.getPropertyName(), tInfo.getXmlValueProperty().getPropertyName(), jClass.getName());
                    }
                    if (!(property.isXmlValue() || property.isAttribute() || property.isInverseReference() || property.isTransient())) {
                        throw JAXBException.propertyOrFieldShouldBeAnAttribute(property.getPropertyName());
                    }
                }
                if (property.isReference()) {
                    this.processReferenceProperty(property, tInfo, jClass);
                }
                if (property.isSwaAttachmentRef() && !this.hasSwaRef) {
                    this.hasSwaRef = true;
                }
                if (property.isXmlIdRef()) {
                    if (targetInfo == null && !typeClass.getQualifiedName().equals(JAVA_LANG_OBJECT)) {
                        throw JAXBException.invalidIDREFClass(jClass.getQualifiedName(), property.getPropertyName(), typeClass.getQualifiedName());
                    }
                    if (targetInfo != null && targetInfo.getIDProperty() == null) {
                        throw JAXBException.invalidIdRef(property.getPropertyName(), typeClass.getQualifiedName());
                    }
                }
                if (property.isXmlId() && tInfo.getIDProperty() != null && !tInfo.getIDProperty().getPropertyName().equals(property.getPropertyName())) {
                    throw JAXBException.idAlreadySet(property.getPropertyName(), tInfo.getIDProperty().getPropertyName(), jClass.getName());
                }
                if (property.isAnyAttribute() && tInfo.isSetAnyAttributePropertyName() && !tInfo.getAnyAttributePropertyName().equals(property.getPropertyName())) {
                    throw JAXBException.multipleAnyAttributeMapping(jClass.getName());
                }
                if (property.isAny() && tInfo.isSetAnyElementPropertyName() && !tInfo.getAnyElementPropertyName().equals(property.getPropertyName())) {
                    throw JAXBException.xmlAnyElementAlreadySet(property.getPropertyName(), tInfo.getAnyElementPropertyName(), jClass.getName());
                }
                if (property.isSwaAttachmentRef() && !this.areEquals(property.getActualType(), JAVAX_ACTIVATION_DATAHANDLER)) {
                    throw JAXBException.invalidAttributeRef(property.getPropertyName(), jClass.getQualifiedName());
                }
                if (property.getXmlElementWrapper() != null && !this.isCollectionType(property) && !property.getType().isArray()) {
                    throw JAXBException.invalidElementWrapper(property.getPropertyName());
                }
                if (property.isXmlTransformation()) {
                    this.processXmlTransformationProperty(property);
                }
                if (!property.isSetXmlJoinNodes()) continue;
                if (targetInfo == null) {
                    throw JAXBException.invalidXmlJoinNodeReferencedClass(property.getPropertyName(), typeClass.getQualifiedName());
                }
                if (targetInfo.getIDProperty() != null || targetInfo.getXmlKeyProperties() != null) continue;
                throw JAXBException.noKeyOrIDPropertyOnJoinTarget(jClass.getQualifiedName(), property.getPropertyName(), typeClass.getQualifiedName());
            }
        }
    }

    private void processTypeInfoProperties(JavaClass javaClass, TypeInfo info) {
        ArrayList<Property> properties = info.getPropertyList();
        for (Property property : properties) {
            JavaClass valueType;
            this.processXmlID(property, javaClass, info);
            this.processXmlIDREF(property);
            if (!property.isMap()) continue;
            JavaClass keyType = property.getKeyType();
            if (this.shouldGenerateTypeInfo(keyType)) {
                JavaClass[] jClassArray = new JavaClass[]{keyType};
                this.buildNewTypeInfo(jClassArray);
            }
            if (!this.shouldGenerateTypeInfo(valueType = property.getValueType())) continue;
            JavaClass[] jClassArray = new JavaClass[]{valueType};
            this.buildNewTypeInfo(jClassArray);
        }
    }

    void processPropertyTypes(JavaClass[] classes) {
        JavaClass[] javaClassArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            JavaClass next = javaClassArray[n2];
            this.processPropertyTypes(next);
            this.classesToProcessPropertyTypes.remove(next);
            ++n2;
        }
        int i = 0;
        while (i < this.classesToProcessPropertyTypes.size()) {
            JavaClass next = this.classesToProcessPropertyTypes.get(i);
            this.processPropertyTypes(next);
            ++i;
        }
    }

    private void processPropertyTypes(JavaClass next) {
        TypeInfo info = this.getTypeInfo().get(next.getQualifiedName());
        if (info != null) {
            for (Property property : info.getPropertyList()) {
                JavaClass[] jClassArray;
                if (property.isXmlLocation()) {
                    info.setLocationAware(true);
                }
                if (property.isTransient()) continue;
                JavaClass type = property.getActualType();
                if (property.isReference()) {
                    this.processReferencePropertyTypes(property, info, next);
                }
                if (!this.typeInfo.containsKey(type.getQualifiedName()) && this.shouldGenerateTypeInfo(type)) {
                    PackageInfo pInfo = this.getPackageInfoForPackage(next);
                    JavaClass adapterClass = pInfo.getPackageLevelAdaptersByClass().get(type);
                    if (adapterClass != null) continue;
                    CompilerHelper.addClassToClassLoader(type, this.helper.getClassLoader());
                    jClassArray = new JavaClass[]{type};
                    this.buildNewTypeInfo(jClassArray);
                }
                if (!property.isChoice()) continue;
                this.processChoiceProperty(property, info, next, type);
                for (Property choiceProp : property.getChoiceProperties()) {
                    type = choiceProp.getActualType();
                    if (this.typeInfo.containsKey(type.getQualifiedName()) || !this.shouldGenerateTypeInfo(type)) continue;
                    CompilerHelper.addClassToClassLoader(type, this.helper.getClassLoader());
                    jClassArray = new JavaClass[]{type};
                    this.buildNewTypeInfo(jClassArray);
                }
            }
        }
    }

    public void processJavaClasses(JavaClass[] classes) {
        this.checkForCallbackMethods();
    }

    private JavaClass[] processAdditionalClasses(JavaClass[] classes) {
        ArrayList<JavaClass> extraClasses = new ArrayList<JavaClass>();
        ArrayList<JavaClass> classesToProcess = new ArrayList<JavaClass>();
        JavaClass[] javaClassArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            JavaClass jClass = javaClassArray[n2];
            Class xmlElementType = null;
            JavaClass javaClass = jClass;
            TypeMappingInfo tmi = this.javaClassToTypeMappingInfos.get(javaClass);
            if (tmi != null) {
                Annotation[] annotations;
                Class adapterClass = this.typeMappingInfoToAdapterClasses.get(tmi);
                if (adapterClass != null) {
                    JavaClass adapterJavaClass = this.helper.getJavaClass(adapterClass);
                    JavaClass newType = this.helper.getJavaClass(Object.class);
                    for (Object nextMethod : adapterJavaClass.getDeclaredMethods()) {
                        JavaClass returnType;
                        JavaMethod method = (JavaMethod)nextMethod;
                        if (!method.getName().equals("marshal") || (returnType = method.getReturnType()).getQualifiedName().equals(newType.getQualifiedName())) continue;
                        newType = returnType;
                        break;
                    }
                    javaClass = newType;
                }
                if ((annotations = this.getAnnotations(tmi)) != null) {
                    int j = 0;
                    while (j < annotations.length) {
                        javax.xml.bind.annotation.XmlElement javaAnnotation;
                        Annotation nextAnnotation = annotations[j];
                        if (nextAnnotation != null && nextAnnotation instanceof javax.xml.bind.annotation.XmlElement && (javaAnnotation = (javax.xml.bind.annotation.XmlElement)nextAnnotation).type() != XmlElement.DEFAULT.class) {
                            xmlElementType = javaAnnotation.type();
                        }
                        ++j;
                    }
                }
            }
            if (this.areEquals(javaClass, byte[].class) || this.areEquals(javaClass, JAVAX_ACTIVATION_DATAHANDLER) || this.areEquals(javaClass, Source.class) || this.areEquals(javaClass, Image.class) || this.areEquals(javaClass, JAVAX_MAIL_INTERNET_MIMEMULTIPART)) {
                if (tmi == null || tmi.getXmlTagName() == null) {
                    ElementDeclaration declaration = new ElementDeclaration(null, javaClass, javaClass.getQualifiedName(), false, XmlElementDecl.GLOBAL.class);
                    declaration.setTypeMappingInfo(tmi);
                    this.localElements.add(declaration);
                }
            } else if (javaClass.isArray()) {
                Class generatedClass;
                if (!this.helper.isBuiltInJavaType(javaClass.getComponentType())) {
                    extraClasses.add(javaClass.getComponentType());
                }
                if ((generatedClass = tmi == null ? this.arrayClassesToGeneratedClasses.get(javaClass.getName()) : CompilerHelper.getExisitingGeneratedClass(tmi, this.typeMappingInfoToGeneratedClasses, this.typeMappingInfoToAdapterClasses, this.helper.getClassLoader())) == null) {
                    generatedClass = this.generateWrapperForArrayClass(javaClass, tmi, xmlElementType, extraClasses);
                    extraClasses.add(this.helper.getJavaClass(generatedClass));
                    this.arrayClassesToGeneratedClasses.put(javaClass.getName(), generatedClass);
                }
                this.generatedClassesToArrayClasses.put(generatedClass, javaClass);
                this.typeMappingInfoToGeneratedClasses.put(tmi, generatedClass);
            } else if (this.isCollectionType(javaClass)) {
                Class generatedClass;
                JavaClass componentClass;
                if (javaClass.hasActualTypeArguments()) {
                    componentClass = (JavaClass)javaClass.getActualTypeArguments().toArray()[0];
                    if (!componentClass.isPrimitive()) {
                        extraClasses.add(componentClass);
                    }
                } else {
                    componentClass = this.helper.getJavaClass(Object.class);
                }
                if ((generatedClass = CompilerHelper.getExisitingGeneratedClass(tmi, this.typeMappingInfoToGeneratedClasses, this.typeMappingInfoToAdapterClasses, this.helper.getClassLoader())) == null) {
                    generatedClass = this.generateCollectionValue(javaClass, tmi, xmlElementType);
                    extraClasses.add(this.helper.getJavaClass(generatedClass));
                }
                this.typeMappingInfoToGeneratedClasses.put(tmi, generatedClass);
            } else if (this.isMapType(javaClass)) {
                Class generatedClass;
                JavaClass valueClass;
                JavaClass keyClass;
                if (javaClass.hasActualTypeArguments()) {
                    keyClass = (JavaClass)javaClass.getActualTypeArguments().toArray()[0];
                    if (!this.helper.isBuiltInJavaType(keyClass)) {
                        extraClasses.add(keyClass);
                    }
                    if (!this.helper.isBuiltInJavaType(valueClass = (JavaClass)javaClass.getActualTypeArguments().toArray()[1])) {
                        extraClasses.add(valueClass);
                    }
                } else {
                    keyClass = this.helper.getJavaClass(Object.class);
                    valueClass = this.helper.getJavaClass(Object.class);
                }
                if ((generatedClass = CompilerHelper.getExisitingGeneratedClass(tmi, this.typeMappingInfoToGeneratedClasses, this.typeMappingInfoToAdapterClasses, this.helper.getClassLoader())) == null) {
                    generatedClass = this.generateWrapperForMapClass(javaClass, keyClass, valueClass, tmi);
                    extraClasses.add(this.helper.getJavaClass(generatedClass));
                }
                this.typeMappingInfoToGeneratedClasses.put(tmi, generatedClass);
            } else {
                this.processClass(javaClass, classesToProcess);
            }
            ++n2;
        }
        for (JavaClass javaClass : extraClasses) {
            this.processClass(javaClass, classesToProcess);
        }
        return classesToProcess.toArray(new JavaClass[classesToProcess.size()]);
    }

    private void processClass(JavaClass javaClass, ArrayList<JavaClass> classesToProcess) {
        if (this.shouldGenerateTypeInfo(javaClass)) {
            if (this.isXmlRegistry(javaClass)) {
                this.processObjectFactory(javaClass, classesToProcess);
            } else {
                classesToProcess.add(javaClass);
                TypeInfo info = this.typeInfo.get(javaClass.getQualifiedName());
                if (info != null && info.isSetXmlSeeAlso()) {
                    for (String jClassName : info.getXmlSeeAlso()) {
                        classesToProcess.add(this.helper.getJavaClass(jClassName));
                    }
                }
                for (JavaClass innerClass : javaClass.getDeclaredClasses()) {
                    if (!Modifier.isStatic(innerClass.getModifiers()) || !this.shouldGenerateTypeInfo(innerClass)) continue;
                    CompilerHelper.addClassToClassLoader(innerClass, this.helper.getClassLoader());
                    TypeInfo tInfo = this.typeInfo.get(innerClass.getQualifiedName());
                    if ((tInfo == null || tInfo.isTransient()) && this.helper.isAnnotationPresent(innerClass, XmlTransient.class)) continue;
                    classesToProcess.add(innerClass);
                }
            }
        }
    }

    private void processXmlSeeAlso(JavaClass javaClass, TypeInfo info) {
        Class xmlSeeAlsoClass = null;
        Method valueMethod = null;
        try {
            xmlSeeAlsoClass = PrivilegedAccessHelper.getClassForName("javax.xml.bind.annotation.XmlSeeAlso", false, this.helper.getClassLoader());
            valueMethod = PrivilegedAccessHelper.getDeclaredMethod(xmlSeeAlsoClass, VALUE_METHOD_NAME, new Class[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        if (xmlSeeAlsoClass != null && this.helper.isAnnotationPresent(javaClass, xmlSeeAlsoClass)) {
            Annotation seeAlso = this.helper.getAnnotation(javaClass, xmlSeeAlsoClass);
            Class[] values = null;
            try {
                values = (Class[])PrivilegedAccessHelper.invokeMethod(valueMethod, seeAlso, new Object[0]);
            }
            catch (Exception exception) {}
            ArrayList<String> seeAlsoClassNames = new ArrayList<String>();
            Class[] classArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Class next = classArray[n2];
                seeAlsoClassNames.add(next.getName());
                ++n2;
            }
            info.setXmlSeeAlso(seeAlsoClassNames);
        }
    }

    private void processFactoryMethods(JavaClass javaClass, TypeInfo info) {
        JavaMethod factoryMethod = this.factoryMethods.get(javaClass.getRawName());
        if (factoryMethod != null) {
            info.setFactoryMethodName(factoryMethod.getName());
            info.setObjectFactoryClassName(factoryMethod.getOwningClass().getQualifiedName());
            JavaClass[] paramTypes = factoryMethod.getParameterTypes();
            if (paramTypes != null && paramTypes.length > 0) {
                String[] paramTypeNames = new String[paramTypes.length];
                int i = 0;
                while (i < paramTypes.length) {
                    if (this.shouldGenerateTypeInfo(paramTypes[i])) {
                        JavaClass[] jClassArray = new JavaClass[]{paramTypes[i]};
                        this.buildNewTypeInfo(jClassArray);
                    }
                    paramTypeNames[i] = paramTypes[i].getQualifiedName();
                    ++i;
                }
                info.setFactoryMethodParamTypes(paramTypeNames);
            }
        }
    }

    private void processPackageLevelAdapters(JavaClass javaClass, TypeInfo info) {
        JavaPackage pack = javaClass.getPackage();
        if (this.helper.isAnnotationPresent(pack, XmlJavaTypeAdapters.class)) {
            javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter[] adapterArray;
            XmlJavaTypeAdapters adapters = (XmlJavaTypeAdapters)this.helper.getAnnotation(pack, XmlJavaTypeAdapters.class);
            javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter[] xmlJavaTypeAdapterArray = adapterArray = adapters.value();
            int n = adapterArray.length;
            int n2 = 0;
            while (n2 < n) {
                javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter next = xmlJavaTypeAdapterArray[n2];
                this.processPackageLevelAdapter(next, info);
                ++n2;
            }
        }
        if (this.helper.isAnnotationPresent(pack, javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter.class)) {
            javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter adapter = (javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter)this.helper.getAnnotation(pack, javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter.class);
            this.processPackageLevelAdapter(adapter, info);
        }
    }

    private void processPackageLevelAdapter(javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter next, TypeInfo info) {
        JavaClass adapterClass = this.helper.getJavaClass(next.value());
        JavaClass boundType = this.helper.getJavaClass(next.type());
        if (boundType != null) {
            info.addPackageLevelAdapterClass(adapterClass, boundType);
        } else {
            this.getLogger().logWarning("jaxb_metadata_warning_invalid_bound_type", new Object[]{boundType, adapterClass});
        }
    }

    private void processClassLevelAdapters(JavaClass javaClass, TypeInfo info) {
        if (this.helper.isAnnotationPresent(javaClass, javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter.class)) {
            javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter adapter = (javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter)this.helper.getAnnotation(javaClass, javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter.class);
            String boundType = adapter.type().getName();
            if (boundType == null || boundType.equals("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter.DEFAULT")) {
                boundType = javaClass.getRawName();
            }
            XmlJavaTypeAdapter xja = new XmlJavaTypeAdapter();
            xja.setValue(adapter.value().getName());
            xja.setType(boundType);
            info.setXmlJavaTypeAdapter(xja);
        }
    }

    private void processSchemaTypes(JavaClass javaClass, TypeInfo info) {
        JavaPackage pack = javaClass.getPackage();
        if (this.helper.isAnnotationPresent(pack, XmlSchemaTypes.class)) {
            XmlSchemaType[] typeArray;
            XmlSchemaTypes types = (XmlSchemaTypes)this.helper.getAnnotation(pack, XmlSchemaTypes.class);
            XmlSchemaType[] xmlSchemaTypeArray = typeArray = types.value();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                XmlSchemaType next = xmlSchemaTypeArray[n2];
                this.processSchemaType(next);
                ++n2;
            }
        } else if (this.helper.isAnnotationPresent(pack, XmlSchemaType.class)) {
            this.processSchemaType((XmlSchemaType)this.helper.getAnnotation(pack, XmlSchemaType.class));
        }
    }

    private void processXmlRootElement(JavaClass javaClass, TypeInfo info) {
        if (this.helper.isAnnotationPresent(javaClass, XmlRootElement.class)) {
            XmlRootElement rootElemAnnotation = (XmlRootElement)this.helper.getAnnotation(javaClass, XmlRootElement.class);
            org.eclipse.persistence.jaxb.xmlmodel.XmlRootElement xmlRE = new org.eclipse.persistence.jaxb.xmlmodel.XmlRootElement();
            xmlRE.setName(rootElemAnnotation.name());
            xmlRE.setNamespace(rootElemAnnotation.namespace());
            info.setXmlRootElement(xmlRE);
        }
    }

    private void processXmlExtensible(JavaClass javaClass, TypeInfo info) {
        if (this.helper.isAnnotationPresent(javaClass, XmlVirtualAccessMethods.class)) {
            XmlVirtualAccessMethods extAnnotation = (XmlVirtualAccessMethods)this.helper.getAnnotation(javaClass, XmlVirtualAccessMethods.class);
            org.eclipse.persistence.jaxb.xmlmodel.XmlVirtualAccessMethods xmlExt = new org.eclipse.persistence.jaxb.xmlmodel.XmlVirtualAccessMethods();
            xmlExt.setGetMethod(extAnnotation.getMethod());
            xmlExt.setSetMethod(extAnnotation.setMethod());
            xmlExt.setSchema(XmlVirtualAccessMethodsSchema.valueOf(extAnnotation.schema().toString()));
            info.setXmlVirtualAccessMethods(xmlExt);
        }
    }

    private void preProcessXmlType(JavaClass javaClass, TypeInfo info, NamespaceInfo packageNamespace) {
        org.eclipse.persistence.jaxb.xmlmodel.XmlType xmlType = new org.eclipse.persistence.jaxb.xmlmodel.XmlType();
        if (this.helper.isAnnotationPresent(javaClass, XmlType.class)) {
            XmlType typeAnnotation = (XmlType)this.helper.getAnnotation(javaClass, XmlType.class);
            xmlType.setName(typeAnnotation.name());
            xmlType.setNamespace(typeAnnotation.namespace());
            String[] propOrder = typeAnnotation.propOrder();
            if (propOrder != null) {
                xmlType.getPropOrder();
            }
            String[] stringArray = propOrder;
            int n = propOrder.length;
            int n2 = 0;
            while (n2 < n) {
                String prop = stringArray[n2];
                xmlType.getPropOrder().add(prop);
                ++n2;
            }
            Class factoryClass = typeAnnotation.factoryClass();
            if (factoryClass == XmlType.DEFAULT.class) {
                xmlType.setFactoryClass("javax.xml.bind.annotation.XmlType.DEFAULT");
            } else {
                xmlType.setFactoryClass(factoryClass.getCanonicalName());
            }
            xmlType.setFactoryMethod(typeAnnotation.factoryMethod());
        } else {
            try {
                xmlType.setName(info.getXmlNameTransformer().transformTypeName(javaClass.getName()));
            }
            catch (Exception ex) {
                throw JAXBException.exceptionDuringNameTransformation(javaClass.getName(), info.getXmlNameTransformer().getClass().getName(), ex);
            }
            xmlType.setNamespace(packageNamespace.getNamespace());
        }
        info.setXmlType(xmlType);
    }

    private void postProcessXmlType(JavaClass javaClass, TypeInfo info, PackageInfo packageNamespace) {
        String typeName;
        org.eclipse.persistence.jaxb.xmlmodel.XmlType xmlType = info.getXmlType();
        String factoryClassName = xmlType.getFactoryClass();
        String factoryMethodName = xmlType.getFactoryMethod();
        if (factoryClassName.equals("javax.xml.bind.annotation.XmlType.DEFAULT")) {
            if (factoryMethodName != null && !factoryMethodName.equals(EMPTY_STRING)) {
                JavaMethod method = javaClass.getDeclaredMethod(factoryMethodName, new JavaClass[0]);
                if (method == null) {
                    throw JAXBException.factoryMethodNotDeclared(factoryMethodName, javaClass.getName());
                }
                info.setFactoryMethodName(factoryMethodName);
            }
        } else {
            if (factoryMethodName == null || factoryMethodName.equals(EMPTY_STRING)) {
                throw JAXBException.factoryClassWithoutFactoryMethod(javaClass.getName());
            }
            info.setObjectFactoryClassName(factoryClassName);
            info.setFactoryMethodName(factoryMethodName);
        }
        if ((typeName = xmlType.getName()).equals("##default")) {
            try {
                typeName = info.getXmlNameTransformer().transformTypeName(javaClass.getName());
            }
            catch (Exception ex) {
                throw JAXBException.exceptionDuringNameTransformation(javaClass.getName(), info.getXmlNameTransformer().getClass().getName(), ex);
            }
        }
        info.setSchemaTypeName(typeName);
        if (xmlType.isSetPropOrder()) {
            List<String> props = xmlType.getPropOrder();
            if (props.size() == 0) {
                info.setPropOrder(new String[0]);
            } else if (props.get(0).equals(EMPTY_STRING)) {
                info.setPropOrder(new String[]{EMPTY_STRING});
            } else {
                info.setPropOrder(xmlType.getPropOrder().toArray(new String[xmlType.getPropOrder().size()]));
            }
        }
        if (xmlType.getNamespace().equals("##default")) {
            info.setClassNamespace(packageNamespace.getNamespace());
        } else {
            info.setClassNamespace(xmlType.getNamespace());
        }
    }

    private void preProcessXmlAccessorType(JavaClass javaClass, TypeInfo info, NamespaceInfo packageNamespace) {
        if (this.helper.isAnnotationPresent(javaClass, XmlAccessorType.class)) {
            XmlAccessorType accessorType = (XmlAccessorType)this.helper.getAnnotation(javaClass, XmlAccessorType.class);
            XmlAccessType xmlAccessType = XmlAccessType.fromValue(accessorType.value().name());
            info.setXmlAccessType(xmlAccessType);
        }
    }

    private void postProcessXmlAccessorType(TypeInfo info, PackageInfo packageNamespace) {
        if (!info.isSetXmlAccessType()) {
            JavaClass next = this.helper.getJavaClass(info.getJavaClassName()).getSuperclass();
            while (next != null && !next.getName().equals(JAVA_LANG_OBJECT)) {
                TypeInfo parentInfo = this.typeInfo.get(next.getName());
                if (parentInfo != null && parentInfo.isSetXmlAccessType()) {
                    info.setXmlAccessType(parentInfo.getXmlAccessType());
                    break;
                }
                next = next.getSuperclass();
            }
            info.setXmlAccessType(XmlAccessType.fromValue(packageNamespace.getAccessType().name()));
        }
    }

    private void preProcessXmlAccessorOrder(JavaClass javaClass, TypeInfo info, NamespaceInfo packageNamespace) {
        XmlAccessorOrder order = null;
        if (this.helper.isAnnotationPresent(javaClass, XmlAccessorOrder.class)) {
            order = (XmlAccessorOrder)this.helper.getAnnotation(javaClass, XmlAccessorOrder.class);
            info.setXmlAccessOrder(XmlAccessOrder.fromValue(order.value().name()));
        }
    }

    private void postProcessXmlAccessorOrder(TypeInfo info, PackageInfo packageNamespace) {
        if (!info.isSetXmlAccessOrder()) {
            info.setXmlAccessOrder(XmlAccessOrder.fromValue(packageNamespace.getAccessOrder().name()));
        }
        info.orderProperties();
    }

    private void processXmlElement(Property property, TypeInfo info) {
        if (this.helper.isAnnotationPresent(property.getElement(), javax.xml.bind.annotation.XmlElement.class)) {
            javax.xml.bind.annotation.XmlElement element = (javax.xml.bind.annotation.XmlElement)this.helper.getAnnotation(property.getElement(), javax.xml.bind.annotation.XmlElement.class);
            property.setIsRequired(element.required());
            property.setNillable(element.nillable());
            if (element.type() != XmlElement.DEFAULT.class && !property.isSwaAttachmentRef()) {
                property.setOriginalType(property.getType());
                if (this.isCollectionType(property.getType())) {
                    property.setGenericType(this.helper.getJavaClass(element.type()));
                } else {
                    property.setType(this.helper.getJavaClass(element.type()));
                }
                property.setHasXmlElementType(true);
            }
            if (!element.defaultValue().equals(ELEMENT_DECL_DEFAULT)) {
                property.setDefaultValue(element.defaultValue());
            }
            this.validateElementIsInPropOrder(info, property.getPropertyName());
        }
    }

    private void processXmlID(Property property, JavaClass javaClass, TypeInfo info) {
        if (this.helper.isAnnotationPresent(property.getElement(), XmlID.class)) {
            property.setIsXmlId(true);
            info.setIDProperty(property);
        }
    }

    private void processXmlIDREF(Property property) {
        if (this.helper.isAnnotationPresent(property.getElement(), XmlIDREF.class)) {
            property.setIsXmlIdRef(true);
        }
    }

    private void processXmlJavaTypeAdapter(Property property, TypeInfo info, JavaClass javaClass) {
        JavaClass adapterClass = null;
        JavaClass ptype = property.getActualType();
        if (this.helper.isAnnotationPresent(property.getElement(), javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter.class)) {
            javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter adapter = (javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter)this.helper.getAnnotation(property.getElement(), javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter.class);
            XmlJavaTypeAdapter xja = new XmlJavaTypeAdapter();
            xja.setValue(adapter.value().getName());
            xja.setType(adapter.type().getName());
            property.setXmlJavaTypeAdapter(xja);
        } else {
            XmlJavaTypeAdapter xmlJavaTypeAdapter;
            TypeInfo ptypeInfo = this.typeInfo.get(ptype.getQualifiedName());
            if (ptypeInfo == null && this.shouldGenerateTypeInfo(ptype) && this.helper.isAnnotationPresent(ptype, javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter.class)) {
                javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter adapter = (javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter)this.helper.getAnnotation(ptype, javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter.class);
                XmlJavaTypeAdapter xja = new XmlJavaTypeAdapter();
                xja.setValue(adapter.value().getName());
                String boundType = adapter.type().getName();
                if (boundType == null || boundType.equals("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter.DEFAULT")) {
                    boundType = ptype.getRawName();
                }
                xja.setType(adapter.type().getName());
                property.setXmlJavaTypeAdapter(xja);
            }
            if (ptypeInfo != null && (xmlJavaTypeAdapter = ptypeInfo.getXmlJavaTypeAdapter()) != null) {
                try {
                    property.setXmlJavaTypeAdapter(xmlJavaTypeAdapter);
                }
                catch (JAXBException jAXBException) {
                    throw JAXBException.invalidTypeAdapterClass(xmlJavaTypeAdapter.getValue(), javaClass.getName());
                }
            }
            if (info.hasPackageLevelAdaptersByClass() && info.getPackageLevelAdaptersByClass().get(ptype.getQualifiedName()) != null && !property.isSetXmlJavaTypeAdapter()) {
                adapterClass = info.getPackageLevelAdapterClass(ptype);
                XmlJavaTypeAdapter xja = new XmlJavaTypeAdapter();
                xja.setValue(adapterClass.getQualifiedName());
                xja.setType(ptype.getQualifiedName());
                property.setXmlJavaTypeAdapter(xja);
            }
        }
    }

    private void processTypeQName(JavaClass javaClass, TypeInfo info, NamespaceInfo packageNamespace) {
        if (info.isTransient()) {
            return;
        }
        String typeName = info.getSchemaTypeName();
        if (typeName != null && !EMPTY_STRING.equals(typeName)) {
            QName typeQName = new QName(info.getClassNamespace(), typeName);
            boolean containsQName = this.typeQNames.contains(typeQName);
            if (containsQName) {
                throw JAXBException.nameCollision(typeQName.getNamespaceURI(), typeQName.getLocalPart());
            }
            this.typeQNames.add(typeQName);
        }
    }

    public boolean shouldGenerateTypeInfo(JavaClass javaClass) {
        String javaClassName;
        if (javaClass == null || javaClass.isPrimitive() || javaClass.isAnnotation() || ORG_W3C_DOM.equals(javaClass.getPackageName())) {
            return false;
        }
        if (this.userDefinedSchemaTypes.get(javaClass.getQualifiedName()) != null) {
            return false;
        }
        if (javaClass.isArray() && !(javaClassName = javaClass.getName()).equals(ClassConstants.APBYTE.getName()) && !javaClassName.equals(ClassConstants.ABYTE.getName())) {
            return true;
        }
        if (this.helper.isBuiltInJavaType(javaClass)) {
            return false;
        }
        return !this.isCollectionType(javaClass) && !this.isMapType(javaClass);
    }

    public ArrayList<Property> getPropertiesForClass(JavaClass cls, TypeInfo info) {
        JavaClass superClass;
        ArrayList<Property> returnList = new ArrayList<Property>();
        if (!info.isTransient() && (superClass = cls.getSuperclass()) != null) {
            TypeInfo superClassInfo = this.typeInfo.get(superClass.getQualifiedName());
            while (superClassInfo != null && superClassInfo.isTransient()) {
                if (info.getXmlAccessType() == XmlAccessType.FIELD) {
                    returnList.addAll(0, this.getFieldPropertiesForClass(superClass, superClassInfo, false));
                } else if (info.getXmlAccessType() == XmlAccessType.PROPERTY) {
                    returnList.addAll(0, this.getPropertyPropertiesForClass(superClass, superClassInfo, false));
                } else if (info.getXmlAccessType() == XmlAccessType.PUBLIC_MEMBER) {
                    returnList.addAll(0, this.getPublicMemberPropertiesForClass(superClass, superClassInfo));
                } else {
                    returnList.addAll(0, this.getNoAccessTypePropertiesForClass(superClass, superClassInfo));
                }
                superClass = superClass.getSuperclass();
                superClassInfo = this.typeInfo.get(superClass.getQualifiedName());
            }
        }
        if (info.isTransient()) {
            returnList.addAll(this.getNoAccessTypePropertiesForClass(cls, info));
        } else if (info.getXmlAccessType() == XmlAccessType.FIELD) {
            returnList.addAll(this.getFieldPropertiesForClass(cls, info, false));
            returnList.addAll(this.getPropertyPropertiesForClass(cls, info, false, true));
        } else if (info.getXmlAccessType() == XmlAccessType.PROPERTY) {
            returnList.addAll(this.getFieldPropertiesForClass(cls, info, false, true));
            returnList.addAll(this.getPropertyPropertiesForClass(cls, info, false));
        } else if (info.getXmlAccessType() == XmlAccessType.PUBLIC_MEMBER) {
            returnList.addAll(this.getPublicMemberPropertiesForClass(cls, info));
        } else {
            returnList.addAll(this.getNoAccessTypePropertiesForClass(cls, info));
        }
        return returnList;
    }

    public ArrayList<Property> getFieldPropertiesForClass(JavaClass cls, TypeInfo info, boolean onlyPublic) {
        return this.getFieldPropertiesForClass(cls, info, onlyPublic, false);
    }

    public ArrayList<Property> getFieldPropertiesForClass(JavaClass cls, TypeInfo info, boolean onlyPublic, boolean onlyExplicit) {
        ArrayList<Property> properties = new ArrayList<Property>();
        if (cls == null) {
            return properties;
        }
        Iterator fieldIt = cls.getDeclaredFields().iterator();
        while (fieldIt.hasNext()) {
            List<String> propOrderList;
            Property property = null;
            JavaField nextField = (JavaField)fieldIt.next();
            int modifiers = nextField.getModifiers();
            if (!Modifier.isTransient(modifiers) && (Modifier.isPublic(nextField.getModifiers()) && onlyPublic || !onlyPublic)) {
                if (!Modifier.isStatic(modifiers)) {
                    if (onlyExplicit && this.hasJAXBAnnotations(nextField) || !onlyExplicit) {
                        property = this.buildNewProperty(info, cls, nextField, nextField.getName(), nextField.getResolvedType());
                        properties.add(property);
                    }
                } else if (this.helper.isAnnotationPresent(nextField, XmlAttribute.class)) {
                    try {
                        property = this.buildNewProperty(info, cls, nextField, nextField.getName(), nextField.getResolvedType());
                        Object value = ((JavaFieldImpl)nextField).get(null);
                        if (value != null) {
                            String stringValue = (String)XMLConversionManager.getDefaultXMLManager().convertObject(value, String.class, property.getSchemaType());
                            property.setFixedValue(stringValue);
                        } else {
                            property.setWriteOnly(true);
                        }
                        properties.add(property);
                    }
                    catch (ClassCastException classCastException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                }
            }
            if (!this.helper.isAnnotationPresent(nextField, XmlTransient.class)) continue;
            if (property != null) {
                property.setTransient(true);
            }
            if (!(propOrderList = Arrays.asList(info.getPropOrder())).contains(nextField.getName())) continue;
            throw JAXBException.transientInProporder(nextField.getName());
        }
        return properties;
    }

    private Property buildNewProperty(TypeInfo info, JavaClass cls, JavaHasAnnotations javaHasAnnotations, String propertyName, JavaClass ptype) {
        TypeInfo refClassInfo;
        XmlAnyElement anyElement;
        Property property = null;
        if (this.helper.isAnnotationPresent(javaHasAnnotations, XmlElements.class)) {
            property = this.buildChoiceProperty(javaHasAnnotations);
        } else if (this.helper.isAnnotationPresent(javaHasAnnotations, XmlElementRef.class) || this.helper.isAnnotationPresent(javaHasAnnotations, XmlElementRefs.class)) {
            this.findAndProcessObjectFactory(cls);
            property = this.buildReferenceProperty(info, javaHasAnnotations, propertyName, ptype);
            if (this.helper.isAnnotationPresent(javaHasAnnotations, XmlAnyElement.class)) {
                anyElement = (XmlAnyElement)this.helper.getAnnotation(javaHasAnnotations, XmlAnyElement.class);
                property.setIsAny(true);
                if (anyElement.value() != null) {
                    property.setDomHandlerClassName(anyElement.value().getName());
                }
                property.setLax(anyElement.lax());
                info.setAnyElementPropertyName(propertyName);
            }
        } else if (this.helper.isAnnotationPresent(javaHasAnnotations, XmlAnyElement.class)) {
            this.findAndProcessObjectFactory(cls);
            anyElement = (XmlAnyElement)this.helper.getAnnotation(javaHasAnnotations, XmlAnyElement.class);
            property = new Property(this.helper);
            property.setIsAny(true);
            if (anyElement.value() != null) {
                property.setDomHandlerClassName(anyElement.value().getName());
            }
            property.setLax(anyElement.lax());
            info.setAnyElementPropertyName(propertyName);
        } else {
            property = this.helper.isAnnotationPresent(javaHasAnnotations, org.eclipse.persistence.oxm.annotations.XmlTransformation.class) || this.helper.isAnnotationPresent(javaHasAnnotations, XmlReadTransformer.class) || this.helper.isAnnotationPresent(javaHasAnnotations, XmlWriteTransformer.class) || this.helper.isAnnotationPresent(javaHasAnnotations, XmlWriteTransformers.class) ? this.buildTransformationProperty(javaHasAnnotations, cls) : new Property(this.helper);
        }
        property.setPropertyName(propertyName);
        property.setElement(javaHasAnnotations);
        TypeInfo pTypeInfo = this.typeInfo.get(ptype.getQualifiedName());
        if (pTypeInfo != null && !pTypeInfo.isTransient() || !this.helper.isAnnotationPresent(ptype, XmlTransient.class)) {
            property.setType(ptype);
        } else {
            JavaClass parent = ptype.getSuperclass();
            while (parent != null) {
                if (parent.getName().equals(JAVA_LANG_OBJECT)) {
                    property.setType(parent);
                    break;
                }
                TypeInfo parentTypeInfo = this.typeInfo.get(parent.getQualifiedName());
                if (parentTypeInfo != null && !parentTypeInfo.isTransient() || !this.helper.isAnnotationPresent(parent, XmlTransient.class)) {
                    property.setType(parent);
                    break;
                }
                parent = parent.getSuperclass();
            }
        }
        if (ptype.isArray() && !this.areEquals(ptype, byte[].class) || property.isCollectionType(ptype) && !this.helper.isAnnotationPresent(javaHasAnnotations, XmlList.class)) {
            property.setNillable(true);
        }
        this.processPropertyAnnotations(info, cls, javaHasAnnotations, property);
        if (this.helper.isAnnotationPresent(javaHasAnnotations, XmlPath.class)) {
            XmlPath xmlPath = (XmlPath)this.helper.getAnnotation(javaHasAnnotations, XmlPath.class);
            property.setXmlPath(xmlPath.value());
            XMLField tempField = new XMLField(xmlPath.value());
            boolean isAttribute = tempField.getLastXPathFragment().isAttribute();
            property.setIsAttribute(isAttribute);
            String schemaName = XMLProcessor.getNameFromXPath(xmlPath.value(), property.getPropertyName(), isAttribute);
            NamespaceInfo nsInfo = this.getPackageInfoForPackage(cls).getNamespaceInfo();
            QName qName = isAttribute ? (nsInfo.isAttributeFormQualified() ? new QName(nsInfo.getNamespace(), schemaName) : new QName(schemaName)) : (nsInfo.isElementFormQualified() ? new QName(nsInfo.getNamespace(), schemaName) : new QName(schemaName));
            property.setSchemaName(qName);
            XPathFragment fragment = tempField.getXPathFragment();
            String currentPath = EMPTY_STRING;
            while (fragment != null && !fragment.nameIsText() && !fragment.isAttribute()) {
                if (fragment.getPredicate() != null) {
                    String fragmentPath = fragment.getLocalName();
                    if (fragment.getPrefix() != null && !EMPTY_STRING.equals(fragment.getPrefix())) {
                        fragmentPath = String.valueOf(fragment.getPrefix()) + ":" + fragmentPath;
                    }
                    String predicatePath = currentPath = String.valueOf(currentPath) + fragmentPath;
                    TypeInfo targetInfo = info;
                    if (fragment.getNextFragment() == null) {
                        TypeInfo predicateTypeInfo = this.typeInfo.get(ptype.getQualifiedName());
                        if (predicateTypeInfo == null && this.shouldGenerateTypeInfo(ptype)) {
                            this.buildNewTypeInfo(new JavaClass[]{ptype});
                            predicateTypeInfo = this.typeInfo.get(ptype.getQualifiedName());
                        }
                        if (predicateTypeInfo != null) {
                            targetInfo = predicateTypeInfo;
                            predicatePath = EMPTY_STRING;
                        }
                    }
                    Property predicateProperty = new Property(this.helper);
                    predicateProperty.setType(this.helper.getJavaClass("java.lang.String"));
                    if (predicatePath.length() > 0) {
                        predicatePath = String.valueOf(predicatePath) + SLASH;
                    }
                    predicatePath = String.valueOf(predicatePath) + fragment.getPredicate().getXPathFragment().getXPath();
                    predicateProperty.setXmlPath(predicatePath);
                    predicateProperty.setIsAttribute(true);
                    String predschemaName = XMLProcessor.getNameFromXPath(predicatePath, property.getPropertyName(), true);
                    QName predQname = nsInfo.isAttributeFormQualified() ? new QName(nsInfo.getNamespace(), predschemaName) : new QName(predschemaName);
                    predicateProperty.setSchemaName(predQname);
                    if (!targetInfo.hasPredicateProperty(predicateProperty)) {
                        targetInfo.getPredicateProperties().add(predicateProperty);
                    }
                } else {
                    currentPath = String.valueOf(currentPath) + fragment.getXPath();
                }
                currentPath = String.valueOf(currentPath) + SLASH;
                fragment = fragment.getNextFragment();
            }
        } else {
            property.setSchemaName(this.getQNameForProperty(propertyName, javaHasAnnotations, this.getPackageInfoForPackage(cls).getNamespaceInfo(), info));
        }
        if ((ptype = property.getActualType()).isPrimitive()) {
            property.setIsRequired(true);
        }
        if (!property.isSetXmlJavaTypeAdapter() && (refClassInfo = this.getTypeInfo().get(ptype.getQualifiedName())) != null && refClassInfo.isSetXmlJavaTypeAdapter()) {
            XmlJavaTypeAdapter xmlJavaTypeAdapter = null;
            try {
                xmlJavaTypeAdapter = refClassInfo.getXmlJavaTypeAdapter();
                property.setXmlJavaTypeAdapter(refClassInfo.getXmlJavaTypeAdapter());
            }
            catch (JAXBException jAXBException) {
                throw JAXBException.invalidTypeAdapterClass(xmlJavaTypeAdapter.getValue(), cls.getName());
            }
        }
        if (property.isXmlTransformation()) {
            this.referencedByTransformer.add(property.getType().getName());
        }
        return property;
    }

    private Property buildChoiceProperty(JavaHasAnnotations javaHasAnnotations) {
        Property choiceProperty = new Property(this.helper);
        choiceProperty.setChoice(true);
        boolean isIdRef = this.helper.isAnnotationPresent(javaHasAnnotations, XmlIDREF.class);
        choiceProperty.setIsXmlIdRef(isIdRef);
        org.eclipse.persistence.jaxb.xmlmodel.XmlElements xmlElements = new org.eclipse.persistence.jaxb.xmlmodel.XmlElements();
        javax.xml.bind.annotation.XmlElement[] elements = ((XmlElements)this.helper.getAnnotation(javaHasAnnotations, XmlElements.class)).value();
        int i = 0;
        while (i < elements.length) {
            javax.xml.bind.annotation.XmlElement next = elements[i];
            XmlElement xmlElement = new XmlElement();
            xmlElement.setDefaultValue(next.defaultValue());
            xmlElement.setName(next.name());
            xmlElement.setNamespace(next.namespace());
            xmlElement.setNillable(next.nillable());
            xmlElement.setRequired(next.required());
            xmlElement.setType(next.type().getName());
            xmlElements.getXmlElement().add(xmlElement);
            ++i;
        }
        choiceProperty.setXmlElements(xmlElements);
        if (this.helper.isAnnotationPresent(javaHasAnnotations, XmlElementsJoinNodes.class)) {
            ArrayList<org.eclipse.persistence.jaxb.xmlmodel.XmlJoinNodes> xmlJoinNodesList = new ArrayList<org.eclipse.persistence.jaxb.xmlmodel.XmlJoinNodes>();
            ArrayList<XmlJoinNodes.XmlJoinNode> xmlJoinNodeList = null;
            XmlJoinNodes[] xmlJoinNodesArray = ((XmlElementsJoinNodes)this.helper.getAnnotation(javaHasAnnotations, XmlElementsJoinNodes.class)).value();
            int n = xmlJoinNodesArray.length;
            int n2 = 0;
            while (n2 < n) {
                XmlJoinNodes xmlJNs = xmlJoinNodesArray[n2];
                xmlJoinNodeList = new ArrayList<XmlJoinNodes.XmlJoinNode>();
                XmlJoinNode[] xmlJoinNodeArray = xmlJNs.value();
                int n3 = xmlJoinNodeArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    XmlJoinNode xmlJN = xmlJoinNodeArray[n4];
                    XmlJoinNodes.XmlJoinNode xmlJoinNode = new XmlJoinNodes.XmlJoinNode();
                    xmlJoinNode.setXmlPath(xmlJN.xmlPath());
                    xmlJoinNode.setReferencedXmlPath(xmlJN.referencedXmlPath());
                    xmlJoinNodeList.add(xmlJoinNode);
                    ++n4;
                }
                if (xmlJoinNodeList.size() > 0) {
                    org.eclipse.persistence.jaxb.xmlmodel.XmlJoinNodes xmlJoinNodes = new org.eclipse.persistence.jaxb.xmlmodel.XmlJoinNodes();
                    xmlJoinNodes.setXmlJoinNode(xmlJoinNodeList);
                    xmlJoinNodesList.add(xmlJoinNodes);
                }
                ++n2;
            }
            choiceProperty.setXmlJoinNodesList(xmlJoinNodesList);
        }
        return choiceProperty;
    }

    private Property buildTransformationProperty(JavaHasAnnotations javaHasAnnotations, JavaClass cls) {
        XmlReadTransformer readTransformer;
        Property property = new Property(this.helper);
        org.eclipse.persistence.oxm.annotations.XmlTransformation transformationAnnotation = (org.eclipse.persistence.oxm.annotations.XmlTransformation)this.helper.getAnnotation(javaHasAnnotations, org.eclipse.persistence.oxm.annotations.XmlTransformation.class);
        XmlTransformation transformation = new XmlTransformation();
        if (transformationAnnotation != null) {
            transformation.setOptional(transformationAnnotation.optional());
        }
        if ((readTransformer = (XmlReadTransformer)this.helper.getAnnotation(javaHasAnnotations, XmlReadTransformer.class)) != null) {
            XmlTransformation.XmlReadTransformer xmlReadTransformer = new XmlTransformation.XmlReadTransformer();
            if (readTransformer.transformerClass() != AttributeTransformer.class) {
                xmlReadTransformer.setTransformerClass(readTransformer.transformerClass().getName());
            } else if (!readTransformer.method().equals(EMPTY_STRING)) {
                xmlReadTransformer.setMethod(readTransformer.method());
            }
            transformation.setXmlReadTransformer(xmlReadTransformer);
        }
        XmlWriteTransformer[] transformers = null;
        if (this.helper.isAnnotationPresent(javaHasAnnotations, XmlWriteTransformer.class)) {
            XmlWriteTransformer writeTransformer = (XmlWriteTransformer)this.helper.getAnnotation(javaHasAnnotations, XmlWriteTransformer.class);
            transformers = new XmlWriteTransformer[]{writeTransformer};
        } else if (this.helper.isAnnotationPresent(javaHasAnnotations, XmlWriteTransformers.class)) {
            XmlWriteTransformers writeTransformers = (XmlWriteTransformers)this.helper.getAnnotation(javaHasAnnotations, XmlWriteTransformers.class);
            transformers = writeTransformers.value();
        }
        if (transformers != null) {
            XmlWriteTransformer[] xmlWriteTransformerArray = transformers;
            int n = transformers.length;
            int n2 = 0;
            while (n2 < n) {
                XmlWriteTransformer next = xmlWriteTransformerArray[n2];
                XmlTransformation.XmlWriteTransformer xmlWriteTransformer = new XmlTransformation.XmlWriteTransformer();
                if (next.transformerClass() != FieldTransformer.class) {
                    xmlWriteTransformer.setTransformerClass(next.transformerClass().getName());
                } else if (!next.method().equals(EMPTY_STRING)) {
                    xmlWriteTransformer.setMethod(next.method());
                }
                xmlWriteTransformer.setXmlPath(next.xmlPath());
                transformation.getXmlWriteTransformer().add(xmlWriteTransformer);
                ++n2;
            }
        }
        property.setXmlTransformation(transformation);
        property.setIsXmlTransformation(true);
        return property;
    }

    private void processChoiceProperty(Property choiceProperty, TypeInfo info, JavaClass cls, JavaClass propertyType) {
        String propertyName = choiceProperty.getPropertyName();
        this.validateElementIsInPropOrder(info, propertyName);
        if (choiceProperty.isSetXmlJoinNodesList() && choiceProperty.getXmlElements().getXmlElement().size() != choiceProperty.getXmlJoinNodesList().size()) {
            throw JAXBException.incorrectNumberOfXmlJoinNodesOnXmlElements(propertyName, cls.getQualifiedName());
        }
        XmlPath[] paths = null;
        if (this.helper.isAnnotationPresent(choiceProperty.getElement(), XmlPaths.class)) {
            XmlPaths pathAnnotation = (XmlPaths)this.helper.getAnnotation(choiceProperty.getElement(), XmlPaths.class);
            paths = pathAnnotation.value();
        }
        ArrayList<Property> choiceProperties = new ArrayList<Property>();
        int i = 0;
        while (i < choiceProperty.getXmlElements().getXmlElement().size()) {
            org.eclipse.persistence.jaxb.xmlmodel.XmlJoinNodes xmlJoinNodes;
            NamespaceInfo namespaceInfo;
            TypeInfo tInfo;
            String namespace;
            String name;
            XmlElement next = choiceProperty.getXmlElements().getXmlElement().get(i);
            Property choiceProp = new Property(this.helper);
            if (paths != null && next.getXmlPath() == null) {
                XmlPath nextPath = paths[i];
                next.setXmlPath(nextPath.value());
            }
            if (next.getXmlPath() != null) {
                choiceProp.setXmlPath(next.getXmlPath());
                boolean isAttribute = new XMLField(next.getXmlPath()).getLastXPathFragment().isAttribute();
                if (isAttribute && !next.getXmlPath().contains(SLASH)) {
                    throw JAXBException.invalidXmlPathWithAttribute(propertyName, cls.getQualifiedName(), next.getXmlPath());
                }
                choiceProp.setIsAttribute(isAttribute);
                name = XMLProcessor.getNameFromXPath(next.getXmlPath(), propertyName, isAttribute);
                namespace = "##default";
            } else {
                name = next.getName();
                namespace = next.getNamespace();
            }
            if (name == null || name.equals("##default")) {
                name = next.getJavaAttribute() != null ? next.getJavaAttribute() : propertyName;
            }
            if (choiceProperty.isXmlIdRef() && ((tInfo = this.typeInfo.get(next.getType())) == null || !tInfo.isIDSet())) {
                throw JAXBException.invalidXmlElementInXmlElementsList(propertyName, name);
            }
            QName qName = null;
            qName = !namespace.equals("##default") ? new QName(namespace, name) : ((namespaceInfo = this.getPackageInfoForPackage(cls).getNamespaceInfo()).isElementFormQualified() ? new QName(namespaceInfo.getNamespace(), name) : new QName(name));
            choiceProp.setPropertyName(name);
            if (next.getType().equals("javax.xml.bind.annotation.XmlElement.DEFAULT") || next.getType().equals("javax.xml.bind.annotation.XmlElement$DEFAULT")) {
                choiceProp.setType(propertyType);
            } else {
                choiceProp.setType(this.helper.getJavaClass(next.getType()));
            }
            if (choiceProperty.isSetXmlJoinNodesList() && (xmlJoinNodes = choiceProperty.getXmlJoinNodesList().get(i)) != null) {
                choiceProp.setXmlJoinNodes(xmlJoinNodes);
                if (!xmlJoinNodes.getType().equals("##default")) {
                    JavaClass pType = this.helper.getJavaClass(xmlJoinNodes.getType());
                    if (this.isCollectionType(choiceProp.getType())) {
                        choiceProp.setGenericType(pType);
                    } else {
                        choiceProp.setType(pType);
                    }
                }
            }
            choiceProp.setSchemaName(qName);
            choiceProp.setSchemaType(this.getSchemaTypeFor(choiceProp.getType()));
            choiceProp.setIsXmlIdRef(choiceProperty.isXmlIdRef());
            choiceProp.setXmlElementWrapper(choiceProperty.getXmlElementWrapper());
            choiceProperties.add(choiceProp);
            if (!this.typeInfo.containsKey(choiceProp.getType().getQualifiedName()) && this.shouldGenerateTypeInfo(choiceProp.getType())) {
                JavaClass[] jClassArray = new JavaClass[]{choiceProp.getType()};
                this.buildNewTypeInfo(jClassArray);
            }
            ++i;
        }
        choiceProperty.setChoiceProperties(choiceProperties);
    }

    private Property buildReferenceProperty(TypeInfo info, JavaHasAnnotations javaHasAnnotations, String propertyName, JavaClass ptype) {
        XmlElementRef[] elementRefs;
        Property property = new Property(this.helper);
        property.setType(ptype);
        XmlElementRef ref = (XmlElementRef)this.helper.getAnnotation(javaHasAnnotations, XmlElementRef.class);
        if (ref != null) {
            elementRefs = new XmlElementRef[]{ref};
        } else {
            XmlElementRefs refs = (XmlElementRefs)this.helper.getAnnotation(javaHasAnnotations, XmlElementRefs.class);
            elementRefs = refs.value();
            info.setElementRefsPropertyName(propertyName);
        }
        ArrayList<org.eclipse.persistence.jaxb.xmlmodel.XmlElementRef> eltRefs = new ArrayList<org.eclipse.persistence.jaxb.xmlmodel.XmlElementRef>();
        XmlElementRef[] xmlElementRefArray = elementRefs;
        int n = elementRefs.length;
        int n2 = 0;
        while (n2 < n) {
            XmlElementRef nextRef = xmlElementRefArray[n2];
            org.eclipse.persistence.jaxb.xmlmodel.XmlElementRef eltRef = new org.eclipse.persistence.jaxb.xmlmodel.XmlElementRef();
            eltRef.setName(nextRef.name());
            eltRef.setNamespace(nextRef.namespace());
            eltRef.setType(nextRef.type().getName());
            eltRefs.add(eltRef);
            ++n2;
        }
        property.setIsReference(true);
        property.setXmlElementRefs(eltRefs);
        return property;
    }

    private Property processReferenceProperty(Property property, TypeInfo info, JavaClass cls) {
        String propertyName = property.getPropertyName();
        this.validateElementIsInPropOrder(info, propertyName);
        for (org.eclipse.persistence.jaxb.xmlmodel.XmlElementRef nextRef : property.getXmlElementRefs()) {
            JavaClass type = property.getType();
            String typeName = type.getQualifiedName();
            if (this.isCollectionType(property) && type.hasActualTypeArguments()) {
                type = property.getGenericType();
                typeName = type.getQualifiedName();
            }
            if (!nextRef.getType().equals("javax.xml.bind.annotation.XmlElementRef.DEFAULT") && !nextRef.getType().equals("javax.xml.bind.annotation.XmlElementRef$DEFAULT")) {
                typeName = nextRef.getType();
                type = this.helper.getJavaClass(typeName);
            }
            boolean missingReference = true;
            for (Map.Entry<String, ElementDeclaration> entry : this.xmlRootElements.entrySet()) {
                ElementDeclaration entryValue = entry.getValue();
                if (this.areEquals(type, Object.class) || !type.isAssignableFrom(entryValue.getJavaType())) continue;
                this.addReferencedElement(property, entryValue);
                missingReference = false;
            }
            if (!missingReference) continue;
            String name = nextRef.getName();
            String namespace = nextRef.getNamespace();
            if (namespace.equals("##default")) {
                namespace = EMPTY_STRING;
            }
            QName qname = new QName(namespace, name);
            JavaClass scopeClass = cls;
            ElementDeclaration referencedElement = null;
            while (!scopeClass.getName().equals(JAVA_LANG_OBJECT)) {
                HashMap<QName, ElementDeclaration> elements = this.getElementDeclarationsForScope(scopeClass.getName());
                if (elements != null) {
                    referencedElement = elements.get(qname);
                }
                if (referencedElement != null) break;
                scopeClass = scopeClass.getSuperclass();
            }
            if (referencedElement == null) {
                referencedElement = this.getGlobalElements().get(qname);
            }
            if (referencedElement != null) {
                this.addReferencedElement(property, referencedElement);
                continue;
            }
            throw JAXBException.invalidElementRef(property.getPropertyName(), cls.getName());
        }
        return property;
    }

    private void processReferencePropertyTypes(Property property, TypeInfo info, JavaClass theClass) {
        for (org.eclipse.persistence.jaxb.xmlmodel.XmlElementRef nextRef : property.getXmlElementRefs()) {
            TypeInfo refTypeInfo;
            JavaClass theType;
            TypeInfo refTypeInfo2;
            JavaClass type = property.getType();
            String typeName = type.getQualifiedName();
            if (this.isCollectionType(property) && type.hasActualTypeArguments()) {
                type = property.getGenericType();
                typeName = type.getQualifiedName();
            }
            if (JAVAX_XML_BIND_JAXBELEMENT.equals(typeName) && type.getActualTypeArguments().size() > 0 && (refTypeInfo2 = this.typeInfo.get((theType = (JavaClass)type.getActualTypeArguments().iterator().next()).getQualifiedName())) == null && this.shouldGenerateTypeInfo(theType)) {
                JavaClass[] jClassArray = new JavaClass[]{theType};
                this.buildNewTypeInfo(jClassArray);
            }
            if (!nextRef.getType().equals("javax.xml.bind.annotation.XmlElementRef.DEFAULT") && !nextRef.getType().equals("javax.xml.bind.annotation.XmlElementRef$DEFAULT")) {
                typeName = nextRef.getType();
                type = this.helper.getJavaClass(typeName);
            }
            if ((refTypeInfo = this.typeInfo.get(type.getQualifiedName())) != null || !this.shouldGenerateTypeInfo(type)) continue;
            JavaClass[] jClassArray = new JavaClass[]{type};
            this.buildNewTypeInfo(jClassArray);
        }
    }

    private void processPropertyAnnotations(TypeInfo info, JavaClass cls, JavaHasAnnotations javaHasAnnotations, Property property) {
        Map<Object, Object> propertiesMap;
        if (this.helper.isAnnotationPresent(javaHasAnnotations, XmlMixed.class)) {
            info.setMixed(true);
            property.setMixedContent(true);
            this.findAndProcessObjectFactory(cls);
        }
        if (this.helper.isAnnotationPresent(javaHasAnnotations, XmlContainerProperty.class)) {
            XmlContainerProperty container = (XmlContainerProperty)this.helper.getAnnotation(javaHasAnnotations, XmlContainerProperty.class);
            property.setInverseReferencePropertyName(container.value());
            property.setInverseReferencePropertyGetMethodName(container.getMethodName());
            property.setInverseReferencePropertySetMethodName(container.setMethodName());
        } else if (this.helper.isAnnotationPresent(javaHasAnnotations, XmlInverseReference.class)) {
            XmlInverseReference inverseReference = (XmlInverseReference)this.helper.getAnnotation(javaHasAnnotations, XmlInverseReference.class);
            property.setInverseReferencePropertyName(inverseReference.mappedBy());
            TypeInfo targetInfo = this.getTypeInfo().get(property.getActualType().getName());
            if (targetInfo != null && targetInfo.getXmlAccessType() == XmlAccessType.PROPERTY) {
                String propName = property.getPropertyName();
                propName = String.valueOf(Character.toUpperCase(propName.charAt(0))) + propName.substring(1);
                property.setInverseReferencePropertyGetMethodName(GET_STR + propName);
                property.setInverseReferencePropertySetMethodName(SET_STR + propName);
            }
            property.setInverseReference(true);
        }
        this.processXmlJavaTypeAdapter(property, info, cls);
        if (this.helper.isAnnotationPresent(property.getElement(), XmlAttachmentRef.class) && this.areEquals(property.getActualType(), JAVAX_ACTIVATION_DATAHANDLER)) {
            property.setIsSwaAttachmentRef(true);
            property.setSchemaType(XMLConstants.SWA_REF_QNAME);
        }
        this.processXmlElement(property, info);
        if (!property.isSwaAttachmentRef() && this.isMtomAttachment(property)) {
            property.setIsMtomAttachment(true);
            property.setSchemaType(XMLConstants.BASE_64_BINARY_QNAME);
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlMimeType.class)) {
            property.setMimeType(((XmlMimeType)this.helper.getAnnotation(property.getElement(), XmlMimeType.class)).value());
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlInlineBinaryData.class) || info.isBinaryDataToBeInlined()) {
            property.setisInlineBinaryData(true);
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlSchemaType.class)) {
            XmlSchemaType schemaType = (XmlSchemaType)this.helper.getAnnotation(property.getElement(), XmlSchemaType.class);
            QName schemaTypeQname = new QName(schemaType.namespace(), schemaType.name());
            property.setSchemaType(schemaTypeQname);
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlAttribute.class)) {
            property.setIsAttribute(true);
            property.setIsRequired(((XmlAttribute)this.helper.getAnnotation(property.getElement(), XmlAttribute.class)).required());
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlAnyAttribute.class)) {
            if (info.isSetAnyAttributePropertyName() && !info.getAnyAttributePropertyName().equals(property.getPropertyName())) {
                throw JAXBException.multipleAnyAttributeMapping(cls.getName());
            }
            if (!this.isMapType(property.getType())) {
                throw JAXBException.anyAttributeOnNonMap(property.getPropertyName());
            }
            property.setIsAnyAttribute(true);
            info.setAnyAttributePropertyName(property.getPropertyName());
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlElementWrapper.class)) {
            XmlElementWrapper wrapper = (XmlElementWrapper)this.helper.getAnnotation(property.getElement(), XmlElementWrapper.class);
            org.eclipse.persistence.jaxb.xmlmodel.XmlElementWrapper xmlEltWrapper = new org.eclipse.persistence.jaxb.xmlmodel.XmlElementWrapper();
            xmlEltWrapper.setName(wrapper.name());
            xmlEltWrapper.setNamespace(wrapper.namespace());
            xmlEltWrapper.setNillable(wrapper.nillable());
            xmlEltWrapper.setRequired(wrapper.required());
            property.setXmlElementWrapper(xmlEltWrapper);
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlList.class)) {
            if (!this.isCollectionType(property) && !property.getType().isArray()) {
                throw JAXBException.invalidList(property.getPropertyName());
            }
            property.setIsXmlList(true);
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlValue.class)) {
            property.setIsXmlValue(true);
            info.setXmlValueProperty(property);
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlReadOnly.class)) {
            property.setReadOnly(true);
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlWriteOnly.class)) {
            property.setWriteOnly(true);
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlCDATA.class)) {
            property.setCdata(true);
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlAccessMethods.class)) {
            XmlAccessMethods accessMethods = (XmlAccessMethods)this.helper.getAnnotation(property.getElement(), XmlAccessMethods.class);
            if (!accessMethods.getMethodName().equals(EMPTY_STRING)) {
                property.setGetMethodName(accessMethods.getMethodName());
            }
            if (!accessMethods.setMethodName().equals(EMPTY_STRING)) {
                property.setSetMethodName(accessMethods.setMethodName());
            }
            if (!property.isMethodProperty()) {
                property.setMethodProperty(true);
            }
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlProperties.class)) {
            XmlProperties xmlProperties = (XmlProperties)this.helper.getAnnotation(property.getElement(), XmlProperties.class);
            propertiesMap = this.createUserPropertiesMap(xmlProperties.value());
            property.setUserProperties(propertiesMap);
        } else if (this.helper.isAnnotationPresent(property.getElement(), XmlProperty.class)) {
            XmlProperty xmlProperty = (XmlProperty)this.helper.getAnnotation(property.getElement(), XmlProperty.class);
            propertiesMap = this.createUserPropertiesMap(new XmlProperty[]{xmlProperty});
            property.setUserProperties(propertiesMap);
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlKey.class)) {
            info.addXmlKeyProperty(property);
        }
        this.processXmlJoinNodes(property);
        this.processXmlNullPolicy(property);
        if (this.helper.isAnnotationPresent(property.getElement(), XmlLocation.class)) {
            if (!this.helper.getJavaClass(XMLConstants.LOCATOR_CLASS).isAssignableFrom(property.getType())) {
                throw JAXBException.invalidXmlLocation(property.getPropertyName(), property.getType().getName());
            }
            property.setXmlLocation(true);
        }
    }

    private void processXmlJoinNodes(Property property) {
        if (this.helper.isAnnotationPresent(property.getElement(), XmlJoinNodes.class)) {
            ArrayList<XmlJoinNodes.XmlJoinNode> xmlJoinNodeList = new ArrayList<XmlJoinNodes.XmlJoinNode>();
            XmlJoinNode[] xmlJoinNodeArray = ((XmlJoinNodes)this.helper.getAnnotation(property.getElement(), XmlJoinNodes.class)).value();
            int n = xmlJoinNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                XmlJoinNode xmlJN = xmlJoinNodeArray[n2];
                XmlJoinNodes.XmlJoinNode xmlJoinNode = new XmlJoinNodes.XmlJoinNode();
                xmlJoinNode.setXmlPath(xmlJN.xmlPath());
                xmlJoinNode.setReferencedXmlPath(xmlJN.referencedXmlPath());
                xmlJoinNodeList.add(xmlJoinNode);
                ++n2;
            }
            org.eclipse.persistence.jaxb.xmlmodel.XmlJoinNodes xmlJoinNodes = new org.eclipse.persistence.jaxb.xmlmodel.XmlJoinNodes();
            xmlJoinNodes.setXmlJoinNode(xmlJoinNodeList);
            property.setXmlJoinNodes(xmlJoinNodes);
        } else if (this.helper.isAnnotationPresent(property.getElement(), XmlJoinNode.class)) {
            XmlJoinNode xmlJN = (XmlJoinNode)this.helper.getAnnotation(property.getElement(), XmlJoinNode.class);
            XmlJoinNodes.XmlJoinNode xmlJoinNode = new XmlJoinNodes.XmlJoinNode();
            xmlJoinNode.setXmlPath(xmlJN.xmlPath());
            xmlJoinNode.setReferencedXmlPath(xmlJN.referencedXmlPath());
            ArrayList<XmlJoinNodes.XmlJoinNode> xmlJoinNodeList = new ArrayList<XmlJoinNodes.XmlJoinNode>();
            xmlJoinNodeList.add(xmlJoinNode);
            org.eclipse.persistence.jaxb.xmlmodel.XmlJoinNodes xmlJoinNodes = new org.eclipse.persistence.jaxb.xmlmodel.XmlJoinNodes();
            xmlJoinNodes.setXmlJoinNode(xmlJoinNodeList);
            property.setXmlJoinNodes(xmlJoinNodes);
        }
    }

    private void processXmlTransformationProperty(Property property) {
        if (property.isSetXmlTransformation()) {
            XmlTransformation xmlTransformation = property.getXmlTransformation();
            if (xmlTransformation.isSetXmlReadTransformer()) {
                XmlTransformation.XmlReadTransformer readTransformer = xmlTransformation.getXmlReadTransformer();
                if (readTransformer.isSetTransformerClass()) {
                    if (readTransformer.isSetMethod()) {
                        throw JAXBException.readTransformerHasBothClassAndMethod(property.getPropertyName());
                    }
                } else if (!readTransformer.isSetMethod()) {
                    throw JAXBException.readTransformerHasNeitherClassNorMethod(property.getPropertyName());
                }
            }
            if (xmlTransformation.isSetXmlWriteTransformers()) {
                for (XmlTransformation.XmlWriteTransformer writeTransformer : xmlTransformation.getXmlWriteTransformer()) {
                    if (!writeTransformer.isSetXmlPath()) {
                        throw JAXBException.writeTransformerHasNoXmlPath(property.getPropertyName());
                    }
                    if (writeTransformer.isSetTransformerClass()) {
                        if (!writeTransformer.isSetMethod()) continue;
                        throw JAXBException.writeTransformerHasBothClassAndMethod(property.getPropertyName(), writeTransformer.getXmlPath());
                    }
                    if (writeTransformer.isSetMethod()) continue;
                    throw JAXBException.writeTransformerHasNeitherClassNorMethod(property.getPropertyName(), writeTransformer.getXmlPath());
                }
            }
        }
    }

    protected boolean areEquals(JavaClass src, Class tgt) {
        if (src == null || tgt == null) {
            return false;
        }
        return src.getRawName().equals(tgt.getCanonicalName());
    }

    private void processXmlNullPolicy(Property property) {
        if (this.helper.isAnnotationPresent(property.getElement(), XmlNullPolicy.class)) {
            XmlNullPolicy nullPolicy = (XmlNullPolicy)this.helper.getAnnotation(property.getElement(), XmlNullPolicy.class);
            org.eclipse.persistence.jaxb.xmlmodel.XmlNullPolicy policy = new org.eclipse.persistence.jaxb.xmlmodel.XmlNullPolicy();
            policy.setEmptyNodeRepresentsNull(nullPolicy.emptyNodeRepresentsNull());
            policy.setIsSetPerformedForAbsentNode(nullPolicy.isSetPerformedForAbsentNode());
            policy.setXsiNilRepresentsNull(nullPolicy.xsiNilRepresentsNull());
            policy.setNullRepresentationForXml(XmlMarshalNullRepresentation.valueOf(nullPolicy.nullRepresentationForXml().toString()));
            property.setNullPolicy(policy);
        } else if (this.helper.isAnnotationPresent(property.getElement(), XmlIsSetNullPolicy.class)) {
            XmlIsSetNullPolicy nullPolicy = (XmlIsSetNullPolicy)this.helper.getAnnotation(property.getElement(), XmlIsSetNullPolicy.class);
            org.eclipse.persistence.jaxb.xmlmodel.XmlIsSetNullPolicy policy = new org.eclipse.persistence.jaxb.xmlmodel.XmlIsSetNullPolicy();
            policy.setEmptyNodeRepresentsNull(nullPolicy.emptyNodeRepresentsNull());
            policy.setXsiNilRepresentsNull(nullPolicy.xsiNilRepresentsNull());
            policy.setNullRepresentationForXml(XmlMarshalNullRepresentation.valueOf(nullPolicy.nullRepresentationForXml().toString()));
            policy.setIsSetMethodName(nullPolicy.isSetMethodName());
            XmlParameter[] xmlParameterArray = nullPolicy.isSetParameters();
            int n = xmlParameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                XmlParameter next = xmlParameterArray[n2];
                XmlIsSetNullPolicy.IsSetParameter param = new XmlIsSetNullPolicy.IsSetParameter();
                param.setValue(next.value());
                param.setType(next.type().getName());
                policy.getIsSetParameter().add(param);
                ++n2;
            }
            property.setNullPolicy(policy);
        }
    }

    protected boolean areEquals(JavaClass src, String tgtCanonicalName) {
        if (src == null || tgtCanonicalName == null) {
            return false;
        }
        return src.getRawName().equals(tgtCanonicalName);
    }

    public ArrayList<Property> getPropertyPropertiesForClass(JavaClass cls, TypeInfo info, boolean onlyPublic) {
        return this.getPropertyPropertiesForClass(cls, info, onlyPublic, false);
    }

    public ArrayList<Property> getPropertyPropertiesForClass(JavaClass cls, TypeInfo info, boolean onlyPublic, boolean onlyExplicit) {
        ArrayList<Property> properties = new ArrayList<Property>();
        if (cls == null) {
            return properties;
        }
        ArrayList<JavaMethod> propertyMethods = new ArrayList<JavaMethod>();
        for (JavaMethod next : new ArrayList(cls.getDeclaredMethods())) {
            int modifiers;
            if (next.isSynthetic()) continue;
            if ((next.getName().startsWith(GET_STR) && next.getName().length() > 3 || next.getName().startsWith(IS_STR) && next.getName().length() > 2) && next.getParameterTypes().length == 0 && next.getReturnType() != this.helper.getJavaClass(Void.class)) {
                modifiers = next.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || (!onlyPublic || !Modifier.isPublic(next.getModifiers())) && onlyPublic) continue;
                propertyMethods.add(next);
                continue;
            }
            if (!next.getName().startsWith(SET_STR) || next.getName().length() <= 3 || next.getParameterTypes().length != 1 || Modifier.isStatic(modifiers = next.getModifiers()) || Modifier.isTransient(modifiers) || (!onlyPublic || !Modifier.isPublic(next.getModifiers())) && onlyPublic) continue;
            propertyMethods.add(next);
        }
        ArrayList<String> propertyNames = new ArrayList<String>();
        int i = 0;
        while (i < propertyMethods.size()) {
            block36: {
                boolean isLocation;
                boolean isTransient;
                JavaMethod setMethod;
                JavaMethod getMethod;
                JavaMethod propertyMethod;
                String propertyName;
                boolean isPropertyTransient;
                block34: {
                    block38: {
                        block39: {
                            boolean isLocation2;
                            block37: {
                                JavaMethod nextMethod;
                                block32: {
                                    block35: {
                                        block33: {
                                            isPropertyTransient = false;
                                            nextMethod = (JavaMethod)propertyMethods.get(i);
                                            propertyName = EMPTY_STRING;
                                            propertyMethod = null;
                                            if (nextMethod.getName().startsWith(SET_STR)) break block32;
                                            if (nextMethod.getName().startsWith(GET_STR)) {
                                                propertyName = nextMethod.getName().substring(3);
                                            } else if (nextMethod.getName().startsWith(IS_STR)) {
                                                propertyName = nextMethod.getName().substring(2);
                                            }
                                            getMethod = nextMethod;
                                            String setMethodName = SET_STR + propertyName;
                                            propertyName = Introspector.decapitalize(propertyName);
                                            JavaClass[] paramTypes = new JavaClass[]{getMethod.getReturnType()};
                                            setMethod = cls.getDeclaredMethod(setMethodName, paramTypes);
                                            if (setMethod == null || !this.hasJAXBAnnotations(setMethod)) break block33;
                                            isTransient = this.helper.isAnnotationPresent(setMethod, XmlTransient.class);
                                            isLocation = this.helper.isAnnotationPresent(setMethod, XmlLocation.class);
                                            if (!isTransient) {
                                                propertyMethod = setMethod;
                                            } else {
                                                isPropertyTransient = true;
                                                if (isLocation) {
                                                    propertyMethod = setMethod;
                                                    info.setLocationAware(true);
                                                }
                                            }
                                            break block34;
                                        }
                                        if ((!onlyExplicit || !this.hasJAXBAnnotations(getMethod)) && onlyExplicit) break block35;
                                        isTransient = this.helper.isAnnotationPresent(getMethod, XmlTransient.class);
                                        isLocation = this.helper.isAnnotationPresent(getMethod, XmlLocation.class);
                                        if (!isTransient) {
                                            propertyMethod = getMethod;
                                        } else {
                                            isPropertyTransient = true;
                                            if (isLocation) {
                                                propertyMethod = getMethod;
                                                info.setLocationAware(true);
                                            }
                                        }
                                        break block34;
                                    }
                                    if (!onlyExplicit) break block34;
                                    break block36;
                                }
                                propertyName = nextMethod.getName().substring(3);
                                setMethod = nextMethod;
                                String getMethodName = GET_STR + propertyName;
                                getMethod = cls.getDeclaredMethod(getMethodName, new JavaClass[0]);
                                if (getMethod == null) {
                                    getMethodName = IS_STR + propertyName;
                                    getMethod = cls.getDeclaredMethod(getMethodName, new JavaClass[0]);
                                }
                                if (getMethod == null || !this.hasJAXBAnnotations(getMethod)) break block37;
                                boolean isTransient2 = this.helper.isAnnotationPresent(getMethod, XmlTransient.class);
                                isLocation2 = this.helper.isAnnotationPresent(getMethod, XmlLocation.class);
                                if (!isTransient2) {
                                    propertyMethod = getMethod;
                                } else {
                                    isPropertyTransient = true;
                                    if (isLocation2) {
                                        propertyMethod = getMethod;
                                        info.setLocationAware(true);
                                    }
                                }
                                break block38;
                            }
                            if ((!onlyExplicit || !this.hasJAXBAnnotations(setMethod)) && onlyExplicit) break block39;
                            boolean isTransient3 = this.helper.isAnnotationPresent(setMethod, XmlTransient.class);
                            isLocation2 = this.helper.isAnnotationPresent(setMethod, XmlLocation.class);
                            if (!isTransient3) {
                                propertyMethod = setMethod;
                            } else {
                                isPropertyTransient = true;
                                if (isLocation2) {
                                    propertyMethod = setMethod;
                                    info.setLocationAware(true);
                                }
                            }
                            break block38;
                        }
                        if (onlyExplicit) break block36;
                    }
                    propertyName = Introspector.decapitalize(propertyName);
                }
                JavaClass ptype = null;
                ptype = getMethod != null ? getMethod.getReturnType() : setMethod.getParameterTypes()[0];
                if (!propertyNames.contains(propertyName)) {
                    propertyNames.add(propertyName);
                    Property property = this.buildNewProperty(info, cls, propertyMethod, propertyName, ptype);
                    property.setTransient(isPropertyTransient);
                    if (getMethod != null) {
                        property.setOriginalGetMethodName(getMethod.getName());
                        if (property.getGetMethodName() == null) {
                            property.setGetMethodName(getMethod.getName());
                        }
                    }
                    if (setMethod != null) {
                        property.setOriginalSetMethodName(setMethod.getName());
                        if (property.getSetMethodName() == null) {
                            property.setSetMethodName(setMethod.getName());
                        }
                    }
                    property.setMethodProperty(true);
                    isTransient = this.helper.isAnnotationPresent(property.getElement(), XmlTransient.class);
                    isLocation = this.helper.isAnnotationPresent(property.getElement(), XmlLocation.class);
                    if (!isTransient || isTransient && isLocation) {
                        properties.add(property);
                    } else {
                        List<String> propOrderList = Arrays.asList(info.getPropOrder());
                        if (propOrderList.contains(propertyName)) {
                            throw JAXBException.transientInProporder(propertyName);
                        }
                        property.setTransient(true);
                    }
                }
            }
            ++i;
        }
        properties = this.removeSuperclassProperties(cls, properties);
        Collections.sort(properties, new PropertyComparitor());
        return properties;
    }

    private ArrayList<Property> removeSuperclassProperties(JavaClass cls, ArrayList<Property> properties) {
        TypeInfo superClassInfo;
        ArrayList<Property> revisedProperties = new ArrayList<Property>();
        revisedProperties.addAll(properties);
        JavaClass superClass = cls.getSuperclass();
        if (superClass != null && (superClassInfo = this.typeInfo.get(superClass.getQualifiedName())) != null && !superClassInfo.isTransient()) {
            for (Property prop : properties) {
                for (Property superProp : superClassInfo.getProperties().values()) {
                    if (superProp.getGetMethodName() == null || !superProp.getGetMethodName().equals(prop.getGetMethodName())) continue;
                    revisedProperties.remove(prop);
                }
            }
        }
        return revisedProperties;
    }

    public ArrayList getPublicMemberPropertiesForClass(JavaClass cls, TypeInfo info) {
        ArrayList<Property> fieldProperties = this.getFieldPropertiesForClass(cls, info, false);
        ArrayList<Property> methodProperties = this.getPropertyPropertiesForClass(cls, info, false);
        ArrayList<Property> publicFieldProperties = new ArrayList<Property>();
        ArrayList<Property> publicMethodProperties = new ArrayList<Property>();
        for (Property next : fieldProperties) {
            if (Modifier.isPublic(((JavaField)next.getElement()).getModifiers())) {
                publicFieldProperties.add(next);
                continue;
            }
            if (!this.hasJAXBAnnotations(next.getElement())) continue;
            publicFieldProperties.add(next);
        }
        for (Property next : methodProperties) {
            if (next.getElement() == null) continue;
            if (Modifier.isPublic(((JavaMethod)next.getElement()).getModifiers())) {
                publicMethodProperties.add(next);
                continue;
            }
            if (!this.hasJAXBAnnotations(next.getElement())) continue;
            publicMethodProperties.add(next);
        }
        if (publicFieldProperties.size() >= 0 && publicMethodProperties.size() == 0) {
            return publicFieldProperties;
        }
        if (publicMethodProperties.size() > 0 && publicFieldProperties.size() == 0) {
            return publicMethodProperties;
        }
        HashMap<String, Property> fieldPropertyMap = this.getPropertyMapFromArrayList(publicFieldProperties);
        int i = 0;
        while (i < publicMethodProperties.size()) {
            Property next = (Property)publicMethodProperties.get(i);
            Property fieldProp = fieldPropertyMap.get(next.getPropertyName());
            if (fieldProp == null) {
                publicFieldProperties.add(next);
            } else if (fieldProp.isTransient()) {
                publicFieldProperties.remove(fieldProp);
                publicFieldProperties.add(next);
            }
            ++i;
        }
        return publicFieldProperties;
    }

    public HashMap<String, Property> getPropertyMapFromArrayList(ArrayList<Property> props) {
        HashMap<String, Property> propMap = new HashMap<String, Property>(props.size());
        for (Property next : props) {
            propMap.put(next.getPropertyName(), next);
        }
        return propMap;
    }

    public ArrayList getNoAccessTypePropertiesForClass(JavaClass cls, TypeInfo info) {
        ArrayList<Property> list = new ArrayList<Property>();
        if (cls == null) {
            return list;
        }
        ArrayList<Property> fieldProperties = this.getFieldPropertiesForClass(cls, info, false);
        HashMap<String, Property> fields = new HashMap<String, Property>(fieldProperties.size());
        for (Property next : fieldProperties) {
            JavaHasAnnotations elem = next.getElement();
            if (!this.hasJAXBAnnotations(elem)) {
                next.setTransient(true);
            }
            list.add(next);
            fields.put(next.getPropertyName(), next);
        }
        ArrayList<Property> methodProperties = this.getPropertyPropertiesForClass(cls, info, false);
        for (Property next : methodProperties) {
            JavaHasAnnotations elem = next.getElement();
            if (this.hasJAXBAnnotations(elem)) {
                Property fieldProperty = (Property)fields.get(next.getPropertyName());
                list.remove(fieldProperty);
                list.add(next);
                continue;
            }
            next.setTransient(true);
            if (fields.get(next.getPropertyName()) != null) continue;
            list.add(next);
        }
        return list;
    }

    public void processSchemaType(String name, String namespace, String jClassQualifiedName) {
        this.userDefinedSchemaTypes.put(jClassQualifiedName, new QName(namespace, name));
    }

    public void processSchemaType(XmlSchemaType type) {
        JavaClass jClass = this.helper.getJavaClass(type.type());
        if (jClass == null) {
            return;
        }
        this.processSchemaType(type.name(), type.namespace(), jClass.getQualifiedName());
    }

    public void addEnumTypeInfo(JavaClass javaClass, EnumTypeInfo info) {
        if (javaClass == null) {
            return;
        }
        info.setClassName(javaClass.getQualifiedName());
        Class restrictionClass = String.class;
        if (this.helper.isAnnotationPresent(javaClass, XmlEnum.class)) {
            XmlEnum xmlEnum = (XmlEnum)this.helper.getAnnotation(javaClass, XmlEnum.class);
            restrictionClass = xmlEnum.value();
        }
        QName restrictionBase = this.getSchemaTypeFor(this.helper.getJavaClass(restrictionClass));
        info.setRestrictionBase(restrictionBase);
        for (JavaField field : javaClass.getDeclaredFields()) {
            if (!field.isEnumConstant()) continue;
            String enumValue = field.getName();
            if (this.helper.isAnnotationPresent(field, XmlEnumValue.class)) {
                enumValue = ((XmlEnumValue)this.helper.getAnnotation(field, XmlEnumValue.class)).value();
            }
            info.addJavaFieldToXmlEnumValuePair(field.getName(), enumValue);
        }
        ElementDeclaration elem = new ElementDeclaration(null, javaClass, javaClass.getQualifiedName(), false);
        this.getLocalElements().add(elem);
    }

    public QName getSchemaTypeOrNullFor(JavaClass javaClass) {
        if (javaClass == null) {
            return null;
        }
        QName schemaType = this.userDefinedSchemaTypes.get(javaClass.getQualifiedName());
        if (schemaType == null) {
            schemaType = (QName)this.helper.getXMLToJavaTypeMap().get(javaClass.getRawName());
        }
        return schemaType;
    }

    public QName getSchemaTypeFor(JavaClass javaClass) {
        QName schemaType = this.getSchemaTypeOrNullFor(javaClass);
        if (schemaType == null) {
            return XMLConstants.ANY_SIMPLE_TYPE_QNAME;
        }
        return schemaType;
    }

    public boolean isCollectionType(Property field) {
        return this.isCollectionType(field.getType());
    }

    public boolean isCollectionType(JavaClass type) {
        return this.helper.getJavaClass(Collection.class).isAssignableFrom(type) || this.helper.getJavaClass(List.class).isAssignableFrom(type) || this.helper.getJavaClass(Set.class).isAssignableFrom(type);
    }

    public NamespaceInfo processNamespaceInformation(XmlSchema xmlSchema) {
        NamespaceInfo info = new NamespaceInfo();
        info.setNamespaceResolver(new NamespaceResolver());
        String packageNamespace = null;
        if (xmlSchema != null) {
            String namespaceMapping = xmlSchema.namespace();
            if (!namespaceMapping.equals(EMPTY_STRING) && !namespaceMapping.equals("##default")) {
                packageNamespace = namespaceMapping;
            } else if (namespaceMapping.equals("##default")) {
                packageNamespace = this.defaultTargetNamespace;
            }
            info.setNamespace(packageNamespace);
            XmlNs[] xmlns = xmlSchema.xmlns();
            int i = 0;
            while (i < xmlns.length) {
                XmlNs next = xmlns[i];
                info.getNamespaceResolver().put(next.prefix(), next.namespaceURI());
                if (next.namespaceURI().equals(packageNamespace)) {
                    this.isDefaultNamespaceAllowed = false;
                }
                ++i;
            }
            info.setAttributeFormQualified(xmlSchema.attributeFormDefault() == XmlNsForm.QUALIFIED);
            info.setElementFormQualified(xmlSchema.elementFormDefault() == XmlNsForm.QUALIFIED);
            try {
                Method locationMethod = PrivilegedAccessHelper.getDeclaredMethod(XmlSchema.class, "location", new Class[0]);
                String location = (String)PrivilegedAccessHelper.invokeMethod(locationMethod, xmlSchema, new Object[0]);
                if (location != null) {
                    if (location.equals("##generate")) {
                        location = null;
                    } else if (location.equals(EMPTY_STRING)) {
                        location = null;
                    }
                }
                info.setLocation(location);
            }
            catch (Exception exception) {}
        } else {
            info.setNamespace(this.defaultTargetNamespace);
        }
        if (!info.isElementFormQualified() || info.isAttributeFormQualified()) {
            this.isDefaultNamespaceAllowed = false;
        }
        return info;
    }

    public HashMap<String, TypeInfo> getTypeInfo() {
        return this.typeInfo;
    }

    public ArrayList<JavaClass> getTypeInfoClasses() {
        return this.typeInfoClasses;
    }

    public HashMap<String, QName> getUserDefinedSchemaTypes() {
        return this.userDefinedSchemaTypes;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceResolver;
    }

    public QName getQNameForProperty(String defaultName, JavaHasAnnotations element, NamespaceInfo namespaceInfo, TypeInfo info) {
        String uri = info.getClassNamespace();
        String name = "##default";
        String namespace = "##default";
        QName qName = null;
        if (this.helper.isAnnotationPresent(element, XmlAttribute.class)) {
            XmlAttribute xmlAttribute = (XmlAttribute)this.helper.getAnnotation(element, XmlAttribute.class);
            name = xmlAttribute.name();
            namespace = xmlAttribute.namespace();
            if (name.equals("##default")) {
                name = defaultName;
                try {
                    name = info.getXmlNameTransformer().transformAttributeName(name);
                }
                catch (Exception ex) {
                    throw JAXBException.exceptionDuringNameTransformation(name, info.getXmlNameTransformer().getClass().getName(), ex);
                }
            }
            if (!namespace.equals("##default")) {
                qName = new QName(namespace, name);
                this.isDefaultNamespaceAllowed = false;
            } else {
                qName = namespaceInfo.isAttributeFormQualified() ? new QName(uri, name) : new QName(name);
            }
        } else {
            if (this.helper.isAnnotationPresent(element, javax.xml.bind.annotation.XmlElement.class)) {
                javax.xml.bind.annotation.XmlElement xmlElement = (javax.xml.bind.annotation.XmlElement)this.helper.getAnnotation(element, javax.xml.bind.annotation.XmlElement.class);
                name = xmlElement.name();
                namespace = xmlElement.namespace();
            }
            if (name.equals("##default")) {
                name = defaultName;
                try {
                    name = info.getXmlNameTransformer().transformElementName(name);
                }
                catch (Exception ex) {
                    throw JAXBException.exceptionDuringNameTransformation(name, info.getXmlNameTransformer().getClass().getName(), ex);
                }
            }
            if (!namespace.equals("##default")) {
                qName = new QName(namespace, name);
                if (namespace.equals(EMPTY_STRING)) {
                    this.isDefaultNamespaceAllowed = false;
                }
            } else {
                qName = namespaceInfo.isElementFormQualified() ? new QName(uri, name) : new QName(name);
            }
        }
        return qName;
    }

    public HashMap<String, PackageInfo> getPackageToPackageInfoMappings() {
        return this.packageToPackageInfoMappings;
    }

    public void addPackageToNamespaceMapping(String packageName, NamespaceInfo nsInfo) {
        PackageInfo info;
        if (this.packageToPackageInfoMappings == null) {
            this.packageToPackageInfoMappings = new HashMap();
        }
        if ((info = this.packageToPackageInfoMappings.get(packageName)) == null) {
            info = new PackageInfo();
            this.packageToPackageInfoMappings.put(packageName, info);
        }
        info.setNamespaceInfo(nsInfo);
    }

    public void addPackageToPackageInfoMapping(String packageName, PackageInfo packageInfo) {
        if (this.packageToPackageInfoMappings == null) {
            this.packageToPackageInfoMappings = new HashMap();
        }
        this.packageToPackageInfoMappings.put(packageName, packageInfo);
    }

    public PackageInfo getPackageInfoForPackage(JavaClass javaClass) {
        String packageName = javaClass.getPackageName();
        PackageInfo packageInfo = this.packageToPackageInfoMappings.get(packageName);
        if (packageInfo == null) {
            packageInfo = this.getPackageInfoForPackage(javaClass.getPackage(), packageName);
        }
        return packageInfo;
    }

    public PackageInfo getPackageInfoForPackage(JavaPackage pack, String packageName) {
        PackageInfo packageInfo = this.packageToPackageInfoMappings.get(packageName);
        if (packageInfo == null) {
            XmlSchema xmlSchema = (XmlSchema)this.helper.getAnnotation(pack, XmlSchema.class);
            packageInfo = new PackageInfo();
            NamespaceInfo namespaceInfo = null;
            if (xmlSchema != null) {
                namespaceInfo = this.findInfoForNamespace(xmlSchema.namespace());
            }
            if (namespaceInfo == null) {
                namespaceInfo = this.processNamespaceInformation(xmlSchema);
            }
            packageInfo.setNamespaceInfo(namespaceInfo);
            if (namespaceInfo.getNamespace() == null) {
                namespaceInfo.setNamespace(EMPTY_STRING);
            }
            if (this.helper.isAnnotationPresent(pack, XmlAccessorType.class)) {
                XmlAccessorType xmlAccessorType = (XmlAccessorType)this.helper.getAnnotation(pack, XmlAccessorType.class);
                packageInfo.setAccessType(XmlAccessType.fromValue(xmlAccessorType.value().name()));
            }
            if (this.helper.isAnnotationPresent(pack, XmlAccessorOrder.class)) {
                XmlAccessorOrder xmlAccessorOrder = (XmlAccessorOrder)this.helper.getAnnotation(pack, XmlAccessorOrder.class);
                packageInfo.setAccessOrder(XmlAccessOrder.fromValue(xmlAccessorOrder.value().name()));
            }
            this.packageToPackageInfoMappings.put(packageName, packageInfo);
        }
        return packageInfo;
    }

    public NamespaceInfo findInfoForNamespace(String namespace) {
        for (PackageInfo next : this.packageToPackageInfoMappings.values()) {
            String nextUri = next.getNamespace();
            if (nextUri == null) {
                nextUri = EMPTY_STRING;
            }
            if (namespace == null) {
                namespace = EMPTY_STRING;
            }
            if (!nextUri.equals(namespace)) continue;
            return next.getNamespaceInfo();
        }
        return null;
    }

    private void checkForCallbackMethods() {
        for (JavaClass next : this.typeInfoClasses) {
            if (next == null) continue;
            JavaClass unmarshallerCls = this.helper.getJavaClass(Unmarshaller.class);
            JavaClass marshallerCls = this.helper.getJavaClass(Marshaller.class);
            JavaClass objectCls = this.helper.getJavaClass(Object.class);
            JavaClass[] unmarshalParams = new JavaClass[]{unmarshallerCls, objectCls};
            JavaClass[] marshalParams = new JavaClass[]{marshallerCls};
            UnmarshalCallback unmarshalCallback = null;
            MarshalCallback marshalCallback = null;
            if (next.getMethod("beforeUnmarshal", unmarshalParams) != null) {
                unmarshalCallback = new UnmarshalCallback();
                unmarshalCallback.setDomainClassName(next.getQualifiedName());
                unmarshalCallback.setHasBeforeUnmarshalCallback();
            }
            if (next.getMethod("afterUnmarshal", unmarshalParams) != null) {
                if (unmarshalCallback == null) {
                    unmarshalCallback = new UnmarshalCallback();
                    unmarshalCallback.setDomainClassName(next.getQualifiedName());
                }
                unmarshalCallback.setHasAfterUnmarshalCallback();
            }
            if (unmarshalCallback != null) {
                if (this.unmarshalCallbacks == null) {
                    this.unmarshalCallbacks = new HashMap();
                }
                this.unmarshalCallbacks.put(next.getQualifiedName(), unmarshalCallback);
            }
            if (next.getMethod("beforeMarshal", marshalParams) != null) {
                marshalCallback = new MarshalCallback();
                marshalCallback.setDomainClassName(next.getQualifiedName());
                marshalCallback.setHasBeforeMarshalCallback();
            }
            if (next.getMethod("afterMarshal", marshalParams) != null) {
                if (marshalCallback == null) {
                    marshalCallback = new MarshalCallback();
                    marshalCallback.setDomainClassName(next.getQualifiedName());
                }
                marshalCallback.setHasAfterMarshalCallback();
            }
            if (marshalCallback == null) continue;
            if (this.marshalCallbacks == null) {
                this.marshalCallbacks = new HashMap();
            }
            this.marshalCallbacks.put(next.getQualifiedName(), marshalCallback);
        }
    }

    public HashMap<String, MarshalCallback> getMarshalCallbacks() {
        return this.marshalCallbacks;
    }

    public HashMap<String, UnmarshalCallback> getUnmarshalCallbacks() {
        return this.unmarshalCallbacks;
    }

    private void findAndProcessObjectFactory(JavaClass cls) {
        try {
            String className = String.valueOf(cls.getPackageName()) + ".ObjectFactory";
            this.findAndProcessObjectFactory(className);
        }
        catch (JAXBException jAXBException) {}
    }

    void findAndProcessObjectFactory(String objectFactoryClassName) {
        try {
            if (this.objectFactoryClassNames.contains(objectFactoryClassName)) {
                return;
            }
            JavaClass javaClass = this.helper.getJavaClass(objectFactoryClassName);
            if (this.isXmlRegistry(javaClass)) {
                JavaClass[] processed = this.processObjectFactory(javaClass, new ArrayList<JavaClass>());
                this.preBuildTypeInfo(processed);
                this.buildTypeInfo(processed);
                this.updateGlobalElements(processed);
            }
        }
        catch (JAXBException jAXBException) {}
    }

    public JavaClass[] processObjectFactory(JavaClass objectFactoryClass, ArrayList<JavaClass> classes) {
        String className = objectFactoryClass.getName();
        if (this.objectFactoryClassNames.contains(className)) {
            return new JavaClass[0];
        }
        this.objectFactoryClassNames.add(className);
        HashMap<String, XmlRegistry.XmlElementDecl> elemDecls = new HashMap<String, XmlRegistry.XmlElementDecl>();
        org.eclipse.persistence.jaxb.xmlmodel.XmlRegistry xmlReg = this.xmlRegistries.get(objectFactoryClass.getQualifiedName());
        if (xmlReg != null) {
            for (XmlRegistry.XmlElementDecl xmlElementDecl : xmlReg.getXmlElementDecl()) {
                elemDecls.put(xmlElementDecl.getJavaMethod(), xmlElementDecl);
            }
        }
        Collection methods = objectFactoryClass.getDeclaredMethods();
        Iterator methodsIter = methods.iterator();
        PackageInfo packageInfo = this.getPackageInfoForPackage(objectFactoryClass);
        while (methodsIter.hasNext()) {
            JavaMethod next = (JavaMethod)methodsIter.next();
            if (!next.getName().startsWith(CREATE)) continue;
            JavaClass type = next.getReturnType();
            if (JAVAX_XML_BIND_JAXBELEMENT.equals(type.getName())) {
                Object[] actutalTypeArguments = next.getReturnType().getActualTypeArguments().toArray();
                type = actutalTypeArguments.length == 0 ? this.helper.getJavaClass(Object.class) : (JavaClass)next.getReturnType().getActualTypeArguments().toArray()[0];
            } else {
                this.factoryMethods.put(next.getReturnType().getRawName(), next);
            }
            XmlRegistry.XmlElementDecl xmlEltDecl = (XmlRegistry.XmlElementDecl)elemDecls.get(next.getName());
            if (xmlEltDecl != null || this.helper.isAnnotationPresent(next, XmlElementDecl.class)) {
                HashMap<QName, ElementDeclaration> elements;
                QName qname;
                String subHeadNamespace;
                String subHeadLocal;
                String localName;
                String url;
                QName substitutionHead = null;
                String defaultValue = null;
                Class<XmlElementDecl.GLOBAL> scopeClass = XmlElementDecl.GLOBAL.class;
                if (xmlEltDecl != null) {
                    JavaClass jScopeClass;
                    url = xmlEltDecl.getNamespace();
                    localName = xmlEltDecl.getName();
                    String scopeClassName = xmlEltDecl.getScope();
                    if (!scopeClassName.equals(ELEMENT_DECL_GLOBAL) && (jScopeClass = this.helper.getJavaClass(scopeClassName)) != null && (scopeClass = this.helper.getClassForJavaClass(jScopeClass)) == null) {
                        scopeClass = XmlElementDecl.GLOBAL.class;
                    }
                    if (!xmlEltDecl.getSubstitutionHeadName().equals(EMPTY_STRING)) {
                        subHeadLocal = xmlEltDecl.getSubstitutionHeadName();
                        subHeadNamespace = xmlEltDecl.getSubstitutionHeadNamespace();
                        if (subHeadNamespace.equals("##default")) {
                            subHeadNamespace = packageInfo.getNamespace();
                        }
                        substitutionHead = new QName(subHeadNamespace, subHeadLocal);
                    }
                    if (xmlEltDecl.getDefaultValue().length() != 1 || !xmlEltDecl.getDefaultValue().startsWith(ELEMENT_DECL_DEFAULT)) {
                        defaultValue = xmlEltDecl.getDefaultValue();
                    }
                } else {
                    XmlElementDecl elementDecl = (XmlElementDecl)this.helper.getAnnotation(next, XmlElementDecl.class);
                    url = elementDecl.namespace();
                    localName = elementDecl.name();
                    scopeClass = elementDecl.scope();
                    if (!elementDecl.substitutionHeadName().equals(EMPTY_STRING)) {
                        subHeadLocal = elementDecl.substitutionHeadName();
                        subHeadNamespace = elementDecl.substitutionHeadNamespace();
                        if (subHeadNamespace.equals("##default")) {
                            subHeadNamespace = packageInfo.getNamespace();
                        }
                        substitutionHead = new QName(subHeadNamespace, subHeadLocal);
                    }
                    if (elementDecl.defaultValue().length() != 1 || !elementDecl.defaultValue().startsWith(ELEMENT_DECL_DEFAULT)) {
                        defaultValue = elementDecl.defaultValue();
                    }
                }
                if ("##default".equals(url)) {
                    url = packageInfo.getNamespace();
                }
                if (EMPTY_STRING.equals(url)) {
                    this.isDefaultNamespaceAllowed = false;
                    qname = new QName(localName);
                } else {
                    qname = new QName(url, localName);
                }
                boolean isList = false;
                if (JAVA_UTIL_LIST.equals(type.getName())) {
                    isList = true;
                    if (type.hasActualTypeArguments()) {
                        type = (JavaClass)type.getActualTypeArguments().toArray()[0];
                    }
                }
                ElementDeclaration declaration = new ElementDeclaration(qname, type, type.getQualifiedName(), isList, scopeClass);
                if (substitutionHead != null) {
                    declaration.setSubstitutionHead(substitutionHead);
                }
                if (defaultValue != null) {
                    declaration.setDefaultValue(defaultValue);
                }
                if (this.helper.isAnnotationPresent(next, javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter.class)) {
                    javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter typeAdapter = (javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter)this.helper.getAnnotation(next, javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter.class);
                    Class typeAdapterClass = typeAdapter.value();
                    declaration.setJavaTypeAdapterClass(typeAdapterClass);
                    Class declJavaType = CompilerHelper.getTypeFromAdapterClass(typeAdapterClass);
                    declaration.setJavaType(this.helper.getJavaClass(declJavaType));
                    declaration.setAdaptedJavaType(type);
                }
                if ((elements = this.getElementDeclarationsForScope(scopeClass.getName())) == null) {
                    elements = new HashMap();
                    this.elementDeclarations.put(scopeClass.getName(), elements);
                }
                elements.put(qname, declaration);
            }
            if (this.helper.isBuiltInJavaType(type) || this.helper.classExistsInArray(type, classes)) continue;
            classes.add(type);
        }
        if (classes.size() > 0) {
            this.classesToProcessPropertyTypes.addAll(classes);
            return classes.toArray(new JavaClass[classes.size()]);
        }
        return new JavaClass[0];
    }

    public HashMap<QName, ElementDeclaration> getGlobalElements() {
        return this.elementDeclarations.get(XmlElementDecl.GLOBAL.class.getName());
    }

    public void updateGlobalElements(JavaClass[] classesToProcess) {
        JavaClass[] javaClassArray = classesToProcess;
        int n = classesToProcess.length;
        int n2 = 0;
        while (n2 < n) {
            JavaClass javaClass = javaClassArray[n2];
            TypeInfo info = this.typeInfo.get(javaClass.getQualifiedName());
            if (info != null && !info.isTransient() && info.isSetXmlRootElement()) {
                org.eclipse.persistence.jaxb.xmlmodel.XmlRootElement xmlRE = info.getXmlRootElement();
                NamespaceInfo namespaceInfo = this.getPackageInfoForPackage(javaClass).getNamespaceInfo();
                String elementName = xmlRE.getName();
                if (elementName.equals("##default") || elementName.equals(EMPTY_STRING)) {
                    XMLNameTransformer transformer = info.getXmlNameTransformer();
                    try {
                        elementName = transformer.transformRootElementName(javaClass.getName());
                    }
                    catch (Exception ex) {
                        throw JAXBException.exceptionDuringNameTransformation(javaClass.getName(), info.getXmlNameTransformer().getClass().getName(), ex);
                    }
                }
                String rootNamespace = xmlRE.getNamespace();
                QName rootElemName = null;
                if (rootNamespace.equals("##default")) {
                    if (namespaceInfo == null) {
                        rootElemName = new QName(elementName);
                    } else {
                        String rootNS = namespaceInfo.getNamespace();
                        rootElemName = new QName(rootNS, elementName);
                        if (rootNS.equals(EMPTY_STRING)) {
                            this.isDefaultNamespaceAllowed = false;
                        }
                    }
                } else {
                    rootElemName = new QName(rootNamespace, elementName);
                    if (rootNamespace.equals(EMPTY_STRING)) {
                        this.isDefaultNamespaceAllowed = false;
                    }
                }
                ElementDeclaration declaration = new ElementDeclaration(rootElemName, javaClass, javaClass.getQualifiedName(), false);
                declaration.setIsXmlRootElement(true);
                this.addGlobalElement(rootElemName, declaration);
                this.xmlRootElements.put(javaClass.getQualifiedName(), declaration);
            }
            ++n2;
        }
        for (QName next : this.getGlobalElements().keySet()) {
            ElementDeclaration nextDeclaration = this.getGlobalElements().get(next);
            QName substitutionHead = nextDeclaration.getSubstitutionHead();
            while (substitutionHead != null) {
                ElementDeclaration rootDeclaration = this.getGlobalElements().get(substitutionHead);
                rootDeclaration.addSubstitutableElement(nextDeclaration);
                substitutionHead = rootDeclaration.getSubstitutionHead() != null && rootDeclaration.getSubstitutionHead().equals(substitutionHead) ? null : rootDeclaration.getSubstitutionHead();
            }
        }
    }

    private void addReferencedElement(Property property, ElementDeclaration referencedElement) {
        property.addReferencedElement(referencedElement);
        if (referencedElement.getSubstitutableElements() != null && referencedElement.getSubstitutableElements().size() > 0) {
            for (ElementDeclaration substitutable : referencedElement.getSubstitutableElements()) {
                this.addReferencedElement(property, substitutable);
            }
        }
    }

    private boolean hasJAXBAnnotations(JavaHasAnnotations elem) {
        return this.helper.isAnnotationPresent(elem, XmlAttachmentRef.class) || this.helper.isAnnotationPresent(elem, XmlLocation.class) || this.helper.isAnnotationPresent(elem, javax.xml.bind.annotation.XmlElement.class) || this.helper.isAnnotationPresent(elem, XmlAttribute.class) || this.helper.isAnnotationPresent(elem, XmlAnyElement.class) || this.helper.isAnnotationPresent(elem, XmlAnyAttribute.class) || this.helper.isAnnotationPresent(elem, XmlValue.class) || this.helper.isAnnotationPresent(elem, XmlElements.class) || this.helper.isAnnotationPresent(elem, XmlElementRef.class) || this.helper.isAnnotationPresent(elem, XmlElementRefs.class) || this.helper.isAnnotationPresent(elem, XmlID.class) || this.helper.isAnnotationPresent(elem, XmlInlineBinaryData.class) || this.helper.isAnnotationPresent(elem, XmlSchemaType.class) || this.helper.isAnnotationPresent(elem, XmlElementWrapper.class) || this.helper.isAnnotationPresent(elem, XmlList.class) || this.helper.isAnnotationPresent(elem, XmlMimeType.class) || this.helper.isAnnotationPresent(elem, XmlIDREF.class) || this.helper.isAnnotationPresent(elem, XmlTransient.class) || this.helper.isAnnotationPresent(elem, XmlPath.class) || this.helper.isAnnotationPresent(elem, XmlPaths.class) || this.helper.isAnnotationPresent(elem, XmlInverseReference.class) || this.helper.isAnnotationPresent(elem, XmlJoinNode.class) || this.helper.isAnnotationPresent(elem, XmlJoinNodes.class) || this.helper.isAnnotationPresent(elem, XmlReadOnly.class) || this.helper.isAnnotationPresent(elem, XmlWriteOnly.class) || this.helper.isAnnotationPresent(elem, XmlCDATA.class) || this.helper.isAnnotationPresent(elem, XmlAccessMethods.class) || this.helper.isAnnotationPresent(elem, XmlNullPolicy.class) || this.helper.isAnnotationPresent(elem, javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter.class) || this.helper.isAnnotationPresent(elem, XmlMixed.class);
    }

    private void validateElementIsInPropOrder(TypeInfo info, String name) {
        if (info.isTransient()) {
            return;
        }
        String[] propOrder = info.getPropOrder();
        if (propOrder.length > 0) {
            if (propOrder.length == 1 && propOrder[0].equals(EMPTY_STRING)) {
                return;
            }
            List<String> propOrderList = Arrays.asList(info.getPropOrder());
            if (!propOrderList.contains(name)) {
                throw JAXBException.missingPropertyInPropOrder(name);
            }
        }
    }

    private void validatePropOrderForInfo(TypeInfo info) {
        if (info.isTransient()) {
            return;
        }
        if (info.getXmlVirtualAccessMethods() != null) {
            return;
        }
        String[] propOrder = info.getPropOrder();
        int propOrderLength = propOrder.length;
        if (propOrderLength > 0) {
            int i = 1;
            while (i < propOrderLength) {
                String nextPropName = propOrder[i];
                if (!nextPropName.equals(EMPTY_STRING) && !info.getPropertyNames().contains(nextPropName)) {
                    throw JAXBException.nonExistentPropertyInPropOrder(nextPropName);
                }
                ++i;
            }
        }
    }

    private void validateXmlValueFieldOrProperty(JavaClass cls, Property property) {
        JavaClass ptype = property.getActualType();
        String propName = property.getPropertyName();
        JavaClass parent = cls.getSuperclass();
        while (parent != null && !parent.getQualifiedName().equals(JAVA_LANG_OBJECT)) {
            TypeInfo parentTypeInfo = this.typeInfo.get(parent.getQualifiedName());
            if (this.hasElementMappedProperties(parentTypeInfo)) {
                throw JAXBException.propertyOrFieldCannotBeXmlValue(propName);
            }
            parent = parent.getSuperclass();
        }
        QName schemaQName = this.getSchemaTypeOrNullFor(ptype);
        if (schemaQName == null) {
            TypeInfo refInfo = this.typeInfo.get(ptype.getQualifiedName());
            if (refInfo != null) {
                if (!refInfo.isPostBuilt()) {
                    this.postBuildTypeInfo(new JavaClass[]{ptype});
                }
            } else if (this.shouldGenerateTypeInfo(ptype)) {
                JavaClass[] jClasses = new JavaClass[]{ptype};
                this.buildNewTypeInfo(jClasses);
                refInfo = this.typeInfo.get(ptype.getQualifiedName());
            }
            if (refInfo != null && !refInfo.isEnumerationType() && refInfo.getXmlValueProperty() == null) {
                throw JAXBException.invalidTypeForXmlValueField(propName);
            }
        }
    }

    private boolean hasElementMappedProperties(TypeInfo typeInfo) {
        for (Property property : typeInfo.getPropertyList()) {
            if (property.isTransient() || property.isAttribute() || property.isAnyAttribute()) continue;
            return true;
        }
        return false;
    }

    public boolean isMapType(JavaClass type) {
        return this.helper.getJavaClass(Map.class).isAssignableFrom(type);
    }

    private Class generateWrapperForMapClass(JavaClass mapClass, JavaClass keyClass, JavaClass valueClass, TypeMappingInfo typeMappingInfo) {
        AnnotationVisitor av;
        Annotation[] annotations;
        PackageInfo packageInfo;
        String namespace;
        Vector namespaces;
        String packageName = JAXB_DEV;
        NamespaceResolver combinedNamespaceResolver = new NamespaceResolver();
        if (!this.helper.isBuiltInJavaType(keyClass)) {
            String keyPackageName = keyClass.getPackageName();
            packageName = String.valueOf(packageName) + DOT_CHR + keyPackageName;
            NamespaceInfo keyNamespaceInfo = this.getPackageInfoForPackage(keyClass).getNamespaceInfo();
            if (keyNamespaceInfo != null) {
                namespaces = keyNamespaceInfo.getNamespaceResolver().getNamespaces();
                for (Namespace n : namespaces) {
                    combinedNamespaceResolver.put(n.getPrefix(), n.getNamespaceURI());
                }
            }
        }
        if (!this.helper.isBuiltInJavaType(valueClass)) {
            String valuePackageName = valueClass.getPackageName();
            packageName = String.valueOf(packageName) + DOT_CHR + valuePackageName;
            NamespaceInfo valueNamespaceInfo = this.getPackageInfoForPackage(valueClass).getNamespaceInfo();
            if (valueNamespaceInfo != null) {
                namespaces = valueNamespaceInfo.getNamespaceResolver().getNamespaces();
                for (Namespace n : namespaces) {
                    combinedNamespaceResolver.put(n.getPrefix(), n.getNamespaceURI());
                }
            }
        }
        if ((namespace = this.defaultTargetNamespace) == null) {
            namespace = EMPTY_STRING;
        }
        if ((packageInfo = this.packageToPackageInfoMappings.get(mapClass.getPackageName())) == null) {
            packageInfo = this.getPackageToPackageInfoMappings().get(packageName);
        } else {
            if (packageInfo.getNamespace() != null) {
                namespace = packageInfo.getNamespace();
            }
            this.getPackageToPackageInfoMappings().put(packageName, packageInfo);
        }
        if (packageInfo == null) {
            packageInfo = new PackageInfo();
            packageInfo.setNamespaceInfo(new NamespaceInfo());
            packageInfo.setNamespace(namespace);
            packageInfo.setNamespaceResolver(combinedNamespaceResolver);
            this.getPackageToPackageInfoMappings().put(packageName, packageInfo);
        }
        int beginIndex = keyClass.getName().lastIndexOf(DOT_CHR.charValue()) + 1;
        String keyName = keyClass.getName().substring(beginIndex);
        int dollarIndex = keyName.indexOf(DOLLAR_SIGN_CHR.charValue());
        if (dollarIndex > -1) {
            keyName = keyName.substring(dollarIndex + 1);
        }
        beginIndex = valueClass.getName().lastIndexOf(DOT_CHR.charValue()) + 1;
        String valueName = valueClass.getName().substring(beginIndex);
        dollarIndex = valueName.indexOf(DOLLAR_SIGN_CHR.charValue());
        if (dollarIndex > -1) {
            valueName = valueName.substring(dollarIndex + 1);
        }
        String collectionClassShortName = mapClass.getRawName().substring(mapClass.getRawName().lastIndexOf(DOT_CHR.charValue()) + 1);
        String suggestedClassName = String.valueOf(keyName) + valueName + collectionClassShortName;
        String qualifiedClassName = String.valueOf(packageName) + DOT_CHR + suggestedClassName;
        qualifiedClassName = this.getNextAvailableClassName(qualifiedClassName);
        String qualifiedInternalClassName = qualifiedClassName.replace(DOT_CHR.charValue(), SLASH_CHR.charValue());
        String internalKeyName = keyClass.getQualifiedName().replace(DOT_CHR.charValue(), SLASH_CHR.charValue());
        String internalValueName = valueClass.getQualifiedName().replace(DOT_CHR.charValue(), SLASH_CHR.charValue());
        org.eclipse.persistence.internal.libraries.asm.Type mapType = org.eclipse.persistence.internal.libraries.asm.Type.getType(L + mapClass.getRawName().replace(DOT_CHR.charValue(), SLASH_CHR.charValue()) + SEMI_COLON);
        ClassWriter cw = new ClassWriter(2);
        String sig = "Lorg/eclipse/persistence/internal/jaxb/many/MapValue<L" + mapType.getInternalName() + "<L" + internalKeyName + ";L" + internalValueName + ";>;>;";
        cw.visit(49, 33, qualifiedInternalClassName, sig, "org/eclipse/persistence/internal/jaxb/many/MapValue", null);
        String fieldSig = L + mapType.getInternalName() + "<L" + internalKeyName + ";L" + internalValueName + ";>;";
        FieldVisitor fv = cw.visitField(1, "entry", L + mapType.getInternalName() + SEMI_COLON, fieldSig, null);
        if (typeMappingInfo != null && (annotations = typeMappingInfo.getAnnotations()) != null) {
            int i = 0;
            while (i < annotations.length) {
                Annotation nextAnnotation = annotations[i];
                if (nextAnnotation != null && !(nextAnnotation instanceof javax.xml.bind.annotation.XmlElement) && !(nextAnnotation instanceof javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter)) {
                    String annotationClassName = nextAnnotation.annotationType().getName();
                    av = fv.visitAnnotation(L + annotationClassName.replace(DOT_CHR.charValue(), SLASH_CHR.charValue()) + SEMI_COLON, true);
                    Method[] methodArray = nextAnnotation.annotationType().getDeclaredMethods();
                    int n = methodArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Method next = methodArray[n2];
                        try {
                            Object nextValue = next.invoke((Object)nextAnnotation, new Object[0]);
                            if (nextValue instanceof Class) {
                                org.eclipse.persistence.internal.libraries.asm.Type nextType = org.eclipse.persistence.internal.libraries.asm.Type.getType(L + ((Class)nextValue).getName().replace(DOT_CHR.charValue(), SLASH_CHR.charValue()) + SEMI_COLON);
                                nextValue = nextType;
                            }
                            av.visit(next.getName(), nextValue);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                        }
                        catch (IllegalAccessException illegalAccessException) {}
                        ++n2;
                    }
                    av.visitEnd();
                }
                ++i;
            }
        }
        fv.visitEnd();
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "org/eclipse/persistence/internal/jaxb/many/MapValue", "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        String methodSig = "(L" + mapType.getInternalName() + "<L" + internalKeyName + ";L" + internalValueName + ";>;)V";
        mv = cw.visitMethod(1, "setItem", "(L" + mapType.getInternalName() + ";)V", methodSig, null);
        mv.visitAnnotation("Ljavax/xml/bind/annotation/XmlTransient;", true);
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, qualifiedInternalClassName, "entry", L + mapType.getInternalName() + SEMI_COLON);
        mv.visitInsn(177);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        methodSig = "()L" + mapType.getInternalName() + "<L" + internalKeyName + ";L" + internalValueName + ";>;";
        mv = cw.visitMethod(1, "getItem", "()L" + mapType.getInternalName() + SEMI_COLON, methodSig, null);
        mv.visitAnnotation("Ljavax/xml/bind/annotation/XmlTransient;", true);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, qualifiedInternalClassName, "entry", L + mapType.getInternalName() + SEMI_COLON);
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(4161, "getItem", "()Ljava/lang/Object;", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, qualifiedInternalClassName, "getItem", "()L" + mapType.getInternalName() + SEMI_COLON);
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(4161, "setItem", "(Ljava/lang/Object;)V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, mapType.getInternalName());
        mv.visitMethodInsn(182, qualifiedInternalClassName, "setItem", "(L" + mapType.getInternalName() + ";)V");
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        av = cw.visitAnnotation("Ljavax/xml/bind/annotation/XmlType;", true);
        av.visit("namespace", namespace);
        cw.visitEnd();
        byte[] classBytes = cw.toByteArray();
        return this.generateClassFromBytes(qualifiedClassName, classBytes);
    }

    private Class generateWrapperForArrayClass(JavaClass arrayClass, TypeMappingInfo typeMappingInfo, Class xmlElementType, List<JavaClass> classesToProcess) {
        JavaClass componentClass = null;
        componentClass = typeMappingInfo != null && xmlElementType != null ? this.helper.getJavaClass(xmlElementType) : arrayClass.getComponentType();
        if (componentClass.isArray()) {
            Class nestedArrayClass = this.arrayClassesToGeneratedClasses.get(componentClass.getName());
            if (nestedArrayClass == null) {
                nestedArrayClass = this.generateWrapperForArrayClass(componentClass, typeMappingInfo, xmlElementType, classesToProcess);
                this.arrayClassesToGeneratedClasses.put(componentClass.getName(), nestedArrayClass);
                classesToProcess.add(this.helper.getJavaClass(nestedArrayClass));
            }
            return this.generateArrayValue(arrayClass, componentClass, this.helper.getJavaClass(nestedArrayClass), typeMappingInfo);
        }
        return this.generateArrayValue(arrayClass, componentClass, componentClass, typeMappingInfo);
    }

    private Class generateArrayValue(JavaClass arrayClass, JavaClass componentClass, JavaClass nestedClass, TypeMappingInfo typeMappingInfo) {
        AnnotationVisitor av;
        Annotation[] annotations;
        String qualifiedClassName;
        String packageName;
        QName qName = null;
        if (componentClass.isArray()) {
            packageName = componentClass.getPackageName();
            qualifiedClassName = String.valueOf(nestedClass.getQualifiedName()) + ARRAY_CLASS_NAME_SUFFIX;
        } else {
            PackageInfo namespaceInfo;
            if (componentClass.isPrimitive()) {
                packageName = ARRAY_PACKAGE_NAME;
                qualifiedClassName = String.valueOf(packageName) + DOT_CHR + componentClass.getName() + ARRAY_CLASS_NAME_SUFFIX;
            } else {
                packageName = ARRAY_PACKAGE_NAME + DOT_CHR + componentClass.getPackageName();
                if (componentClass.isMemberClass()) {
                    qualifiedClassName = componentClass.getName();
                    qualifiedClassName = qualifiedClassName.substring(qualifiedClassName.indexOf(DOLLAR_SIGN_CHR.charValue()) + 1);
                    qualifiedClassName = ARRAY_PACKAGE_NAME + DOT_CHR + componentClass.getPackageName() + DOT_CHR + qualifiedClassName + ARRAY_CLASS_NAME_SUFFIX;
                } else {
                    qualifiedClassName = ARRAY_PACKAGE_NAME + DOT_CHR + componentClass.getQualifiedName() + ARRAY_CLASS_NAME_SUFFIX;
                }
            }
            if (componentClass.isPrimitive() || this.helper.isBuiltInJavaType(componentClass)) {
                qName = (QName)this.helper.getXMLToJavaTypeMap().get(componentClass.getQualifiedName());
                if (qName != null) {
                    packageName = ARRAY_PACKAGE_NAME;
                    qualifiedClassName = ARRAY_PACKAGE_NAME + DOT_CHR + qName.getLocalPart() + ARRAY_CLASS_NAME_SUFFIX;
                }
                if ((namespaceInfo = this.getPackageToPackageInfoMappings().get(packageName)) == null) {
                    namespaceInfo = new PackageInfo();
                    namespaceInfo.setNamespaceInfo(new NamespaceInfo());
                    namespaceInfo.setNamespace(ARRAY_NAMESPACE);
                    namespaceInfo.setNamespaceResolver(new NamespaceResolver());
                    this.getPackageToPackageInfoMappings().put(packageName, namespaceInfo);
                }
            } else {
                namespaceInfo = this.getPackageInfoForPackage(componentClass.getPackage(), componentClass.getPackageName());
                this.getPackageToPackageInfoMappings().put(packageName, namespaceInfo);
            }
        }
        String qualifiedInternalClassName = qualifiedClassName.replace(DOT_CHR.charValue(), SLASH_CHR.charValue());
        String superClassName = componentClass.isArray() ? "org/eclipse/persistence/internal/jaxb/many/MultiDimensionalArrayValue" : "org/eclipse/persistence/internal/jaxb/many/ArrayValue";
        ClassWriter cw = new ClassWriter(2);
        cw.visit(49, 33, qualifiedInternalClassName, null, superClassName, null);
        if (qualifiedClassName.startsWith(ARRAY_PACKAGE_NAME) && qualifiedClassName.contains("QName")) {
            AnnotationVisitor xmlTypeAV = cw.visitAnnotation("Ljavax/xml/bind/annotation/XmlType;", true);
            xmlTypeAV.visit("name", qualifiedClassName.substring(qualifiedClassName.lastIndexOf(DOT_CHR.charValue()) + 1));
            xmlTypeAV.visitEnd();
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, superClassName, "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        if (componentClass.isArray()) {
            mv = cw.visitMethod(4, "adaptedClass", "()Ljava/lang/Class;", null, null);
            mv.visitLdcInsn(org.eclipse.persistence.internal.libraries.asm.Type.getType(L + nestedClass.getQualifiedName().replace(DOT_CHR.charValue(), SLASH_CHR.charValue()) + SEMI_COLON));
            mv.visitInsn(176);
            mv.visitMaxs(1, 1);
        }
        mv = cw.visitMethod(4, "componentClass", "()Ljava/lang/Class;", null, null);
        JavaClass baseComponentClass = this.getBaseComponentType(componentClass);
        if (baseComponentClass.isPrimitive()) {
            mv.visitFieldInsn(178, this.getObjectType(baseComponentClass).getQualifiedName().replace(DOT_CHR.charValue(), SLASH_CHR.charValue()), "TYPE", "Ljava/lang/Class;");
        } else {
            mv.visitLdcInsn(org.eclipse.persistence.internal.libraries.asm.Type.getType(L + baseComponentClass.getQualifiedName().replace(DOT_CHR.charValue(), SLASH_CHR.charValue()) + SEMI_COLON));
        }
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getAdaptedValue", "()Ljava/util/List;", "()Ljava/util/List<" + org.eclipse.persistence.internal.libraries.asm.Type.getType(L + this.getObjectType(nestedClass).getName().replace(DOT_CHR.charValue(), SLASH_CHR.charValue()) + SEMI_COLON) + ">;", null);
        boolean hasXmlList = false;
        if (typeMappingInfo != null && (annotations = this.getAnnotations(typeMappingInfo)) != null) {
            Annotation[] annotationArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (annotationType.equals(XmlList.class)) {
                    hasXmlList = true;
                }
                av = mv.visitAnnotation(L + annotationType.getName().replace(DOT_CHR.charValue(), SLASH_CHR.charValue()) + SEMI_COLON, true);
                Method[] methodArray = annotation.annotationType().getDeclaredMethods();
                int n3 = methodArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Method next = methodArray[n4];
                    try {
                        Object nextValue = next.invoke((Object)annotation, new Object[0]);
                        if (nextValue instanceof Class) {
                            nextValue = org.eclipse.persistence.internal.libraries.asm.Type.getType(L + ((Class)nextValue).getName().replace(DOT_CHR.charValue(), SLASH_CHR.charValue()) + SEMI_COLON);
                        }
                        av.visit(next.getName(), nextValue);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                    ++n4;
                }
                av.visitEnd();
                ++n2;
            }
        }
        if (hasXmlList) {
            av = mv.visitAnnotation("Ljavax/xml/bind/annotation/XmlValue;", true);
            av.visitEnd();
        } else {
            av = mv.visitAnnotation("Ljavax/xml/bind/annotation/XmlElement;", true);
            av.visit("name", ITEM);
            av.visit("nillable", true);
            av.visitEnd();
        }
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, qualifiedInternalClassName, "adaptedValue", "Ljava/util/List;");
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        try {
            return this.generateClassFromBytes(qualifiedClassName, cw.toByteArray());
        }
        catch (LinkageError e) {
            if (qName != null) {
                throw JAXBException.nameCollision(qName.getNamespaceURI(), qName.getLocalPart());
            }
            throw e;
        }
    }

    private JavaClass getBaseComponentType(JavaClass javaClass) {
        JavaClass componentType = javaClass.getComponentType();
        if (componentType == null) {
            return javaClass;
        }
        if (!componentType.isArray()) {
            return componentType;
        }
        return this.getBaseComponentType(componentType);
    }

    private JavaClass getObjectType(JavaClass javaClass) {
        if (javaClass.isPrimitive()) {
            String primitiveClassName = javaClass.getRawName();
            Class primitiveClass = this.getPrimitiveClass(primitiveClassName);
            return this.helper.getJavaClass(this.getObjectClass(primitiveClass));
        }
        return javaClass;
    }

    private Class generateCollectionValue(JavaClass collectionClass, TypeMappingInfo typeMappingInfo, Class xmlElementType) {
        AnnotationVisitor av;
        Annotation[] annotations;
        JavaClass componentClass = typeMappingInfo != null && xmlElementType != null ? this.helper.getJavaClass(xmlElementType) : (collectionClass.hasActualTypeArguments() ? (JavaClass)collectionClass.getActualTypeArguments().toArray()[0] : this.helper.getJavaClass(Object.class));
        if (componentClass.isPrimitive()) {
            Class primitiveClass = this.getPrimitiveClass(componentClass.getRawName());
            componentClass = this.helper.getJavaClass(this.getObjectClass(primitiveClass));
        }
        PackageInfo packageInfo = this.packageToPackageInfoMappings.get(collectionClass.getPackageName());
        String namespace = EMPTY_STRING;
        if (this.defaultTargetNamespace != null) {
            namespace = this.defaultTargetNamespace;
        }
        PackageInfo componentNamespaceInfo = this.getPackageInfoForPackage(componentClass);
        String packageName = componentClass.getPackageName();
        packageName = "jaxb.dev.java.net." + packageName;
        if (packageInfo == null) {
            packageInfo = this.getPackageToPackageInfoMappings().get(packageName);
        } else {
            this.getPackageToPackageInfoMappings().put(packageName, packageInfo);
            if (packageInfo.getNamespace() != null) {
                namespace = packageInfo.getNamespace();
            }
        }
        if (packageInfo == null) {
            if (componentNamespaceInfo != null) {
                packageInfo = componentNamespaceInfo;
            } else {
                packageInfo = new PackageInfo();
                packageInfo.setNamespaceInfo(new NamespaceInfo());
                packageInfo.setNamespaceResolver(new NamespaceResolver());
            }
            this.getPackageToPackageInfoMappings().put(packageName, packageInfo);
        }
        String name = componentClass.getName();
        org.eclipse.persistence.internal.libraries.asm.Type componentType = org.eclipse.persistence.internal.libraries.asm.Type.getType(L + componentClass.getName().replace(DOT_CHR.charValue(), SLASH_CHR.charValue()) + SEMI_COLON);
        String componentTypeInternalName = null;
        if (name.equals("[B")) {
            name = "byteArray";
            componentTypeInternalName = componentType.getInternalName();
        } else if (name.equals("[Ljava.lang.Byte;")) {
            name = "ByteArray";
            componentTypeInternalName = String.valueOf(componentType.getInternalName()) + SEMI_COLON;
        } else {
            componentTypeInternalName = L + componentType.getInternalName() + SEMI_COLON;
        }
        int beginIndex = name.lastIndexOf(DOT_CHR.charValue()) + 1;
        name = name.substring(beginIndex);
        int dollarIndex = name.indexOf(DOLLAR_SIGN_CHR.charValue());
        if (dollarIndex > -1) {
            name = name.substring(dollarIndex + 1);
        }
        String collectionClassRawName = collectionClass.getRawName();
        String collectionClassShortName = collectionClassRawName.substring(collectionClassRawName.lastIndexOf(DOT_CHR.charValue()) + 1);
        String suggestedClassName = String.valueOf(collectionClassShortName) + "Of" + name;
        String qualifiedClassName = String.valueOf(packageName) + DOT_CHR + suggestedClassName;
        qualifiedClassName = this.getNextAvailableClassName(qualifiedClassName);
        org.eclipse.persistence.internal.libraries.asm.Type collectionType = org.eclipse.persistence.internal.libraries.asm.Type.getType(L + collectionClassRawName.replace(DOT_CHR.charValue(), SLASH_CHR.charValue()) + SEMI_COLON);
        String qualifiedInternalClassName = qualifiedClassName.replace(DOT_CHR.charValue(), SLASH_CHR.charValue());
        ClassWriter cw = new ClassWriter(2);
        String classSig = "Lorg/eclipse/persistence/internal/jaxb/many/CollectionValue<L" + collectionType.getInternalName() + "<" + componentTypeInternalName + ">;>;";
        cw.visit(49, 33, qualifiedInternalClassName, classSig, "org/eclipse/persistence/internal/jaxb/many/CollectionValue", null);
        String fieldSig = L + collectionType.getInternalName() + "<" + componentTypeInternalName + ">;";
        FieldVisitor fv = cw.visitField(1, ITEM, L + collectionType.getInternalName() + SEMI_COLON, fieldSig, null);
        if (typeMappingInfo != null && (annotations = this.getAnnotations(typeMappingInfo)) != null) {
            int i = 0;
            while (i < annotations.length) {
                Annotation nextAnnotation = annotations[i];
                if (nextAnnotation != null && !(nextAnnotation instanceof javax.xml.bind.annotation.XmlElement) && !(nextAnnotation instanceof javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter)) {
                    String annotationClassName = nextAnnotation.annotationType().getName();
                    av = fv.visitAnnotation(L + annotationClassName.replace(DOT_CHR.charValue(), SLASH_CHR.charValue()) + SEMI_COLON, true);
                    Method[] methodArray = nextAnnotation.annotationType().getDeclaredMethods();
                    int n = methodArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Method next = methodArray[n2];
                        try {
                            Object nextValue = next.invoke((Object)nextAnnotation, new Object[0]);
                            if (nextValue instanceof Class) {
                                org.eclipse.persistence.internal.libraries.asm.Type nextType = org.eclipse.persistence.internal.libraries.asm.Type.getType(L + ((Class)nextValue).getName().replace(DOT_CHR.charValue(), SLASH_CHR.charValue()) + SEMI_COLON);
                                nextValue = nextType;
                            }
                            av.visit(next.getName(), nextValue);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                        }
                        catch (IllegalAccessException illegalAccessException) {}
                        ++n2;
                    }
                }
                ++i;
            }
        }
        fv.visitEnd();
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "org/eclipse/persistence/internal/jaxb/many/CollectionValue", "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        String methodSig = "(L" + collectionType.getInternalName() + "<" + componentTypeInternalName + ">;)V";
        mv = cw.visitMethod(1, "setItem", "(L" + collectionType.getInternalName() + ";)V", methodSig, null);
        mv.visitAnnotation("Ljavax/xml/bind/annotation/XmlTransient;", true);
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, qualifiedInternalClassName, ITEM, L + collectionType.getInternalName() + SEMI_COLON);
        mv.visitInsn(177);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        methodSig = "()L" + collectionType.getInternalName() + "<" + componentTypeInternalName + ">;";
        mv = cw.visitMethod(1, "getItem", "()L" + collectionType.getInternalName() + SEMI_COLON, methodSig, null);
        mv.visitAnnotation("Ljavax/xml/bind/annotation/XmlTransient;", true);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, qualifiedInternalClassName, ITEM, L + collectionType.getInternalName() + SEMI_COLON);
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(4161, "getItem", "()Ljava/lang/Object;", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, qualifiedInternalClassName, "getItem", "()L" + collectionType.getInternalName() + SEMI_COLON);
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(4161, "setItem", "(Ljava/lang/Object;)V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, collectionType.getInternalName());
        mv.visitMethodInsn(182, qualifiedInternalClassName, "setItem", "(L" + collectionType.getInternalName() + ";)V");
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        av = cw.visitAnnotation("Ljavax/xml/bind/annotation/XmlType;", true);
        av.visit("namespace", namespace);
        cw.visitEnd();
        byte[] classBytes = cw.toByteArray();
        return this.generateClassFromBytes(qualifiedClassName, classBytes);
    }

    private Class generateClassFromBytes(String className, byte[] classBytes) {
        JaxbClassLoader loader = (JaxbClassLoader)this.helper.getClassLoader();
        Class generatedClass = loader.generateClass(className, classBytes);
        return generatedClass;
    }

    private String getNextAvailableClassName(String suggestedName) {
        int counter = 1;
        return this.getNextAvailableClassName(suggestedName, suggestedName, counter);
    }

    private String getNextAvailableClassName(String suggestedBaseName, String suggestedName, int counter) {
        for (Class nextClass : this.typeMappingInfoToGeneratedClasses.values()) {
            if (!nextClass.getName().equals(suggestedName)) continue;
            return this.getNextAvailableClassName(suggestedBaseName, String.valueOf(suggestedBaseName) + ++counter, counter);
        }
        return suggestedName;
    }

    private Class getPrimitiveClass(String primitiveClassName) {
        return ConversionManager.getDefaultManager().convertClassNameToClass(primitiveClassName);
    }

    private Class getObjectClass(Class primitiveClass) {
        ConversionManager.getDefaultManager();
        return ConversionManager.getObjectClass(primitiveClass);
    }

    public Map<Type, Class> getCollectionClassesToGeneratedClasses() {
        return this.collectionClassesToGeneratedClasses;
    }

    public Map<String, Class> getArrayClassesToGeneratedClasses() {
        return this.arrayClassesToGeneratedClasses;
    }

    public Map<Class, Type> getGeneratedClassesToCollectionClasses() {
        return this.generatedClassesToCollectionClasses;
    }

    public Map<Class, JavaClass> getGeneratedClassesToArrayClasses() {
        return this.generatedClassesToArrayClasses;
    }

    public Map<String, TypeInfo> getTypeInfosForPackage(String packageName) {
        HashMap<String, TypeInfo> typeInfos = new HashMap<String, TypeInfo>();
        ArrayList<JavaClass> jClasses = this.getTypeInfoClasses();
        for (JavaClass jClass : jClasses) {
            if (!jClass.getPackageName().equals(packageName)) continue;
            String key = jClass.getQualifiedName();
            typeInfos.put(key, this.typeInfo.get(key));
        }
        return typeInfos;
    }

    public void setPackageToNamespaceMappings(HashMap<String, NamespaceInfo> packageToNamespaceMappings) {
    }

    public void setPackageToPackageInfoMappings(HashMap<String, PackageInfo> packageToPackageInfoMappings) {
        this.packageToPackageInfoMappings = packageToPackageInfoMappings;
    }

    public SchemaTypeInfo addClass(JavaClass javaClass) {
        if (javaClass == null) {
            return null;
        }
        if (this.helper.isAnnotationPresent(javaClass, XmlTransient.class)) {
            return null;
        }
        if (this.typeInfo == null) {
            this.typeInfoClasses = new ArrayList();
            this.typeInfo = new HashMap();
            this.typeQNames = new ArrayList();
            this.userDefinedSchemaTypes = new HashMap();
            this.packageToPackageInfoMappings = new HashMap();
            this.namespaceResolver = new NamespaceResolver();
        }
        JavaClass[] jClasses = new JavaClass[]{javaClass};
        this.buildNewTypeInfo(jClasses);
        TypeInfo info = this.typeInfo.get(javaClass.getQualifiedName());
        String packageName = javaClass.getPackageName();
        PackageInfo packageInfo = this.packageToPackageInfoMappings.get(packageName);
        SchemaTypeInfo schemaInfo = new SchemaTypeInfo();
        schemaInfo.setSchemaTypeName(new QName(info.getClassNamespace(), info.getSchemaTypeName()));
        if (info.isSetXmlRootElement()) {
            org.eclipse.persistence.jaxb.xmlmodel.XmlRootElement xmlRE = info.getXmlRootElement();
            String elementName = xmlRE.getName();
            if (elementName.equals("##default") || elementName.equals(EMPTY_STRING)) {
                try {
                    elementName = info.getXmlNameTransformer().transformRootElementName(javaClass.getName());
                }
                catch (Exception ex) {
                    throw JAXBException.exceptionDuringNameTransformation(javaClass.getName(), info.getXmlNameTransformer().getClass().getName(), ex);
                }
            }
            String rootNamespace = xmlRE.getNamespace();
            QName rootElemName = null;
            rootElemName = rootNamespace.equals("##default") ? new QName(packageInfo.getNamespace(), elementName) : new QName(rootNamespace, elementName);
            schemaInfo.getGlobalElementDeclarations().add(rootElemName);
            ElementDeclaration declaration = new ElementDeclaration(rootElemName, javaClass, javaClass.getRawName(), false);
            this.addGlobalElement(rootElemName, declaration);
        }
        return schemaInfo;
    }

    public void buildNewTypeInfo(JavaClass[] javaClasses) {
        this.preBuildTypeInfo(javaClasses);
        this.postBuildTypeInfo(javaClasses);
        JavaClass[] javaClassArray = javaClasses;
        int n = javaClasses.length;
        int n2 = 0;
        while (n2 < n) {
            JavaClass next = javaClassArray[n2];
            this.processPropertyTypes(next);
            ++n2;
        }
    }

    private void preProcessCustomizer(JavaClass jClass, TypeInfo tInfo) {
        XmlCustomizer xmlCustomizer = (XmlCustomizer)this.helper.getAnnotation(jClass, XmlCustomizer.class);
        if (xmlCustomizer != null) {
            tInfo.setXmlCustomizer(xmlCustomizer.value().getName());
        }
    }

    private JAXBMetadataLogger getLogger() {
        if (this.logger == null) {
            this.logger = new JAXBMetadataLogger();
        }
        return this.logger;
    }

    Helper getHelper() {
        return this.helper;
    }

    public boolean isDefaultNamespaceAllowed() {
        return this.isDefaultNamespaceAllowed;
    }

    public List<ElementDeclaration> getLocalElements() {
        return this.localElements;
    }

    public Map<TypeMappingInfo, Class> getTypeMappingInfoToGeneratedClasses() {
        return this.typeMappingInfoToGeneratedClasses;
    }

    public Map<TypeMappingInfo, Class> getTypeMappingInfoToAdapterClasses() {
        return this.typeMappingInfoToAdapterClasses;
    }

    public void addXmlRegistry(String factoryClassName, org.eclipse.persistence.jaxb.xmlmodel.XmlRegistry xmlReg) {
        this.xmlRegistries.put(factoryClassName, xmlReg);
    }

    private boolean isXmlRegistry(JavaClass javaClass) {
        if (javaClass == null) {
            return false;
        }
        return this.helper.isAnnotationPresent(javaClass, XmlRegistry.class) || this.xmlRegistries.get(javaClass.getQualifiedName()) != null;
    }

    public Map<TypeMappingInfo, QName> getTypeMappingInfoToSchemaType() {
        return this.typeMappingInfoToSchemaType;
    }

    String getDefaultTargetNamespace() {
        return this.defaultTargetNamespace;
    }

    void setDefaultTargetNamespace(String defaultTargetNamespace) {
        this.defaultTargetNamespace = defaultTargetNamespace;
    }

    public void setDefaultNamespaceAllowed(boolean isDefaultNamespaceAllowed) {
        this.isDefaultNamespaceAllowed = isDefaultNamespaceAllowed;
    }

    HashMap<QName, ElementDeclaration> getElementDeclarationsForScope(String scopeClassName) {
        return this.elementDeclarations.get(scopeClassName);
    }

    private void addGlobalElement(QName key, ElementDeclaration declaration) {
        this.getGlobalElements().put(key, declaration);
        this.classesToProcessPropertyTypes.add(declaration.getJavaType());
    }

    private Map<Object, Object> createUserPropertiesMap(XmlProperty[] properties) {
        HashMap<Object, Object> propMap = new HashMap<Object, Object>();
        XmlProperty[] xmlPropertyArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            XmlProperty prop = xmlPropertyArray[n2];
            Object pvalue = prop.value();
            if (prop.valueType() != String.class) {
                pvalue = XMLConversionManager.getDefaultXMLManager().convertObject(prop.value(), prop.valueType());
            }
            propMap.put(prop.name(), pvalue);
            ++n2;
        }
        return propMap;
    }

    public boolean isMtomAttachment(Property property) {
        JavaClass ptype = property.getActualType();
        return this.areEquals(ptype, JAVAX_ACTIVATION_DATAHANDLER) || this.areEquals(ptype, byte[].class) || this.areEquals(ptype, Image.class) || this.areEquals(ptype, Source.class) || this.areEquals(ptype, JAVAX_MAIL_INTERNET_MIMEMULTIPART);
    }

    public boolean hasSwaRef() {
        return this.hasSwaRef;
    }

    public void setHasSwaRef(boolean swaRef) {
        this.hasSwaRef = swaRef;
    }

    public List getReferencedByTransformer() {
        return this.referencedByTransformer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PropertyComparitor
    implements Comparator<Property> {
        PropertyComparitor() {
        }

        @Override
        public int compare(Property p1, Property p2) {
            return p1.getPropertyName().compareTo(p2.getPropertyName());
        }
    }
}

