/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import org.eclipse.persistence.eis.mappings.EISOneToOneMapping;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.ObjectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotatedElement;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.mappings.ManyToOneMapping;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;

public class ManyToOneAccessor
extends ObjectAccessor {
    public ManyToOneAccessor() {
        super("<many-to-one>");
    }

    public ManyToOneAccessor(MetadataAnnotation manyToOne, MetadataAnnotatedElement annotatedElement, ClassAccessor classAccessor) {
        super(manyToOne, annotatedElement, classAccessor);
    }

    public boolean equals(Object objectToCompare) {
        return super.equals(objectToCompare) && objectToCompare instanceof ManyToOneAccessor;
    }

    protected String getLoggingContext() {
        return "metadata_default_many_to_one_reference_class";
    }

    public boolean isManyToOne() {
        return true;
    }

    public boolean isPrivateOwned() {
        if (super.isPrivateOwned()) {
            this.getLogger().logWarningMessage("annotation_warning_ignore_private_owned", this);
        }
        return false;
    }

    public void process() {
        super.process();
        ObjectReferenceMapping mapping = this.initManyToOneMapping();
        if (mapping instanceof ManyToOneMapping) {
            this.processOwningMappingKeys((OneToOneMapping)((ManyToOneMapping)mapping));
        } else if (mapping instanceof EISOneToOneMapping) {
            this.processEISOneToOneForeignKeyRelationship((EISOneToOneMapping)mapping);
        }
    }
}

