/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.DomToXMLStreamWriter;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLStreamWriterRecord
extends MarshalRecord {
    private DomToXMLStreamWriter domToStreamWriter;
    private Map<String, String> prefixMapping;
    private NamespaceResolver namespaceResolver;
    private XMLStreamWriter xmlStreamWriter;

    public XMLStreamWriterRecord(XMLStreamWriter xmlStreamWriter) {
        this.xmlStreamWriter = xmlStreamWriter;
    }

    public XMLStreamWriter getXMLStreamWriter() {
        return this.xmlStreamWriter;
    }

    public void setXMLStreamWriter(XMLStreamWriter anXMLStreamWriter) {
        this.xmlStreamWriter = anXMLStreamWriter;
    }

    private DomToXMLStreamWriter getDomToXMLStreamWriter() {
        if (this.domToStreamWriter == null) {
            this.domToStreamWriter = new DomToXMLStreamWriter();
        }
        return this.domToStreamWriter;
    }

    public void attribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, String value) {
        try {
            String namespaceURI = xPathFragment.getNamespaceURI();
            if (namespaceURI == null) {
                this.xmlStreamWriter.writeAttribute(xPathFragment.getLocalName(), value);
            } else if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
                if ("xmlns".equals(xPathFragment.getLocalName())) {
                    this.xmlStreamWriter.writeDefaultNamespace(value);
                } else {
                    this.xmlStreamWriter.writeNamespace(xPathFragment.getLocalName(), value);
                }
            } else {
                String prefix = this.getPrefixForFragment(xPathFragment);
                if (prefix == null) {
                    this.xmlStreamWriter.writeAttribute(namespaceURI, xPathFragment.getLocalName(), value);
                } else {
                    this.xmlStreamWriter.writeAttribute(prefix, namespaceURI, xPathFragment.getLocalName(), value);
                }
            }
        }
        catch (XMLStreamException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void attribute(String namespaceURI, String localName, String name, String value) {
        try {
            if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
                if ("xmlns".equals(localName)) {
                    this.xmlStreamWriter.writeDefaultNamespace(value);
                } else {
                    this.xmlStreamWriter.writeNamespace(localName, value);
                }
            } else if (namespaceURI == null || namespaceURI.length() == 0) {
                this.xmlStreamWriter.writeAttribute(localName, value);
            } else {
                this.xmlStreamWriter.writeAttribute(this.xmlStreamWriter.getNamespaceContext().getPrefix(namespaceURI), namespaceURI, localName, value);
            }
        }
        catch (XMLStreamException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void cdata(String value) {
        try {
            this.xmlStreamWriter.writeCData(value);
        }
        catch (XMLStreamException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void characters(String value) {
        try {
            this.xmlStreamWriter.writeCharacters(value);
        }
        catch (XMLStreamException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void closeStartElement() {
    }

    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        super.openStartElement(xPathFragment, namespaceResolver);
        try {
            String namespaceURI = xPathFragment.getNamespaceURI();
            if (namespaceURI == null) {
                NamespaceContext namespaceContext = this.xmlStreamWriter.getNamespaceContext();
                if (namespaceContext == null) {
                    this.xmlStreamWriter.writeStartElement(xPathFragment.getLocalName());
                } else {
                    String defaultNamespace = this.xmlStreamWriter.getNamespaceContext().getNamespaceURI("");
                    this.xmlStreamWriter.writeStartElement("", xPathFragment.getLocalName(), "");
                    if (defaultNamespace != null && defaultNamespace.length() > 0) {
                        this.xmlStreamWriter.writeDefaultNamespace("");
                    }
                }
            } else {
                String prefix = this.getPrefixForFragment(xPathFragment);
                if (prefix == null) {
                    prefix = "";
                }
                this.xmlStreamWriter.writeStartElement(prefix, xPathFragment.getLocalName(), namespaceURI);
            }
            this.writePrefixMappings();
        }
        catch (XMLStreamException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void element(XPathFragment frag) {
        try {
            this.xmlStreamWriter.writeStartElement(this.getNameForFragment(frag));
            this.xmlStreamWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void endDocument() {
        try {
            this.xmlStreamWriter.writeEndDocument();
            this.xmlStreamWriter.flush();
        }
        catch (XMLStreamException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void endElement(XPathFragment pathFragment, NamespaceResolver namespaceResolver) {
        try {
            this.xmlStreamWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void node(Node node, NamespaceResolver resolver) {
        try {
            if (node.getNodeType() == 9) {
                node = ((Document)node).getDocumentElement();
            }
            this.getDomToXMLStreamWriter().writeToStream(node, this.xmlStreamWriter);
        }
        catch (XMLStreamException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void startDocument(String encoding, String version) {
        try {
            if ("UTF-8".equals(encoding)) {
                this.xmlStreamWriter.writeStartDocument(version);
            } else {
                this.xmlStreamWriter.writeStartDocument(encoding, version);
            }
        }
        catch (XMLStreamException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void startPrefixMapping(String prefix, String namespaceUri) {
        if (this.prefixMapping == null) {
            this.prefixMapping = new HashMap<String, String>();
        }
        this.prefixMapping.put(prefix, namespaceUri);
    }

    private void writePrefixMappings() {
        try {
            if (this.namespaceResolver != null) {
                String defaultNamespace = this.namespaceResolver.getDefaultNamespaceURI();
                if (defaultNamespace != null) {
                    this.xmlStreamWriter.writeNamespace("", defaultNamespace);
                }
                if (this.namespaceResolver.hasPrefixesToNamespaces()) {
                    for (Map.Entry<String, String> entry : this.namespaceResolver.getPrefixesToNamespaces().entrySet()) {
                        this.xmlStreamWriter.writeNamespace(entry.getKey(), entry.getValue());
                    }
                }
                this.namespaceResolver = null;
            }
            if (this.prefixMapping != null) {
                for (Map.Entry<String, String> entry : this.prefixMapping.entrySet()) {
                    this.xmlStreamWriter.writeNamespace(entry.getKey(), entry.getValue());
                }
                this.prefixMapping = null;
            }
        }
        catch (XMLStreamException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void namespaceDeclarations(NamespaceResolver namespaceResolver) {
    }

    public void startPrefixMappings(NamespaceResolver namespaceResolver) {
        this.namespaceResolver = namespaceResolver;
    }
}

