/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql;

import org.eclipse.persistence.jpa.jpql.AbstractPathResolver;
import org.eclipse.persistence.jpa.jpql.Resolver;
import org.eclipse.persistence.jpa.jpql.ResolverVisitor;
import org.eclipse.persistence.jpa.jpql.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.spi.IManagedTypeVisitor;
import org.eclipse.persistence.jpa.jpql.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeDeclaration;
import org.eclipse.persistence.jpa.jpql.util.iterator.IterableIterator;
import org.eclipse.persistence.jpa.jpql.util.iterator.NullIterator;

public class CollectionValuedFieldResolver
extends AbstractPathResolver {
    public CollectionValuedFieldResolver(Resolver parent, String path) {
        super(parent, path);
    }

    public void accept(ResolverVisitor visitor) {
        visitor.visit(this);
    }

    protected IType buildType() {
        ITypeDeclaration[] typeParameters;
        ITypeDeclaration typeDeclaration = this.getTypeDeclaration();
        IType type = typeDeclaration.getType();
        if (this.getTypeHelper().isCollectionType(type)) {
            ITypeDeclaration[] typeParameters2 = typeDeclaration.getTypeParameters();
            if (typeParameters2.length > 0) {
                type = typeParameters2[0].getType();
            }
        } else if (this.getTypeHelper().isMapType(type) && (typeParameters = typeDeclaration.getTypeParameters()).length == 2) {
            type = typeParameters[1].getType();
        }
        return this.getTypeHelper().convertPrimitive(type);
    }

    protected IManagedType resolveManagedType(IMapping mapping) {
        ITypeDeclaration typeDeclaration = mapping.getTypeDeclaration();
        IType type = typeDeclaration.getType();
        if (this.getTypeHelper().isCollectionType(type)) {
            ITypeDeclaration[] typeParameters = typeDeclaration.getTypeParameters();
            if (typeParameters.length == 0) {
                return null;
            }
            type = typeParameters[0].getType();
        } else if (this.getTypeHelper().isMapType(type)) {
            return new MapManagedType(this.getProvider(), type);
        }
        return this.getProvider().getManagedType(type);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MapManagedType
    implements IManagedType {
        protected final IType mapType;
        protected final IManagedTypeProvider provider;

        protected MapManagedType(IManagedTypeProvider provider, IType mapType) {
            this.provider = provider;
            this.mapType = mapType;
        }

        @Override
        public void accept(IManagedTypeVisitor visitor) {
        }

        @Override
        public int compareTo(IManagedType managedType) {
            return this.getType().getName().compareTo(managedType.getType().getName());
        }

        @Override
        public IMapping getMappingNamed(String name) {
            return null;
        }

        @Override
        public IManagedTypeProvider getProvider() {
            return this.provider;
        }

        @Override
        public IType getType() {
            return this.mapType;
        }

        @Override
        public IterableIterator<IMapping> mappings() {
            return NullIterator.instance();
        }

        public String toString() {
            return this.getType().getName();
        }
    }
}

