/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.exceptions;

import java.io.StringWriter;
import java.sql.SQLException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.i18n.ExceptionMessageGenerator;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.Record;

public class DatabaseException
extends EclipseLinkException {
    protected SQLException exception;
    protected transient Call call;
    protected transient DatabaseQuery query;
    protected transient AbstractRecord queryArguments;
    protected transient Accessor accessor;
    protected boolean isCommunicationFailure;
    public static final int SQL_EXCEPTION = 4002;
    public static final int CONFIGURATION_ERROR_CLASS_NOT_FOUND = 4003;
    public static final int DATABASE_ACCESSOR_NOT_CONNECTED = 4005;
    public static final int ERROR_READING_BLOB_DATA = 4006;
    public static final int COULD_NOT_CONVERT_OBJECT_TYPE = 4007;
    public static final int LOGOUT_WHILE_TRANSACTION_IN_PROGRESS = 4008;
    public static final int SEQUENCE_TABLE_INFORMATION_NOT_COMPLETE = 4009;
    public static final int ERROR_PREALLOCATING_SEQUENCE_NUMBERS = 4011;
    public static final int CANNOT_REGISTER_SYNCHRONIZATIONLISTENER_FOR_UNITOFWORK = 4014;
    public static final int SYNCHRONIZED_UNITOFWORK_DOES_NOT_SUPPORT_COMMITANDRESUME = 4015;
    public static final int CONFIGURATION_ERROR_NEW_INSTANCE_INSTANTIATION_EXCEPTION = 4016;
    public static final int CONFIGURATION_ERROR_NEW_INSTANCE_ILLEGAL_ACCESS_EXCEPTION = 4017;
    public static final int TRANSACTION_MANAGER_NOT_SET_FOR_JTS_DRIVER = 4018;
    public static final int ERROR_RETRIEVE_DB_METADATA_THROUGH_JDBC_CONNECTION = 4019;
    public static final int COULD_NOT_FIND_MATCHED_DATABASE_FIELD_FOR_SPECIFIED_OPTOMISTICLOCKING_FIELDS = 4020;
    public static final int UNABLE_TO_ACQUIRE_CONNECTION_FROM_DRIVER = 4021;
    public static final int DATABASE_ACCESSOR_CONNECTION_IS_NULL = 4022;

    protected DatabaseException(String message) {
        super(message);
    }

    protected DatabaseException(SQLException exception) {
        super(exception.toString(), exception);
    }

    public static DatabaseException cannotRegisterSynchronizatonListenerForUnitOfWork(Exception e) {
        Object[] args = new Object[]{e};
        DatabaseException databaseException = new DatabaseException(ExceptionMessageGenerator.buildMessage(DatabaseException.class, 4014, args));
        databaseException.setErrorCode(4014);
        databaseException.setInternalException(e);
        return databaseException;
    }

    public static DatabaseException configurationErrorClassNotFound(String className) {
        Object[] args = new Object[]{className};
        DatabaseException databaseException = new DatabaseException(ExceptionMessageGenerator.buildMessage(DatabaseException.class, 4003, args));
        databaseException.setErrorCode(4003);
        return databaseException;
    }

    public static DatabaseException configurationErrorNewInstanceIllegalAccessException(IllegalAccessException exception, Class javaClass) {
        Object[] args = new Object[]{javaClass};
        DatabaseException databaseException = new DatabaseException(ExceptionMessageGenerator.buildMessage(DatabaseException.class, 4017, args));
        databaseException.setErrorCode(4017);
        databaseException.setInternalException(exception);
        return databaseException;
    }

    public static DatabaseException configurationErrorNewInstanceInstantiationException(InstantiationException exception, Class javaClass) {
        Object[] args = new Object[]{javaClass};
        DatabaseException databaseException = new DatabaseException(ExceptionMessageGenerator.buildMessage(DatabaseException.class, 4016, args));
        databaseException.setErrorCode(4016);
        databaseException.setInternalException(exception);
        return databaseException;
    }

    public static DatabaseException couldNotConvertObjectType(int type) {
        Object[] args = new Object[]{CR, type};
        DatabaseException databaseException = new DatabaseException(ExceptionMessageGenerator.buildMessage(DatabaseException.class, 4007, args));
        databaseException.setErrorCode(4007);
        return databaseException;
    }

    public static DatabaseException databaseAccessorNotConnected() {
        Object[] args = new Object[]{};
        String message = ExceptionMessageGenerator.buildMessage(DatabaseException.class, 4005, args);
        DatabaseException databaseException = new DatabaseException(message);
        databaseException.setErrorCode(4005);
        return databaseException;
    }

    public static DatabaseException databaseAccessorNotConnected(DatabaseAccessor databaseAccessor) {
        Object[] args = new Object[]{};
        DatabaseException databaseException = new DatabaseException(ExceptionMessageGenerator.buildMessage(DatabaseException.class, 4005, args));
        databaseException.setErrorCode(4005);
        databaseException.setAccessor(databaseAccessor);
        return databaseException;
    }

    public static DatabaseException databaseAccessorConnectionIsNull(DatabaseAccessor databaseAccessor, AbstractSession session) {
        Object[] args = new Object[]{};
        DatabaseException databaseException = new DatabaseException(ExceptionMessageGenerator.buildMessage(DatabaseException.class, 4022, args));
        databaseException.setErrorCode(4022);
        databaseException.setAccessor(databaseAccessor);
        databaseException.setSession(session);
        return databaseException;
    }

    public static DatabaseException errorPreallocatingSequenceNumbers() {
        Object[] args = new Object[]{};
        DatabaseException databaseException = new DatabaseException(ExceptionMessageGenerator.buildMessage(DatabaseException.class, 4011, args));
        databaseException.setErrorCode(4011);
        return databaseException;
    }

    public static DatabaseException errorReadingBlobData() {
        Object[] args = new Object[]{};
        DatabaseException databaseException = new DatabaseException(ExceptionMessageGenerator.buildMessage(DatabaseException.class, 4006, args));
        databaseException.setErrorCode(4006);
        return databaseException;
    }

    public static DatabaseException specifiedLockingFieldsNotFoundInDatabase(String lockingFieldName) {
        Object[] args = new Object[]{lockingFieldName};
        DatabaseException databaseException = new DatabaseException(ExceptionMessageGenerator.buildMessage(DatabaseException.class, 4020, args));
        databaseException.setErrorCode(4020);
        return databaseException;
    }

    public Accessor getAccessor() {
        return this.accessor;
    }

    public int getDatabaseErrorCode() {
        if (this.getInternalException() == null) {
            return super.getErrorCode();
        }
        return ((SQLException)this.getInternalException()).getErrorCode();
    }

    public String getMessage() {
        if (this.getInternalException() == null) {
            return super.getMessage();
        }
        StringWriter writer = new StringWriter();
        writer.write(super.getMessage());
        writer.write(DatabaseException.cr());
        writer.write(this.getIndentationString());
        writer.write(ExceptionMessageGenerator.getHeader("ErrorCodeHeader"));
        if (this.getInternalException() instanceof SQLException) {
            writer.write(Integer.toString(((SQLException)this.getInternalException()).getErrorCode()));
        } else {
            writer.write("000");
        }
        if (this.getCall() != null) {
            writer.write(DatabaseException.cr());
            writer.write(this.getIndentationString());
            writer.write(ExceptionMessageGenerator.getHeader("CallHeader"));
            if (this.getAccessor() != null) {
                writer.write(this.getCall().getLogString(this.getAccessor()));
            } else {
                writer.write(this.getCall().toString());
            }
        }
        if (this.getQuery() != null) {
            writer.write(DatabaseException.cr());
            writer.write(this.getIndentationString());
            writer.write(ExceptionMessageGenerator.getHeader("QueryHeader"));
            try {
                writer.write(this.getQuery().toString());
            }
            catch (RuntimeException runtimeException) {}
        }
        return writer.toString();
    }

    public DatabaseQuery getQuery() {
        return this.query;
    }

    public Call getCall() {
        return this.call;
    }

    public void setCall(Call call) {
        this.call = call;
    }

    public Record getQueryArgumentsRecord() {
        return this.queryArguments;
    }

    public static DatabaseException logoutWhileTransactionInProgress() {
        Object[] args = new Object[]{};
        DatabaseException databaseException = new DatabaseException(ExceptionMessageGenerator.buildMessage(DatabaseException.class, 4008, args));
        databaseException.setErrorCode(4008);
        return databaseException;
    }

    public static DatabaseException sequenceTableInformationNotComplete() {
        Object[] args = new Object[]{};
        DatabaseException databaseException = new DatabaseException(ExceptionMessageGenerator.buildMessage(DatabaseException.class, 4009, args));
        databaseException.setErrorCode(4009);
        return databaseException;
    }

    public void setAccessor(Accessor accessor) {
        this.accessor = accessor;
    }

    public void setQuery(DatabaseQuery query) {
        this.query = query;
    }

    public void setQueryArguments(AbstractRecord queryArguments) {
        this.queryArguments = queryArguments;
    }

    public static DatabaseException sqlException(SQLException exception) {
        return DatabaseException.sqlException(exception, false);
    }

    public static DatabaseException sqlException(SQLException exception, boolean commError) {
        DatabaseException databaseException = new DatabaseException(exception);
        databaseException.setErrorCode(4002);
        databaseException.setCommunicationFailure(commError);
        return databaseException;
    }

    public static DatabaseException sqlException(SQLException exception, AbstractSession session, boolean commError) {
        if (session == null) {
            return DatabaseException.sqlException(exception, commError);
        }
        return DatabaseException.sqlException(exception, session.getAccessor(), session, commError);
    }

    public static DatabaseException sqlException(SQLException exception, Accessor accessor, AbstractSession session, boolean isCommunicationFailure) {
        DatabaseException databaseException = new DatabaseException(exception);
        databaseException.setErrorCode(4002);
        databaseException.setAccessor(accessor);
        databaseException.setSession(session);
        databaseException.setCommunicationFailure(isCommunicationFailure);
        return databaseException;
    }

    public static DatabaseException sqlException(SQLException exception, Call call, Accessor accessor, AbstractSession session, boolean isCommunicationFailure) {
        DatabaseException databaseException = new DatabaseException(exception);
        databaseException.setErrorCode(4002);
        databaseException.setAccessor(accessor);
        databaseException.setCall(call);
        databaseException.setCommunicationFailure(isCommunicationFailure);
        return databaseException;
    }

    public static DatabaseException synchronizedUnitOfWorkDoesNotSupportCommitAndResume() {
        Object[] args = new Object[]{};
        String message = ExceptionMessageGenerator.buildMessage(DatabaseException.class, 4015, args);
        DatabaseException databaseException = new DatabaseException(message);
        databaseException.setErrorCode(4015);
        return databaseException;
    }

    public static DatabaseException transactionManagerNotSetForJTSDriver() {
        Object[] args = new Object[]{};
        DatabaseException databaseException = new DatabaseException(ExceptionMessageGenerator.buildMessage(DatabaseException.class, 4018, args));
        databaseException.setErrorCode(4018);
        return databaseException;
    }

    public static DatabaseException errorRetrieveDbMetadataThroughJDBCConnection() {
        Object[] args = new Object[]{};
        DatabaseException databaseException = new DatabaseException(ExceptionMessageGenerator.buildMessage(DatabaseException.class, 4019, args));
        databaseException.setErrorCode(4019);
        return databaseException;
    }

    public static DatabaseException unableToAcquireConnectionFromDriverException(String driver, String user, String url) {
        Object[] args = new Object[]{driver, user, url};
        DatabaseException databaseException = new DatabaseException(ExceptionMessageGenerator.buildMessage(DatabaseException.class, 4021, args));
        databaseException.setErrorCode(4021);
        return databaseException;
    }

    public static DatabaseException unableToAcquireConnectionFromDriverException(SQLException exception, String driver, String user, String url) {
        DatabaseException databaseException = DatabaseException.unableToAcquireConnectionFromDriverException(driver, user, url);
        databaseException.setInternalException(exception);
        return databaseException;
    }

    public boolean isCommunicationFailure() {
        return this.isCommunicationFailure;
    }

    public void setCommunicationFailure(boolean isCommunicationFailure) {
        this.isCommunicationFailure = isCommunicationFailure;
    }
}

