/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record.namespaces;

import org.eclipse.persistence.internal.descriptors.Namespace;
import org.eclipse.persistence.oxm.NamespacePrefixMapper;
import org.eclipse.persistence.oxm.NamespaceResolver;

public class PrefixMapperNamespaceResolver
extends NamespaceResolver {
    private NamespacePrefixMapper prefixMapper;
    private NamespaceResolver contextualNamespaces;

    public PrefixMapperNamespaceResolver(NamespacePrefixMapper mapper, NamespaceResolver nestedResolver) {
        String[] uris;
        String uri;
        this.prefixMapper = mapper;
        String[] declarations = mapper.getContextualNamespaceDecls();
        if (declarations != null && declarations.length > 0) {
            this.contextualNamespaces = new NamespaceResolver();
            int i = 0;
            while (i < declarations.length - 1) {
                String prefix = declarations[i];
                uri = declarations[i + 1];
                this.contextualNamespaces.put(prefix, uri);
                i += 2;
            }
        }
        if ((uris = mapper.getPreDeclaredNamespaceUris()) != null && uris.length > 0) {
            int i = 0;
            while (i < uris.length) {
                uri = uris[i];
                String prefix = this.prefixMapper.getPreferredPrefix(uri, null, true);
                if (prefix != null) {
                    this.put(prefix, uri);
                }
                ++i;
            }
        }
        if ((declarations = this.prefixMapper.getPreDeclaredNamespaceUris2()) != null && declarations.length > 0) {
            int i = 0;
            while (i < declarations.length - 1) {
                String prefix = declarations[i];
                String uri2 = declarations[i + 1];
                this.put(prefix, uri2);
                i += 2;
            }
        }
        for (Object next : nestedResolver.getNamespaces()) {
            Namespace ns = (Namespace)next;
            String uri3 = ns.getNamespaceURI();
            String prefix = this.resolveNamespaceURI(uri3);
            if (prefix != null) continue;
            this.put(ns.getPrefix(), uri3);
        }
    }

    public String resolveNamespaceURI(String uri) {
        String prefix = null;
        if (this.contextualNamespaces != null) {
            prefix = this.contextualNamespaces.resolveNamespaceURI(uri);
        }
        if (prefix == null) {
            prefix = super.resolveNamespaceURI(uri);
        }
        if (prefix == null) {
            prefix = this.prefixMapper.getPreferredPrefix(uri, prefix, true);
        }
        return prefix;
    }

    public void put(String a, String b) {
        super.put(a, b);
    }
}

