/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql;

import java.util.Collection;
import org.eclipse.persistence.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.jpql.parser.AbsExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractTraverseParentVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AdditionExpression;
import org.eclipse.persistence.jpa.jpql.parser.AndExpression;
import org.eclipse.persistence.jpa.jpql.parser.AvgFunction;
import org.eclipse.persistence.jpa.jpql.parser.BetweenExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.ComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.CompoundExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConcatExpression;
import org.eclipse.persistence.jpa.jpql.parser.CountFunction;
import org.eclipse.persistence.jpa.jpql.parser.DivisionExpression;
import org.eclipse.persistence.jpa.jpql.parser.EmptyCollectionComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.ExistsExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.InExpression;
import org.eclipse.persistence.jpa.jpql.parser.InputParameter;
import org.eclipse.persistence.jpa.jpql.parser.LengthExpression;
import org.eclipse.persistence.jpa.jpql.parser.LikeExpression;
import org.eclipse.persistence.jpa.jpql.parser.LowerExpression;
import org.eclipse.persistence.jpa.jpql.parser.MaxFunction;
import org.eclipse.persistence.jpa.jpql.parser.MinFunction;
import org.eclipse.persistence.jpa.jpql.parser.ModExpression;
import org.eclipse.persistence.jpa.jpql.parser.MultiplicationExpression;
import org.eclipse.persistence.jpa.jpql.parser.NullComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.NumericLiteral;
import org.eclipse.persistence.jpa.jpql.parser.OrExpression;
import org.eclipse.persistence.jpa.jpql.parser.SizeExpression;
import org.eclipse.persistence.jpa.jpql.parser.SqrtExpression;
import org.eclipse.persistence.jpa.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.SubstringExpression;
import org.eclipse.persistence.jpa.jpql.parser.SubtractionExpression;
import org.eclipse.persistence.jpa.jpql.parser.SumFunction;
import org.eclipse.persistence.jpa.jpql.parser.TrimExpression;
import org.eclipse.persistence.jpa.jpql.parser.UpdateItem;
import org.eclipse.persistence.jpa.jpql.spi.IType;

public class ParameterTypeVisitor
extends AbstractTraverseParentVisitor {
    private Expression currentExpression;
    private Expression expression;
    private boolean ignoreType;
    private InputParameter inputParameter;
    private final JPQLQueryContext queryContext;
    private Class<?> type;

    public ParameterTypeVisitor(JPQLQueryContext queryContext) {
        this.queryContext = queryContext;
    }

    protected void dispose() {
        this.type = null;
        this.expression = null;
        this.ignoreType = false;
        this.inputParameter = null;
        this.currentExpression = null;
    }

    public IType getType() {
        if (this.ignoreType) {
            return this.queryContext.getTypeHelper().unknownType();
        }
        if (this.expression == null) {
            if (this.type == null) {
                this.type = Object.class;
            }
            return this.queryContext.getType(this.type);
        }
        return this.queryContext.getType(this.expression);
    }

    public void visit(AbsExpression expression) {
        this.expression = expression;
    }

    public void visit(AdditionExpression expression) {
        this.visitCompoundExpression(expression);
    }

    public void visit(AndExpression expression) {
        this.visitCompoundExpression(expression);
    }

    public void visit(AvgFunction expression) {
        this.expression = expression;
    }

    public void visit(BetweenExpression expression) {
        expression.getExpression().accept(this);
    }

    public void visit(CollectionValuedPathExpression expression) {
        this.expression = expression;
    }

    public void visit(ComparisonExpression expression) {
        this.visitCompoundExpression(expression);
    }

    public void visit(ConcatExpression expression) {
        if (expression.getExpression().isAncestor(this.inputParameter)) {
            this.expression = expression;
        }
    }

    public void visit(CountFunction expression) {
        this.expression = expression;
    }

    public void visit(DivisionExpression expression) {
        this.visitCompoundExpression(expression);
    }

    public void visit(EmptyCollectionComparisonExpression expression) {
        if (expression.getExpression() == this.inputParameter) {
            this.ignoreType = true;
        } else {
            super.visit(expression);
        }
    }

    public void visit(ExistsExpression expression) {
        this.expression = expression;
    }

    public void visit(IdentificationVariable expression) {
        this.expression = expression;
    }

    public void visit(InExpression expression) {
        if (expression.getInItems() == this.inputParameter) {
            this.type = Collection.class;
        } else if (expression.getInItems().isAncestor(this.inputParameter)) {
            expression.getExpression().accept(this);
        }
    }

    public void visit(InputParameter expression) {
        this.inputParameter = expression;
        expression.getParent().accept(this);
    }

    public void visit(LengthExpression expression) {
        this.type = expression.isAncestor(this.inputParameter) ? String.class : Integer.class;
    }

    public void visit(LikeExpression expression) {
        Expression patternValue = expression.getPatternValue();
        Expression stringExpression = expression.getStringExpression();
        Expression escapeCharacter = expression.getEscapeCharacter();
        if (escapeCharacter == this.inputParameter) {
            this.type = Character.class;
        } else if (patternValue.isAncestor(this.inputParameter)) {
            this.expression = expression.getStringExpression();
        } else if (stringExpression.isAncestor(this.inputParameter)) {
            this.expression = expression;
        }
    }

    public void visit(LowerExpression expression) {
        this.expression = expression;
    }

    public void visit(MaxFunction expression) {
        this.expression = expression;
    }

    public void visit(MinFunction expression) {
        this.expression = expression;
    }

    public void visit(ModExpression expression) {
        this.expression = expression;
    }

    public void visit(MultiplicationExpression expression) {
        this.visitCompoundExpression(expression);
    }

    public void visit(NullComparisonExpression expression) {
        if (expression.getExpression() == this.inputParameter) {
            this.ignoreType = true;
        } else {
            expression.getExpression().accept(this);
        }
    }

    public void visit(NumericLiteral expression) {
        this.expression = expression;
    }

    public void visit(OrExpression expression) {
        this.visitCompoundExpression(expression);
    }

    public void visit(SizeExpression expression) {
        this.expression = expression;
    }

    public void visit(SqrtExpression expression) {
        if (expression.isAncestor(this.inputParameter)) {
            super.visit(expression);
        } else {
            this.expression = expression;
        }
    }

    public void visit(StateFieldPathExpression expression) {
        this.expression = expression;
    }

    public void visit(SubstringExpression expression) {
        if (expression.getFirstExpression().isAncestor(this.inputParameter)) {
            this.type = String.class;
        } else if (expression.getSecondExpression().isAncestor(this.inputParameter) || expression.getThirdExpression().isAncestor(this.inputParameter)) {
            this.type = Integer.class;
        }
    }

    public void visit(SubtractionExpression expression) {
        this.visitCompoundExpression(expression);
    }

    public void visit(SumFunction expression) {
        this.expression = expression;
    }

    public void visit(TrimExpression expression) {
        if (expression.getTrimCharacter() == this.inputParameter) {
            this.type = Character.class;
        } else if (expression.getExpression() == this.inputParameter) {
            this.type = String.class;
        }
    }

    public void visit(UpdateItem expression) {
        expression.getStateFieldPathExpression().accept(this);
    }

    protected void visitCompoundExpression(CompoundExpression expression) {
        Expression leftExpression = expression.getLeftExpression();
        Expression rightExpression = expression.getRightExpression();
        if (leftExpression.isAncestor(this.inputParameter)) {
            if (this.currentExpression == null) {
                this.currentExpression = expression;
                rightExpression.accept(this);
                this.currentExpression = null;
            } else {
                this.type = null;
                this.ignoreType = true;
                expression = null;
            }
        } else if (rightExpression.isAncestor(this.inputParameter)) {
            if (this.currentExpression == null) {
                this.currentExpression = expression;
                leftExpression.accept(this);
                this.currentExpression = null;
            } else {
                this.type = null;
                this.ignoreType = true;
                expression = null;
            }
        } else {
            super.visit(expression);
        }
    }
}

