/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.parser.StringExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArithmeticFactor
extends AbstractExpression {
    private AbstractExpression expression;

    public ArithmeticFactor(AbstractExpression parent, String arithmeticFactor) {
        super(parent, arithmeticFactor);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getExpression().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getExpression());
    }

    @Override
    protected void addOrderedChildrenTo(List<StringExpression> children) {
        children.add(this.buildStringExpression(this.getText()));
        if (this.expression != null) {
            children.add(this.expression);
        }
    }

    public Expression getExpression() {
        if (this.expression == null) {
            this.expression = this.buildNullExpression();
        }
        return this.expression;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("arithmetic_factor");
    }

    @Override
    protected boolean handleAggregate(JPQLQueryBNF queryBNF) {
        return false;
    }

    public boolean hasExpression() {
        return this.expression != null && !this.expression.isNull();
    }

    public boolean isMinusSign() {
        return this.getText().charAt(0) == '-';
    }

    @Override
    protected boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        char character = wordParser.character();
        return wordParser.isArithmeticSymbol(character) || super.isParsingComplete(wordParser, word, expression);
    }

    public boolean isPlusSign() {
        return this.getText().charAt(0) == '+';
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        wordParser.moveForward(1);
        wordParser.skipLeadingWhitespace();
        this.expression = this.parse(wordParser, this.getQueryBNF(), tolerant);
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        writer.append(this.getText());
        if (this.expression != null) {
            this.expression.toParsedText(writer, actual);
        }
    }
}

