/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import org.eclipse.persistence.dbws.DBWSModelProject;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ComplexDatabaseType;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseType;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelGenerator;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelGeneratorProperties;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelProject;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexType;
import org.eclipse.persistence.internal.oxm.schema.model.Schema;
import org.eclipse.persistence.internal.sessions.factories.MissingDescriptorListener;
import org.eclipse.persistence.internal.sessions.factories.ObjectPersistenceWorkbenchXMLProject;
import org.eclipse.persistence.internal.sessions.factories.XMLSessionConfigProject_11_1_1;
import org.eclipse.persistence.internal.sessions.factories.model.SessionConfigs;
import org.eclipse.persistence.internal.xr.CollectionResult;
import org.eclipse.persistence.internal.xr.DeleteOperation;
import org.eclipse.persistence.internal.xr.InsertOperation;
import org.eclipse.persistence.internal.xr.NamedQueryHandler;
import org.eclipse.persistence.internal.xr.Parameter;
import org.eclipse.persistence.internal.xr.ProjectHelper;
import org.eclipse.persistence.internal.xr.QueryHandler;
import org.eclipse.persistence.internal.xr.QueryOperation;
import org.eclipse.persistence.internal.xr.Result;
import org.eclipse.persistence.internal.xr.UpdateOperation;
import org.eclipse.persistence.internal.xr.XRDynamicClassLoader;
import org.eclipse.persistence.internal.xr.sxf.SimpleXMLFormat;
import org.eclipse.persistence.internal.xr.sxf.SimpleXMLFormatProject;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.SerializedObjectConverter;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLLogin;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.XMLNullRepresentationType;
import org.eclipse.persistence.oxm.platform.DOMPlatform;
import org.eclipse.persistence.platform.database.jdbc.JDBCTypes;
import org.eclipse.persistence.platform.database.oracle.jdbc.OracleArrayType;
import org.eclipse.persistence.platform.database.oracle.jdbc.OracleObjectType;
import org.eclipse.persistence.platform.database.oracle.plsql.OraclePLSQLTypes;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLCollection;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLrecord;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.factories.XMLProjectReader;
import org.eclipse.persistence.sessions.factories.XMLProjectWriter;
import org.eclipse.persistence.tools.dbws.DBWSBuilder;
import org.eclipse.persistence.tools.dbws.DefaultNamingConventionTransformer;
import org.eclipse.persistence.tools.dbws.NamingConventionTransformer;
import org.eclipse.persistence.tools.dbws.OperationModel;
import org.eclipse.persistence.tools.dbws.ProcedureOperationModel;
import org.eclipse.persistence.tools.dbws.SQLOperationModel;
import org.eclipse.persistence.tools.dbws.TableOperationModel;
import org.eclipse.persistence.tools.dbws.Util;
import org.eclipse.persistence.tools.dbws.WSDLGenerator;
import org.eclipse.persistence.tools.dbws.jdbc.DbColumn;
import org.eclipse.persistence.tools.dbws.jdbc.DbTable;
import org.eclipse.persistence.tools.oracleddl.metadata.ArgumentType;
import org.eclipse.persistence.tools.oracleddl.metadata.BinaryType;
import org.eclipse.persistence.tools.oracleddl.metadata.BlobType;
import org.eclipse.persistence.tools.oracleddl.metadata.CharType;
import org.eclipse.persistence.tools.oracleddl.metadata.ClobType;
import org.eclipse.persistence.tools.oracleddl.metadata.DecimalType;
import org.eclipse.persistence.tools.oracleddl.metadata.DoubleType;
import org.eclipse.persistence.tools.oracleddl.metadata.FieldType;
import org.eclipse.persistence.tools.oracleddl.metadata.FloatType;
import org.eclipse.persistence.tools.oracleddl.metadata.FunctionType;
import org.eclipse.persistence.tools.oracleddl.metadata.LongRawType;
import org.eclipse.persistence.tools.oracleddl.metadata.NCharType;
import org.eclipse.persistence.tools.oracleddl.metadata.NClobType;
import org.eclipse.persistence.tools.oracleddl.metadata.NumericType;
import org.eclipse.persistence.tools.oracleddl.metadata.ObjectTableType;
import org.eclipse.persistence.tools.oracleddl.metadata.ObjectType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLCollectionType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLRecordType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLType;
import org.eclipse.persistence.tools.oracleddl.metadata.PrecisionType;
import org.eclipse.persistence.tools.oracleddl.metadata.ProcedureType;
import org.eclipse.persistence.tools.oracleddl.metadata.RawType;
import org.eclipse.persistence.tools.oracleddl.metadata.RealType;
import org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum;
import org.eclipse.persistence.tools.oracleddl.metadata.SizedType;
import org.eclipse.persistence.tools.oracleddl.metadata.TableType;
import org.eclipse.persistence.tools.oracleddl.metadata.TimeStampType;
import org.eclipse.persistence.tools.oracleddl.metadata.VArrayType;
import org.eclipse.persistence.tools.oracleddl.metadata.VarChar2Type;

public abstract class BaseDBWSBuilderHelper {
    public static final String ITEM_MAPPING_NAME = "item";
    public static final String ITEMS_MAPPING_ATTRIBUTE_NAME = "items";
    public static final String ITEMS_MAPPING_FIELD_NAME = "ITEMS";
    public static final String BOOLEAN_STR = "BOOLEAN";
    public static final String DATE_STR = "DATE";
    public static final String DECIMAL_STR = "DECIMAL";
    public static final String INTEGER_STR = "INTEGER";
    public static final String MTOM_STR = "MTOM";
    public static final String NUMBER_STR = "NUMBER";
    public static final String SWAREF_STR = "SWAREF";
    protected List<TableType> dbTables = new ArrayList<TableType>();
    protected List<ProcedureType> dbStoredProcedures = new ArrayList<ProcedureType>();
    protected DBWSBuilder dbwsBuilder;
    protected XMLSessionConfigProject_11_1_1 sessionConfigProject = new XMLSessionConfigProject_11_1_1();
    protected NamingConventionTransformer nct;
    protected ObjectPersistenceWorkbenchXMLProject workbenchXMLProject = new ObjectPersistenceWorkbenchXMLProject();

    public BaseDBWSBuilderHelper(DBWSBuilder dbwsBuilder) {
        this.dbwsBuilder = dbwsBuilder;
    }

    public List<TableType> getDbTables() {
        return this.dbTables;
    }

    public List<ProcedureType> getDbStoredProcedures() {
        return this.dbStoredProcedures;
    }

    public abstract boolean hasTables();

    public abstract boolean hasComplexProcedureArgs();

    protected abstract List<TableType> loadTables(List<String> var1, List<String> var2, List<String> var3);

    protected abstract List<ProcedureType> loadProcedures(List<String> var1, List<String> var2, List<String> var3);

    protected abstract void addToOROXProjectsForComplexArgs(List<ArgumentType> var1, Project var2, Project var3, ProcedureOperationModel var4);

    protected abstract void buildQueryForProcedureType(ProcedureType var1, Project var2, Project var3, ProcedureOperationModel var4, boolean var5);

    protected void addToOROXProjectsForSecondarySql(SQLOperationModel sqlOm, Project orProject, Project oxProject, NamingConventionTransformer nct) {
        List<DbColumn> columns = BaseDBWSBuilderHelper.buildDbColumns(this.dbwsBuilder.getConnection(), sqlOm.getBuildSql());
        String tableName = sqlOm.getReturnType();
        NamingConventionTransformer customNct = this.setUpCustomTransformer(tableName, nct);
        RelationalDescriptor desc = Util.buildORDescriptor(tableName, this.dbwsBuilder.getProjectName(), null, customNct);
        desc.descriptorIsAggregate();
        orProject.addDescriptor((ClassDescriptor)desc);
        XMLDescriptor xdesc = Util.buildOXDescriptor(tableName, this.dbwsBuilder.getProjectName(), this.dbwsBuilder.getTargetNamespace(), customNct);
        oxProject.addDescriptor((ClassDescriptor)xdesc);
        ArrayList<String> columnsAlreadyProcessed = new ArrayList<String>();
        for (DbColumn dbColumn : columns) {
            String columnName = dbColumn.getFieldName();
            if (!columnsAlreadyProcessed.contains(columnName)) {
                columnsAlreadyProcessed.add(columnName);
                NamingConventionTransformer.ElementStyle style = nct.styleForElement(columnName);
                if (style == NamingConventionTransformer.ElementStyle.NONE) continue;
                this.dbwsBuilder.logMessage(Level.FINE, "Building mappings for " + columnName);
                DirectToFieldMapping orFieldMapping = this.buildORFieldMappingFromColumn(dbColumn, desc, this.dbwsBuilder.getDatabasePlatform(), nct);
                desc.addMapping((DatabaseMapping)orFieldMapping);
                XMLDirectMapping oxFieldMapping = this.buildOXFieldMappingFromColumn(dbColumn, this.dbwsBuilder.getDatabasePlatform(), nct);
                xdesc.addMapping((DatabaseMapping)oxFieldMapping);
                continue;
            }
            this.dbwsBuilder.logMessage(Level.SEVERE, "Duplicate ResultSet columns not supported '" + columnName + "'");
            throw new RuntimeException("Duplicate ResultSet columns not supported");
        }
    }

    public void buildOROXProjects(NamingConventionTransformer nct) {
        this.nct = nct;
        String projectName = this.dbwsBuilder.getProjectName();
        Project orProject = new Project();
        orProject.setName(projectName + "-" + "dbws-or");
        Project oxProject = null;
        if (this.dbTables.isEmpty() && !this.dbwsBuilder.hasBuildSqlOperations()) {
            this.dbwsBuilder.logMessage(Level.FINEST, "No tables specified");
            oxProject = new SimpleXMLFormatProject();
        } else {
            oxProject = new Project();
        }
        oxProject.setName(projectName + "-" + "dbws-ox");
        for (TableType dbTable : this.dbTables) {
            String tableName = dbTable.getTableName();
            RelationalDescriptor desc = Util.buildORDescriptor(tableName, this.dbwsBuilder.getProjectName(), this.dbwsBuilder.requireCRUDOperations, nct);
            orProject.addDescriptor((ClassDescriptor)desc);
            XMLDescriptor xdesc = Util.buildOXDescriptor(tableName, this.dbwsBuilder.getProjectName(), this.dbwsBuilder.getTargetNamespace(), nct);
            oxProject.addDescriptor((ClassDescriptor)xdesc);
            for (FieldType dbColumn : dbTable.getColumns()) {
                String columnName = dbColumn.getFieldName();
                NamingConventionTransformer.ElementStyle style = nct.styleForElement(columnName);
                if (style == NamingConventionTransformer.ElementStyle.NONE) continue;
                this.dbwsBuilder.logMessage(Level.FINE, "Building mappings for " + tableName + "." + columnName);
                DirectToFieldMapping orFieldMapping = this.buildORFieldMappingFromColumn(dbColumn, desc, this.dbwsBuilder.getDatabasePlatform(), nct);
                desc.addMapping((DatabaseMapping)orFieldMapping);
                XMLDirectMapping oxFieldMapping = this.buildOXFieldMappingFromColumn(dbColumn, this.dbwsBuilder.getDatabasePlatform(), nct);
                xdesc.addMapping((DatabaseMapping)oxFieldMapping);
                if (oxFieldMapping.getAttributeClassificationName() != ClassConstants.APBYTE.getName()) continue;
                orFieldMapping.setAttributeClassificationName(ClassConstants.APBYTE.getName());
            }
            this.setUpFindQueries(tableName, desc);
        }
        this.finishUpProjects(orProject, oxProject);
    }

    protected DirectToFieldMapping buildORFieldMappingFromColumn(FieldType dbColumn, RelationalDescriptor desc, DatabasePlatform databasePlatform, NamingConventionTransformer nct) {
        SizedType sizedType;
        String columnName = dbColumn.getFieldName();
        org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType dataType = dbColumn.getDataType();
        String typeName = BaseDBWSBuilderHelper.getTypeNameForDatabaseType(dataType);
        int jdbcType = Util.getJDBCTypeFromTypeName(typeName);
        String dmdTypeName = Util.getJDBCTypeNameFromType(jdbcType);
        Class attributeClass = null;
        attributeClass = "CHAR".equalsIgnoreCase(dmdTypeName) && dbColumn.getDataType() instanceof SizedType ? ((sizedType = (SizedType)dbColumn.getDataType()).getSize() == 1L ? Character.class : String.class) : org.eclipse.persistence.internal.xr.Util.getClassFromJDBCType((String)dmdTypeName.toUpperCase(), (DatabasePlatform)databasePlatform);
        if (attributeClass.getName().contains("oracle.sql.TIMESTAMP")) {
            attributeClass = Timestamp.class;
        }
        DirectToFieldMapping dtfm = BaseDBWSBuilderHelper.setUpDirectToFieldMapping(desc, columnName, nct, attributeClass, jdbcType, dbColumn.pk());
        return dtfm;
    }

    protected XMLDirectMapping buildOXFieldMappingFromColumn(FieldType dbColumn, DatabasePlatform databasePlatform, NamingConventionTransformer nct) {
        SizedType sizedType;
        String columnName = dbColumn.getFieldName();
        org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType dataType = dbColumn.getDataType();
        String typeName = BaseDBWSBuilderHelper.getTypeNameForDatabaseType(dataType);
        int jdbcType = Util.getJDBCTypeFromTypeName(typeName);
        String dmdTypeName = Util.getJDBCTypeNameFromType(jdbcType);
        QName qName = Util.getXMLTypeFromJDBCType(jdbcType);
        Class attributeClass = "CHAR".equalsIgnoreCase(dmdTypeName) && dbColumn.getDataType() instanceof SizedType ? ((sizedType = (SizedType)dbColumn.getDataType()).getSize() == 1L ? Character.class : String.class) : org.eclipse.persistence.internal.xr.Util.getClassFromJDBCType((String)dmdTypeName.toUpperCase(), (DatabasePlatform)databasePlatform);
        if (attributeClass.getName().contains("oracle.sql.TIMESTAMP")) {
            attributeClass = Timestamp.class;
        }
        XMLDirectMapping xdm = this.setUpXMLDirectMapping(columnName, qName, nct, attributeClass, jdbcType, dbColumn.pk());
        return xdm;
    }

    public void buildDbArtifacts() {
        boolean schemaNameMatch;
        ArrayList<String> schemaPatterns;
        ArrayList<String> catalogPatterns;
        ArrayList<TableOperationModel> tableOperations = new ArrayList<TableOperationModel>();
        ArrayList<ProcedureOperationModel> procedureOperations = new ArrayList<ProcedureOperationModel>();
        if (this.dbTables.size() == 0) {
            for (OperationModel operation : this.dbwsBuilder.operations) {
                if (!operation.isTableOperation()) continue;
                TableOperationModel tom = (TableOperationModel)operation;
                tableOperations.add(tom);
                if (tom.additionalOperations == null || tom.additionalOperations.size() <= 0) continue;
                for (OperationModel nestedOperation : tom.additionalOperations) {
                    if (!nestedOperation.isProcedureOperation()) continue;
                    procedureOperations.add((ProcedureOperationModel)nestedOperation);
                }
            }
            if (tableOperations.size() > 0) {
                catalogPatterns = new ArrayList<String>();
                schemaPatterns = new ArrayList<String>();
                ArrayList<String> tableNamePatterns = new ArrayList<String>();
                for (TableOperationModel tableOperation : tableOperations) {
                    catalogPatterns.add(tableOperation.getCatalogPattern());
                    schemaPatterns.add(tableOperation.getSchemaPattern());
                    tableNamePatterns.add(tableOperation.getTablePattern());
                }
                List<TableType> tables = this.loadTables(catalogPatterns, schemaPatterns, tableNamePatterns);
                for (TableType tableType : tables) {
                    for (TableOperationModel tableOperation : tableOperations) {
                        boolean tableNameMatch = Util.sqlMatch(tableOperation.getTablePattern(), tableType.getTableName());
                        schemaNameMatch = Util.sqlMatch(tableOperation.getSchemaPattern(), tableType.getSchema());
                        if (!tableNameMatch || !schemaNameMatch) continue;
                        String originalCatalogPattern = tableOperation.getCatalogPattern();
                        if (tableType instanceof DbTable && originalCatalogPattern != null) {
                            boolean catalogNameMatch = Util.sqlMatch(originalCatalogPattern, ((DbTable)tableType).getCatalog());
                            if (!catalogNameMatch) continue;
                            tableOperation.getDbTables().add(tableType);
                            continue;
                        }
                        tableOperation.getDbTables().add(tableType);
                    }
                }
                this.dbTables.addAll(tables);
            }
        }
        if (this.dbStoredProcedures.size() == 0) {
            for (OperationModel operation : this.dbwsBuilder.operations) {
                if (!operation.isProcedureOperation()) continue;
                procedureOperations.add((ProcedureOperationModel)operation);
            }
            if (procedureOperations.size() > 0) {
                catalogPatterns = new ArrayList();
                schemaPatterns = new ArrayList();
                ArrayList<String> procedureNamePatterns = new ArrayList<String>();
                for (ProcedureOperationModel procedureOperation : procedureOperations) {
                    catalogPatterns.add(procedureOperation.getCatalogPattern());
                    schemaPatterns.add(procedureOperation.getSchemaPattern());
                    procedureNamePatterns.add(procedureOperation.getProcedurePattern());
                }
                List<ProcedureType> procedures = this.loadProcedures(catalogPatterns, schemaPatterns, procedureNamePatterns);
                for (ProcedureType procedureType : procedures) {
                    for (ProcedureOperationModel procedureOperation : procedureOperations) {
                        boolean procedureNameMatch = Util.sqlMatch(procedureOperation.getProcedurePattern(), procedureType.getProcedureName());
                        schemaNameMatch = true;
                        boolean catalogNameMatch = true;
                        if (procedureNameMatch) {
                            String originalCatalogPattern;
                            String originalSchemaPattern = procedureOperation.getSchemaPattern();
                            if (originalSchemaPattern != null) {
                                schemaNameMatch = Util.sqlMatch(originalSchemaPattern, procedureType.getSchema());
                            }
                            if ((originalCatalogPattern = procedureOperation.getCatalogPattern()) != null) {
                                catalogNameMatch = Util.sqlMatch(originalCatalogPattern, procedureType.getCatalogName());
                            }
                        }
                        if (!procedureNameMatch || !schemaNameMatch || !catalogNameMatch) continue;
                        procedureOperation.getDbStoredProcedures().add(procedureType);
                    }
                }
                this.dbStoredProcedures.addAll(procedures);
            }
        }
    }

    public void buildSchema(NamingConventionTransformer nct) {
        Project oxProject = this.dbwsBuilder.getOxProject();
        Schema schema = null;
        ArrayList<XMLDescriptor> descriptorsToProcess = new ArrayList<XMLDescriptor>();
        for (XMLDescriptor desc : oxProject.getOrderedDescriptors()) {
            String alias = desc.getAlias();
            if ("simple-xml-format".equals(alias)) continue;
            descriptorsToProcess.add(desc);
        }
        if (descriptorsToProcess.size() > 0) {
            StringWriter sw = new StringWriter();
            XMLProjectWriter.write((Project)oxProject, (Writer)sw);
            XRDynamicClassLoader specialLoader = new XRDynamicClassLoader(this.getClass().getClassLoader());
            Project oxProjectClone = XMLProjectReader.read((Reader)new StringReader(sw.toString()), (ClassLoader)specialLoader);
            ProjectHelper.fixOROXAccessors((Project)oxProjectClone, null);
            XMLLogin xmlLogin = new XMLLogin();
            DOMPlatform domPlatform = new DOMPlatform();
            domPlatform.getConversionManager().setLoader((ClassLoader)specialLoader);
            xmlLogin.setPlatform((Platform)domPlatform);
            oxProjectClone.setLogin((Login)xmlLogin);
            oxProjectClone.createDatabaseSession();
            SchemaModelGenerator schemaGenerator = new SchemaModelGenerator(true);
            SchemaModelGeneratorProperties sgProperties = new SchemaModelGeneratorProperties();
            sgProperties.addProperty(this.dbwsBuilder.getTargetNamespace(), "elementFormQualified", (Object)true);
            Map schemaMap = schemaGenerator.generateSchemas(descriptorsToProcess, sgProperties);
            Schema s = (Schema)schemaMap.get(this.dbwsBuilder.getTargetNamespace());
            if (this.dbwsBuilder.getSchema() != null && s != null) {
                Map topLevelComplexTypes = this.dbwsBuilder.getSchema().getTopLevelComplexTypes();
                for (Map.Entry me : topLevelComplexTypes.entrySet()) {
                    s.addTopLevelComplexTypes((ComplexType)me.getValue());
                }
                NamespaceResolver snr = s.getNamespaceResolver();
                NamespaceResolver nr = this.dbwsBuilder.getSchema().getNamespaceResolver();
                for (String prefix : nr.getPrefixesToNamespaces().keySet()) {
                    if (snr.resolveNamespacePrefix(prefix) != null) continue;
                    snr.put(prefix, nr.resolveNamespacePrefix(prefix));
                }
                schema = s;
                schema.setNamespaceResolver(snr);
            }
        } else {
            schema = new Schema();
            Util.addSimpleXMLFormat(schema);
            schema.setTargetNamespace(this.dbwsBuilder.getTargetNamespace());
        }
        this.dbwsBuilder.setSchema(schema);
    }

    public void buildSessionsXML(OutputStream dbwsSessionsStream) {
        if (!Util.isNullStream(dbwsSessionsStream)) {
            this.dbwsBuilder.logMessage(Level.FINEST, "Building " + this.dbwsBuilder.getSessionsFileName());
            SessionConfigs ts = this.dbwsBuilder.getPackager().buildSessionsXML(dbwsSessionsStream, this.dbwsBuilder);
            XMLContext context = new XMLContext((Project)this.sessionConfigProject);
            XMLMarshaller marshaller = context.createMarshaller();
            marshaller.marshal((Object)ts, (Writer)new OutputStreamWriter(dbwsSessionsStream));
            this.dbwsBuilder.getPackager().closeSessionsStream(dbwsSessionsStream);
        }
    }

    public void buildDBWSModel(NamingConventionTransformer nct, OutputStream dbwsServiceStream) {
        Project orProject = this.dbwsBuilder.getOrProject();
        Project oxProject = this.dbwsBuilder.getOxProject();
        if (!Util.isNullStream(dbwsServiceStream)) {
            for (ClassDescriptor desc : orProject.getOrderedDescriptors()) {
                String tablenameAlias = desc.getAlias();
                if (!this.dbwsBuilder.requireCRUDOperations.contains(tablenameAlias)) continue;
                QueryOperation findByPKQueryOperation = new QueryOperation();
                findByPKQueryOperation.setName("findByPrimaryKey_" + tablenameAlias);
                findByPKQueryOperation.setUserDefined(false);
                NamedQueryHandler nqh1 = new NamedQueryHandler();
                nqh1.setName("findByPrimaryKey");
                nqh1.setDescriptor(tablenameAlias);
                Result result = new Result();
                QName theInstanceType = new QName(this.dbwsBuilder.getTargetNamespace(), tablenameAlias, "ns1");
                result.setType(theInstanceType);
                findByPKQueryOperation.setResult(result);
                findByPKQueryOperation.setQueryHandler((QueryHandler)nqh1);
                for (DatabaseField field : desc.getPrimaryKeyFields()) {
                    Parameter p = new Parameter();
                    p.setName(field.getName().toLowerCase());
                    p.setType(Util.getXMLTypeFromJDBCType(field.getSqlType()));
                    findByPKQueryOperation.getParameters().add(p);
                }
                this.dbwsBuilder.xrServiceModel.getOperations().put(findByPKQueryOperation.getName(), findByPKQueryOperation);
                QueryOperation findAllOperation = new QueryOperation();
                findAllOperation.setName("findAll_" + tablenameAlias);
                findAllOperation.setUserDefined(false);
                NamedQueryHandler nqh2 = new NamedQueryHandler();
                nqh2.setName("findAll");
                nqh2.setDescriptor(tablenameAlias);
                CollectionResult result2 = new CollectionResult();
                result2.setType(theInstanceType);
                findAllOperation.setResult((Result)result2);
                findAllOperation.setQueryHandler((QueryHandler)nqh2);
                this.dbwsBuilder.xrServiceModel.getOperations().put(findAllOperation.getName(), findAllOperation);
                InsertOperation insertOperation = new InsertOperation();
                insertOperation.setName("create_" + tablenameAlias);
                Parameter theInstance = new Parameter();
                theInstance.setName("theInstance");
                theInstance.setType(theInstanceType);
                insertOperation.getParameters().add(theInstance);
                this.dbwsBuilder.xrServiceModel.getOperations().put(insertOperation.getName(), insertOperation);
                UpdateOperation updateOperation = new UpdateOperation();
                updateOperation.setName("update_" + tablenameAlias);
                updateOperation.getParameters().add(theInstance);
                this.dbwsBuilder.xrServiceModel.getOperations().put(updateOperation.getName(), updateOperation);
                DeleteOperation deleteOperation = new DeleteOperation();
                deleteOperation.setName("delete_" + tablenameAlias);
                deleteOperation.setDescriptorName(tablenameAlias);
                for (DatabaseField field : desc.getPrimaryKeyFields()) {
                    Parameter p = new Parameter();
                    p.setName(field.getName().toLowerCase());
                    p.setType(Util.getXMLTypeFromJDBCType(field.getSqlType()));
                    deleteOperation.getParameters().add(p);
                }
                this.dbwsBuilder.xrServiceModel.getOperations().put(deleteOperation.getName(), deleteOperation);
            }
            for (OperationModel operation : this.dbwsBuilder.operations) {
                if (operation.isTableOperation()) {
                    TableOperationModel tableModel = (TableOperationModel)operation;
                    if (tableModel.additionalOperations == null || tableModel.additionalOperations.size() <= 0) continue;
                    for (OperationModel additionalOperation : tableModel.additionalOperations) {
                        if (additionalOperation.isSQLOperation() && ((SQLOperationModel)additionalOperation).hasBuildSql()) {
                            this.addToOROXProjectsForSecondarySql((SQLOperationModel)additionalOperation, orProject, oxProject, nct);
                            continue;
                        }
                        additionalOperation.buildOperation(this.dbwsBuilder);
                    }
                    continue;
                }
                operation.buildOperation(this.dbwsBuilder);
            }
            DBWSModelProject modelProject = new DBWSModelProject();
            modelProject.ns.put("ns1", this.dbwsBuilder.getTargetNamespace());
            XMLContext context = new XMLContext((Project)modelProject);
            XMLMarshaller marshaller = context.createMarshaller();
            marshaller.marshal((Object)this.dbwsBuilder.xrServiceModel, dbwsServiceStream);
            this.dbwsBuilder.getPackager().closeServiceStream(dbwsServiceStream);
        }
    }

    public void writeAttachmentSchema(OutputStream swarefStream) {
        if (!Util.isNullStream(swarefStream)) {
            this.dbwsBuilder.logMessage(Level.FINEST, "writing " + Util.WSI_SWAREF_XSD_FILE);
            OutputStreamWriter osw = new OutputStreamWriter(new BufferedOutputStream(swarefStream));
            try {
                osw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<xsd:schema targetNamespace=\"http://ws-i.org/profiles/basic/1.1/xsd\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"> \n  <xsd:simpleType name=\"swaRef\"> \n    <xsd:restriction base=\"xsd:anyURI\"/> \n  </xsd:simpleType> \n</xsd:schema>");
                osw.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.dbwsBuilder.getPackager().closeSWARefStream(swarefStream);
        }
    }

    public void buildWSDL(OutputStream wsdlStream, NamingConventionTransformer nct) throws WSDLException {
        if (!Util.isNullStream(wsdlStream)) {
            this.dbwsBuilder.logMessage(Level.FINEST, "building eclipselink-dbws.wsdl");
            this.dbwsBuilder.wsdlGenerator = new WSDLGenerator(this.dbwsBuilder.xrServiceModel, nct, this.dbwsBuilder.getWsdlLocationURI(), this.dbwsBuilder.getPackager().hasAttachments(), this.dbwsBuilder.getTargetNamespace(), wsdlStream);
            this.dbwsBuilder.wsdlGenerator.generateWSDL(this.dbwsBuilder.usesSOAP12());
            this.dbwsBuilder.getPackager().closeWSDLStream(wsdlStream);
        }
    }

    public void writeWebXML(OutputStream webXmlStream) {
        if (!Util.isNullStream(webXmlStream)) {
            this.dbwsBuilder.logMessage(Level.FINEST, "writing web.xml");
            this.dbwsBuilder.getPackager().writeWebXml(webXmlStream, this.dbwsBuilder);
            this.dbwsBuilder.getPackager().closeWebXmlStream(webXmlStream);
        }
    }

    public void generateDBWSProvider(OutputStream sourceProviderStream, OutputStream classProviderStream, OutputStream sourceProviderListenerStream, OutputStream classProviderListenerStream) {
        if (Util.isNullStream(sourceProviderStream) && Util.isNullStream(classProviderStream) && Util.isNullStream(sourceProviderListenerStream) && Util.isNullStream(classProviderListenerStream)) {
            return;
        }
        if (!Util.isNullStream(sourceProviderStream)) {
            this.dbwsBuilder.logMessage(Level.FINEST, "generating DBWSProvider.java");
        }
        if (!Util.isNullStream(classProviderStream)) {
            this.dbwsBuilder.logMessage(Level.FINEST, "generating DBWSProvider.class");
        }
        this.dbwsBuilder.getPackager().writeProvider(sourceProviderStream, classProviderStream, sourceProviderListenerStream, classProviderListenerStream, this.dbwsBuilder);
        this.dbwsBuilder.getPackager().closeProviderSourceStream(sourceProviderStream);
        this.dbwsBuilder.getPackager().closeProviderClassStream(classProviderStream);
    }

    public void writeSchema(OutputStream dbwsSchemaStream) {
        if (!Util.isNullStream(dbwsSchemaStream)) {
            boolean hasSwaRef;
            SchemaModelProject schemaProject = new SchemaModelProject();
            boolean bl = hasSwaRef = this.dbwsBuilder.getSchema().getNamespaceResolver().resolveNamespacePrefix("ref") != null;
            if (hasSwaRef) {
                XMLDescriptor descriptor = (XMLDescriptor)schemaProject.getClassDescriptor(Schema.class);
                descriptor.getNamespaceResolver().put("ref", "http://ws-i.org/profiles/basic/1.1/xsd");
            }
            XMLContext context = new XMLContext((Project)schemaProject);
            XMLMarshaller marshaller = context.createMarshaller();
            marshaller.marshal((Object)this.dbwsBuilder.getSchema(), dbwsSchemaStream);
            this.dbwsBuilder.getPackager().closeSchemaStream(dbwsSchemaStream);
        }
    }

    public void writeOROXProjects(OutputStream dbwsOrStream, OutputStream dbwsOxStream) {
        Project orProject = this.dbwsBuilder.getOrProject();
        Project oxProject = this.dbwsBuilder.getOxProject();
        boolean writeORProject = false;
        if (this.hasTables() || this.dbwsBuilder.hasBuildSqlOperations()) {
            writeORProject = true;
        } else if (this.hasComplexProcedureArgs()) {
            writeORProject = true;
        }
        if (!writeORProject) {
            if (orProject.getQueries().size() > 0) {
                writeORProject = true;
            } else if (orProject.getDescriptors().size() > 0) {
                Collection descriptors = orProject.getDescriptors().values();
                for (ClassDescriptor desc : descriptors) {
                    if (!desc.isObjectRelationalDataTypeDescriptor()) continue;
                    writeORProject = true;
                    break;
                }
            }
        }
        if (writeORProject && !Util.isNullStream(dbwsOrStream)) {
            XMLContext context = new XMLContext((Project)this.workbenchXMLProject);
            context.getSession((Object)orProject).getEventManager().addListener((SessionEventListener)new MissingDescriptorListener());
            XMLMarshaller marshaller = context.createMarshaller();
            marshaller.marshal((Object)orProject, (Writer)new OutputStreamWriter(dbwsOrStream));
        }
        if (!Util.isNullStream(dbwsOxStream)) {
            boolean writeOXProject = false;
            if (this.hasTables() || this.dbwsBuilder.hasBuildSqlOperations()) {
                writeOXProject = true;
            } else if (this.hasComplexProcedureArgs()) {
                writeOXProject = true;
            }
            if (!writeOXProject) {
                if (orProject.getQueries().size() > 0) {
                    writeOXProject = true;
                } else if (orProject.getDescriptors().size() > 0) {
                    Collection descriptors = orProject.getDescriptors().values();
                    for (ClassDescriptor desc : descriptors) {
                        if (!desc.isObjectRelationalDataTypeDescriptor()) continue;
                        writeOXProject = true;
                        break;
                    }
                }
            }
            if (writeOXProject) {
                XMLContext context = new XMLContext((Project)this.workbenchXMLProject);
                context.getSession((Object)oxProject).getEventManager().addListener((SessionEventListener)new MissingDescriptorListener());
                XMLMarshaller marshaller = context.createMarshaller();
                marshaller.marshal((Object)oxProject, (Writer)new OutputStreamWriter(dbwsOxStream));
            }
        }
        this.dbwsBuilder.getPackager().closeOrStream(dbwsOrStream);
        this.dbwsBuilder.getPackager().closeOxStream(dbwsOxStream);
    }

    protected static ResultSetMetaData getResultSetMetadataForSecondarySQL(Connection connection, String secondarySql) {
        ResultSet resultSet = null;
        try {
            Statement statement = connection.createStatement();
            resultSet = statement.executeQuery(secondarySql);
        }
        catch (SQLException sqlException) {
            throw new IllegalStateException("failure executing secondary SQL: " + secondarySql, sqlException);
        }
        if (resultSet != null) {
            try {
                return resultSet.getMetaData();
            }
            catch (SQLException sqlException) {
                throw new IllegalStateException("failure retrieving resultSet metadata", sqlException);
            }
        }
        return null;
    }

    protected static DirectToFieldMapping setUpDirectToFieldMapping(RelationalDescriptor desc, String columnName, NamingConventionTransformer nct, Class<?> attributeClass, int jdbcType, boolean isPk) {
        DirectToFieldMapping dtfm = new DirectToFieldMapping();
        dtfm.setAttributeClassificationName(attributeClass.getName());
        String fieldName = nct.generateElementAlias(columnName);
        dtfm.setAttributeName(fieldName);
        DatabaseField databaseField = new DatabaseField(columnName, desc.getTableName());
        databaseField.setSqlType(jdbcType);
        dtfm.setField(databaseField);
        if (nct.getOptimisticLockingField() != null && nct.getOptimisticLockingField().equalsIgnoreCase(columnName)) {
            desc.useVersionLocking(columnName, false);
        }
        if (isPk) {
            desc.addPrimaryKeyField(databaseField);
        }
        return dtfm;
    }

    protected XMLDirectMapping setUpXMLDirectMapping(String columnName, QName qName, NamingConventionTransformer nct, Class<?> attributeClass, int jdbcType, boolean isPk) {
        XMLDirectMapping xdm = null;
        boolean binaryAttach = false;
        String attachmentType = null;
        if (XMLConstants.BASE_64_BINARY_QNAME.equals(qName)) {
            attributeClass = ClassConstants.APBYTE;
            block0: for (OperationModel om : this.dbwsBuilder.operations) {
                if (!om.isTableOperation()) continue;
                TableOperationModel tom = (TableOperationModel)om;
                if (tom.getBinaryAttachment()) {
                    binaryAttach = true;
                    if (MTOM_STR.equalsIgnoreCase(tom.getAttachmentType())) {
                        attachmentType = MTOM_STR;
                        break;
                    }
                    attachmentType = SWAREF_STR;
                    break;
                }
                if (tom.additionalOperations == null || tom.additionalOperations.size() <= 0) continue;
                for (OperationModel om2 : tom.additionalOperations) {
                    ProcedureOperationModel pom;
                    if (!om2.isProcedureOperation() || !(pom = (ProcedureOperationModel)om2).getBinaryAttachment()) continue;
                    binaryAttach = true;
                    if (MTOM_STR.equalsIgnoreCase(tom.getAttachmentType())) {
                        attachmentType = MTOM_STR;
                        continue block0;
                    }
                    attachmentType = SWAREF_STR;
                    continue block0;
                }
            }
            if (binaryAttach) {
                xdm = new XMLBinaryDataMapping();
                XMLBinaryDataMapping xbdm = (XMLBinaryDataMapping)xdm;
                if (attachmentType.equals(SWAREF_STR)) {
                    xbdm.setSwaRef(true);
                }
                xbdm.setMimeType("application/octet-stream");
            } else {
                xdm = new XMLDirectMapping();
                SerializedObjectConverter converter = new SerializedObjectConverter((DatabaseMapping)xdm);
                xdm.setConverter((Converter)converter);
            }
        } else {
            xdm = new XMLDirectMapping();
        }
        String fieldName = nct.generateElementAlias(columnName);
        xdm.setAttributeName(fieldName);
        xdm.setAttributeClassificationName(attributeClass.getName());
        String xPath = "";
        NamingConventionTransformer.ElementStyle style = nct.styleForElement(columnName);
        if (style == NamingConventionTransformer.ElementStyle.ATTRIBUTE) {
            xPath = xPath + "@" + fieldName;
        } else if (style == NamingConventionTransformer.ElementStyle.ELEMENT) {
            xPath = xPath + fieldName;
            if (!isPk) {
                AbstractNullPolicy nullPolicy = xdm.getNullPolicy();
                nullPolicy.setNullRepresentedByEmptyNode(false);
                nullPolicy.setMarshalNullRepresentation(XMLNullRepresentationType.XSI_NIL);
                nullPolicy.setNullRepresentedByXsiNil(true);
                xdm.setNullPolicy(nullPolicy);
            }
        }
        if (attributeClass != ClassConstants.APBYTE) {
            xPath = xPath + "/text()";
        }
        xdm.setXPath(xPath);
        XMLField xmlField = (XMLField)xdm.getField();
        xmlField.setSchemaType(qName);
        if (isPk) {
            xmlField.setRequired(true);
        }
        return xdm;
    }

    protected NamingConventionTransformer setUpCustomTransformer(String tableName, NamingConventionTransformer nct) {
        DefaultNamingConventionTransformer customNct = new DefaultNamingConventionTransformer(){

            @Override
            protected boolean isDefaultTransformer() {
                return false;
            }

            @Override
            public String generateSchemaAlias(String tableName) {
                return tableName;
            }
        };
        ((DefaultNamingConventionTransformer)customNct).setNextTransformer(nct);
        return customNct;
    }

    protected void setUpFindQueries(String tableName, RelationalDescriptor desc) {
        ReadObjectQuery roq = new ReadObjectQuery();
        String generatedJavaClassName = Util.getGeneratedJavaClassName(tableName, this.dbwsBuilder.getProjectName());
        roq.setReferenceClassName(generatedJavaClassName);
        Expression expression = null;
        ExpressionBuilder builder = new ExpressionBuilder();
        List primaryKeyFields = desc.getPrimaryKeyFields();
        for (int index = 0; index < primaryKeyFields.size(); ++index) {
            DatabaseField primaryKeyField = (DatabaseField)primaryKeyFields.get(index);
            Expression subExp1 = builder.getField(primaryKeyField);
            Expression subExp2 = builder.getParameter(primaryKeyField.getName().toLowerCase());
            Expression subExpression = subExp1.equal(subExp2);
            expression = expression == null ? subExpression : expression.and(subExpression);
            roq.addArgument(primaryKeyField.getName().toLowerCase());
        }
        roq.setSelectionCriteria(expression);
        desc.getQueryManager().addQuery("findByPrimaryKey", (DatabaseQuery)roq);
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClassName(generatedJavaClassName);
        desc.getQueryManager().addQuery("findAll", (DatabaseQuery)raq);
    }

    protected void finishUpProjects(Project orProject, Project oxProject) {
        for (OperationModel opModel : this.dbwsBuilder.operations) {
            if (!opModel.isSQLOperation() || !((SQLOperationModel)opModel).hasBuildSql()) continue;
            this.addToOROXProjectsForSecondarySql((SQLOperationModel)opModel, orProject, oxProject, this.nct);
        }
        for (OperationModel opModel : this.dbwsBuilder.operations) {
            ProcedureOperationModel procedureOperation;
            if (!opModel.isProcedureOperation() || !(procedureOperation = (ProcedureOperationModel)opModel).isPLSQLProcedureOperation() && !procedureOperation.isAdvancedJDBCProcedureOperation()) continue;
            for (ProcedureType procType : procedureOperation.getDbStoredProcedures()) {
                List<ArgumentType> args = this.getArgumentListForProcedureType(procType);
                boolean hasComplexArgs = Util.hasComplexArgs(args);
                boolean hasPLSQLArgs = Util.hasPLSQLArgs(args);
                boolean hasPLSQLScalarArgs = Util.hasPLSQLScalarArgs(args);
                if (!procedureOperation.hasComplexArguments) {
                    procedureOperation.setHasComplexArguments(hasComplexArgs);
                }
                if (!hasComplexArgs && !hasPLSQLScalarArgs) continue;
                this.addToOROXProjectsForComplexArgs(args, orProject, oxProject, procedureOperation);
                this.buildQueryForProcedureType(procType, orProject, oxProject, procedureOperation, hasPLSQLArgs);
            }
        }
        DatabaseLogin databaseLogin = new DatabaseLogin();
        databaseLogin.removeProperty("user");
        databaseLogin.removeProperty("password");
        databaseLogin.setDriverClassName(null);
        databaseLogin.setConnectionString(null);
        orProject.setLogin(databaseLogin);
        XMLLogin xmlLogin = new XMLLogin();
        xmlLogin.setDatasourcePlatform((Platform)new DOMPlatform());
        xmlLogin.getProperties().remove("user");
        xmlLogin.getProperties().remove("password");
        oxProject.setLogin((Login)xmlLogin);
        this.dbwsBuilder.setOrProject(orProject);
        this.dbwsBuilder.setOxProject(oxProject);
    }

    protected static List<DbColumn> buildDbColumns(Connection connection, String secondarySql) {
        ArrayList<DbColumn> columns = null;
        ResultSetMetaData rsMetaData = BaseDBWSBuilderHelper.getResultSetMetadataForSecondarySQL(connection, secondarySql);
        if (rsMetaData != null) {
            int columnCount = 0;
            try {
                columnCount = rsMetaData.getColumnCount();
            }
            catch (SQLException sqlException) {
                throw new IllegalStateException("failure retrieving columnCount", sqlException);
            }
            if (columnCount > 0) {
                columns = new ArrayList<DbColumn>(columnCount);
                try {
                    for (int i = 1; i <= columnCount; ++i) {
                        String dbColumnName = rsMetaData.getColumnLabel(i);
                        DbColumn dbColumn = new DbColumn(dbColumnName);
                        dbColumn.setJDBCType(rsMetaData.getColumnType(i));
                        dbColumn.setJDBCTypeName(rsMetaData.getColumnTypeName(i));
                        int dbPrecision = rsMetaData.getPrecision(i);
                        int dbScale = rsMetaData.getScale(i);
                        dbColumn.setDataType(BaseDBWSBuilderHelper.buildTypeForJDBCType(dbColumn.getJDBCType(), dbPrecision, dbScale));
                        if (rsMetaData.isNullable(i) == 1) {
                            dbColumn.unSetNotNull();
                        } else {
                            dbColumn.setNotNull();
                        }
                        columns.add(dbColumn);
                    }
                }
                catch (SQLException sqlException) {
                    throw new IllegalStateException("failure retrieving column information", sqlException);
                }
            }
        }
        return columns;
    }

    protected static String getTypeNameForDatabaseType(org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType dataType) {
        NumericType numericDataType;
        String typeName = dataType.getTypeName();
        if (dataType instanceof NumericType && (numericDataType = (NumericType)dataType).getScale() > 0L) {
            typeName = DECIMAL_STR;
        }
        return typeName;
    }

    protected static org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType buildTypeForJDBCType(int jdbcType, int precision, int scale) {
        VarChar2Type type = new VarChar2Type();
        switch (jdbcType) {
            case -2: {
                type = new BinaryType();
                break;
            }
            case 2004: {
                type = new BlobType();
                break;
            }
            case 1: {
                type = new CharType();
                break;
            }
            case 2005: {
                type = new ClobType();
                break;
            }
            case 91: {
                type = ScalarDatabaseTypeEnum.DATE_TYPE;
                break;
            }
            case -5: {
                type = ScalarDatabaseTypeEnum.BIGINT_TYPE;
                break;
            }
            case 2: 
            case 3: {
                type = new DecimalType((long)precision, (long)scale);
                break;
            }
            case 8: {
                type = new DoubleType((long)precision, (long)scale);
                break;
            }
            case 6: {
                type = new FloatType((long)precision, (long)scale);
                break;
            }
            case -4: {
                type = new LongRawType();
                break;
            }
            case -15: {
                type = new NCharType();
                break;
            }
            case 2011: {
                type = new NClobType();
                break;
            }
            case 7: {
                type = new RealType((long)precision, (long)scale);
                break;
            }
            case 92: {
                type = ScalarDatabaseTypeEnum.TIME_TYPE;
                break;
            }
            case 93: {
                type = new TimeStampType();
                break;
            }
            case -3: {
                type = new RawType();
            }
        }
        return type;
    }

    protected DatabaseType buildDatabaseTypeFromMetadataType(org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType dType) {
        return this.buildDatabaseTypeFromMetadataType(dType, null);
    }

    protected DatabaseType buildDatabaseTypeFromMetadataType(org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType dType, String catalog) {
        if (dType instanceof ArgumentType) {
            dType = ((ArgumentType)dType).getDataType();
        }
        if (dType.isComposite()) {
            String typeName = dType.getTypeName();
            String compatibleType = dType.getTypeName();
            String javaTypeName = dType.getTypeName().toLowerCase();
            if (dType instanceof PLSQLType) {
                if (catalog != null) {
                    typeName = (catalog + ".").concat(typeName);
                    compatibleType = (catalog + "_").concat(compatibleType);
                    javaTypeName = (catalog.toLowerCase() + ".").concat(javaTypeName);
                }
                if (dType instanceof PLSQLRecordType) {
                    PLSQLrecord plsqlRec = new PLSQLrecord();
                    plsqlRec.setTypeName(typeName);
                    plsqlRec.setCompatibleType(compatibleType);
                    plsqlRec.setJavaTypeName(javaTypeName);
                    for (FieldType fld : ((PLSQLRecordType)dType).getFields()) {
                        if (fld.getDataType() instanceof PrecisionType) {
                            PrecisionType precisionType = (PrecisionType)fld.getDataType();
                            plsqlRec.addField(fld.getFieldName(), this.buildDatabaseTypeFromMetadataType((org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType)precisionType), (int)precisionType.getPrecision(), (int)precisionType.getScale());
                            continue;
                        }
                        if (fld.getDataType() instanceof SizedType) {
                            SizedType sizedType = (SizedType)fld.getDataType();
                            plsqlRec.addField(fld.getFieldName(), this.buildDatabaseTypeFromMetadataType((org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType)sizedType), (int)sizedType.getSize());
                            continue;
                        }
                        plsqlRec.addField(fld.getFieldName(), this.buildDatabaseTypeFromMetadataType(fld.getDataType(), catalog));
                    }
                    return plsqlRec;
                }
                PLSQLCollection plsqlCollection = new PLSQLCollection();
                plsqlCollection.setTypeName(typeName);
                plsqlCollection.setCompatibleType(compatibleType);
                plsqlCollection.setJavaTypeName(javaTypeName + "_CollectionWrapper");
                plsqlCollection.setNestedType(this.buildDatabaseTypeFromMetadataType(((PLSQLCollectionType)dType).getNestedType(), catalog));
                return plsqlCollection;
            }
            if (dType instanceof VArrayType) {
                OracleArrayType varray = new OracleArrayType();
                varray.setTypeName(typeName);
                varray.setCompatibleType(compatibleType);
                varray.setJavaTypeName(Util.getGeneratedWrapperClassName(javaTypeName, this.dbwsBuilder.getProjectName()));
                varray.setNestedType(this.buildDatabaseTypeFromMetadataType(((VArrayType)dType).getEnclosedType(), null));
                return varray;
            }
            if (dType instanceof ObjectType) {
                OracleObjectType objType = new OracleObjectType();
                objType.setTypeName(typeName);
                objType.setCompatibleType(compatibleType);
                objType.setJavaTypeName(Util.getGeneratedJavaClassName(javaTypeName, this.dbwsBuilder.getProjectName()));
                Map fields = objType.getFields();
                ObjectType oType = (ObjectType)dType;
                for (FieldType field : oType.getFields()) {
                    fields.put(field.getFieldName(), this.buildDatabaseTypeFromMetadataType(field.getDataType()));
                }
                return objType;
            }
            if (dType instanceof ObjectTableType) {
                OracleArrayType tableType = new OracleArrayType();
                tableType.setTypeName(typeName);
                tableType.setCompatibleType(compatibleType);
                tableType.setJavaTypeName(Util.getGeneratedWrapperClassName(javaTypeName, this.dbwsBuilder.getProjectName()));
                DatabaseType nestedType = this.buildDatabaseTypeFromMetadataType(((ObjectTableType)dType).getEnclosedType(), null);
                Class wrapper = this.getWrapperClass(nestedType);
                if (wrapper != null) {
                    ((ComplexDatabaseType)nestedType).setJavaType(wrapper);
                }
                tableType.setNestedType(nestedType);
                return tableType;
            }
            return null;
        }
        if (dType instanceof ScalarDatabaseTypeEnum) {
            return OraclePLSQLTypes.getDatabaseTypeForCode((String)((ScalarDatabaseTypeEnum)dType).getTypeName());
        }
        return JDBCTypes.getDatabaseTypeForCode((int)Util.getJDBCTypeFromTypeName(dType.getTypeName()));
    }

    public static Class<?> getAttributeClassForDatabaseType(org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType dbType) {
        if (!dbType.isComposite()) {
            String typeName = dbType.getTypeName();
            if (NUMBER_STR.equals(typeName) || "NUMERIC".equals(typeName)) {
                return ClassConstants.BIGDECIMAL;
            }
            if (INTEGER_STR.equals(typeName)) {
                return ClassConstants.INTEGER;
            }
            if (BOOLEAN_STR.equals(typeName)) {
                return ClassConstants.BOOLEAN;
            }
            if (DATE_STR.equals(typeName)) {
                return ClassConstants.JavaSqlDate_Class;
            }
        }
        return ClassConstants.STRING;
    }

    protected void handleSimpleXMLFormat(boolean isSimpleXMLFormat, Result result, ProcedureOperationModel procedureOperationModel) {
        if (isSimpleXMLFormat) {
            String xmlTag;
            SimpleXMLFormat sxf = new SimpleXMLFormat();
            String simpleXMLFormatTag = procedureOperationModel.getSimpleXMLFormatTag();
            if (simpleXMLFormatTag != null && simpleXMLFormatTag.length() > 0) {
                sxf.setSimpleXMLFormatTag(simpleXMLFormatTag);
            }
            if ((xmlTag = procedureOperationModel.getXmlTag()) != null && xmlTag.length() > 0) {
                sxf.setXMLTag(xmlTag);
            }
            result.setSimpleXMLFormat(sxf);
            if (this.dbwsBuilder.getOxProject().getDescriptorForAlias("simple-xml-format") == null) {
                SimpleXMLFormatProject sxfProject = new SimpleXMLFormatProject();
                this.dbwsBuilder.getOxProject().addDescriptor(sxfProject.buildXRRowSetModelDescriptor());
            }
        }
    }

    protected void finishProcedureOperation() {
        if (Util.requiresSimpleXMLFormat(this.dbwsBuilder.getXrServiceModel()) && this.dbwsBuilder.getSchema().getTopLevelElements().get("simple-xml-format") == null) {
            Util.addSimpleXMLFormat(this.dbwsBuilder.getSchema());
        }
    }

    protected List<ArgumentType> getArgumentListForProcedureType(ProcedureType pType) {
        ArrayList<ArgumentType> args = new ArrayList<ArgumentType>();
        if (pType.isFunction()) {
            args.add(((FunctionType)pType).getReturnArgument());
        }
        args.addAll(pType.getArguments());
        return args;
    }

    protected Class getWrapperClass(DatabaseType databaseType) {
        if (databaseType instanceof ComplexDatabaseType) {
            return this.getWrapperClass(((ComplexDatabaseType)databaseType).getJavaTypeName());
        }
        return null;
    }

    protected Class getWrapperClass(String wrapperClassName) {
        Class wrapperClass = null;
        try {
            wrapperClass = new XRDynamicClassLoader(this.getClass().getClassLoader()).loadClass(wrapperClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return wrapperClass;
    }
}

