/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.internal.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.jpa.jpql.LiteralType;
import org.eclipse.persistence.jpa.jpql.parser.AbsExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSelectClause;
import org.eclipse.persistence.jpa.jpql.parser.AdditionExpression;
import org.eclipse.persistence.jpa.jpql.parser.AvgFunction;
import org.eclipse.persistence.jpa.jpql.parser.CaseExpression;
import org.eclipse.persistence.jpa.jpql.parser.CoalesceExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConcatExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConstructorExpression;
import org.eclipse.persistence.jpa.jpql.parser.CountFunction;
import org.eclipse.persistence.jpa.jpql.parser.DateTime;
import org.eclipse.persistence.jpa.jpql.parser.DivisionExpression;
import org.eclipse.persistence.jpa.jpql.parser.EclipseLinkAnonymousExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.EntryExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.FuncExpression;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.IndexExpression;
import org.eclipse.persistence.jpa.jpql.parser.Join;
import org.eclipse.persistence.jpa.jpql.parser.KeyExpression;
import org.eclipse.persistence.jpa.jpql.parser.KeywordExpression;
import org.eclipse.persistence.jpa.jpql.parser.LengthExpression;
import org.eclipse.persistence.jpa.jpql.parser.LocateExpression;
import org.eclipse.persistence.jpa.jpql.parser.LowerExpression;
import org.eclipse.persistence.jpa.jpql.parser.MaxFunction;
import org.eclipse.persistence.jpa.jpql.parser.MinFunction;
import org.eclipse.persistence.jpa.jpql.parser.ModExpression;
import org.eclipse.persistence.jpa.jpql.parser.MultiplicationExpression;
import org.eclipse.persistence.jpa.jpql.parser.NullIfExpression;
import org.eclipse.persistence.jpa.jpql.parser.NumericLiteral;
import org.eclipse.persistence.jpa.jpql.parser.ObjectExpression;
import org.eclipse.persistence.jpa.jpql.parser.ResultVariable;
import org.eclipse.persistence.jpa.jpql.parser.SelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SizeExpression;
import org.eclipse.persistence.jpa.jpql.parser.SqrtExpression;
import org.eclipse.persistence.jpa.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.StringLiteral;
import org.eclipse.persistence.jpa.jpql.parser.SubExpression;
import org.eclipse.persistence.jpa.jpql.parser.SubstringExpression;
import org.eclipse.persistence.jpa.jpql.parser.SubtractionExpression;
import org.eclipse.persistence.jpa.jpql.parser.SumFunction;
import org.eclipse.persistence.jpa.jpql.parser.TreatExpression;
import org.eclipse.persistence.jpa.jpql.parser.TrimExpression;
import org.eclipse.persistence.jpa.jpql.parser.TypeExpression;
import org.eclipse.persistence.jpa.jpql.parser.UpperExpression;
import org.eclipse.persistence.jpa.jpql.parser.ValueExpression;
import org.eclipse.persistence.queries.ReportQuery;

final class ReportItemBuilder
extends EclipseLinkAnonymousExpressionVisitor {
    private ConstructorExpressionVisitor constructorExpressionVisitor;
    private boolean multipleSelects;
    ReportQuery query;
    private final JPQLQueryContext queryContext;
    Class<?>[] type = new Class[1];

    ReportItemBuilder(JPQLQueryContext queryContext) {
        this.queryContext = queryContext;
    }

    private ConstructorExpressionVisitor constructorExpressionVisitor() {
        if (this.constructorExpressionVisitor == null) {
            this.constructorExpressionVisitor = new ConstructorExpressionVisitor();
        }
        return this.constructorExpressionVisitor;
    }

    public void visit(AbsExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.query.addAttribute("", queryExpression, this.type[0]);
    }

    public void visit(AdditionExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        if (this.type[0] == Object.class) {
            this.type[0] = null;
        }
        this.query.addAttribute("plus", queryExpression, this.type[0]);
    }

    public void visit(AvgFunction expression) {
        StateFieldPathExpression pathExpression = (StateFieldPathExpression)expression.getExpression();
        String name = pathExpression.getPath(pathExpression.pathSize() - 1);
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.query.addAttribute(name, queryExpression, this.type[0]);
    }

    public void visit(CaseExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.query.addAttribute("Case", queryExpression, this.type[0]);
    }

    public void visit(CoalesceExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.query.addAttribute("Coalesce", queryExpression);
    }

    public void visit(CollectionExpression expression) {
        this.multipleSelects = true;
        for (Expression child : expression.children()) {
            child.accept(this);
            this.type[0] = null;
        }
    }

    public void visit(ConcatExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.query.addAttribute("", queryExpression, this.type[0]);
    }

    public void visit(ConstructorExpression expression) {
        Class<?> type = this.queryContext.getType(expression.getClassName());
        this.query.beginAddingConstructorArguments(type);
        expression.accept(this.constructorExpressionVisitor());
        this.query.endAddingToConstructorItem();
    }

    public void visit(CountFunction expression) {
        String name = this.queryContext.literal(expression.getExpression(), LiteralType.PATH_EXPRESSION_LAST_PATH);
        if (name == "") {
            name = "COUNT";
        }
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.query.addAttribute(name, queryExpression, this.type[0]);
    }

    public void visit(DateTime expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        if (expression.isJDBCDate()) {
            this.query.addAttribute("CONSTANT", queryExpression);
        } else {
            this.query.addAttribute("date", queryExpression, this.type[0]);
        }
    }

    public void visit(DivisionExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        if (this.type[0] == Object.class) {
            this.type[0] = null;
        }
        this.query.addAttribute("divide", queryExpression, this.type[0]);
    }

    public void visit(EntryExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.query.addAttribute(" MapEntry", queryExpression);
    }

    public void visit(FuncExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.query.addAttribute("", queryExpression);
    }

    public void visit(IdentificationVariable expression) {
        String variableName = expression.getVariableName();
        ArrayList<org.eclipse.persistence.expressions.Expression> joinFetchExpressions = null;
        Collection<Join> joinFetches = this.queryContext.getJoinFetches(variableName);
        if (joinFetches != null) {
            for (Join joinFetch : joinFetches) {
                String joinFetchVariableName = this.queryContext.literal(joinFetch, LiteralType.PATH_EXPRESSION_IDENTIFICATION_VARIABLE);
                if (!variableName.equals(joinFetchVariableName)) continue;
                if (joinFetchExpressions == null) {
                    joinFetchExpressions = new ArrayList<org.eclipse.persistence.expressions.Expression>();
                }
                joinFetchExpressions.add(this.queryContext.buildExpression(joinFetch, this.type));
            }
        }
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        if (joinFetchExpressions == null) {
            this.query.addAttribute(expression.getText(), queryExpression);
        } else {
            this.query.addItem(expression.getText(), queryExpression, joinFetchExpressions);
        }
    }

    public void visit(IndexExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.query.addAttribute("Index", queryExpression, this.type[0]);
    }

    public void visit(KeyExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.query.addAttribute("MapKey", queryExpression);
    }

    public void visit(KeywordExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.query.addAttribute("CONSTANT", queryExpression);
    }

    public void visit(LengthExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.query.addAttribute("", queryExpression, this.type[0]);
    }

    public void visit(LocateExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.query.addAttribute("", queryExpression, this.type[0]);
    }

    public void visit(LowerExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.query.addAttribute("", queryExpression, this.type[0]);
    }

    public void visit(MaxFunction expression) {
        StateFieldPathExpression pathExpression = (StateFieldPathExpression)expression.getExpression();
        String name = pathExpression.getPath(pathExpression.pathSize() - 1);
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.query.addAttribute(name, queryExpression);
    }

    public void visit(MinFunction expression) {
        StateFieldPathExpression pathExpression = (StateFieldPathExpression)expression.getExpression();
        String name = pathExpression.getPath(pathExpression.pathSize() - 1);
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.query.addAttribute(name, queryExpression);
    }

    public void visit(ModExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.query.addAttribute("", queryExpression, this.type[0]);
    }

    public void visit(MultiplicationExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        if (this.type[0] == Object.class) {
            this.type[0] = null;
        }
        this.query.addAttribute("multiply", queryExpression, this.type[0]);
    }

    public void visit(NullIfExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.query.addAttribute("NULLIF", queryExpression);
    }

    public void visit(NumericLiteral expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.query.addAttribute("CONSTANT", queryExpression);
    }

    public void visit(ObjectExpression expression) {
        expression.getExpression().accept(this);
    }

    protected void visit(Expression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.query.addAttribute("", queryExpression);
    }

    public void visit(ResultVariable expression) {
        expression.getSelectExpression().accept(this);
        IdentificationVariable identificationVariable = (IdentificationVariable)expression.getResultVariable();
        String variableName = identificationVariable.getVariableName();
        List<ReportItem> items = this.query.getItems();
        ReportItem lastItem = items.get(items.size() - 1);
        this.queryContext.addQueryExpression(variableName, lastItem.getAttributeExpression());
    }

    public void visit(SelectClause expression) {
        this.visitAbstractSelectClause(expression);
    }

    public void visit(SimpleSelectClause expression) {
        this.visitAbstractSelectClause(expression);
    }

    public void visit(SizeExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression.getExpression());
        this.query.addAttribute("size", queryExpression.count(), Integer.class);
        CollectionValuedPathExpression pathExpression = (CollectionValuedPathExpression)expression.getExpression();
        queryExpression = this.queryContext.buildGroupByExpression(pathExpression);
        this.query.addGrouping(queryExpression);
    }

    public void visit(SqrtExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.query.addAttribute("", queryExpression, this.type[0]);
    }

    public void visit(StateFieldPathExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildModifiedPathExpression(expression);
        String name = expression.getPath(expression.pathSize() - 1);
        this.query.addAttribute(name, queryExpression);
        this.query.dontRetrievePrimaryKeys();
    }

    public void visit(StringLiteral expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.query.addAttribute("CONSTANT", queryExpression);
    }

    public void visit(SubExpression expression) {
        expression.getExpression().accept(this);
    }

    public void visit(SubstringExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.query.addAttribute("", queryExpression, this.type[0]);
    }

    public void visit(SubtractionExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        if (this.type[0] == Object.class) {
            this.type[0] = null;
        }
        this.query.addAttribute("minus", queryExpression, this.type[0]);
    }

    public void visit(SumFunction expression) {
        StateFieldPathExpression pathExpression = (StateFieldPathExpression)expression.getExpression();
        String name = pathExpression.getPath(pathExpression.pathSize() - 1);
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.query.addAttribute(name, queryExpression, this.type[0]);
    }

    public void visit(TreatExpression expression) {
    }

    public void visit(TrimExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.query.addAttribute("", queryExpression, this.type[0]);
    }

    public void visit(TypeExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.query.addAttribute("", queryExpression);
    }

    public void visit(UpperExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.query.addAttribute("", queryExpression, this.type[0]);
    }

    public void visit(ValueExpression expression) {
        IdentificationVariable identificationVariable = (IdentificationVariable)expression.getExpression();
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.query.addAttribute(identificationVariable.getText(), queryExpression);
    }

    private void visitAbstractSelectClause(AbstractSelectClause expression) {
        this.multipleSelects = false;
        expression.getSelectExpression().accept(this);
        if (this.multipleSelects) {
            this.query.returnWithoutReportQueryResult();
        } else {
            this.query.returnSingleAttribute();
        }
    }

    private class ConstructorExpressionVisitor
    extends EclipseLinkAnonymousExpressionVisitor {
        private ConstructorExpressionVisitor() {
        }

        public void visit(CollectionExpression expression) {
            expression.acceptChildren(this);
        }

        public void visit(ConstructorExpression expression) {
            expression.getConstructorItems().accept(this);
        }

        protected void visit(Expression expression) {
            expression.accept(ReportItemBuilder.this);
        }
    }
}

