/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql.spi;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.jpa.jpql.spi.JavaManagedType;
import org.eclipse.persistence.internal.jpa.jpql.spi.JavaManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.spi.IEntity;
import org.eclipse.persistence.jpa.jpql.spi.IManagedTypeVisitor;
import org.eclipse.persistence.jpa.jpql.spi.IQuery;
import org.eclipse.persistence.jpa.jpql.spi.java.JavaQuery;
import org.eclipse.persistence.queries.DatabaseQuery;

final class JavaEntity
extends JavaManagedType
implements IEntity {
    JavaEntity(JavaManagedTypeProvider provider, ClassDescriptor descriptor) {
        super(provider, descriptor);
    }

    public void accept(IManagedTypeVisitor visitor) {
        visitor.visit(this);
    }

    private IQuery buildQuery(DatabaseQuery query) {
        return new JavaQuery(this.getProvider(), query.getEJBQLString());
    }

    public String getName() {
        String name = this.getDescriptor().getAlias();
        if (ExpressionTools.stringIsEmpty(name)) {
            name = this.getDescriptor().getJavaClass().getSimpleName();
        }
        return name;
    }

    public IQuery getNamedQuery(String queryName) {
        DatabaseQuery query = this.getProvider().getSession().getQuery(queryName);
        return query == null ? null : this.buildQuery(query);
    }
}

