/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql.spi;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.jpa.jpql.spi.AbstractMapping;
import org.eclipse.persistence.internal.jpa.jpql.spi.JavaManagedTypeProvider;
import org.eclipse.persistence.internal.jpa.jpql.spi.JavaMapping;
import org.eclipse.persistence.internal.jpa.jpql.spi.JavaQueryKey;
import org.eclipse.persistence.jpa.jpql.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.util.iterator.CloneIterator;
import org.eclipse.persistence.jpa.jpql.util.iterator.IterableIterator;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.querykeys.QueryKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class JavaManagedType
implements IManagedType {
    private ClassDescriptor descriptor;
    private boolean initialized;
    private Map<String, IMapping> mappings;
    private JavaManagedTypeProvider provider;
    private IType type;

    JavaManagedType(JavaManagedTypeProvider provider, ClassDescriptor descriptor) {
        this.provider = provider;
        this.descriptor = descriptor;
        this.mappings = new HashMap<String, IMapping>();
    }

    private IType buildType() {
        return this.provider.getTypeRepository().getType(this.descriptor.getJavaClass());
    }

    @Override
    public final int compareTo(IManagedType managedType) {
        return this.getType().getName().compareTo(managedType.getType().getName());
    }

    final ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public final IMapping getMappingNamed(String name) {
        IMapping mapping = this.mappings.get(name);
        if (mapping == null) {
            QueryKey queryKey;
            DatabaseMapping databaseMapping = this.descriptor.getMappingForAttributeName(name);
            if (databaseMapping != null) {
                mapping = new JavaMapping(this, databaseMapping);
                this.mappings.put(name, mapping);
            }
            if (mapping == null && (queryKey = this.descriptor.getQueryKeyNamed(name)) != null) {
                mapping = new JavaQueryKey(this, queryKey);
                this.mappings.put(name, mapping);
            }
        }
        return mapping;
    }

    @Override
    public final JavaManagedTypeProvider getProvider() {
        return this.provider;
    }

    @Override
    public final IType getType() {
        if (this.type == null) {
            this.type = this.buildType();
        }
        return this.type;
    }

    private void initializeMappings() {
        if (!this.initialized) {
            AbstractMapping mapping;
            this.initialized = true;
            for (DatabaseMapping databaseMapping : this.descriptor.getMappings()) {
                mapping = new JavaMapping(this, databaseMapping);
                this.mappings.put(databaseMapping.getAttributeName(), mapping);
            }
            for (QueryKey queryKey : this.descriptor.getQueryKeys().values()) {
                mapping = new JavaQueryKey(this, queryKey);
                this.mappings.put(queryKey.getName(), mapping);
            }
        }
    }

    @Override
    public IterableIterator<IMapping> mappings() {
        this.initializeMappings();
        return new CloneIterator<IMapping>(this.mappings.values());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("type=");
        sb.append(this.descriptor.getJavaClassName());
        return sb.toString();
    }
}

