/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.columns.AssociationOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.AttributeOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.mappings.AggregateMapping;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.EmbeddableMapping;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeObjectMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedAccessor
extends MappingAccessor {
    private List<AssociationOverrideMetadata> m_associationOverrides = new ArrayList<AssociationOverrideMetadata>();
    private List<AttributeOverrideMetadata> m_attributeOverrides = new ArrayList<AttributeOverrideMetadata>();

    public EmbeddedAccessor() {
        super("<embedded>");
    }

    protected EmbeddedAccessor(String xmlElement) {
        super(xmlElement);
    }

    public EmbeddedAccessor(MetadataAnnotation embedded, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(embedded, accessibleObject, classAccessor);
        int n;
        int n2;
        Object[] objectArray;
        if (this.isAnnotationPresent(AttributeOverrides.class)) {
            objectArray = (Object[])this.getAnnotation(AttributeOverrides.class).getAttributeArray("value");
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                Object attributeOverride = objectArray[n];
                this.m_attributeOverrides.add(new AttributeOverrideMetadata((MetadataAnnotation)attributeOverride, this));
                ++n;
            }
        }
        if (this.isAnnotationPresent(AttributeOverride.class)) {
            this.m_attributeOverrides.add(new AttributeOverrideMetadata(this.getAnnotation(AttributeOverride.class), this));
        }
        if (this.isAnnotationPresent(AssociationOverrides.class)) {
            objectArray = (Object[])this.getAnnotation(AssociationOverrides.class).getAttributeArray("value");
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                Object associationOverride = objectArray[n];
                this.m_associationOverrides.add(new AssociationOverrideMetadata((MetadataAnnotation)associationOverride, this));
                ++n;
            }
        }
        if (this.isAnnotationPresent(AssociationOverride.class)) {
            this.m_associationOverrides.add(new AssociationOverrideMetadata(this.getAnnotation(AssociationOverride.class), this));
        }
    }

    public void addMapsIdAccessor(MappingAccessor mapsIdAccessor) {
        ((AggregateObjectMapping)this.getMapping()).addMapsIdMapping(mapsIdAccessor.getMapping());
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof EmbeddedAccessor) {
            EmbeddedAccessor embeddedAccessor = (EmbeddedAccessor)objectToCompare;
            if (!this.valuesMatch(this.m_associationOverrides, embeddedAccessor.getAssociationOverrides())) {
                return false;
            }
            return this.valuesMatch(this.m_attributeOverrides, embeddedAccessor.getAttributeOverrides());
        }
        return false;
    }

    public List<AssociationOverrideMetadata> getAssociationOverrides() {
        return this.m_associationOverrides;
    }

    public List<AttributeOverrideMetadata> getAttributeOverrides() {
        return this.m_attributeOverrides;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObjects(this.m_attributeOverrides, accessibleObject);
        this.initXMLObjects(this.m_associationOverrides, accessibleObject);
    }

    @Override
    public boolean isEmbedded() {
        return true;
    }

    @Override
    public void process() {
        AggregateMapping mapping = this.getOwningDescriptor().getClassDescriptor().newAggregateMapping();
        this.setMapping(mapping);
        mapping.setReferenceClassName(this.getReferenceClassName());
        mapping.setAttributeName(this.getAttributeName());
        this.setAccessorMethods(mapping);
        if (mapping.isAggregateObjectMapping()) {
            AggregateObjectMapping aggregateMapping = (AggregateObjectMapping)mapping;
            aggregateMapping.setIsNullAllowed(true);
            this.processAttributeOverrides(this.m_attributeOverrides, aggregateMapping, this.getReferenceDescriptor());
            this.processAssociationOverrides(this.m_associationOverrides, aggregateMapping, this.getReferenceDescriptor());
        } else if (mapping.isAbstractCompositeObjectMapping()) {
            ((AbstractCompositeObjectMapping)mapping).setField(this.getDatabaseField(this.getDescriptor().getPrimaryTable(), "metadata_default_column"));
        }
        this.processReturnInsertAndUpdate();
    }

    public void setAssociationOverrides(List<AssociationOverrideMetadata> associationOverrides) {
        this.m_associationOverrides = associationOverrides;
    }

    public void setAttributeOverrides(List<AttributeOverrideMetadata> attributeOverrides) {
        this.m_attributeOverrides = attributeOverrides;
    }

    protected void updateDerivedIdField(EmbeddableMapping embeddableMapping, String overrideName, DatabaseField overrideField, MappingAccessor mappingAccessor) {
        this.addFieldNameTranslation(embeddableMapping, overrideName, overrideField, mappingAccessor);
        this.updatePrimaryKeyField(mappingAccessor, overrideField);
    }
}

