/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.nosql;

import org.eclipse.persistence.annotations.DataFormatType;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.eis.EISDescriptor;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;

public class NoSqlMetadata
extends ORMetadata {
    private String dataType;
    private String dataFormat;

    public NoSqlMetadata() {
        super("<eis>");
    }

    public NoSqlMetadata(MetadataAnnotation struct, MetadataAccessor accessor) {
        super(struct, accessor);
        this.dataType = (String)struct.getAttribute("dataType");
        this.dataFormat = (String)struct.getAttribute("dataFormat");
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(String dataFormat) {
        this.dataFormat = dataFormat;
    }

    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof NoSqlMetadata) {
            NoSqlMetadata eis = (NoSqlMetadata)objectToCompare;
            if (!this.valuesMatch(this.dataType, eis.getDataType())) {
                return false;
            }
            return this.valuesMatch(this.dataFormat, eis.getDataFormat());
        }
        return false;
    }

    public void process(MetadataDescriptor descriptor) {
        ClassDescriptor oldDesriptor = descriptor.getClassDescriptor();
        EISDescriptor newDescriptor = new EISDescriptor();
        newDescriptor.setJavaClassName(oldDesriptor.getJavaClassName());
        if (this.dataType != null) {
            newDescriptor.setDataTypeName(this.getDataType());
        } else {
            String defaultName = Helper.getShortClassName(descriptor.getJavaClassName());
            defaultName = this.getProject().useDelimitedIdentifier() ? defaultName : defaultName.toUpperCase();
            newDescriptor.setDataTypeName(defaultName);
        }
        if (this.dataFormat != null) {
            if (this.dataFormat.equals(DataFormatType.XML.name())) {
                newDescriptor.setDataFormat("xml");
            } else if (this.dataFormat.equals(DataFormatType.MAPPED.name())) {
                newDescriptor.setDataFormat("mapped");
            } else if (this.dataFormat.equals(DataFormatType.INDEXED.name())) {
                newDescriptor.setDataFormat("indexed");
            }
        }
        newDescriptor.setAlias("");
        newDescriptor.getQueryManager().checkDatabaseForDoesExist();
        if (oldDesriptor.isAggregateDescriptor()) {
            newDescriptor.descriptorIsAggregate();
        }
        descriptor.setDescriptor(newDescriptor);
        descriptor.getProject().getProject().getOrderedDescriptors().remove(oldDesriptor);
        descriptor.getProject().getProject().getOrderedDescriptors().add(newDescriptor);
    }
}

