/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.PropertyException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jaxb.IDResolverWrapper;
import org.eclipse.persistence.internal.jaxb.WrappedValue;
import org.eclipse.persistence.internal.jaxb.many.ManyValue;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathQName;
import org.eclipse.persistence.internal.oxm.record.XMLEventReaderInputSource;
import org.eclipse.persistence.internal.oxm.record.XMLEventReaderReader;
import org.eclipse.persistence.internal.oxm.record.XMLStreamReaderInputSource;
import org.eclipse.persistence.internal.oxm.record.XMLStreamReaderReader;
import org.eclipse.persistence.internal.oxm.record.json.JSONReader;
import org.eclipse.persistence.internal.oxm.record.namespaces.PrefixMapperNamespaceResolver;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.JAXBErrorHandler;
import org.eclipse.persistence.jaxb.JAXBUnmarshalListener;
import org.eclipse.persistence.jaxb.JAXBUnmarshallerHandler;
import org.eclipse.persistence.jaxb.TypeMappingInfo;
import org.eclipse.persistence.jaxb.attachment.AttachmentUnmarshallerAdapter;
import org.eclipse.persistence.oxm.IDResolver;
import org.eclipse.persistence.oxm.MediaType;
import org.eclipse.persistence.oxm.NamespacePrefixMapper;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class JAXBUnmarshaller
implements Unmarshaller {
    private ValidationEventHandler validationEventHandler = new DefaultValidationEventHandler();
    private XMLUnmarshaller xmlUnmarshaller;
    private JAXBContext jaxbContext;
    private XMLInputFactory xmlInputFactory;
    private boolean initializedXMLInputFactory = false;
    public static final String XML_JAVATYPE_ADAPTERS = "xml-javatype-adapters";
    public static final String STAX_SOURCE_CLASS_NAME = "javax.xml.transform.stax.StAXSource";
    private NamespaceResolver namespaceResolver;
    private String attributePrefix;
    private boolean includeRoot;
    public static final String JSON_NAMESPACE_PREFIX_MAPPER = "eclipselink.namespace-prefix-mapper";
    public static final String MEDIA_TYPE = "eclipselink.media-type";
    public static final String ID_RESOLVER = "eclipselink.id-resolver";
    private static final String SUN_ID_RESOLVER = "com.sun.xml.bind.IDResolver";
    private static final String SUN_JSE_ID_RESOLVER = "com.sun.xml.internal.bind.IDResolver";
    public static final String JSON_ATTRIBUTE_PREFIX = "eclipselink.json.attribute-prefix";
    public static final String JSON_INCLUDE_ROOT = "eclipselink.json.include-root";
    public static final String JSON_VALUE_WRAPPER = "eclipselink.json.value-wrapper";

    public JAXBUnmarshaller(XMLUnmarshaller newXMLUnmarshaller) {
        this.xmlUnmarshaller = newXMLUnmarshaller;
        this.xmlUnmarshaller.setValidationMode(0);
        this.xmlUnmarshaller.setUnmarshalListener(new JAXBUnmarshalListener(this));
        this.xmlUnmarshaller.setErrorHandler(new JAXBErrorHandler(this.validationEventHandler));
        this.includeRoot = true;
    }

    private XMLInputFactory getXMLInputFactory() {
        if (!this.initializedXMLInputFactory) {
            try {
                try {
                    this.xmlInputFactory = XMLInputFactory.newInstance();
                }
                catch (FactoryConfigurationError factoryConfigurationError) {
                    this.initializedXMLInputFactory = true;
                }
            }
            finally {
                this.initializedXMLInputFactory = true;
            }
        }
        return this.xmlInputFactory;
    }

    public XMLUnmarshaller getXMLUnmarshaller() {
        return this.xmlUnmarshaller;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object unmarshal(File file) throws JAXBException {
        try {
            if (this.xmlUnmarshaller.getMediaType() != MediaType.APPLICATION_JSON) {
                Object value = this.xmlUnmarshaller.unmarshal(file);
                return this.createJAXBElementIfRequired(value);
            }
            try {
                FileInputStream inputStream = new FileInputStream(file);
                try {
                    Object object = this.unmarshal(inputStream);
                    return object;
                }
                finally {
                    inputStream.close();
                }
            }
            catch (FileNotFoundException e) {
                throw XMLMarshalException.unmarshalException(e);
            }
            catch (IOException e) {
                throw XMLMarshalException.unmarshalException(e);
            }
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public Object unmarshal(InputStream inputStream) throws JAXBException {
        try {
            if (this.xmlUnmarshaller.getMediaType() == MediaType.APPLICATION_JSON) {
                InputSource source = new InputSource(inputStream);
                return this.unmarshal(source);
            }
            XMLInputFactory xmlInputFactory = this.getXMLInputFactory();
            if (xmlInputFactory == null || this.xmlUnmarshaller.getValidationMode() != 0) {
                return this.createJAXBElementIfRequired(this.xmlUnmarshaller.unmarshal(inputStream));
            }
            if (inputStream == null) {
                throw XMLMarshalException.nullArgumentException();
            }
            XMLStreamReader xmlStreamReader = xmlInputFactory.createXMLStreamReader(inputStream);
            Object value = this.unmarshal(xmlStreamReader);
            xmlStreamReader.close();
            return value;
        }
        catch (JAXBException jaxbException) {
            throw jaxbException;
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
        catch (Exception exception) {
            throw new UnmarshalException((Throwable)exception);
        }
    }

    public Object unmarshal(URL url) throws JAXBException {
        try {
            if (this.xmlUnmarshaller.getMediaType() == MediaType.APPLICATION_JSON) {
                try {
                    Object object = null;
                    InputStream inputStream = url.openStream();
                    try {
                        try {
                            object = this.unmarshal(inputStream);
                        }
                        catch (XMLMarshalException e) {
                            throw this.handleXMLMarshalException(e);
                        }
                    }
                    finally {
                        inputStream.close();
                    }
                    return object;
                }
                catch (IOException e) {
                    throw new UnmarshalException((Throwable)e);
                }
            }
            Object value = this.xmlUnmarshaller.unmarshal(url);
            return this.createJAXBElementIfRequired(value);
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public Object unmarshal(InputSource inputSource) throws JAXBException {
        try {
            Object value = null;
            value = this.xmlUnmarshaller.getMediaType() == MediaType.APPLICATION_JSON ? this.xmlUnmarshaller.unmarshal(new JSONReader(this.attributePrefix, this.namespaceResolver, this.namespaceResolver != null, this.includeRoot), inputSource) : this.xmlUnmarshaller.unmarshal(inputSource);
            return this.createJAXBElementIfRequired(value);
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public Object unmarshal(Reader reader) throws JAXBException {
        if (this.xmlUnmarshaller.getMediaType() == MediaType.APPLICATION_JSON) {
            if (reader == null) {
                throw XMLMarshalException.nullArgumentException();
            }
            boolean namespaceAware = this.namespaceResolver != null;
            return this.createJAXBElementIfRequired(this.xmlUnmarshaller.unmarshal(new JSONReader(this.attributePrefix, this.namespaceResolver, namespaceAware, this.includeRoot), new InputSource(reader)));
        }
        try {
            XMLInputFactory xmlInputFactory = this.getXMLInputFactory();
            if (xmlInputFactory == null || this.xmlUnmarshaller.getValidationMode() != 0) {
                return this.createJAXBElementIfRequired(this.xmlUnmarshaller.unmarshal(reader));
            }
            if (reader == null) {
                throw XMLMarshalException.nullArgumentException();
            }
            XMLStreamReader xmlStreamReader = xmlInputFactory.createXMLStreamReader(reader);
            Object value = this.unmarshal(xmlStreamReader);
            xmlStreamReader.close();
            return value;
        }
        catch (JAXBException jaxbException) {
            throw jaxbException;
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
        catch (Exception exception) {
            throw new UnmarshalException((Throwable)exception);
        }
    }

    public Object unmarshal(Node node) throws JAXBException {
        try {
            Object value = this.xmlUnmarshaller.unmarshal(node);
            return this.createJAXBElementIfRequired(value);
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    private JAXBElement buildJAXBElementFromObject(Object obj, Class declaredClass) {
        if (obj instanceof XMLRoot) {
            JAXBElement jaxbElement = this.createJAXBElementFromXMLRoot((XMLRoot)obj, declaredClass);
            if (((XMLRoot)obj).isNil()) {
                jaxbElement.setNil(((XMLRoot)obj).isNil());
                jaxbElement.setValue(null);
            }
            return jaxbElement;
        }
        if (obj instanceof JAXBElement) {
            return (JAXBElement)obj;
        }
        AbstractSession sess = this.xmlUnmarshaller.getXMLContext().getSession(obj);
        XMLDescriptor desc = (XMLDescriptor)sess.getClassDescriptor(obj);
        String rootName = desc.getDefaultRootElement();
        if (rootName == null) {
            return this.createJAXBElement(new QName(""), obj.getClass(), obj);
        }
        String rootNamespaceUri = null;
        int idx = rootName.indexOf(":");
        if (idx != -1) {
            rootNamespaceUri = desc.getNamespaceResolver().resolveNamespacePrefix(rootName.substring(0, idx));
            rootName = rootName.substring(idx + 1);
        }
        QName qname = rootNamespaceUri == null ? new QName(rootName) : new QName(rootNamespaceUri, rootName);
        if (declaredClass != null) {
            return this.createJAXBElement(qname, declaredClass, obj);
        }
        return this.createJAXBElement(qname, obj.getClass(), obj);
    }

    public JAXBElement unmarshal(Node node, Class javaClass) throws JAXBException {
        if (javaClass == null) {
            throw new IllegalArgumentException();
        }
        try {
            Class generatedClass;
            Class classToUnmarshalTo = this.getClassToUnmarshalTo(javaClass);
            if (this.jaxbContext.getArrayClassesToGeneratedClasses() != null && (generatedClass = this.jaxbContext.getArrayClassesToGeneratedClasses().get(javaClass.getCanonicalName())) != null) {
                classToUnmarshalTo = generatedClass;
            }
            return this.buildJAXBElementFromObject(this.xmlUnmarshaller.unmarshal(node, classToUnmarshalTo), javaClass);
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public Object unmarshal(Source source) throws JAXBException {
        try {
            Object value = this.xmlUnmarshaller.unmarshal(source);
            return this.createJAXBElementIfRequired(value);
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public JAXBElement unmarshal(Source source, Class javaClass) throws JAXBException {
        if (javaClass == null) {
            throw new IllegalArgumentException();
        }
        Class classToUnmarshalTo = this.getClassToUnmarshalTo(javaClass);
        try {
            if (this.xmlUnmarshaller.getMediaType() == MediaType.APPLICATION_JSON && source instanceof StreamSource) {
                boolean namespaceAware;
                StreamSource streamSource = (StreamSource)source;
                boolean bl = namespaceAware = this.namespaceResolver != null;
                if (streamSource.getReader() != null) {
                    return this.buildJAXBElementFromObject(this.xmlUnmarshaller.unmarshal(new JSONReader(this.attributePrefix, this.namespaceResolver, namespaceAware, this.includeRoot), new InputSource(streamSource.getReader()), classToUnmarshalTo), javaClass);
                }
                if (streamSource.getInputStream() != null) {
                    return this.buildJAXBElementFromObject(this.xmlUnmarshaller.unmarshal(new JSONReader(this.attributePrefix, this.namespaceResolver, namespaceAware, this.includeRoot), new InputSource(streamSource.getInputStream()), classToUnmarshalTo), javaClass);
                }
                return this.buildJAXBElementFromObject(this.xmlUnmarshaller.unmarshal(new JSONReader(this.attributePrefix, this.namespaceResolver, namespaceAware, this.includeRoot), new InputSource(streamSource.getSystemId()), classToUnmarshalTo), javaClass);
            }
            return this.buildJAXBElementFromObject(this.xmlUnmarshaller.unmarshal(source, classToUnmarshalTo), javaClass);
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    private JAXBElement unmarshal(Source source, Class javaClass, Class declaredType) {
        Class generatedClass;
        Class classToUnmarshalTo = javaClass;
        if (this.jaxbContext.getArrayClassesToGeneratedClasses() != null && (generatedClass = this.jaxbContext.getArrayClassesToGeneratedClasses().get(javaClass.getCanonicalName())) != null) {
            classToUnmarshalTo = generatedClass;
        }
        return this.buildJAXBElementFromObject(this.xmlUnmarshaller.unmarshal(source, classToUnmarshalTo), declaredType);
    }

    public JAXBElement unmarshal(Source source, Type type) throws JAXBException {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        try {
            TypeMappingInfo tmi;
            if (this.jaxbContext.getTypeToTypeMappingInfo() != null && (tmi = this.jaxbContext.getTypeToTypeMappingInfo().get(type)) != null) {
                return this.unmarshal(source, tmi);
            }
            Class unmarshalClass = this.jaxbContext.getCollectionClassesToGeneratedClasses().get(type);
            if (unmarshalClass != null) {
                JAXBElement unmarshalled = this.unmarshal(source, unmarshalClass, Object.class);
                Class declaredClass = null;
                declaredClass = type instanceof Class ? (Class)type : Object.class;
                JAXBElement returnVal = new JAXBElement(unmarshalled.getName(), declaredClass, unmarshalled.getScope(), unmarshalled.getValue());
                return returnVal;
            }
            if (type instanceof Class) {
                return this.unmarshal(source, (Class)type, Object.class);
            }
            return null;
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public JAXBElement unmarshal(Source source, TypeMappingInfo type) throws JAXBException {
        try {
            Class unmarshalClass = this.jaxbContext.getTypeMappingInfoToGeneratedType().get(type);
            JAXBContext.RootLevelXmlAdapter adapter = this.jaxbContext.getTypeMappingInfoToJavaTypeAdapters().get(type);
            if (unmarshalClass != null) {
                JAXBElement unmarshalled = this.unmarshal(source, unmarshalClass);
                Class declaredClass = null;
                declaredClass = type.getType() instanceof Class ? (Class)type.getType() : Object.class;
                Object value = unmarshalled.getValue();
                if (adapter != null) {
                    try {
                        value = adapter.getXmlAdapter().unmarshal(value);
                    }
                    catch (Exception ex) {
                        throw new JAXBException((Throwable)XMLMarshalException.marshalException(ex));
                    }
                }
                JAXBElement returnVal = new JAXBElement(unmarshalled.getName(), declaredClass, unmarshalled.getScope(), unmarshalled.getValue());
                return returnVal;
            }
            if (type.getType() instanceof Class) {
                if (adapter != null) {
                    JAXBElement element = this.unmarshal(source, adapter.getBoundType());
                    try {
                        Object value = adapter.getXmlAdapter().unmarshal(element.getValue());
                        element.setValue(value);
                        return element;
                    }
                    catch (Exception ex) {
                        throw new JAXBException((Throwable)XMLMarshalException.marshalException(ex));
                    }
                }
                return this.unmarshal(source, (Class)type.getType());
            }
            if (type.getType() instanceof ParameterizedType) {
                return this.unmarshal(source, ((ParameterizedType)type.getType()).getRawType());
            }
            return null;
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public JAXBElement unmarshal(XMLStreamReader streamReader, Class javaClass) throws JAXBException {
        if (streamReader == null || javaClass == null) {
            throw new IllegalArgumentException();
        }
        try {
            Class classToUnmarshalTo = this.getClassToUnmarshalTo(javaClass);
            XMLStreamReaderReader staxReader = new XMLStreamReaderReader(this.xmlUnmarshaller);
            staxReader.setErrorHandler(this.xmlUnmarshaller.getErrorHandler());
            XMLStreamReaderInputSource inputSource = new XMLStreamReaderInputSource(streamReader);
            JAXBElement unmarshalled = this.buildJAXBElementFromObject(this.xmlUnmarshaller.unmarshal(staxReader, inputSource, classToUnmarshalTo), javaClass);
            if (classToUnmarshalTo != javaClass) {
                JAXBElement returnVal = new JAXBElement(unmarshalled.getName(), javaClass, unmarshalled.getScope(), unmarshalled.getValue());
                return returnVal;
            }
            return unmarshalled;
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public JAXBElement unmarshal(XMLStreamReader streamReader, Type type) throws JAXBException {
        if (streamReader == null || type == null) {
            throw new IllegalArgumentException();
        }
        try {
            TypeMappingInfo tmi;
            if (this.jaxbContext.getTypeToTypeMappingInfo() != null && (tmi = this.jaxbContext.getTypeToTypeMappingInfo().get(type)) != null) {
                return this.unmarshal(streamReader, tmi);
            }
            Class unmarshalClass = this.jaxbContext.getCollectionClassesToGeneratedClasses().get(type);
            if (unmarshalClass != null) {
                JAXBElement unmarshalled = this.unmarshal(streamReader, unmarshalClass);
                Class declaredClass = null;
                declaredClass = type instanceof Class ? (Class)type : Object.class;
                JAXBElement returnVal = new JAXBElement(unmarshalled.getName(), declaredClass, unmarshalled.getScope(), unmarshalled.getValue());
                return returnVal;
            }
            if (type instanceof Class) {
                return this.unmarshal(streamReader, (Class)type);
            }
            return null;
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public JAXBElement unmarshal(XMLStreamReader streamReader, TypeMappingInfo type) throws JAXBException {
        try {
            if (this.jaxbContext.getTypeMappingInfoToGeneratedType() == null) {
                return this.unmarshal(streamReader, type.getType());
            }
            JAXBContext.RootLevelXmlAdapter adapter = null;
            if (this.jaxbContext.getTypeMappingInfoToJavaTypeAdapters().size() > 0) {
                adapter = this.jaxbContext.getTypeMappingInfoToJavaTypeAdapters().get(type);
            }
            Class unmarshalClass = null;
            if (this.jaxbContext.getTypeMappingInfoToGeneratedType().size() > 0) {
                unmarshalClass = this.jaxbContext.getTypeMappingInfoToGeneratedType().get(type);
            }
            if (unmarshalClass != null) {
                JAXBElement unmarshalled = this.unmarshal(streamReader, unmarshalClass);
                Class declaredClass = null;
                declaredClass = type.getType() instanceof Class ? (Class)type.getType() : Object.class;
                Object value = unmarshalled.getValue();
                if (adapter != null) {
                    try {
                        value = adapter.getXmlAdapter().unmarshal(value);
                    }
                    catch (Exception ex) {
                        throw new JAXBException((Throwable)XMLMarshalException.marshalException(ex));
                    }
                }
                JAXBElement returnVal = new JAXBElement(unmarshalled.getName(), declaredClass, unmarshalled.getScope(), value);
                return returnVal;
            }
            if (type.getType() instanceof Class) {
                if (adapter != null) {
                    JAXBElement element = this.unmarshal(streamReader, adapter.getBoundType());
                    try {
                        Object value = adapter.getXmlAdapter().unmarshal(element.getValue());
                        element.setValue(value);
                        return element;
                    }
                    catch (Exception ex) {
                        throw new JAXBException((Throwable)XMLMarshalException.marshalException(ex));
                    }
                }
                return this.unmarshal(streamReader, (Class)type.getType());
            }
            if (type.getType() instanceof ParameterizedType) {
                return this.unmarshal(streamReader, ((ParameterizedType)type.getType()).getRawType());
            }
            return null;
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public Object unmarshal(XMLStreamReader streamReader) throws JAXBException {
        if (streamReader == null) {
            throw new IllegalArgumentException();
        }
        try {
            XMLStreamReaderReader staxReader = new XMLStreamReaderReader(this.xmlUnmarshaller);
            staxReader.setErrorHandler(this.xmlUnmarshaller.getErrorHandler());
            XMLStreamReaderInputSource inputSource = new XMLStreamReaderInputSource(streamReader);
            Object value = this.xmlUnmarshaller.unmarshal(staxReader, inputSource);
            return this.createJAXBElementIfRequired(value);
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public JAXBElement unmarshal(XMLEventReader eventReader, Class javaClass) throws JAXBException {
        if (eventReader == null || javaClass == null) {
            throw new IllegalArgumentException();
        }
        try {
            Class classToUnmarshalTo = this.getClassToUnmarshalTo(javaClass);
            XMLEventReaderReader staxReader = new XMLEventReaderReader(this.xmlUnmarshaller);
            XMLEventReaderInputSource inputSource = new XMLEventReaderInputSource(eventReader);
            JAXBElement unmarshalled = this.buildJAXBElementFromObject(this.xmlUnmarshaller.unmarshal(staxReader, inputSource, classToUnmarshalTo), javaClass);
            if (classToUnmarshalTo != javaClass) {
                JAXBElement returnVal = new JAXBElement(unmarshalled.getName(), javaClass, unmarshalled.getScope(), unmarshalled.getValue());
                return returnVal;
            }
            return unmarshalled;
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public JAXBElement unmarshal(XMLEventReader eventReader, Type type) throws JAXBException {
        if (eventReader == null || type == null) {
            throw new IllegalArgumentException();
        }
        try {
            TypeMappingInfo tmi;
            if (this.jaxbContext.getTypeToTypeMappingInfo() != null && (tmi = this.jaxbContext.getTypeToTypeMappingInfo().get(type)) != null) {
                return this.unmarshal(eventReader, tmi);
            }
            Class unmarshalClass = this.jaxbContext.getCollectionClassesToGeneratedClasses().get(type);
            if (unmarshalClass != null) {
                JAXBElement unmarshalled = this.unmarshal(eventReader, unmarshalClass);
                Class declaredClass = null;
                declaredClass = type instanceof Class ? (Class)type : Object.class;
                JAXBElement returnVal = new JAXBElement(unmarshalled.getName(), declaredClass, unmarshalled.getScope(), unmarshalled.getValue());
                return returnVal;
            }
            if (type instanceof Class) {
                return this.unmarshal(eventReader, (Class)type);
            }
            return null;
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public JAXBElement unmarshal(XMLEventReader eventReader, TypeMappingInfo type) throws JAXBException {
        try {
            if (this.jaxbContext.getTypeMappingInfoToGeneratedType() == null) {
                return this.unmarshal(eventReader, type.getType());
            }
            Class unmarshalClass = this.jaxbContext.getTypeMappingInfoToGeneratedType().get(type);
            JAXBContext.RootLevelXmlAdapter adapter = this.jaxbContext.getTypeMappingInfoToJavaTypeAdapters().get(type);
            if (unmarshalClass != null) {
                JAXBElement unmarshalled = this.unmarshal(eventReader, unmarshalClass);
                Class declaredClass = null;
                declaredClass = type.getType() instanceof Class ? (Class)type.getType() : Object.class;
                Object value = unmarshalled.getValue();
                if (adapter != null) {
                    try {
                        value = adapter.getXmlAdapter().unmarshal(value);
                    }
                    catch (Exception ex) {
                        throw new JAXBException((Throwable)XMLMarshalException.marshalException(ex));
                    }
                }
                JAXBElement returnVal = new JAXBElement(unmarshalled.getName(), declaredClass, unmarshalled.getScope(), value);
                return returnVal;
            }
            if (type.getType() instanceof Class) {
                if (adapter != null) {
                    JAXBElement element = this.unmarshal(eventReader, adapter.getBoundType());
                    try {
                        Object value = adapter.getXmlAdapter().unmarshal(element.getValue());
                        element.setValue(value);
                        return element;
                    }
                    catch (Exception ex) {
                        throw new JAXBException((Throwable)XMLMarshalException.marshalException(ex));
                    }
                }
                return this.unmarshal(eventReader, (Class)type.getType());
            }
            if (type.getType() instanceof ParameterizedType) {
                return this.unmarshal(eventReader, ((ParameterizedType)type.getType()).getRawType());
            }
            return null;
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public Object unmarshal(XMLEventReader eventReader) throws JAXBException {
        if (eventReader == null) {
            throw new IllegalArgumentException();
        }
        try {
            XMLEventReaderReader staxReader = new XMLEventReaderReader(this.xmlUnmarshaller);
            XMLEventReaderInputSource inputSource = new XMLEventReaderInputSource(eventReader);
            Object value = this.xmlUnmarshaller.unmarshal(staxReader, inputSource);
            return this.createJAXBElementIfRequired(value);
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public UnmarshallerHandler getUnmarshallerHandler() {
        return new JAXBUnmarshallerHandler(this);
    }

    public void setValidating(boolean validate) throws JAXBException {
        if (validate) {
            this.xmlUnmarshaller.setValidationMode(3);
        } else {
            this.xmlUnmarshaller.setValidationMode(0);
        }
    }

    public boolean isValidating() throws JAXBException {
        return this.xmlUnmarshaller.getValidationMode() != 0;
    }

    public void setEventHandler(ValidationEventHandler newValidationEventHandler) throws JAXBException {
        this.validationEventHandler = newValidationEventHandler == null ? new DefaultValidationEventHandler() : newValidationEventHandler;
        this.xmlUnmarshaller.setErrorHandler(new JAXBErrorHandler(this.validationEventHandler));
    }

    public ValidationEventHandler getEventHandler() throws JAXBException {
        return this.validationEventHandler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProperty(String key, Object value) throws PropertyException {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (key.equals(MEDIA_TYPE)) {
            MediaType mType = MediaType.getMediaTypeByName((String)value);
            if (mType == null) throw new PropertyException(key, value);
            this.xmlUnmarshaller.setMediaType(mType);
            return;
        } else if (key.equals(JSON_ATTRIBUTE_PREFIX)) {
            this.attributePrefix = (String)value;
            return;
        } else if (JSON_INCLUDE_ROOT.equals(key)) {
            this.includeRoot = (Boolean)value;
            return;
        } else if (JSON_NAMESPACE_PREFIX_MAPPER.equals(key)) {
            if (value instanceof Map) {
                Map namespaces = (Map)value;
                NamespaceResolver nr = new NamespaceResolver();
                Iterator namesapcesIter = namespaces.entrySet().iterator();
                int i = 0;
                while (i < namespaces.size()) {
                    Map.Entry nextEntry = namesapcesIter.next();
                    nr.put((String)nextEntry.getValue(), (String)nextEntry.getKey());
                    ++i;
                }
                this.setNamespaceResolver(nr);
                return;
            } else {
                if (!(value instanceof NamespacePrefixMapper)) return;
                this.setNamespaceResolver(new PrefixMapperNamespaceResolver((NamespacePrefixMapper)value, null));
            }
            return;
        } else if (JSON_VALUE_WRAPPER.equals(key)) {
            this.xmlUnmarshaller.setValueWrapper((String)value);
            return;
        } else if (ID_RESOLVER.equals(key)) {
            this.setIDResolver((IDResolver)value);
            return;
        } else {
            if (!SUN_ID_RESOLVER.equals(key) && !SUN_JSE_ID_RESOLVER.equals(key)) throw new PropertyException(key, value);
            this.setIDResolver(new IDResolverWrapper(value));
        }
    }

    public Object getProperty(String key) throws PropertyException {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (key.equals(MEDIA_TYPE)) {
            return this.xmlUnmarshaller.getMediaType().getName();
        }
        throw new PropertyException(key);
    }

    public Unmarshaller.Listener getListener() {
        return ((JAXBUnmarshalListener)this.xmlUnmarshaller.getUnmarshalListener()).getListener();
    }

    public void setListener(Unmarshaller.Listener listener) {
        ((JAXBUnmarshalListener)this.xmlUnmarshaller.getUnmarshalListener()).setListener(listener);
    }

    public XmlAdapter getAdapter(Class javaClass) {
        HashMap result = (HashMap)this.xmlUnmarshaller.getProperty(XML_JAVATYPE_ADAPTERS);
        if (result == null) {
            return null;
        }
        return (XmlAdapter)result.get(javaClass);
    }

    public void setAdapter(Class javaClass, XmlAdapter adapter) {
        HashMap<Class, XmlAdapter> result = (HashMap<Class, XmlAdapter>)this.xmlUnmarshaller.getProperty(XML_JAVATYPE_ADAPTERS);
        if (result == null) {
            result = new HashMap<Class, XmlAdapter>();
            this.xmlUnmarshaller.getProperties().put(XML_JAVATYPE_ADAPTERS, result);
        }
        result.put(javaClass, adapter);
    }

    public void setAdapter(XmlAdapter adapter) {
        this.setAdapter(adapter.getClass(), adapter);
    }

    public void setSchema(Schema schema) {
        this.xmlUnmarshaller.setSchema(schema);
    }

    public Schema getSchema() {
        return this.xmlUnmarshaller.getSchema();
    }

    public AttachmentUnmarshaller getAttachmentUnmarshaller() {
        if (this.xmlUnmarshaller.getAttachmentUnmarshaller() == null) {
            return null;
        }
        return ((AttachmentUnmarshallerAdapter)this.xmlUnmarshaller.getAttachmentUnmarshaller()).getAttachmentUnmarshaller();
    }

    public void setAttachmentUnmarshaller(AttachmentUnmarshaller unmarshaller) {
        if (unmarshaller == null) {
            this.xmlUnmarshaller.setAttachmentUnmarshaller(null);
        } else {
            this.xmlUnmarshaller.setAttachmentUnmarshaller(new AttachmentUnmarshallerAdapter(unmarshaller));
        }
    }

    public void setUnmarshalCallbacks(HashMap callbacks) {
        ((JAXBUnmarshalListener)this.xmlUnmarshaller.getUnmarshalListener()).setClassBasedUnmarshalEvents(callbacks);
    }

    private Object createJAXBElementIfRequired(Object value) {
        if (value instanceof XMLRoot) {
            JAXBElement jaxbElement = this.createJAXBElementFromXMLRoot((XMLRoot)value, Object.class);
            jaxbElement.setNil(((XMLRoot)value).isNil());
            return jaxbElement;
        }
        return value;
    }

    private JAXBElement createJAXBElementFromXMLRoot(XMLRoot xmlRoot, Class declaredType) {
        Class declaredClass;
        HashMap<QName, Class> qNamesToDeclaredClasses;
        Object value = xmlRoot.getObject();
        if (value instanceof WrappedValue) {
            QName qname = new QName(xmlRoot.getNamespaceURI(), xmlRoot.getLocalName());
            return new JAXBElement(qname, ((WrappedValue)((Object)value)).getDeclaredType(), ((WrappedValue)((Object)value)).getValue());
        }
        if (value instanceof JAXBElement) {
            return (JAXBElement)value;
        }
        QName qname = new QName(xmlRoot.getNamespaceURI(), xmlRoot.getLocalName());
        XPathQName xpathQName = new XPathQName(xmlRoot.getNamespaceURI(), xmlRoot.getLocalName(), this.xmlUnmarshaller.getMediaType() == MediaType.APPLICATION_XML);
        if (value instanceof ManyValue) {
            value = ((ManyValue)value).getItem();
        }
        if ((qNamesToDeclaredClasses = this.jaxbContext.getQNamesToDeclaredClasses()) != null && (declaredClass = (Class)qNamesToDeclaredClasses.get(qname)) != null) {
            return this.createJAXBElement(qname, declaredClass, value);
        }
        XMLDescriptor descriptorForQName = this.xmlUnmarshaller.getXMLContext().getDescriptor(xpathQName);
        if (descriptorForQName != null) {
            return this.createJAXBElement(qname, descriptorForQName.getJavaClass(), value);
        }
        if (value != null) {
            XMLConversionManager xcm = (XMLConversionManager)this.xmlUnmarshaller.getXMLContext().getSession(0).getDatasourcePlatform().getConversionManager();
            if (XMLConversionManager.getDefaultJavaTypes().get(value.getClass()) != null) {
                return this.createJAXBElement(qname, declaredType, value);
            }
        }
        return this.createJAXBElement(qname, declaredType, value);
    }

    private JAXBElement createJAXBElement(QName qname, Class theClass, Object value) {
        if (theClass == null) {
            return new JAXBElement(qname, Object.class, value);
        }
        if (ClassConstants.XML_GREGORIAN_CALENDAR.isAssignableFrom(theClass)) {
            theClass = ClassConstants.XML_GREGORIAN_CALENDAR;
        } else if (ClassConstants.DURATION.isAssignableFrom(theClass)) {
            theClass = ClassConstants.DURATION;
        }
        return new JAXBElement(qname, theClass, value);
    }

    public JAXBContext getJaxbContext() {
        return this.jaxbContext;
    }

    public void setJaxbContext(JAXBContext jaxbContext) {
        this.jaxbContext = jaxbContext;
    }

    private Class getClassToUnmarshalTo(Class originalClass) {
        Class generatedClass;
        TypeMappingInfo tmi;
        Class generatedClass2;
        Class classToUnmarshalTo = originalClass;
        if (this.jaxbContext.getArrayClassesToGeneratedClasses() != null && this.jaxbContext.getArrayClassesToGeneratedClasses().size() > 0 && (generatedClass2 = this.jaxbContext.getArrayClassesToGeneratedClasses().get(originalClass.getCanonicalName())) != null) {
            classToUnmarshalTo = generatedClass2;
        }
        if (this.jaxbContext.getCollectionClassesToGeneratedClasses() != null && this.jaxbContext.getCollectionClassesToGeneratedClasses().size() > 0 && (generatedClass2 = this.jaxbContext.getCollectionClassesToGeneratedClasses().get(originalClass)) != null) {
            classToUnmarshalTo = generatedClass2;
        }
        if (this.jaxbContext.getTypeToTypeMappingInfo() != null && (tmi = this.jaxbContext.getTypeToTypeMappingInfo().get(originalClass)) != null && this.jaxbContext.getTypeMappingInfoToGeneratedType() != null && (generatedClass = this.jaxbContext.getTypeMappingInfoToGeneratedType().get(tmi)) != null) {
            classToUnmarshalTo = generatedClass;
        }
        return classToUnmarshalTo;
    }

    private JAXBException handleXMLMarshalException(XMLMarshalException xmlMarshalException) {
        if (xmlMarshalException.getErrorCode() == 25011) {
            throw new IllegalArgumentException(xmlMarshalException);
        }
        return new UnmarshalException((Throwable)xmlMarshalException);
    }

    private void setNamespaceResolver(NamespaceResolver namespaceResolver) {
        this.namespaceResolver = namespaceResolver;
    }

    public String getAttributePrefix() {
        return this.attributePrefix;
    }

    public IDResolver getIDResolver() {
        return this.getXMLUnmarshaller().getIDResolver();
    }

    public void setIDResolver(IDResolver idResolver) {
        this.getXMLUnmarshaller().setIDResolver(idResolver);
    }
}

