/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql;

import org.eclipse.persistence.jpa.jpql.Assert;
import org.eclipse.persistence.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.jpql.Resolver;
import org.eclipse.persistence.jpa.jpql.TypeHelper;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AnonymousExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionRegistry;
import org.eclipse.persistence.jpa.jpql.parser.IdentifierRole;
import org.eclipse.persistence.jpa.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.parser.NullExpression;
import org.eclipse.persistence.jpa.jpql.spi.IEmbeddable;
import org.eclipse.persistence.jpa.jpql.spi.IEntity;
import org.eclipse.persistence.jpa.jpql.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.spi.IMappedSuperclass;
import org.eclipse.persistence.jpa.jpql.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.spi.IQuery;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeDeclaration;
import org.eclipse.persistence.jpa.jpql.spi.ITypeRepository;
import org.eclipse.persistence.jpa.jpql.spi.JPAVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractVisitor
extends AnonymousExpressionVisitor {
    private CollectionExpressionVisitor collectionExpressionVisitor;
    protected final JPQLQueryContext context;
    private NullExpressionVisitor nullExpressionVisitor;

    protected AbstractVisitor(JPQLQueryContext context) {
        Assert.isNotNull(context, "The JPQLQueryContext cannot be null");
        this.context = context;
        this.initialize();
    }

    protected CollectionExpressionVisitor buildCollectionExpressionVisitor() {
        return new CollectionExpressionVisitor();
    }

    protected NullExpressionVisitor buildNullExpressionVisitor() {
        return new NullExpressionVisitor();
    }

    public void dispose() {
    }

    protected CollectionExpression getCollectionExpression(Expression expression) {
        CollectionExpressionVisitor visitor = this.getCollectionExpressionVisitor();
        try {
            expression.accept(visitor);
            CollectionExpression collectionExpression = visitor.expression;
            return collectionExpression;
        }
        finally {
            visitor.expression = null;
        }
    }

    protected CollectionExpressionVisitor getCollectionExpressionVisitor() {
        if (this.collectionExpressionVisitor == null) {
            this.collectionExpressionVisitor = this.buildCollectionExpressionVisitor();
        }
        return this.collectionExpressionVisitor;
    }

    protected IEmbeddable getEmbeddable(IType type) {
        return this.getProvider().getEmbeddable(type);
    }

    protected IEntity getEntity(IType type) {
        return this.getProvider().getEntity(type);
    }

    protected IEntity getEntityNamed(String entityName) {
        return this.getProvider().getEntityNamed(entityName);
    }

    protected ExpressionRegistry getExpressionRegistry() {
        return this.getQueryContext().getExpressionRegistry();
    }

    protected JPQLGrammar getGrammar() {
        return this.getQueryContext().getGrammar();
    }

    protected IdentifierRole getIdentifierRole(String identifier) {
        return this.getExpressionRegistry().getIdentifierRole(identifier);
    }

    protected JPAVersion getIdentifierVersion(String identifier) {
        return this.getExpressionRegistry().getIdentifierVersion(identifier);
    }

    protected JPAVersion getJPAVersion() {
        return this.getQueryContext().getJPAVersion();
    }

    protected JPQLExpression getJPQLExpression() {
        return this.context.getJPQLExpression();
    }

    protected IManagedType getManagedType(IType type) {
        return this.getProvider().getManagedType(type);
    }

    protected IMappedSuperclass getMappedSuperclass(IType type) {
        return this.getProvider().getMappedSuperclass(type);
    }

    protected IMapping getMapping(Expression expression) {
        return this.context.getMapping(expression);
    }

    protected NullExpressionVisitor getNullExpressionVisitor() {
        if (this.nullExpressionVisitor == null) {
            this.nullExpressionVisitor = this.buildNullExpressionVisitor();
        }
        return this.nullExpressionVisitor;
    }

    protected IManagedTypeProvider getProvider() {
        return this.getQuery().getProvider();
    }

    protected IQuery getQuery() {
        return this.context.getQuery();
    }

    protected JPQLQueryBNF getQueryBNF(String queryBNFId) {
        return this.getExpressionRegistry().getQueryBNF(queryBNFId);
    }

    protected JPQLQueryContext getQueryContext() {
        return this.context;
    }

    protected String getQueryExpression() {
        return this.getQuery().getExpression();
    }

    protected Resolver getResolver(Expression expression) {
        return this.context.getResolver(expression);
    }

    protected IType getType(Class<?> type) {
        return this.getTypeRepository().getType(type);
    }

    protected IType getType(Expression expression) {
        return this.context.getType(expression);
    }

    protected IType getType(String name) {
        return this.getTypeRepository().getType(name);
    }

    protected ITypeDeclaration getTypeDeclaration(Expression expression) {
        return this.context.getTypeDeclaration(expression);
    }

    protected TypeHelper getTypeHelper() {
        return this.getTypeRepository().getTypeHelper();
    }

    protected ITypeRepository getTypeRepository() {
        return this.getProvider().getTypeRepository();
    }

    protected void initialize() {
    }

    protected boolean isNull(Expression expression) {
        NullExpressionVisitor visitor = this.getNullExpressionVisitor();
        try {
            expression.accept(visitor);
            boolean bl = visitor.expression != null;
            return bl;
        }
        finally {
            visitor.expression = null;
        }
    }

    @Override
    protected abstract void visit(Expression var1);

    protected static class CollectionExpressionVisitor
    extends AbstractExpressionVisitor {
        protected CollectionExpression expression;

        protected CollectionExpressionVisitor() {
        }

        public void visit(CollectionExpression expression) {
            this.expression = expression;
        }
    }

    protected static class NullExpressionVisitor
    extends AbstractExpressionVisitor {
        protected NullExpression expression;

        protected NullExpressionVisitor() {
        }

        public void visit(NullExpression expression) {
            this.expression = expression;
        }
    }
}

