/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql;

import org.eclipse.persistence.jpa.jpql.AbstractGrammarValidator;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.jpql.parser.AbstractEclipseLinkTraverseParentVisitor;
import org.eclipse.persistence.jpa.jpql.parser.EclipseLinkExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.EclipseLinkJPQLGrammar1;
import org.eclipse.persistence.jpa.jpql.parser.EclipseLinkJPQLGrammar2_0;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.FuncExpression;
import org.eclipse.persistence.jpa.jpql.parser.InputParameter;
import org.eclipse.persistence.jpa.jpql.parser.SelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectClause;
import org.eclipse.persistence.jpa.jpql.parser.TreatExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkGrammarValidator
extends AbstractGrammarValidator
implements EclipseLinkExpressionVisitor {
    protected FuncExpressionVisitor funcExpressionVisitor;

    public EclipseLinkGrammarValidator(JPQLQueryContext context) {
        super(context);
    }

    @Override
    protected boolean isJoinFetchIdentifiable() {
        return this.getGrammar().getProviderVersion() == "2.4";
    }

    protected AbstractGrammarValidator.AbstractSingleEncapsulatedExpressionHelper<FuncExpression> buildFuncExpressionHelper() {
        return new AbstractGrammarValidator.AbstractSingleEncapsulatedExpressionHelper<FuncExpression>((AbstractGrammarValidator)this){

            @Override
            public String expressionInvalidKey() {
                return null;
            }

            @Override
            public String expressionMissingKey() {
                return "FUNC_EXPRESSION_MISSING_FUNCTION_NAME";
            }

            @Override
            public boolean hasExpression(FuncExpression expression) {
                return true;
            }

            @Override
            public boolean isValidExpression(FuncExpression expression) {
                return true;
            }

            @Override
            public String leftParenthesisMissingKey() {
                return "FUNC_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey() {
                return "FUNC_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    @Override
    protected boolean canParseJPA2Identifiers() {
        return this.getGrammar() != EclipseLinkJPQLGrammar1.instance();
    }

    protected AbstractGrammarValidator.AbstractSingleEncapsulatedExpressionHelper<FuncExpression> funcExpressionHelper() {
        AbstractGrammarValidator.AbstractSingleEncapsulatedExpressionHelper<FuncExpression> helper = (AbstractGrammarValidator.AbstractSingleEncapsulatedExpressionHelper<FuncExpression>)this.getHelper("FUNC");
        if (helper == null) {
            helper = this.buildFuncExpressionHelper();
            this.registerHelper("FUNC", helper);
        }
        return helper;
    }

    protected FuncExpressionVisitor funcExpressionVisitor() {
        if (this.funcExpressionVisitor == null) {
            this.funcExpressionVisitor = new FuncExpressionVisitor();
        }
        return this.funcExpressionVisitor;
    }

    @Override
    protected boolean isInExpressionPathValid(Expression pathExpression) {
        return super.isInExpressionPathValid(pathExpression) || this.isValid(pathExpression, "identification_variable") || this.isValid(pathExpression, "input_parameter");
    }

    @Override
    protected boolean isInputParameterInValidLocation(InputParameter expression) {
        return true;
    }

    @Override
    boolean isSubqueryAllowedAnywhere() {
        return true;
    }

    @Override
    public void visit(FuncExpression expression) {
        if (this.canParseJPA2Identifiers()) {
            String functionName;
            this.validateAbstractSingleEncapsulatedExpression(expression, this.funcExpressionHelper());
            if (expression.hasLeftParenthesis() && ExpressionTools.stringIsEmpty(functionName = expression.getFunctionName())) {
                int startPosition = this.position(expression) + "FUNC".length();
                if (expression.hasLeftParenthesis()) {
                    ++startPosition;
                }
                int endPosition = startPosition;
                this.addProblem((Expression)expression, startPosition, endPosition, "FUNC_EXPRESSION_MISSING_FUNCTION_NAME", new String[0]);
            }
        } else if (this.getGrammar() == EclipseLinkJPQLGrammar2_0.instance()) {
            this.addProblem(expression, "FUNC_EXPRESSION_INVALID_JPA_PLATFORM");
        } else {
            this.addProblem(expression, "FUNC_EXPRESSION_INVALID_JPA_PLATFORM");
        }
        super.visit(expression);
    }

    @Override
    public void visit(TreatExpression expression) {
        if (!this.canParseJPA2Identifiers()) {
            if (this.getGrammar() == EclipseLinkJPQLGrammar2_0.instance()) {
                this.addProblem(expression, "FUNC_EXPRESSION_INVALID_JPA_PLATFORM");
            } else {
                this.addProblem(expression, "FUNC_EXPRESSION_INVALID_JPA_PLATFORM");
            }
        }
        super.visit(expression);
    }

    protected static class FuncExpressionVisitor
    extends AbstractEclipseLinkTraverseParentVisitor {
        FuncExpression expression;
        SelectClause selectClause;
        SimpleSelectClause simpleSelectClause;

        protected FuncExpressionVisitor() {
        }

        public void visit(FuncExpression expression) {
            this.expression = expression;
            super.visit(expression);
        }

        public void visit(SelectClause expression) {
            this.selectClause = expression;
        }

        public void visit(SimpleSelectClause expression) {
            this.simpleSelectClause = expression;
        }
    }
}

