/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.Assert;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.model.AbstractStateObjectBuilder;
import org.eclipse.persistence.jpa.jpql.model.ICaseExpressionStateObjectBuilder;
import org.eclipse.persistence.jpa.jpql.model.IScalarExpressionStateObjectBuilder;
import org.eclipse.persistence.jpa.jpql.model.query.AbsExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.AdditionExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.ArithmeticFactorStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.AvgFunctionStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.CoalesceExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.CollectionValuedPathExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.ConcatExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.CountFunctionStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.DateTimeStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.DivisionExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.EntityTypeLiteralStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.EnumTypeStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.IdentificationVariableStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.IndexExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.InputParameterStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.LengthExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.LocateExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.MaxFunctionStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.ModExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.MultiplicationExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.NullIfExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.NumericLiteralStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.SizeExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.SqrtExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateFieldPathExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StringLiteralStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.SubExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.SubtractionExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.SumFunctionStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.TypeExpressionStateObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScalarExpressionStateObjectBuilder<T extends IScalarExpressionStateObjectBuilder<T>>
extends AbstractStateObjectBuilder
implements IScalarExpressionStateObjectBuilder<T> {
    private ICaseExpressionStateObjectBuilder caseBuilder;
    private StateObject parent;

    protected AbstractScalarExpressionStateObjectBuilder(StateObject parent) {
        this.parent = parent;
    }

    @Override
    public T abs(T builder) {
        this.checkBuilder((IScalarExpressionStateObjectBuilder<?>)builder);
        AbsExpressionStateObject stateObject = new AbsExpressionStateObject(this.parent, this.pop());
        this.add((T)stateObject);
        return (T)this;
    }

    @Override
    public T add(T builder) {
        this.checkBuilder((IScalarExpressionStateObjectBuilder<?>)builder);
        StateObject rightStateObject = this.pop();
        StateObject leftStateObject = this.pop();
        AdditionExpressionStateObject stateObject = new AdditionExpressionStateObject(this.parent, leftStateObject, rightStateObject);
        this.add((T)stateObject);
        return (T)this;
    }

    protected void arithmetic(boolean plusSign) {
        ArithmeticFactorStateObject stateObject = new ArithmeticFactorStateObject(this.parent, plusSign, this.pop());
        this.add((T)stateObject);
    }

    protected void avg(boolean distinct, String path) {
        AvgFunctionStateObject stateObject = new AvgFunctionStateObject(this.parent, distinct, this.literal(path));
        this.add((T)stateObject);
    }

    @Override
    public T avg(String path) {
        this.avg(false, path);
        return (T)this;
    }

    @Override
    public T avgDistinct(String path) {
        this.avg(true, path);
        return (T)this;
    }

    protected StateObject buildCollectionPath(String path) {
        return new CollectionValuedPathExpressionStateObject(this.parent, path);
    }

    protected StateObject buildIdentificationVariable(String literal) {
        return new IdentificationVariableStateObject(this.parent, literal);
    }

    protected StateObject buildInputParameter(String parameter) {
        return new InputParameterStateObject(this.parent, parameter);
    }

    protected StateObject buildNumeric(Number number) {
        return new NumericLiteralStateObject(this.parent, number);
    }

    protected StateObject buildNumeric(String number) {
        return new NumericLiteralStateObject(this.parent, number);
    }

    protected StateObject buildStateFieldPath(String path) {
        return new StateFieldPathExpressionStateObject(this.parent, path);
    }

    protected StateObject buildStringLiteral(String literal) {
        return new StringLiteralStateObject(this.parent, literal);
    }

    @Override
    public T case_(ICaseExpressionStateObjectBuilder builder) {
        Assert.isEqual(this.caseBuilder, builder, "The Case expression builder is not the same as the current one");
        this.add((T)builder.buildStateObject());
        builder = null;
        return (T)this;
    }

    @Override
    public T coalesce(T builder1, T builder2, T ... builders) {
        this.checkBuilders(new IScalarExpressionStateObjectBuilder[]{builder1, builder2});
        this.checkBuilders((IScalarExpressionStateObjectBuilder[])builders);
        ArrayList<StateObject> stateObjects = new ArrayList<StateObject>();
        stateObjects.addAll(this.stateObjects((IScalarExpressionStateObjectBuilder[])builders));
        stateObjects.add(0, this.pop());
        stateObjects.add(0, this.pop());
        CoalesceExpressionStateObject stateObject = new CoalesceExpressionStateObject(this.parent, stateObjects);
        this.add((T)stateObject);
        return (T)this;
    }

    @Override
    public T concat(T builder1, T builder2, T ... builders) {
        this.checkBuilders(new IScalarExpressionStateObjectBuilder[]{builder1, builder2});
        this.checkBuilders((IScalarExpressionStateObjectBuilder[])builders);
        ArrayList<StateObject> stateObjects = new ArrayList<StateObject>();
        stateObjects.addAll(this.stateObjects((IScalarExpressionStateObjectBuilder[])builders));
        stateObjects.add(0, this.pop());
        stateObjects.add(0, this.pop());
        ConcatExpressionStateObject stateObject = new ConcatExpressionStateObject(this.parent, (List<? extends StateObject>)stateObjects);
        this.add((T)stateObject);
        return (T)this;
    }

    protected void count(boolean distinct, String path) {
        CountFunctionStateObject stateObject = new CountFunctionStateObject(this.parent, distinct, this.literal(path));
        this.add((T)stateObject);
    }

    @Override
    public T count(String path) {
        this.count(false, path);
        return (T)this;
    }

    @Override
    public T countDistinct(String path) {
        this.count(true, path);
        return (T)this;
    }

    @Override
    public T currentDate() {
        return this.date("CURRENT_DATE");
    }

    @Override
    public T currentTime() {
        return this.date("CURRENT_TIME");
    }

    @Override
    public T currentTimestamp() {
        return this.date("CURRENT_TIMESTAMP");
    }

    @Override
    public T date(String jdbcDate) {
        DateTimeStateObject stateObject = new DateTimeStateObject(this.parent, jdbcDate);
        this.add((T)stateObject);
        return (T)this;
    }

    @Override
    public T divide(T builder) {
        this.checkBuilder((IScalarExpressionStateObjectBuilder<?>)builder);
        StateObject rightStateObject = this.pop();
        StateObject leftStateObject = this.pop();
        DivisionExpressionStateObject stateObject = new DivisionExpressionStateObject(this.parent, leftStateObject, rightStateObject);
        this.add((T)stateObject);
        return (T)this;
    }

    @Override
    public T entityType(String entityTypeName) {
        EntityTypeLiteralStateObject stateObject = new EntityTypeLiteralStateObject(this.parent, entityTypeName);
        this.add((T)stateObject);
        return (T)this;
    }

    @Override
    public T enumLiteral(Enum<? extends Enum<?>> enumConstant) {
        EnumTypeStateObject stateObject = new EnumTypeStateObject(this.parent, enumConstant);
        this.add((T)stateObject);
        return (T)this;
    }

    @Override
    public ICaseExpressionStateObjectBuilder getCaseBuilder() {
        if (this.caseBuilder == null) {
            this.caseBuilder = this.getParent().getQueryBuilder().buildCaseExpressionStateObjectBuilder(this.parent);
        }
        return this.caseBuilder;
    }

    protected StateObject getParent() {
        return this.parent;
    }

    @Override
    public T index(String variable) {
        IndexExpressionStateObject stateObject = new IndexExpressionStateObject(this.parent, variable);
        this.add((T)stateObject);
        return (T)this;
    }

    @Override
    public T length(T builder) {
        this.checkBuilder((IScalarExpressionStateObjectBuilder<?>)builder);
        LengthExpressionStateObject stateObject = new LengthExpressionStateObject(this.parent, this.pop());
        this.add((T)stateObject);
        return (T)this;
    }

    protected StateObject literal(String literal) {
        if (literal != null && literal.length() > 0) {
            char character = literal.charAt(0);
            if (ExpressionTools.isQuote(character)) {
                return this.buildStringLiteral(literal);
            }
            if (ExpressionTools.isParameter(character)) {
                return this.buildInputParameter(literal);
            }
            if (literal.indexOf(46) > 0) {
                return this.buildStateFieldPath(literal);
            }
            return this.buildIdentificationVariable(literal);
        }
        return this.buildStringLiteral(literal);
    }

    protected List<StateObject> literals(String ... literals) {
        ArrayList<StateObject> stateObjects = new ArrayList<StateObject>();
        String[] stringArray = literals;
        int n = literals.length;
        int n2 = 0;
        while (n2 < n) {
            String literal = stringArray[n2];
            stateObjects.add(this.literal(literal));
            ++n2;
        }
        return stateObjects;
    }

    @Override
    public T locate(T parameter1, T parameter2) {
        return this.locate(parameter1, parameter2, null);
    }

    @Override
    public T locate(T parameter1, T parameter2, T parameter3) {
        this.checkBuilders(new IScalarExpressionStateObjectBuilder[]{parameter1, parameter2});
        if (parameter3 != null) {
            this.checkBuilder((IScalarExpressionStateObjectBuilder<?>)parameter3);
        }
        StateObject thirdStateObject = parameter3 != null ? this.pop() : null;
        StateObject secondStateObject = this.pop();
        StateObject firstStateObject = this.pop();
        LocateExpressionStateObject stateObject = new LocateExpressionStateObject(this.parent, firstStateObject, secondStateObject, thirdStateObject);
        this.add((T)stateObject);
        return (T)this;
    }

    protected void max(boolean distinct, String path) {
        MaxFunctionStateObject stateObject = new MaxFunctionStateObject(this.parent, distinct, this.literal(path));
        this.add((T)stateObject);
    }

    @Override
    public T max(String path) {
        this.max(false, path);
        return (T)this;
    }

    @Override
    public T maxDistinct(String path) {
        this.max(true, path);
        return (T)this;
    }

    protected void min(boolean distinct, String path) {
        MaxFunctionStateObject stateObject = new MaxFunctionStateObject(this.parent, distinct, this.literal(path));
        this.add((T)stateObject);
    }

    @Override
    public T min(String path) {
        this.min(false, path);
        return (T)this;
    }

    @Override
    public T minDistinct(String path) {
        this.min(true, path);
        return (T)this;
    }

    @Override
    public T minus(T builder) {
        this.checkBuilders(new IScalarExpressionStateObjectBuilder[]{builder});
        this.arithmetic(false);
        return (T)this;
    }

    @Override
    public T mod(T parameter1, T parameter2) {
        this.checkBuilders(new IScalarExpressionStateObjectBuilder[]{parameter1, parameter2});
        StateObject secondStateObject = this.pop();
        StateObject firstStateObject = this.pop();
        ModExpressionStateObject stateObject = new ModExpressionStateObject(this.parent, firstStateObject, secondStateObject);
        this.add((T)stateObject);
        return (T)this;
    }

    @Override
    public T multiply(T builder) {
        this.checkBuilders(new IScalarExpressionStateObjectBuilder[]{builder});
        StateObject rightStateObject = this.pop();
        StateObject leftStateObject = this.pop();
        MultiplicationExpressionStateObject stateObject = new MultiplicationExpressionStateObject(this.parent, leftStateObject, rightStateObject);
        this.add((T)stateObject);
        return (T)this;
    }

    @Override
    public T nullIf(T builder1, T builder2) {
        this.checkBuilders(new IScalarExpressionStateObjectBuilder[]{builder1, builder2});
        StateObject rightStateObject = this.pop();
        StateObject leftStateObject = this.pop();
        NullIfExpressionStateObject stateObject = new NullIfExpressionStateObject(this.parent, leftStateObject, rightStateObject);
        this.add((T)stateObject);
        return (T)this;
    }

    @Override
    public T numeric(Number number) {
        StateObject stateObject = this.buildNumeric(number);
        this.add((T)stateObject);
        return (T)this;
    }

    @Override
    public T numeric(String number) {
        StateObject stateObject = this.buildNumeric(number);
        this.add((T)stateObject);
        return (T)this;
    }

    @Override
    public T parameter(String parameter) {
        StateObject stateObject = this.buildInputParameter(parameter);
        this.add((T)stateObject);
        return (T)this;
    }

    @Override
    public T path(String path) {
        StateObject stateObject = this.buildStateFieldPath(path);
        this.add((T)stateObject);
        return (T)this;
    }

    @Override
    public T plus(T builder) {
        this.checkBuilders(new IScalarExpressionStateObjectBuilder[]{builder});
        this.arithmetic(true);
        return (T)this;
    }

    @Override
    public T size(String path) {
        SizeExpressionStateObject stateObject = new SizeExpressionStateObject(this.parent, this.buildCollectionPath(path));
        this.add((T)stateObject);
        return (T)this;
    }

    @Override
    public T sqrt(T builder) {
        this.checkBuilders(new IScalarExpressionStateObjectBuilder[]{builder});
        SqrtExpressionStateObject stateObject = new SqrtExpressionStateObject(this.parent, this.pop());
        this.add((T)stateObject);
        return (T)this;
    }

    protected List<StateObject> stateObjects(int count) {
        if (count == 0) {
            return Collections.emptyList();
        }
        ArrayList<StateObject> items = new ArrayList<StateObject>(count);
        while (count-- > 0) {
            items.add(0, this.pop());
        }
        return items;
    }

    protected List<StateObject> stateObjects(T ... builders) {
        return this.stateObjects(builders.length);
    }

    @Override
    public T string(String literal) {
        StateObject stateObject = this.buildStringLiteral(literal);
        this.add((T)stateObject);
        return (T)this;
    }

    @Override
    public T sub(T builder) {
        this.checkBuilders(new IScalarExpressionStateObjectBuilder[]{builder});
        SubExpressionStateObject stateObject = new SubExpressionStateObject(this.parent, this.pop());
        this.add((T)stateObject);
        return (T)this;
    }

    @Override
    public T subtract(T builder) {
        this.checkBuilders(new IScalarExpressionStateObjectBuilder[]{builder});
        StateObject rightStateObject = this.pop();
        StateObject leftStateObject = this.pop();
        SubtractionExpressionStateObject stateObject = new SubtractionExpressionStateObject(this.parent, leftStateObject, rightStateObject);
        this.add((T)stateObject);
        return (T)this;
    }

    protected void sum(boolean distinct, String path) {
        SumFunctionStateObject stateObject = new SumFunctionStateObject(this.parent, distinct, this.literal(path));
        this.add((T)stateObject);
    }

    @Override
    public T sum(String path) {
        this.sum(false, path);
        return (T)this;
    }

    @Override
    public T sumDistinct(String path) {
        this.sum(true, path);
        return (T)this;
    }

    @Override
    public T type(String path) {
        TypeExpressionStateObject stateObject = new TypeExpressionStateObject(this.parent, path);
        this.add((T)stateObject);
        return (T)this;
    }
}

