/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassChooserPanel;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorInterfaceAliasPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWInterfaceAliasDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassChooserTools;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassRepositoryHolder;
import org.eclipse.persistence.tools.workbench.uitools.LabelArea;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;

public class InterfaceAliasPolicyPage
extends ScrollablePropertiesPage {
    public static final int EDITOR_WEIGHT = 3;

    public InterfaceAliasPolicyPage(PropertyValueModel nodeHolder, WorkbenchContextHolder contextHolder) {
        super(nodeHolder, contextHolder);
    }

    private String getHelpTopicId() {
        return "descriptor.interfacealias";
    }

    protected Component buildPage() {
        JPanel interfaceAliasPanel = new JPanel(new GridBagLayout());
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel interfaceChooserLabel = this.buildLabel("INTERFACE_ALIAS");
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        interfaceAliasPanel.add((Component)interfaceChooserLabel, constraints);
        ClassChooserPanel interfaceAliasChooserPanel = ClassChooserTools.buildPanel(this.buildInterfaceAliasHolder(), this.buildClassRepositoryHolder(), ClassChooserTools.buildDeclarableReferenceFilter(), interfaceChooserLabel, this.getWorkbenchContextHolder());
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 0, 0);
        interfaceAliasPanel.add((Component)interfaceAliasChooserPanel, constraints);
        JPanel emptyPanel = new JPanel();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        interfaceAliasPanel.add((Component)emptyPanel, constraints);
        this.addHelpTopicId(interfaceAliasPanel, this.getHelpTopicId());
        return interfaceAliasPanel;
    }

    MWMappingDescriptor descriptor() {
        return (MWMappingDescriptor)this.selection();
    }

    private ClassRepositoryHolder buildClassRepositoryHolder() {
        return new ClassRepositoryHolder(){

            public MWClassRepository getClassRepository() {
                return InterfaceAliasPolicyPage.this.descriptor().getRepository();
            }
        };
    }

    private PropertyValueModel buildInterfaceAliasHolder() {
        return new PropertyAspectAdapter(this.buildInterfaceAliasPolicyHolder(), "interfaceAlias"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorInterfaceAliasPolicy)this.subject).getInterfaceAlias();
            }

            protected void setValueOnSubject(Object value) {
                MWDescriptorInterfaceAliasPolicy policy = (MWDescriptorInterfaceAliasPolicy)this.subject;
                MWClass interfaceClass = (MWClass)value;
                boolean shouldContinueWithSelection = true;
                if (policy.getProject().descriptorForType(interfaceClass) != null) {
                    shouldContinueWithSelection = InterfaceAliasPolicyPage.this.promptToRemoveInterfaceDescriptor();
                }
                if (shouldContinueWithSelection) {
                    policy.setInterfaceAlias(interfaceClass);
                }
            }
        };
    }

    private boolean promptToRemoveInterfaceDescriptor() {
        return JOptionPane.showConfirmDialog(this, new LabelArea(this.resourceRepository().getString("INTERFACE_ALIAS_REMOVE_DESCRIPTOR_MESSAGE")), this.resourceRepository().getString("INTERFACE_ALIAS_REMOVE_DESCRIPTOR_TITLE"), 0) == 0;
    }

    private PropertyValueModel buildInterfaceAliasPolicyHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "interfaceAliasPolicy"){

            protected Object getValueFromSubject() {
                MWDescriptorPolicy policy = ((MWInterfaceAliasDescriptor)this.subject).getInterfaceAliasPolicy();
                return policy.isActive() ? policy : null;
            }
        };
    }
}

