/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql;

import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.jpql.parser.AbstractEclipseLinkExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AbstractFromClause;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSelectClause;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.AvgFunction;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionMemberDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.ConstructorExpression;
import org.eclipse.persistence.jpa.jpql.parser.CountFunction;
import org.eclipse.persistence.jpa.jpql.parser.EclipseLinkAnonymousExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.FromClause;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.Join;
import org.eclipse.persistence.jpa.jpql.parser.KeyExpression;
import org.eclipse.persistence.jpa.jpql.parser.MaxFunction;
import org.eclipse.persistence.jpa.jpql.parser.MinFunction;
import org.eclipse.persistence.jpa.jpql.parser.ObjectExpression;
import org.eclipse.persistence.jpa.jpql.parser.OrderByClause;
import org.eclipse.persistence.jpa.jpql.parser.OrderByItem;
import org.eclipse.persistence.jpa.jpql.parser.RangeVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.ResultVariable;
import org.eclipse.persistence.jpa.jpql.parser.SelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.SimpleFromClause;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.SumFunction;
import org.eclipse.persistence.jpa.jpql.parser.ValueExpression;
import org.eclipse.persistence.jpa.jpql.parser.WhereClause;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;

abstract class AbstractReadAllQueryVisitor
extends AbstractEclipseLinkExpressionVisitor {
    private CountFunctionVisitor countFunctionVisitor;
    private JoinExpressionVisitor joinVisitor;
    private OneToOneSelectedVisitor oneToOneSelectedVisitor;
    private OrderByVisitor orderByVisitor;
    ObjectLevelReadQuery query;
    final JPQLQueryContext queryContext;

    AbstractReadAllQueryVisitor(JPQLQueryContext queryContext) {
        this.queryContext = queryContext;
    }

    private CountFunctionVisitor countFunctionVisitor() {
        if (this.countFunctionVisitor == null) {
            this.countFunctionVisitor = new CountFunctionVisitor();
        }
        return this.countFunctionVisitor;
    }

    private boolean hasNotCountFunction(AbstractSelectClause expression) {
        CountFunctionVisitor visitor = this.countFunctionVisitor();
        expression.accept((ExpressionVisitor)visitor);
        return visitor.hasCountFunction;
    }

    private boolean hasOneToOneSelected(AbstractSelectClause expression) {
        OneToOneSelectedVisitor visitor = this.oneToOneSelectedVisitor();
        expression.accept((ExpressionVisitor)visitor);
        return visitor.oneToOneSelected;
    }

    private JoinExpressionVisitor joinVisitor() {
        if (this.joinVisitor == null) {
            this.joinVisitor = new JoinExpressionVisitor();
        }
        return this.joinVisitor;
    }

    private OneToOneSelectedVisitor oneToOneSelectedVisitor() {
        if (this.oneToOneSelectedVisitor == null) {
            this.oneToOneSelectedVisitor = new OneToOneSelectedVisitor();
        }
        return this.oneToOneSelectedVisitor;
    }

    private OrderByVisitor orderyByVisitor() {
        if (this.orderByVisitor == null) {
            this.orderByVisitor = new OrderByVisitor();
        }
        return this.orderByVisitor;
    }

    public void visit(FromClause expression) {
        this.visitAbstractFromClause((AbstractFromClause)expression);
    }

    public void visit(OrderByClause expression) {
        expression.accept((ExpressionVisitor)this.orderyByVisitor());
    }

    public void visit(SelectClause expression) {
        this.visitAbstractSelectClause((AbstractSelectClause)expression);
    }

    public void visit(SelectStatement expression) {
        this.visitAbstractSelectStatement((AbstractSelectStatement)expression);
        if (expression.hasOrderByClause()) {
            expression.getOrderByClause().accept((ExpressionVisitor)this);
        }
        expression.getFromClause().accept((ExpressionVisitor)this.joinVisitor());
    }

    public void visit(SimpleFromClause expression) {
        this.visitAbstractFromClause((AbstractFromClause)expression);
    }

    public void visit(SimpleSelectClause expression) {
        this.visitAbstractSelectClause((AbstractSelectClause)expression);
    }

    public void visit(SimpleSelectStatement expression) {
        this.visitAbstractSelectStatement((AbstractSelectStatement)expression);
        expression.getFromClause().accept((ExpressionVisitor)this.joinVisitor());
    }

    public void visit(WhereClause expression) {
        this.query.setSelectionCriteria(this.queryContext.buildExpression((Expression)expression));
    }

    void visitAbstractFromClause(AbstractFromClause expression) {
        org.eclipse.persistence.expressions.Expression baseExpression = this.queryContext.getBaseExpression();
        ExpressionBuilder expressionBuilder = baseExpression.getBuilder();
        this.query.setExpressionBuilder(expressionBuilder);
        if (this.query.getReferenceClass() == null) {
            this.query.setReferenceClass(expressionBuilder.getQueryClass());
            this.query.changeDescriptor(this.queryContext.getSession());
        }
    }

    void visitAbstractSelectClause(AbstractSelectClause expression) {
        if (expression.hasDistinct() && !this.hasNotCountFunction(expression)) {
            this.query.useDistinct();
        }
        boolean buildNullForNullPK = this.hasOneToOneSelected(expression);
        this.query.setShouldBuildNullForNullPk(buildNullForNullPK);
    }

    void visitAbstractSelectStatement(AbstractSelectStatement expression) {
        expression.getFromClause().accept((ExpressionVisitor)this);
        expression.getSelectClause().accept((ExpressionVisitor)this);
        if (expression.hasWhereClause()) {
            expression.getWhereClause().accept((ExpressionVisitor)this);
        }
        if (expression.hasGroupByClause()) {
            expression.getGroupByClause().accept((ExpressionVisitor)this);
        }
        if (expression.hasHavingClause()) {
            expression.getHavingClause().accept((ExpressionVisitor)this);
        }
    }

    private class CountFunctionVisitor
    extends EclipseLinkAnonymousExpressionVisitor {
        boolean hasCountFunction;

        private CountFunctionVisitor() {
        }

        public void visit(CountFunction expression) {
            this.hasCountFunction = true;
        }

        protected void visit(Expression expression) {
            this.hasCountFunction = false;
        }

        public void visit(SelectClause expression) {
            expression.getSelectExpression().accept((ExpressionVisitor)this);
        }

        public void visit(SimpleSelectClause expression) {
            expression.getSelectExpression().accept((ExpressionVisitor)this);
        }
    }

    private class JoinExpressionVisitor
    extends AbstractEclipseLinkExpressionVisitor {
        private JoinExpressionVisitor() {
        }

        private void addNonFetchJoinedAttribute(Expression expression, IdentificationVariable identificationVariable) {
            ObjectLevelReadQuery query;
            String variableName = identificationVariable.getVariableName();
            org.eclipse.persistence.expressions.Expression queryExpression = AbstractReadAllQueryVisitor.this.queryContext.getQueryExpression(variableName);
            if (queryExpression == null) {
                Join join;
                queryExpression = AbstractReadAllQueryVisitor.this.queryContext.buildExpression(expression);
                AbstractReadAllQueryVisitor.this.queryContext.addQueryExpression(variableName, queryExpression);
                if (expression instanceof Join && (join = (Join)expression).hasOnClause()) {
                    if (join.isLeftJoin()) {
                        ((QueryKeyExpression)queryExpression).getBaseExpression().leftJoin(queryExpression, AbstractReadAllQueryVisitor.this.queryContext.buildExpression(join.getOnClause()));
                    } else {
                        ((QueryKeyExpression)queryExpression).getBaseExpression().join(queryExpression, AbstractReadAllQueryVisitor.this.queryContext.buildExpression(join.getOnClause()));
                    }
                }
            }
            if ((query = (ObjectLevelReadQuery)AbstractReadAllQueryVisitor.this.queryContext.getDatabaseQuery()).getExpressionBuilder() != queryExpression) {
                query.addNonFetchJoinedAttribute(queryExpression);
            }
        }

        public void visit(CollectionExpression expression) {
            expression.acceptChildren((ExpressionVisitor)this);
        }

        public void visit(CollectionMemberDeclaration expression) {
            this.addNonFetchJoinedAttribute((Expression)expression, (IdentificationVariable)expression.getIdentificationVariable());
        }

        public void visit(FromClause expression) {
            expression.getDeclaration().accept((ExpressionVisitor)this);
        }

        public void visit(IdentificationVariableDeclaration expression) {
            expression.getRangeVariableDeclaration().accept((ExpressionVisitor)this);
            if (expression.hasJoins()) {
                expression.getJoins().accept((ExpressionVisitor)this);
            }
        }

        public void visit(Join expression) {
            if (expression.hasIdentificationVariable()) {
                IdentificationVariable identificationVariable;
                String variableName;
                org.eclipse.persistence.expressions.Expression queryExpression;
                this.addNonFetchJoinedAttribute((Expression)expression, (IdentificationVariable)expression.getIdentificationVariable());
                if (expression.hasFetch() && (queryExpression = AbstractReadAllQueryVisitor.this.queryContext.getQueryExpression(variableName = (identificationVariable = (IdentificationVariable)expression.getIdentificationVariable()).getVariableName())) == null) {
                    queryExpression = AbstractReadAllQueryVisitor.this.queryContext.buildExpression((Expression)expression);
                    AbstractReadAllQueryVisitor.this.queryContext.addQueryExpression(variableName, queryExpression);
                }
            }
        }

        public void visit(RangeVariableDeclaration expression) {
            this.addNonFetchJoinedAttribute((Expression)expression, (IdentificationVariable)expression.getIdentificationVariable());
        }

        public void visit(SimpleFromClause expression) {
            expression.getDeclaration().accept((ExpressionVisitor)this);
        }
    }

    private class OneToOneSelectedVisitor
    extends EclipseLinkAnonymousExpressionVisitor {
        boolean oneToOneSelected;

        private OneToOneSelectedVisitor() {
        }

        public void visit(AvgFunction expression) {
            expression.getExpression().accept((ExpressionVisitor)this);
        }

        public void visit(CollectionExpression expression) {
            for (Expression child : expression.children()) {
                child.accept((ExpressionVisitor)this);
                if (this.oneToOneSelected) break;
            }
        }

        public void visit(ConstructorExpression expression) {
            expression.getConstructorItems().accept((ExpressionVisitor)this);
        }

        public void visit(CountFunction expression) {
            this.oneToOneSelected = false;
        }

        public void visit(IdentificationVariable expression) {
            this.oneToOneSelected = !AbstractReadAllQueryVisitor.this.queryContext.isRangeIdentificationVariable(expression.getVariableName());
        }

        public void visit(KeyExpression expression) {
            this.oneToOneSelected = true;
        }

        public void visit(MaxFunction expression) {
            expression.getExpression().accept((ExpressionVisitor)this);
        }

        public void visit(MinFunction expression) {
            expression.getExpression().accept((ExpressionVisitor)this);
        }

        public void visit(ObjectExpression expression) {
            expression.getExpression().accept((ExpressionVisitor)this);
        }

        protected void visit(Expression expression) {
            this.oneToOneSelected = true;
        }

        public void visit(ResultVariable expression) {
            expression.getSelectExpression().accept((ExpressionVisitor)this);
        }

        public void visit(SelectClause expression) {
            expression.getSelectExpression().accept((ExpressionVisitor)this);
        }

        public void visit(SimpleSelectClause expression) {
            expression.getSelectExpression().accept((ExpressionVisitor)this);
        }

        public void visit(StateFieldPathExpression expression) {
            DatabaseMapping mapping = AbstractReadAllQueryVisitor.this.queryContext.resolveMapping((Expression)expression);
            this.oneToOneSelected = mapping != null && !mapping.isDirectToFieldMapping();
        }

        public void visit(SumFunction expression) {
            expression.getExpression().accept((ExpressionVisitor)this);
        }

        public void visit(ValueExpression expression) {
            this.oneToOneSelected = true;
        }
    }

    private class OrderByVisitor
    extends AbstractEclipseLinkExpressionVisitor {
        private OrderByVisitor() {
        }

        public void visit(CollectionExpression expression) {
            expression.acceptChildren((ExpressionVisitor)this);
        }

        public void visit(OrderByClause expression) {
            expression.getOrderByItems().accept((ExpressionVisitor)this);
        }

        public void visit(OrderByItem expression) {
            org.eclipse.persistence.expressions.Expression queryExpression = AbstractReadAllQueryVisitor.this.queryContext.buildExpression(expression.getExpression());
            if (expression.getOrdering() == OrderByItem.Ordering.DESC) {
                AbstractReadAllQueryVisitor.this.query.addOrdering(queryExpression.descending());
            } else {
                AbstractReadAllQueryVisitor.this.query.addOrdering(queryExpression.ascending());
            }
        }
    }
}

