/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.internal.jpa.jpql.DeleteQueryVisitor;
import org.eclipse.persistence.internal.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.internal.jpa.jpql.ObjectLevelReadQueryVisitor;
import org.eclipse.persistence.internal.jpa.jpql.ReadAllQueryBuilder;
import org.eclipse.persistence.internal.jpa.jpql.UpdateQueryVisitor;
import org.eclipse.persistence.internal.jpa.jpql.spi.JavaManagedTypeProvider;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jpa.jpql.EclipseLinkJPQLQueryHelper;
import org.eclipse.persistence.jpa.jpql.JPQLQueryProblem;
import org.eclipse.persistence.jpa.jpql.JPQLQueryProblemResourceBundle;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.DefaultEclipseLinkJPQLGrammar;
import org.eclipse.persistence.jpa.jpql.parser.DeleteStatement;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar;
import org.eclipse.persistence.jpa.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.UpdateStatement;
import org.eclipse.persistence.jpa.jpql.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.spi.IQuery;
import org.eclipse.persistence.jpa.jpql.spi.java.JavaQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.queries.JPAQueryBuilder;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.UpdateAllQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HermesParser
implements JPAQueryBuilder {
    private boolean validateQueries;

    public HermesParser() {
        this(true);
    }

    public HermesParser(boolean validateQueries) {
        this.validateQueries = validateQueries;
    }

    private void addArguments(JPQLQueryContext queryContext, DatabaseQuery databaseQuery) {
        for (Map.Entry<String, Class<?>> inputParameters : queryContext.inputParameters()) {
            databaseQuery.addArgument(inputParameters.getKey().substring(1), inputParameters.getValue());
        }
    }

    private IManagedTypeProvider buildProvider(AbstractSession session) {
        return new JavaManagedTypeProvider(session);
    }

    public DatabaseQuery buildQuery(String jpqlQuery, AbstractSession session) {
        return this.populateQueryImp(jpqlQuery, null, session);
    }

    public org.eclipse.persistence.expressions.Expression buildSelectionCriteria(String entityName, String selectionCriteria, AbstractSession session) {
        JPQLExpression jpqlExpression = new JPQLExpression((CharSequence)selectionCriteria, this.jpqlGrammar(), "conditional_expression", this.validateQueries);
        JPQLQueryContext queryContext = new JPQLQueryContext();
        queryContext.cache(session, null, jpqlExpression, selectionCriteria);
        queryContext.addRangeVariableDeclaration(entityName, "this");
        return queryContext.buildExpression(jpqlExpression.getQueryStatement());
    }

    private JPQLGrammar jpqlGrammar() {
        return DefaultEclipseLinkJPQLGrammar.instance();
    }

    private void logProblems(JPQLQueryContext queryContext, List<JPQLQueryProblem> problems, String messageKey) {
        ResourceBundle bundle = ResourceBundle.getBundle(JPQLQueryProblemResourceBundle.class.getName());
        StringBuilder sb = new StringBuilder();
        int index = 0;
        int count = problems.size();
        while (index < count) {
            JPQLQueryProblem problem = problems.get(index);
            String message = bundle.getString(problem.getMessageKey());
            message = MessageFormat.format(message, problem.getMessageArguments());
            sb.append("\n");
            sb.append("[");
            sb.append(problem.getStartPosition());
            sb.append(", ");
            sb.append(problem.getEndPosition());
            sb.append("] ");
            sb.append(message);
            ++index;
        }
        String errorMessage = bundle.getString(messageKey);
        errorMessage = MessageFormat.format(errorMessage, queryContext.getJPQLQuery(), sb);
        throw new JPQLException(errorMessage);
    }

    public void populateQuery(String jpqlQuery, DatabaseQuery query, AbstractSession session) {
        this.populateQueryImp(jpqlQuery, query, session);
    }

    private DatabaseQuery populateQueryImp(String jpqlQuery, DatabaseQuery query, AbstractSession session) {
        JPQLExpression jpqlExpression = new JPQLExpression((CharSequence)jpqlQuery, this.jpqlGrammar(), this.validateQueries);
        JPQLQueryContext queryContext = new JPQLQueryContext();
        queryContext.cache(session, (DatabaseQuery)query, jpqlExpression, jpqlQuery);
        this.validate(queryContext, jpqlExpression, session, jpqlQuery);
        DatabaseQueryVisitor visitor = new DatabaseQueryVisitor(queryContext);
        jpqlExpression.accept((ExpressionVisitor)visitor);
        if (query == null) {
            query = queryContext.getDatabaseQuery();
            this.addArguments(queryContext, (DatabaseQuery)query);
        }
        return query;
    }

    private void validate(JPQLQueryContext queryContext, JPQLExpression expression, AbstractSession session, String jpqlQuery) {
        if (this.validateQueries) {
            ArrayList<JPQLQueryProblem> problems = new ArrayList<JPQLQueryProblem>();
            EclipseLinkJPQLQueryHelper queryHelper = new EclipseLinkJPQLQueryHelper(this.jpqlGrammar());
            queryHelper.setJPQLExpression(expression);
            queryHelper.setQuery((IQuery)new JavaQuery(this.buildProvider(session), (CharSequence)jpqlQuery));
            queryHelper.validateGrammar((Expression)expression, problems);
            if (!problems.isEmpty()) {
                this.logProblems(queryContext, problems, "HERMES_PARSER_GRAMMAR_VALIDATOR_ERROR_MESSAGE");
                problems.clear();
            }
            queryHelper.validateSemantic((Expression)expression, problems);
            if (!problems.isEmpty()) {
                this.logProblems(queryContext, problems, "HERMES_PARSER_SEMANTIC_VALIDATOR_ERROR_MESSAGE");
            }
        }
    }

    private class DatabaseQueryVisitor
    extends AbstractExpressionVisitor {
        private final JPQLQueryContext queryContext;

        DatabaseQueryVisitor(JPQLQueryContext queryContext) {
            this.queryContext = queryContext;
        }

        private ReadAllQuery buildReadAllQuery(SelectStatement expression) {
            ReadAllQueryBuilder visitor = new ReadAllQueryBuilder(this.queryContext);
            expression.accept((ExpressionVisitor)visitor);
            return visitor.query;
        }

        public void visit(DeleteStatement expression) {
            DeleteAllQuery query = (DeleteAllQuery)this.queryContext.getDatabaseQuery();
            if (query == null) {
                query = new DeleteAllQuery();
                this.queryContext.setDatabasQuery((DatabaseQuery)query);
                query.setJPQLString(this.queryContext.getJPQLQuery());
            }
            query.setSession(this.queryContext.getSession());
            query.setShouldDeferExecutionInUOW(false);
            DeleteQueryVisitor visitor = new DeleteQueryVisitor(this.queryContext);
            visitor.query = query;
            expression.accept((ExpressionVisitor)visitor);
        }

        public void visit(JPQLExpression expression) {
            expression.getQueryStatement().accept((ExpressionVisitor)this);
        }

        public void visit(SelectStatement expression) {
            ObjectLevelReadQuery query = (ObjectLevelReadQuery)this.queryContext.getDatabaseQuery();
            if (query == null) {
                query = this.buildReadAllQuery(expression);
                this.queryContext.setDatabasQuery((DatabaseQuery)query);
                query.setJPQLString(this.queryContext.getJPQLQuery());
            }
            if (query.isReportQuery()) {
                this.queryContext.populateReportQuery((AbstractSelectStatement)expression, (ReportQuery)query);
            } else {
                ObjectLevelReadQueryVisitor visitor = new ObjectLevelReadQueryVisitor(this.queryContext);
                visitor.query = query;
                expression.accept((ExpressionVisitor)visitor);
            }
        }

        public void visit(UpdateStatement expression) {
            UpdateAllQuery query = (UpdateAllQuery)this.queryContext.getDatabaseQuery();
            if (query == null) {
                query = new UpdateAllQuery();
                this.queryContext.setDatabasQuery((DatabaseQuery)query);
                query.setJPQLString(this.queryContext.getJPQLQuery());
            }
            query.setSession(this.queryContext.getSession());
            query.setShouldDeferExecutionInUOW(false);
            UpdateQueryVisitor visitor = new UpdateQueryVisitor(this.queryContext);
            visitor.query = query;
            expression.accept((ExpressionVisitor)visitor);
        }
    }
}

