/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql;

import java.util.Collection;
import org.eclipse.persistence.internal.jpa.jpql.AbstractReadAllQueryVisitor;
import org.eclipse.persistence.internal.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.jpql.LiteralType;
import org.eclipse.persistence.jpa.jpql.parser.AbstractEclipseLinkExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.Join;
import org.eclipse.persistence.jpa.jpql.parser.SelectClause;

final class ObjectLevelReadQueryVisitor
extends AbstractReadAllQueryVisitor {
    private JoinedAttributeExpressionVisitor joinedAttributesVisitor;

    ObjectLevelReadQueryVisitor(JPQLQueryContext queryContext) {
        super(queryContext);
    }

    private JoinedAttributeExpressionVisitor joindAttributesVisitor() {
        if (this.joinedAttributesVisitor == null) {
            this.joinedAttributesVisitor = new JoinedAttributeExpressionVisitor();
        }
        return this.joinedAttributesVisitor;
    }

    public void visit(SelectClause expression) {
        super.visit(expression);
        expression.getSelectExpression().accept((ExpressionVisitor)this.joindAttributesVisitor());
    }

    private class JoinedAttributeExpressionVisitor
    extends AbstractEclipseLinkExpressionVisitor {
        private JoinedAttributeExpressionVisitor() {
        }

        public void visit(CollectionExpression expression) {
            expression.acceptChildren((ExpressionVisitor)this);
        }

        public void visit(IdentificationVariable expression) {
            String variableName = expression.getVariableName();
            Collection<Join> joinFetches = ObjectLevelReadQueryVisitor.this.queryContext.getJoinFetches(variableName);
            if (joinFetches != null) {
                for (Join joinFetch : joinFetches) {
                    String joinFetchVariableName = ObjectLevelReadQueryVisitor.this.queryContext.literal((Expression)joinFetch, LiteralType.PATH_EXPRESSION_IDENTIFICATION_VARIABLE);
                    if (!variableName.equals(joinFetchVariableName)) continue;
                    org.eclipse.persistence.expressions.Expression queryExpression = ObjectLevelReadQueryVisitor.this.queryContext.buildExpression((Expression)joinFetch);
                    ObjectLevelReadQueryVisitor.this.query.addJoinedAttribute(queryExpression);
                }
            }
        }
    }
}

